/*
 * Decompiled with CFR 0.152.
 */
package org.mapyrus.io;

import java.awt.geom.Rectangle2D;
import java.net.URL;
import java.util.StringTokenizer;
import org.mapyrus.MapyrusException;
import org.mapyrus.MapyrusMessages;
import org.mapyrus.io.GeoImageBoundingBox;

public class WMSRequestBoundingBox
implements GeoImageBoundingBox {
    Rectangle2D.Double mBounds;

    public WMSRequestBoundingBox(URL uRL) throws MapyrusException {
        String string = uRL.getQuery().toUpperCase();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "&");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (!string2.startsWith("BBOX=")) continue;
            StringTokenizer stringTokenizer2 = new StringTokenizer(string2.substring(5), ",");
            if (stringTokenizer2.countTokens() != 4) {
                throw new MapyrusException(MapyrusMessages.get("invalidwmsrequest") + ": " + uRL);
            }
            try {
                double d;
                double d2 = Double.parseDouble(stringTokenizer2.nextToken());
                double d3 = Double.parseDouble(stringTokenizer2.nextToken());
                double d4 = Double.parseDouble(stringTokenizer2.nextToken());
                double d5 = Double.parseDouble(stringTokenizer2.nextToken());
                if (d3 > d5) {
                    d = d3;
                    d3 = d5;
                    d5 = d;
                }
                if (d2 > d4) {
                    d = d2;
                    d2 = d4;
                    d4 = d;
                }
                this.mBounds = new Rectangle2D.Double(d2, d3, d4 - d2, d5 - d3);
            }
            catch (NumberFormatException numberFormatException) {
                throw new MapyrusException(MapyrusMessages.get("invalidwmsrequest") + ": " + uRL);
            }
        }
        if (this.mBounds == null) {
            throw new MapyrusException(MapyrusMessages.get("invalidwmsrequest") + ": " + uRL);
        }
    }

    public Rectangle2D getBounds() {
        return this.mBounds;
    }
}

