/*
 * Decompiled with CFR 0.152.
 */
package org.mapyrus.io;

import java.awt.geom.AffineTransform;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.StringTokenizer;
import org.mapyrus.FileOrURL;
import org.mapyrus.GeometricPath;
import org.mapyrus.MapyrusException;
import org.mapyrus.MapyrusMessages;

public class ImageClippingFile {
    GeometricPath mPath;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImageClippingFile(String string, AffineTransform affineTransform) throws MapyrusException, IOException {
        BufferedReader bufferedReader = null;
        double[] dArray = new double[2];
        int n = 0;
        try {
            String string2;
            FileOrURL fileOrURL = new FileOrURL(string);
            bufferedReader = fileOrURL.getReader();
            this.mPath = new GeometricPath();
            while ((string2 = ((LineNumberReader)bufferedReader).readLine()) != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string2, " \t,");
                if (stringTokenizer.countTokens() < 2) continue;
                String string3 = stringTokenizer.nextToken();
                String string4 = stringTokenizer.nextToken();
                if (string3.startsWith("#")) continue;
                try {
                    dArray[0] = Double.parseDouble(string3);
                    dArray[1] = Double.parseDouble(string4);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new MapyrusException(MapyrusMessages.get("invalidnumber") + ": " + string + ":" + ((LineNumberReader)bufferedReader).getLineNumber() + ": " + string2);
                }
                if (affineTransform != null) {
                    affineTransform.transform(dArray, 0, dArray, 0, 1);
                }
                if (n++ == 0) {
                    this.mPath.moveTo((float)dArray[0], (float)dArray[1], 0.0);
                    continue;
                }
                this.mPath.lineTo((float)dArray[0], (float)dArray[1]);
            }
            this.mPath.closePath();
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public GeometricPath getClippingPolygon() {
        return this.mPath;
    }
}

