/*
 * Decompiled with CFR 0.152.
 */
package org.mapyrus.image;

import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mapyrus.MapyrusException;
import org.mapyrus.MapyrusMessages;

public class PNMImage {
    private BufferedImage mImage;

    public PNMImage(String string) throws MapyrusException, IOException {
        DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(string)));
        this.init(dataInputStream, string);
    }

    public PNMImage(InputStream inputStream, String string) throws MapyrusException, IOException {
        DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(inputStream));
        this.init(dataInputStream, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(DataInputStream dataInputStream, String string) throws MapyrusException, IOException {
        try {
            boolean bl;
            boolean bl2;
            int n = dataInputStream.read();
            int n2 = dataInputStream.read();
            if (n == 80 && n2 == 54) {
                bl2 = false;
                bl = false;
            } else if (n == 80 && n2 == 53) {
                bl = true;
                bl2 = false;
            } else if (n == 80 && n2 == 52) {
                bl2 = true;
                bl = false;
            } else {
                throw new MapyrusException(MapyrusMessages.get("notappmfile") + ": " + string);
            }
            int n3 = this.readNumber(dataInputStream);
            int n4 = this.readNumber(dataInputStream);
            int n5 = 1;
            if (!bl2) {
                n5 = this.readNumber(dataInputStream);
            }
            int n6 = n5 < 256 ? 1 : 2;
            this.mImage = new BufferedImage(n3, n4, 1);
            int n7 = 0;
            for (int i = 0; i < n4; ++i) {
                int n8 = 0;
                for (int j = 0; j < n3; ++j) {
                    int n9;
                    int n10;
                    int n11;
                    if (n6 == 1) {
                        if (bl2) {
                            if (n8 == 0) {
                                n7 = dataInputStream.read();
                                n8 = 128;
                            }
                            n11 = (n7 & n8) != 0 ? 0 : 255;
                            n10 = n11;
                            n9 = n11;
                            n8 >>= 1;
                        } else if (bl) {
                            n10 = n11 = dataInputStream.read();
                            n9 = n11;
                        } else {
                            n9 = dataInputStream.read();
                            n10 = dataInputStream.read();
                            n11 = dataInputStream.read();
                        }
                    } else if (bl) {
                        n10 = n11 = dataInputStream.readShort();
                        n9 = n11;
                    } else {
                        n9 = dataInputStream.readShort();
                        n10 = dataInputStream.readShort();
                        n11 = dataInputStream.readShort();
                    }
                    int n12 = n9 << 16 | n10 << 8 | n11;
                    this.mImage.setRGB(j, i, n12);
                }
            }
        }
        finally {
            try {
                dataInputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    private int readNumber(InputStream inputStream) throws IOException {
        boolean bl;
        int n = 0;
        int n2 = inputStream.read();
        boolean bl2 = bl = n2 == 35;
        while (n2 != -1 && (bl || Character.isWhitespace((char)n2))) {
            n2 = inputStream.read();
            if (n2 == 35) {
                bl = true;
                continue;
            }
            if (!bl || n2 != 13 && n2 != 10) continue;
            bl = false;
        }
        while (n2 >= 48 && n2 <= 57) {
            n = n * 10 + (n2 - 48);
            n2 = inputStream.read();
        }
        return n;
    }

    public BufferedImage getBufferedImage() {
        return this.mImage;
    }

    public static void write(BufferedImage bufferedImage, OutputStream outputStream) throws IOException {
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        outputStream.write(80);
        outputStream.write(54);
        outputStream.write(10);
        outputStream.write(Integer.toString(n).getBytes());
        outputStream.write(32);
        outputStream.write(Integer.toString(n2).getBytes());
        outputStream.write(10);
        outputStream.write(Integer.toString(255).getBytes());
        outputStream.write(10);
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                int n3 = bufferedImage.getRGB(j, i);
                int n4 = n3 & 0xFF;
                int n5 = n3 >> 8 & 0xFF;
                int n6 = n3 >> 16 & 0xFF;
                outputStream.write(n6);
                outputStream.write(n5);
                outputStream.write(n4);
            }
        }
        outputStream.flush();
    }
}

