/*
 * Decompiled with CFR 0.152.
 */
package org.mapyrus.image;

import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import org.mapyrus.MapyrusException;
import org.mapyrus.MapyrusMessages;

public class PATImage {
    private BufferedImage mImage;

    public PATImage(URL uRL) throws MapyrusException, IOException {
        DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(uRL.openStream()));
        this.init(dataInputStream, uRL.toString());
    }

    public PATImage(String string) throws MapyrusException, IOException {
        DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(string)));
        this.init(dataInputStream, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(DataInputStream dataInputStream, String string) throws MapyrusException, IOException {
        try {
            int n = dataInputStream.readInt();
            dataInputStream.readInt();
            int n2 = dataInputStream.readInt();
            int n3 = dataInputStream.readInt();
            int n4 = dataInputStream.readInt();
            byte[] byArray = new byte[4];
            if (dataInputStream.read(byArray) != byArray.length) {
                throw new MapyrusException(MapyrusMessages.get("unexpectedeof") + ": " + string);
            }
            if (byArray[0] != 71 || byArray[1] != 80 || byArray[2] != 65 || byArray[3] != 84 || n2 <= 0 || n3 <= 0) {
                throw new MapyrusException(MapyrusMessages.get("notapatfile") + ": " + string);
            }
            int n5 = 24;
            while (n5++ < n) {
                if (dataInputStream.read() >= 0) continue;
                throw new MapyrusException(MapyrusMessages.get("unexpectedeof") + ": " + string);
            }
            this.mImage = new BufferedImage(n2, n3, 1);
            for (int i = 0; i < n3; ++i) {
                for (int j = 0; j < n2; ++j) {
                    int n6;
                    int n7;
                    int n8;
                    if (n4 == 1) {
                        n7 = n8 = dataInputStream.read();
                        n6 = n8;
                    } else {
                        n6 = dataInputStream.read();
                        n7 = dataInputStream.read();
                        n8 = dataInputStream.read();
                    }
                    if (n6 < 0 || n7 < 0 || n8 < 0) {
                        throw new MapyrusException(MapyrusMessages.get("unexpectedeof") + ": " + string);
                    }
                    int n9 = n6 << 16 | n7 << 8 | n8;
                    this.mImage.setRGB(j, i, n9);
                }
            }
        }
        finally {
            try {
                dataInputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public BufferedImage getBufferedImage() {
        return this.mImage;
    }
}

