/*
 * Decompiled with CFR 0.152.
 */
package org.mapyrus.image;

import java.awt.Color;
import java.awt.image.BufferedImage;
import org.mapyrus.MapyrusException;
import org.mapyrus.MapyrusMessages;

public class Bitmap {
    public static final int HEX_DIGIT_BITMAP = 0;
    public static final int BINARY_DIGIT_BITMAP = 1;
    private BufferedImage mBitmap;

    public Bitmap(String string, int n, Color color) throws MapyrusException {
        int n2;
        int n3;
        int n4 = string.length();
        byte[] byArray = new byte[n4 * 4];
        int n5 = 0;
        for (int i = 0; i < n4; ++i) {
            n3 = string.charAt(i);
            n2 = 0;
            n3 = this.hexValue(n3);
            if (n == 0 && n3 == 0 && i + 1 < n4 && ((n2 = (int)string.charAt(i + 1)) == 120 || n2 == 88)) {
                n3 = -1;
            }
            if (n == 1 && (n3 == 0 || n3 == 1)) {
                byArray[n5] = (byte)n3;
                ++n5;
                continue;
            }
            if (n != 0 || n3 < 0) continue;
            byArray[n5] = (byte)(n3 & 8);
            byArray[n5 + 1] = (byte)(n3 & 4);
            byArray[n5 + 2] = (byte)(n3 & 2);
            byArray[n5 + 3] = (byte)(n3 & 1);
            n5 += 4;
        }
        n3 = (int)Math.round(Math.sqrt(n5));
        if (n5 == 0 || n3 * n3 != n5) {
            throw new MapyrusException(MapyrusMessages.get("invalidhexicon") + ": " + string);
        }
        this.mBitmap = new BufferedImage(n3, n3, 6);
        n2 = color.getRGB();
        int n6 = 0;
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n3; ++j) {
                if (byArray[n6++] == 0) continue;
                this.mBitmap.setRGB(j, i, n2);
            }
        }
    }

    private int hexValue(int n) {
        int n2 = -1;
        if (n >= 48 && n <= 57) {
            n2 = n - 48;
        } else if (n >= 97 && n <= 102) {
            n2 = n - 97 + 10;
        } else if (n >= 65 && n <= 70) {
            n2 = n - 65 + 10;
        }
        return n2;
    }

    public BufferedImage getBufferedImage() {
        return this.mBitmap;
    }
}

