/*
 * Decompiled with CFR 0.152.
 */
package org.mapyrus.function;

import java.io.IOException;
import java.util.ArrayList;
import org.mapyrus.Argument;
import org.mapyrus.ContextStack;
import org.mapyrus.Interpreter;
import org.mapyrus.MapyrusException;
import org.mapyrus.Statement;
import org.mapyrus.function.Function;

public class UserFunction
implements Function {
    private String mFuncName;
    private ArrayList mFormalParameters;
    private ArrayList mStatements;
    private Interpreter mInterpreter;

    public UserFunction(String string, ArrayList arrayList, ArrayList arrayList2, Interpreter interpreter) {
        this.mFuncName = string;
        this.mFormalParameters = arrayList;
        this.mStatements = arrayList2;
        this.mInterpreter = interpreter;
    }

    public Argument evaluate(ContextStack contextStack, ArrayList arrayList) throws MapyrusException {
        Argument argument = null;
        boolean bl = false;
        try {
            Object object;
            int n;
            contextStack.saveState(this.mFuncName);
            bl = true;
            for (n = 0; n < arrayList.size(); ++n) {
                object = (String)this.mFormalParameters.get(n);
                contextStack.setLocalScope((String)object);
                Argument argument2 = (Argument)arrayList.get(n);
                contextStack.defineVariable((String)object, argument2);
            }
            for (n = 0; n < this.mStatements.size(); ++n) {
                object = (Statement)this.mStatements.get(n);
                argument = this.mInterpreter.executeStatement((Statement)object);
                if (argument == null) continue;
                break;
            }
        }
        catch (IOException iOException) {
            throw new MapyrusException(iOException.getMessage());
        }
        finally {
            try {
                if (bl) {
                    contextStack.restoreState();
                }
            }
            catch (IOException iOException) {
                throw new MapyrusException(iOException.getMessage());
            }
        }
        if (argument == null) {
            argument = Argument.emptyString;
        }
        return argument;
    }

    public int getMaxArgumentCount() {
        return this.mFormalParameters.size();
    }

    public int getMinArgumentCount() {
        return this.mFormalParameters.size();
    }

    public String getName() {
        return this.mFuncName;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.mFuncName);
        stringBuffer.append(" ");
        for (int i = 0; i < this.mFormalParameters.size(); ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.mFormalParameters.get(i));
        }
        return stringBuffer.toString();
    }

    public void setStatements(ArrayList arrayList) {
        this.mStatements = arrayList;
    }

    public UserFunction clone(Interpreter interpreter) {
        UserFunction userFunction = new UserFunction(this.mFuncName, this.mFormalParameters, this.mStatements, interpreter);
        return userFunction;
    }
}

