/*
 * Decompiled with CFR 0.152.
 */
package org.mapyrus.font;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.mapyrus.MapyrusException;
import org.mapyrus.font.AdobeFontMetrics;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdobeFontMetricsManager {
    private static String[] mStdFontMetricResources = new String[]{"agd.afm", "agdo.afm", "agw.afm", "agwo.afm", "bkd.afm", "bkdi.afm", "bkl.afm", "bkli.afm", "cob.afm", "cobo.afm", "com.afm", "coo.afm", "hv.afm", "hvb.afm", "hvbo.afm", "hvn.afm", "hvnb.afm", "hvnbo.afm", "hvno.afm", "hvo.afm", "ncb.afm", "ncbi.afm", "nci.afm", "ncr.afm", "pob.afm", "pobi.afm", "poi.afm", "por.afm", "sy.afm", "tib.afm", "tibi.afm", "tii.afm", "tir.afm", "zcmi.afm", "zd.afm"};
    private HashMap<String, AdobeFontMetrics> mFontMetrics = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AdobeFontMetricsManager(List<String> list, HashSet<String> hashSet) throws IOException, MapyrusException {
        Object object;
        Closeable closeable;
        for (int i = 0; i < mStdFontMetricResources.length; ++i) {
            String string = "org/mapyrus/font/" + mStdFontMetricResources[i];
            closeable = this.getClass().getClassLoader().getResourceAsStream(string);
            object = null;
            try {
                object = new BufferedReader(new InputStreamReader((InputStream)closeable));
                AdobeFontMetrics adobeFontMetrics = new AdobeFontMetrics((BufferedReader)object, string, hashSet);
                this.mFontMetrics.put(adobeFontMetrics.getFontName(), adobeFontMetrics);
                continue;
            }
            finally {
                if (object != null) {
                    ((BufferedReader)object).close();
                }
            }
        }
        for (String string : list) {
            closeable = null;
            try {
                closeable = new BufferedReader(new FileReader(string));
                object = new AdobeFontMetrics((BufferedReader)closeable, string, hashSet);
                this.mFontMetrics.put(((AdobeFontMetrics)object).getFontName(), (AdobeFontMetrics)object);
            }
            finally {
                if (closeable == null) continue;
                ((BufferedReader)closeable).close();
            }
        }
    }

    public double getStringWidth(String string, double d, String string2) {
        double d2 = 0.0;
        AdobeFontMetrics adobeFontMetrics = this.mFontMetrics.get(string);
        d2 = adobeFontMetrics != null ? adobeFontMetrics.getStringWidth(string2, d) : (double)string2.length() * d;
        return d2;
    }
}

