/*
 * Decompiled with CFR 0.152.
 */
package org.mapyrus.font;

import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.StringTokenizer;
import org.mapyrus.MapyrusException;
import org.mapyrus.MapyrusMessages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdobeFontMetrics {
    private static final int FULL_CHAR_WIDTH = 1000;
    private String mFontName;
    private short[] mCharWidths;
    private int mFirstChar;
    private int mLastChar;
    private boolean mIsFixedPitch;
    private int mItalicAngle;
    private int mCapHeight;
    private int mAscender;
    private int mDescender;
    private Rectangle mFontBBox;
    private int mFlags;
    private static HashMap<String, Integer> mISOLatin1CharIndexes = new HashMap(256);

    public AdobeFontMetrics(BufferedReader bufferedReader, String string, HashSet<String> hashSet) throws IOException, MapyrusException {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        this.mCharWidths = new short[256];
        this.mIsFixedPitch = false;
        this.mFirstChar = Integer.MAX_VALUE;
        this.mLastChar = Integer.MIN_VALUE;
        this.mFlags = 32;
        try {
            String string2 = bufferedReader.readLine();
            if (string2 == null || !string2.startsWith("StartFontMetrics")) {
                throw new MapyrusException(MapyrusMessages.get("notaafmfile") + ": " + string);
            }
            while (!bl2 && string2 != null) {
                int n;
                int n2;
                StringTokenizer stringTokenizer;
                if (bl && string2.startsWith("C")) {
                    Integer n3;
                    stringTokenizer = new StringTokenizer(string2, " ;");
                    if (stringTokenizer.countTokens() < 6) {
                        throw new MapyrusException(MapyrusMessages.get("notaafmfile") + ": " + string + ": " + string2);
                    }
                    stringTokenizer.nextToken();
                    n2 = Integer.parseInt(stringTokenizer.nextToken());
                    stringTokenizer.nextToken();
                    n = Short.parseShort(stringTokenizer.nextToken());
                    stringTokenizer.nextToken();
                    String string3 = stringTokenizer.nextToken();
                    if (bl3 && (n2 < 0 || n2 > 127) && (n3 = mISOLatin1CharIndexes.get(string3)) != null) {
                        n2 = n3;
                    }
                    if (n2 >= 0 && n2 < this.mCharWidths.length) {
                        this.mCharWidths[n2] = n;
                        if (n2 < this.mFirstChar) {
                            this.mFirstChar = n2;
                        }
                        if (n2 > this.mLastChar) {
                            this.mLastChar = n2;
                        }
                    }
                } else if (string2.startsWith("FontName")) {
                    stringTokenizer = new StringTokenizer(string2);
                    if (stringTokenizer.countTokens() < 2) {
                        throw new MapyrusException(MapyrusMessages.get("notaafmfile") + ": " + string + ": " + string2);
                    }
                    stringTokenizer.nextToken();
                    this.mFontName = stringTokenizer.nextToken();
                    bl3 = hashSet.contains(this.mFontName);
                } else if (string2.startsWith("IsFixedPitch") && string2.toLowerCase().indexOf("true") >= 0) {
                    this.mIsFixedPitch = true;
                    this.mFlags |= 1;
                } else if (string2.startsWith("ItalicAngle")) {
                    stringTokenizer = new StringTokenizer(string2);
                    if (stringTokenizer.countTokens() < 2) {
                        throw new MapyrusException(MapyrusMessages.get("notaafmfile") + ": " + string + ": " + string2);
                    }
                    stringTokenizer.nextToken();
                    this.mItalicAngle = (int)Math.round(Double.parseDouble(stringTokenizer.nextToken()));
                } else if (string2.startsWith("CapHeight")) {
                    stringTokenizer = new StringTokenizer(string2);
                    if (stringTokenizer.countTokens() < 2) {
                        throw new MapyrusException(MapyrusMessages.get("notaafmfile") + ": " + string + ": " + string2);
                    }
                    stringTokenizer.nextToken();
                    this.mCapHeight = Integer.parseInt(stringTokenizer.nextToken());
                } else if (string2.startsWith("Ascender")) {
                    stringTokenizer = new StringTokenizer(string2);
                    if (stringTokenizer.countTokens() < 2) {
                        throw new MapyrusException(MapyrusMessages.get("notaafmfile") + ": " + string + ": " + string2);
                    }
                    stringTokenizer.nextToken();
                    this.mAscender = Integer.parseInt(stringTokenizer.nextToken());
                } else if (string2.startsWith("Descender")) {
                    stringTokenizer = new StringTokenizer(string2);
                    if (stringTokenizer.countTokens() < 2) {
                        throw new MapyrusException(MapyrusMessages.get("notaafmfile") + ": " + string + ": " + string2);
                    }
                    stringTokenizer.nextToken();
                    this.mDescender = Integer.parseInt(stringTokenizer.nextToken());
                } else if (string2.startsWith("FontBBox")) {
                    stringTokenizer = new StringTokenizer(string2);
                    if (stringTokenizer.countTokens() < 5) {
                        throw new MapyrusException(MapyrusMessages.get("notaafmfile") + ": " + string + ": " + string2);
                    }
                    stringTokenizer.nextToken();
                    n2 = Integer.parseInt(stringTokenizer.nextToken());
                    n = Integer.parseInt(stringTokenizer.nextToken());
                    int n4 = Integer.parseInt(stringTokenizer.nextToken());
                    int n5 = Integer.parseInt(stringTokenizer.nextToken());
                    this.mFontBBox = new Rectangle(n2, n, n4 - n2, n5 - n);
                } else if (string2.startsWith("Weight")) {
                    stringTokenizer = new StringTokenizer(string2);
                    while (stringTokenizer.hasMoreTokens()) {
                        String string4 = stringTokenizer.nextToken();
                        if (!string4.equalsIgnoreCase("italic")) continue;
                        this.mFlags |= 0x40;
                    }
                } else if (string2.startsWith("StartCharMetrics")) {
                    bl = true;
                } else if (string2.startsWith("EndCharMetrics")) {
                    bl = false;
                    bl2 = true;
                }
                string2 = bufferedReader.readLine();
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new MapyrusException(MapyrusMessages.get("notaafmfile") + ": " + string + ": " + numberFormatException.getMessage());
        }
    }

    public String getFontName() {
        return this.mFontName;
    }

    public int getFirstChar() {
        return this.mFirstChar;
    }

    public int getLastChar() {
        return this.mLastChar;
    }

    public int getCharWidth(int n) {
        return this.mCharWidths[n];
    }

    public int getItalicAngle() {
        return this.mItalicAngle;
    }

    public int getCapHeight() {
        return this.mCapHeight;
    }

    public Rectangle getFontBBox() {
        return this.mFontBBox;
    }

    public int getFlags() {
        return this.mFlags;
    }

    public int getAscender() {
        return this.mAscender;
    }

    public int getDescender() {
        return this.mDescender;
    }

    public String toString() {
        return "Adobe Font Metrics for " + this.mFontName;
    }

    public double getStringWidth(String string, double d) {
        double d2;
        int n = 0;
        int n2 = string.length();
        if (this.mIsFixedPitch) {
            int n3 = 32;
            d2 = (double)string.length() * ((double)this.mCharWidths[n3] / 1000.0) * d;
        } else {
            for (int i = 0; i < n2; ++i) {
                char c = string.charAt(i);
                if (c >= '\u0000' && c < this.mCharWidths.length) {
                    n += this.mCharWidths[c];
                    continue;
                }
                n += 1000;
            }
            d2 = (double)n / 1000.0 * d;
        }
        return d2;
    }

    static {
        mISOLatin1CharIndexes.put("Aacute", new Integer(193));
        mISOLatin1CharIndexes.put("Acircumflex", new Integer(194));
        mISOLatin1CharIndexes.put("Adieresis", new Integer(196));
        mISOLatin1CharIndexes.put("Agrave", new Integer(192));
        mISOLatin1CharIndexes.put("Aring", new Integer(197));
        mISOLatin1CharIndexes.put("Atilde", new Integer(195));
        mISOLatin1CharIndexes.put("Ccedilla", new Integer(199));
        mISOLatin1CharIndexes.put("Eacute", new Integer(201));
        mISOLatin1CharIndexes.put("Ecircumflex", new Integer(202));
        mISOLatin1CharIndexes.put("Edieresis", new Integer(203));
        mISOLatin1CharIndexes.put("Egrave", new Integer(200));
        mISOLatin1CharIndexes.put("Eth", new Integer(0));
        mISOLatin1CharIndexes.put("Iacute", new Integer(205));
        mISOLatin1CharIndexes.put("Icircumflex", new Integer(206));
        mISOLatin1CharIndexes.put("Idieresis", new Integer(207));
        mISOLatin1CharIndexes.put("Igrave", new Integer(204));
        mISOLatin1CharIndexes.put("Oacute", new Integer(211));
        mISOLatin1CharIndexes.put("Ocircumflex", new Integer(212));
        mISOLatin1CharIndexes.put("Odieresis", new Integer(214));
        mISOLatin1CharIndexes.put("Ograve", new Integer(210));
        mISOLatin1CharIndexes.put("Oslash", new Integer(216));
        mISOLatin1CharIndexes.put("Otilde", new Integer(213));
        mISOLatin1CharIndexes.put("Thorn", new Integer(222));
        mISOLatin1CharIndexes.put("Uacute", new Integer(218));
        mISOLatin1CharIndexes.put("Ucircumflex", new Integer(219));
        mISOLatin1CharIndexes.put("Udieresis", new Integer(220));
        mISOLatin1CharIndexes.put("Ugrave", new Integer(217));
        mISOLatin1CharIndexes.put("Yacute", new Integer(221));
        mISOLatin1CharIndexes.put("acircumflex", new Integer(226));
        mISOLatin1CharIndexes.put("acute", new Integer(225));
        mISOLatin1CharIndexes.put("adieresis", new Integer(228));
        mISOLatin1CharIndexes.put("agrave", new Integer(224));
        mISOLatin1CharIndexes.put("aring", new Integer(229));
        mISOLatin1CharIndexes.put("atilde", new Integer(227));
        mISOLatin1CharIndexes.put("breve", new Integer(150));
        mISOLatin1CharIndexes.put("brokenbar", new Integer(166));
        mISOLatin1CharIndexes.put("caron", new Integer(159));
        mISOLatin1CharIndexes.put("ccedilla", new Integer(231));
        mISOLatin1CharIndexes.put("cedilla", new Integer(184));
        mISOLatin1CharIndexes.put("cent", new Integer(162));
        mISOLatin1CharIndexes.put("circumflex", new Integer(147));
        mISOLatin1CharIndexes.put("copyright", new Integer(169));
        mISOLatin1CharIndexes.put("currency", new Integer(164));
        mISOLatin1CharIndexes.put("degree", new Integer(176));
        mISOLatin1CharIndexes.put("dieresis", new Integer(168));
        mISOLatin1CharIndexes.put("divide", new Integer(247));
        mISOLatin1CharIndexes.put("dotaccent", new Integer(151));
        mISOLatin1CharIndexes.put("dotlessi", new Integer(144));
        mISOLatin1CharIndexes.put("eacute", new Integer(233));
        mISOLatin1CharIndexes.put("ecircumflex", new Integer(234));
        mISOLatin1CharIndexes.put("edieresis", new Integer(235));
        mISOLatin1CharIndexes.put("egrave", new Integer(232));
        mISOLatin1CharIndexes.put("eth", new Integer(240));
        mISOLatin1CharIndexes.put("exclamdown", new Integer(161));
        mISOLatin1CharIndexes.put("germandbls", new Integer(223));
        mISOLatin1CharIndexes.put("grave", new Integer(145));
        mISOLatin1CharIndexes.put("guillemotleft", new Integer(171));
        mISOLatin1CharIndexes.put("guillemotright", new Integer(187));
        mISOLatin1CharIndexes.put("hungarumlaut", new Integer(157));
        mISOLatin1CharIndexes.put("hyphen", new Integer(173));
        mISOLatin1CharIndexes.put("iacute", new Integer(237));
        mISOLatin1CharIndexes.put("icircumflex", new Integer(238));
        mISOLatin1CharIndexes.put("idieresis", new Integer(239));
        mISOLatin1CharIndexes.put("igrave", new Integer(236));
        mISOLatin1CharIndexes.put("logicalnot", new Integer(172));
        mISOLatin1CharIndexes.put("macron", new Integer(175));
        mISOLatin1CharIndexes.put("mu", new Integer(0));
        mISOLatin1CharIndexes.put("multiply", new Integer(215));
        mISOLatin1CharIndexes.put("ntilde", new Integer(241));
        mISOLatin1CharIndexes.put("oacute", new Integer(243));
        mISOLatin1CharIndexes.put("ocircumflex", new Integer(244));
        mISOLatin1CharIndexes.put("odieresis", new Integer(246));
        mISOLatin1CharIndexes.put("ogonek", new Integer(158));
        mISOLatin1CharIndexes.put("ograve", new Integer(242));
        mISOLatin1CharIndexes.put("onehalf", new Integer(189));
        mISOLatin1CharIndexes.put("onequarter", new Integer(188));
        mISOLatin1CharIndexes.put("onesuperior", new Integer(185));
        mISOLatin1CharIndexes.put("ordfeminine", new Integer(170));
        mISOLatin1CharIndexes.put("ordmasculine", new Integer(186));
        mISOLatin1CharIndexes.put("oslash", new Integer(248));
        mISOLatin1CharIndexes.put("otilde", new Integer(245));
        mISOLatin1CharIndexes.put("paragraph", new Integer(182));
        mISOLatin1CharIndexes.put("periodcentered", new Integer(183));
        mISOLatin1CharIndexes.put("plusminus", new Integer(177));
        mISOLatin1CharIndexes.put("questiondown", new Integer(191));
        mISOLatin1CharIndexes.put("registered", new Integer(174));
        mISOLatin1CharIndexes.put("ring", new Integer(154));
        mISOLatin1CharIndexes.put("section", new Integer(167));
        mISOLatin1CharIndexes.put("sterling", new Integer(163));
        mISOLatin1CharIndexes.put("thorn", new Integer(254));
        mISOLatin1CharIndexes.put("threequarters", new Integer(190));
        mISOLatin1CharIndexes.put("threesuperior", new Integer(179));
        mISOLatin1CharIndexes.put("tilde", new Integer(148));
        mISOLatin1CharIndexes.put("twosuperior", new Integer(178));
        mISOLatin1CharIndexes.put("uacute", new Integer(250));
        mISOLatin1CharIndexes.put("ucircumflex", new Integer(251));
        mISOLatin1CharIndexes.put("udieresis", new Integer(252));
        mISOLatin1CharIndexes.put("ugrave", new Integer(249));
        mISOLatin1CharIndexes.put("yacute", new Integer(253));
        mISOLatin1CharIndexes.put("ydieresis", new Integer(255));
        mISOLatin1CharIndexes.put("yen", new Integer(165));
    }
}

