/*
 * Decompiled with CFR 0.152.
 */
package org.mapyrus.dataset;

import java.awt.geom.Rectangle2D;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.mapyrus.Argument;
import org.mapyrus.Constants;
import org.mapyrus.MapyrusException;
import org.mapyrus.MapyrusMessages;
import org.mapyrus.Row;
import org.mapyrus.dataset.GeographicDataset;

public class OGRDataset
implements GeographicDataset {
    private LineNumberReader mReader;
    private String mFilename;
    private Process mProcess;
    private double mXMin;
    private double mYMin;
    private double mXMax;
    private double mYMax;
    private String mNextLine;
    private String mProjection;
    private String[] mFieldNames;

    private String readWKTProjection(LineNumberReader lineNumberReader) throws IOException, MapyrusException {
        int n;
        int n2;
        String string = "";
        do {
            String string2;
            if ((string2 = lineNumberReader.readLine().trim()) == null || string.length() > 2048) {
                throw new MapyrusException(MapyrusMessages.get("invalidogrprojection") + ": " + string);
            }
            string = string + string2;
            n = 0;
            n2 = 0;
            int n3 = string.indexOf(91);
            while (n3 >= 0) {
                ++n2;
                n3 = string.indexOf(91, n3 + 1);
            }
            n3 = string.indexOf(93);
            while (n3 >= 0) {
                ++n;
                n3 = string.indexOf(93, n3 + 1);
            }
        } while (n2 != n);
        return string;
    }

    public OGRDataset(String string, String string2, InputStream inputStream) throws FileNotFoundException, IOException, MapyrusException {
        Object object;
        this.mFilename = string;
        if (string.equals("-")) {
            this.mReader = new LineNumberReader(new InputStreamReader(inputStream));
        } else if (string.endsWith("|")) {
            String string3 = string.substring(0, string.length() - 1).trim();
            object = Constants.getOSName().indexOf("WIN") >= 0 ? new String[]{string3} : new String[]{"sh", "-c", string3};
            this.mProcess = Runtime.getRuntime().exec((String[])object);
            this.mReader = new LineNumberReader(new InputStreamReader(this.mProcess.getInputStream()));
        } else {
            this.mReader = new LineNumberReader(new FileReader(string));
        }
        boolean bl = false;
        object = this.mReader.readLine();
        while (object != null && !bl) {
            Object object2;
            if (((String)object).startsWith("Extent:")) {
                object2 = new StringTokenizer((String)object, " (),");
                if (((StringTokenizer)object2).countTokens() < 6) continue;
                ((StringTokenizer)object2).nextToken();
                this.mXMin = Double.parseDouble(((StringTokenizer)object2).nextToken());
                this.mYMin = Double.parseDouble(((StringTokenizer)object2).nextToken());
                String string4 = ((StringTokenizer)object2).nextToken();
                while (!string4.equals("-")) {
                    string4 = ((StringTokenizer)object2).nextToken();
                }
                this.mXMax = Double.parseDouble(((StringTokenizer)object2).nextToken());
                this.mYMax = Double.parseDouble(((StringTokenizer)object2).nextToken());
                object = this.mReader.readLine();
                continue;
            }
            if (((String)object).startsWith("Layer SRS")) {
                this.mProjection = this.readWKTProjection(this.mReader);
                object = this.mReader.readLine();
                object2 = new ArrayList();
                while (object != null && !((String)object).startsWith("OGRFeature")) {
                    int n = ((String)object).indexOf(58);
                    if (n >= 0) {
                        String string5 = ((String)object).substring(0, n);
                        ((ArrayList)object2).add(string5);
                    }
                    object = this.mReader.readLine();
                }
                ((ArrayList)object2).add("STYLE");
                ((ArrayList)object2).add("GEOMETRY");
                this.mFieldNames = new String[((ArrayList)object2).size()];
                ((ArrayList)object2).toArray(this.mFieldNames);
                bl = true;
                continue;
            }
            object = this.mReader.readLine();
        }
        if (!bl) {
            throw new MapyrusException(MapyrusMessages.get("invalidogrheader") + ": " + this.mFilename);
        }
        this.mNextLine = object;
    }

    public String getProjection() {
        return this.mProjection;
    }

    public Hashtable getMetadata() {
        return new Hashtable();
    }

    public String[] getFieldNames() {
        return this.mFieldNames;
    }

    public Rectangle2D.Double getWorlds() {
        return new Rectangle2D.Double(this.mXMin, this.mYMin, this.mXMax - this.mXMin, this.mYMax - this.mYMin);
    }

    public Row fetch() throws MapyrusException {
        Row row = null;
        try {
            if (this.mNextLine != null) {
                if (this.mNextLine.length() == 0) {
                    this.mNextLine = this.mReader.readLine();
                }
                if (this.mNextLine != null && this.mNextLine.startsWith("OGRFeature")) {
                    int n;
                    row = new Row(this.mFieldNames.length);
                    for (n = 0; n < this.mFieldNames.length - 2; ++n) {
                        this.mNextLine = this.mReader.readLine();
                        if (this.mNextLine == null) {
                            throw new EOFException(MapyrusMessages.get("unexpectedeof") + ": " + this.mFilename);
                        }
                        int n2 = this.mNextLine.indexOf(61);
                        if (n2 < 0) {
                            throw new MapyrusException(MapyrusMessages.get("invalidogrfeature") + ": " + this.mNextLine);
                        }
                        String string = this.mNextLine.substring(n2 + 2);
                        if (string.length() == 0) {
                            row.add(Argument.emptyString);
                            continue;
                        }
                        row.add(new Argument(1, string));
                    }
                    this.mNextLine = this.mReader.readLine();
                    if (this.mNextLine == null) {
                        throw new EOFException(MapyrusMessages.get("unexpectedeof") + ": " + this.mFilename);
                    }
                    n = this.mNextLine.indexOf("Style =");
                    if (n >= 0) {
                        row.add(new Argument(1, this.mNextLine.substring(n + 8)));
                        this.mNextLine = this.mReader.readLine();
                    } else {
                        row.add(Argument.emptyString);
                    }
                    if (this.mNextLine == null) {
                        throw new EOFException(MapyrusMessages.get("unexpectedeof") + ": " + this.mFilename);
                    }
                    row.add(new Argument(1, this.mNextLine.trim()));
                    this.mNextLine = this.mReader.readLine();
                }
            }
        }
        catch (IOException iOException) {
            throw new MapyrusException(iOException.getMessage());
        }
        return row;
    }

    public void close() throws MapyrusException {
        block14: {
            try {
                if (this.mProcess != null) {
                    while (this.mReader.read() > 0) {
                    }
                }
                if (this.mProcess == null) break block14;
                try {
                    int n = this.mProcess.waitFor();
                    if (n != 0) {
                        throw new MapyrusException(MapyrusMessages.get("processerror") + ": " + this.mFilename);
                    }
                }
                catch (InterruptedException interruptedException) {
                    throw new MapyrusException(interruptedException.getMessage());
                }
            }
            catch (IOException iOException) {
                throw new MapyrusException(iOException.getMessage());
            }
            finally {
                try {
                    this.mReader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

