/*
 * Decompiled with CFR 0.152.
 */
package org.mapyrus.dataset;

import java.io.IOException;
import java.io.InputStream;
import org.mapyrus.Constants;
import org.mapyrus.MapyrusException;
import org.mapyrus.MapyrusMessages;
import org.mapyrus.dataset.GeographicDataset;
import org.mapyrus.dataset.GrassDataset;
import org.mapyrus.dataset.JDBCDataset;
import org.mapyrus.dataset.OGRDataset;
import org.mapyrus.dataset.OpenStreetMapDataset;
import org.mapyrus.dataset.ShapefileDataset;
import org.mapyrus.dataset.TextfileDataset;

public class DatasetFactory {
    public static GeographicDataset open(String string, String string2, String string3, InputStream inputStream) throws MapyrusException {
        String string4;
        GeographicDataset geographicDataset;
        block10: {
            geographicDataset = null;
            string4 = null;
            try {
                if (string.equalsIgnoreCase("textfile")) {
                    geographicDataset = new TextfileDataset(string2, string3, inputStream);
                    break block10;
                }
                if (string.equalsIgnoreCase("shapefile")) {
                    geographicDataset = new ShapefileDataset(string2, string3);
                    break block10;
                }
                if (string.equalsIgnoreCase("jdbc")) {
                    geographicDataset = new JDBCDataset(string2, string3);
                    break block10;
                }
                if (string.equalsIgnoreCase("grass")) {
                    geographicDataset = new GrassDataset(string2, string3);
                    break block10;
                }
                if (string.equalsIgnoreCase("ogrinfo")) {
                    geographicDataset = new OGRDataset(string2, string3, inputStream);
                    break block10;
                }
                if (string.equalsIgnoreCase("osm")) {
                    geographicDataset = new OpenStreetMapDataset(string2, string3, inputStream);
                    break block10;
                }
                throw new MapyrusException(MapyrusMessages.get("invaliddatasettype") + ": " + string);
            }
            catch (IOException iOException) {
                string4 = iOException.getMessage();
            }
        }
        if (geographicDataset == null) {
            if (string4 == null) {
                string4 = "";
            }
            throw new MapyrusException(MapyrusMessages.get("opendataseterror") + ": " + string2 + Constants.LINE_SEPARATOR + string4);
        }
        return geographicDataset;
    }
}

