/*
 * Decompiled with CFR 0.152.
 */
package org.mapyrus;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public class PageMask {
    BufferedImage mMask;
    private Graphics2D mMaskGraphics;
    private int mMaskWidth;
    private int mMaskHeight;
    private static final int PIXELS_PER_MM = 3;

    public PageMask(int n, int n2) {
        this.mMask = new BufferedImage(n * 3, n2 * 3, 12);
        this.mMaskGraphics = (Graphics2D)this.mMask.getGraphics();
        this.mMaskGraphics.scale(3.0, 3.0);
        this.mMaskGraphics.setColor(Color.BLACK);
        this.mMaskGraphics.fillRect(0, 0, n, n2);
        this.mMaskWidth = n;
        this.mMaskHeight = n2;
    }

    public void setValue(int n, int n2, int n3, int n4, int n5) {
        int n6 = Math.min(n, n3);
        int n7 = Math.max(n, n3);
        int n8 = Math.min(n2, n4);
        int n9 = Math.max(n2, n4);
        int n10 = Math.max(n7 - n6, 1);
        int n11 = Math.max(n9 - n8, 1);
        this.mMaskGraphics.setColor(n5 != 0 ? Color.WHITE : Color.BLACK);
        this.mMaskGraphics.fillRect(n6, n8, n10, n11);
    }

    public void setValue(Shape shape, int n) {
        this.mMaskGraphics.setColor(n != 0 ? Color.WHITE : Color.BLACK);
        Rectangle2D rectangle2D = shape.getBounds2D();
        if (rectangle2D.getWidth() == 0.0 && rectangle2D.getHeight() == 0.0) {
            this.mMaskGraphics.fillRect((int)rectangle2D.getMinX(), (int)rectangle2D.getMinY(), 1, 1);
        } else {
            this.mMaskGraphics.fill(shape);
        }
    }

    public boolean isAllZero(int n, int n2, int n3, int n4) {
        int n5 = Math.min(n, n3);
        int n6 = Math.max(n, n3);
        int n7 = Math.min(n2, n4);
        int n8 = Math.max(n2, n4);
        boolean bl = n5 < 0 || n7 < 0 || n6 >= this.mMaskWidth || n8 >= this.mMaskHeight;
        for (int i = n7 * 3; !bl && i <= n8 * 3; ++i) {
            for (int j = n5 * 3; !bl && j <= n6 * 3; ++j) {
                int n9 = this.mMask.getRGB(j, i) & 0xFFFFFF;
                bl = n9 != 0;
            }
        }
        return !bl;
    }

    public boolean isAllZero(Shape shape) {
        boolean bl;
        Rectangle2D rectangle2D = shape.getBounds2D();
        boolean bl2 = bl = rectangle2D.getMinX() < 0.0 || rectangle2D.getMinY() < 0.0 || rectangle2D.getMaxX() >= (double)this.mMaskWidth || rectangle2D.getMaxY() >= (double)this.mMaskHeight;
        if (!bl) {
            BufferedImage bufferedImage = new BufferedImage(this.mMaskWidth * 3, this.mMaskHeight * 3, 12);
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            graphics2D.scale(3.0, 3.0);
            graphics2D.setColor(Color.BLACK);
            graphics2D.fillRect(0, 0, this.mMaskWidth, this.mMaskHeight);
            graphics2D.setColor(Color.WHITE);
            if (rectangle2D.getWidth() == 0.0 && rectangle2D.getHeight() == 0.0) {
                graphics2D.fillRect((int)rectangle2D.getMinX(), (int)rectangle2D.getMinY(), 1, 1);
            } else {
                graphics2D.fill(shape);
            }
            int n = (int)(rectangle2D.getMaxX() * 3.0);
            int n2 = (int)(rectangle2D.getMaxY() * 3.0);
            for (int i = (int)(rectangle2D.getMinY() * 3.0); i <= n2 && !bl; ++i) {
                for (int j = (int)(rectangle2D.getMinX() * 3.0); j <= n && !bl; ++j) {
                    int n3 = bufferedImage.getRGB(j, i) & 0xFFFFFF;
                    if (n3 == 0) continue;
                    int n4 = this.mMask.getRGB(j, i) & 0xFFFFFF;
                    bl = n4 != 0;
                }
            }
        }
        return !bl;
    }
}

