/*
 * Decompiled with CFR 0.152.
 */
package org.mapyrus;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.zip.GZIPOutputStream;
import org.mapyrus.ColorDatabase;
import org.mapyrus.Constants;
import org.mapyrus.FileOrURL;
import org.mapyrus.FontCache;
import org.mapyrus.GeometricPath;
import org.mapyrus.MapyrusException;
import org.mapyrus.MapyrusFrame;
import org.mapyrus.MapyrusMessages;
import org.mapyrus.PageMask;
import org.mapyrus.Throttle;
import org.mapyrus.font.AdobeFontMetrics;
import org.mapyrus.font.AdobeFontMetricsManager;
import org.mapyrus.font.PostScriptFont;
import org.mapyrus.font.StringDimension;
import org.mapyrus.font.TrueTypeFont;
import org.mapyrus.image.BlendComposite;
import org.mapyrus.image.ImageIOWrapper;
import org.mapyrus.io.ASCII85Writer;
import org.mapyrus.io.WildcardFile;
import org.mapyrus.pdf.PDFFile;
import org.mapyrus.ps.PostScriptFile;
import org.mapyrus.svg.SVGFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutputFormat {
    private static final int INTERNAL_IMAGE = 1;
    private static final int IMAGE_FILE = 2;
    private static final int SCREEN_WINDOW = 3;
    private static final int POSTSCRIPT_GEOMETRY = 4;
    private static final int POSTSCRIPT_IMAGE = 5;
    private static final int PDF = 6;
    private static final int SVG = 7;
    private static final int IMAGEMAP = 8;
    public static final int JUSTIFY_LEFT = 1;
    public static final int JUSTIFY_CENTER = 2;
    public static final int JUSTIFY_RIGHT = 4;
    public static final int JUSTIFY_TOP = 8;
    public static final int JUSTIFY_MIDDLE = 16;
    public static final int JUSTIFY_BOTTOM = 32;
    private static final int FONT_OUTLINE_MITER_LIMIT = 2;
    private static final String[] PDF_FONTS = new String[]{"Courier", "Courier-Bold", "Courier-BoldOblique", "Courier-Oblique", "Helvetica", "Helvetica-Bold", "Helvetica-BoldOblique", "Helvetica-Oblique", "Symbol", "Times-Bold", "Times-BoldItalic", "Times-Italic", "Times-Roman", "ZapfDingbats"};
    private String mPDFFontPrefix;
    private String mPDFImagePrefix;
    private String mPDFGstatePrefix;
    private String mSVGClipPathPrefix;
    private int mOutputType;
    private String mFormatName;
    private BufferedImage mImage;
    private String mFilename;
    private PrintWriter mWriter;
    private OutputStream mOutputStream;
    private Graphics2D mGraphics2D;
    private boolean mIsPipedOutput;
    private boolean mIsStandardOutput;
    private boolean mIsUpdatingFile;
    private Process mOutputProcess;
    private File mTempFile;
    private PrintWriter mImageMapWriter;
    private String mUniqueKey;
    private FontCache mFontCache;
    private HashSet<String> mSuppliedFontResources;
    private HashSet<String> mNeededFontResources;
    private HashSet<String> mEncodeAsISOLatin1;
    private AdobeFontMetricsManager mAdobeFontMetrics;
    private ArrayList<String> mAfmFiles;
    private ArrayList<PostScriptFont> mPfbFiles;
    private ArrayList<AdobeFontMetrics> mPDFFonts;
    private HashMap<String, TrueTypeFont> mTTFFonts;
    private double mPageWidth;
    private double mPageHeight;
    private double mResolution;
    private String mMediaBox;
    private double mMinimumLineWidth;
    private String mFontName;
    private double mFontSize;
    private int mJustificationShiftX;
    private int mJustificationShiftY;
    private double mFontRotation;
    private double mFontOutlineWidth;
    private double mFontLineSpacing;
    private Font mBaseFont;
    private PageMask mPageMask;
    private int mClipPathCounter;
    private Stack<Integer> mSVGOpenGTags;
    private int mGradientCounter;
    private ArrayList<Integer> mPDFFileOffsets;
    private StringWriter mPDFGeometryStringWriter;
    private PrintWriter mPDFGeometryWriter;
    private HashMap<String, String> mPDFExtGStateObjects;
    private HashMap<String, StringWriter> mPDFImageObjects;
    private ArrayList<PDFFile> mPDFIncludedFiles;
    private ArrayList<ArrayList<Integer>> mPDFIncludedPages;
    private DecimalFormat mCoordinateDecimal = new DecimalFormat("#.###", Constants.US_DECIMAL_FORMAT_SYMBOLS);

    private void writePostScriptHeader(double d, double d2, int n, boolean bl, ArrayList<PostScriptFont> arrayList, Color color) throws IOException, MapyrusException {
        long l = Math.round(d / 25.4 * 72.0);
        long l2 = Math.round(d2 / 25.4 * 72.0);
        StringBuffer stringBuffer = new StringBuffer("%!PS-Adobe-3.0");
        if (this.mFormatName.equals("eps") || this.mFormatName.equals("epsimage")) {
            stringBuffer.append(" EPSF-3.0");
        }
        this.writeLine(this.mWriter, stringBuffer.toString());
        if (bl) {
            this.writeLine(this.mWriter, "%%BoundingBox: 0 0 " + l2 + " " + l);
        } else {
            this.writeLine(this.mWriter, "%%BoundingBox: 0 0 " + l + " " + l2);
        }
        if (!this.mFormatName.equals("eps") && !this.mFormatName.equals("epsimage")) {
            this.writeLine(this.mWriter, "%%Pages: 1");
        }
        this.writeLine(this.mWriter, "%%DocumentData: Clean7Bit");
        this.writeLine(this.mWriter, "%%LanguageLevel: 2");
        this.writeLine(this.mWriter, "%%Creator: (Mapyrus " + Constants.getVersion() + ")");
        this.writeLine(this.mWriter, "%%OperatorMessage: (Mapyrus Output...)");
        Date date = new Date();
        this.writeLine(this.mWriter, "%%CreationDate: (" + date.toString() + ")");
        String string = System.getProperty("user.name");
        if (string != null) {
            this.writeLine(this.mWriter, "%%For: (" + string + ")");
        }
        this.writeLine(this.mWriter, "%%DocumentRequiredResources: (atend)");
        if (arrayList.size() > 0) {
            stringBuffer = new StringBuffer("%%DocumentSuppliedResources: font");
            for (PostScriptFont object : arrayList) {
                stringBuffer.append(" ").append(object.getName());
                this.mSuppliedFontResources.add(object.getName());
            }
            this.writeLine(this.mWriter, stringBuffer.toString());
        }
        this.writeLine(this.mWriter, "%%EndComments");
        this.writeLine(this.mWriter, "");
        this.writeLine(this.mWriter, "% Resolution " + n + " DPI");
        this.writeLine(this.mWriter, "%%BeginSetup");
        for (PostScriptFont postScriptFont : arrayList) {
            this.writeLine(this.mWriter, "%%BeginResource: font " + postScriptFont.getName());
            String string2 = postScriptFont.getFontDefinition();
            this.writeLine(this.mWriter, string2);
            this.writeLine(this.mWriter, "%%EndResource");
        }
        this.writeLine(this.mWriter, "%%EndSetup");
        this.writeLine(this.mWriter, "1 setlinewidth 0 setlinecap 0 setlinejoin");
        this.writeLine(this.mWriter, "[] 0 setdash 0 setgray 10 setmiterlimit");
        if (bl) {
            this.writeLine(this.mWriter, "% Turn page 90 degrees.");
            this.writeLine(this.mWriter, "90 rotate 0 " + l2 + " neg translate");
        }
        this.writeLine(this.mWriter, "0 0 " + l + " " + l2 + " rectclip");
        this.writeLine(this.mWriter, "/RG { setrgbcolor } bind def");
        if (color != null) {
            float[] fArray = color.getRGBColorComponents(null);
            this.writeLine(this.mWriter, "gsave");
            this.writeLine(this.mWriter, this.mCoordinateDecimal.format(fArray[0]) + " " + this.mCoordinateDecimal.format(fArray[1]) + " " + this.mCoordinateDecimal.format(fArray[2]) + " RG");
            this.writeLine(this.mWriter, "0 0 " + l + " " + l2 + " rectfill");
            this.writeLine(this.mWriter, "grestore");
        }
        this.writeLine(this.mWriter, "/m { moveto } bind def /l { lineto } bind def");
        this.writeLine(this.mWriter, "/c { curveto } bind def /h { closepath } bind def");
        this.writeLine(this.mWriter, "/S { stroke } bind def /f { fill } bind def");
        this.writeLine(this.mWriter, "/W { clip } bind def /n { newpath } bind def");
        this.writeLine(this.mWriter, "/ju { /fjy exch def /fjx exch def } bind def");
        this.writeLine(this.mWriter, "/font {");
        this.writeLine(this.mWriter, "/foutline exch def");
        this.writeLine(this.mWriter, "/flinespacing exch def");
        this.writeLine(this.mWriter, "/frot exch radtodeg def");
        this.writeLine(this.mWriter, "/fsize exch def findfont fsize scalefont setfont } def");
        this.writeLine(this.mWriter, "/radtodeg { 180 mul 3.1415629 div } bind def");
        this.writeLine(this.mWriter, "/t {");
        this.writeLine(this.mWriter, "/str exch def");
        this.writeLine(this.mWriter, "/nlines exch def");
        this.writeLine(this.mWriter, "/linenum exch def");
        this.writeLine(this.mWriter, "gsave currentpoint translate frot rotate");
        this.writeLine(this.mWriter, "% Shift label to correct justification");
        this.writeLine(this.mWriter, "1 fjx eq {0} if");
        this.writeLine(this.mWriter, "2 fjx eq {str stringwidth pop neg 2 div} if");
        this.writeLine(this.mWriter, "4 fjx eq {str stringwidth pop neg} if");
        this.writeLine(this.mWriter, "32 fjy eq {nlines 1 sub fsize mul flinespacing mul} if");
        this.writeLine(this.mWriter, "16 fjy eq {nlines fsize mul nlines 1 sub fsize mul flinespacing 1 sub mul add 2 div fsize sub} if");
        this.writeLine(this.mWriter, "8 fjy eq {fsize neg} if");
        this.writeLine(this.mWriter, "% Shift multi-line labels down");
        this.writeLine(this.mWriter, "linenum fsize mul flinespacing mul sub");
        this.writeLine(this.mWriter, "rmoveto");
        this.writeLine(this.mWriter, "% Draw label or label outline");
        this.writeLine(this.mWriter, "foutline 0 gt");
        this.writeLine(this.mWriter, "{str false charpath foutline w 0 j 0 J 2 M stroke}");
        this.writeLine(this.mWriter, "{str show}");
        this.writeLine(this.mWriter, "ifelse");
        this.writeLine(this.mWriter, "grestore newpath");
        this.writeLine(this.mWriter, "} bind def");
        this.writeLine(this.mWriter, "/w { setlinewidth } bind def");
        this.writeLine(this.mWriter, "/J { setlinecap } bind def");
        this.writeLine(this.mWriter, "/j { setlinejoin } bind def");
        this.writeLine(this.mWriter, "/M { setmiterlimit } bind def");
        this.writeLine(this.mWriter, "/d { setdash } bind def");
        this.writeLine(this.mWriter, "/q { gsave 12 dict begin } bind def");
        this.writeLine(this.mWriter, "/Q { end grestore } bind def");
        this.writeLine(this.mWriter, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePDFHeader(String string, double d, double d2, int n, boolean bl, ArrayList<PostScriptFont> arrayList, Color color) throws IOException, MapyrusException {
        long l = Math.round(d / 25.4 * 72.0);
        long l2 = Math.round(d2 / 25.4 * 72.0);
        this.mPfbFiles = arrayList;
        this.mPDFFileOffsets = new ArrayList();
        int n2 = this.writeLine(this.mWriter, "%PDF-1.4");
        this.mPDFFileOffsets.add(new Integer(n2));
        n2 += this.writeLine(this.mWriter, "1 0 obj % Document Catalog");
        n2 += this.writeLine(this.mWriter, "<<");
        n2 += this.writeLine(this.mWriter, "/Type /Catalog");
        n2 += this.writeLine(this.mWriter, "/Outlines 3 0 R");
        n2 += this.writeLine(this.mWriter, "/Pages 4 0 R");
        n2 += this.writeLine(this.mWriter, ">>");
        this.mPDFFileOffsets.add(new Integer(n2 += this.writeLine(this.mWriter, "endobj")));
        n2 += this.writeLine(this.mWriter, "2 0 obj % Document Metadata");
        n2 += this.writeLine(this.mWriter, "<<");
        n2 += this.writeLine(this.mWriter, "/Creator (Mapyrus " + Constants.getVersion() + ")");
        String string2 = System.getProperty("user.name");
        if (string2 != null) {
            n2 += this.writeLine(this.mWriter, "/Author (" + string2 + ")");
        }
        StringBuffer stringBuffer = new StringBuffer("D:");
        stringBuffer.append(new SimpleDateFormat("yyyyMMddHHmmssZZZZZ").format(new Date()));
        stringBuffer.insert(stringBuffer.length() - 2, '\'');
        stringBuffer.append('\'');
        n2 += this.writeLine(this.mWriter, "/CreationDate (" + stringBuffer.toString() + ")");
        n2 += this.writePostScriptString(this.mWriter, "/Title", string);
        n2 += this.writeLine(this.mWriter, ">>");
        this.mPDFFileOffsets.add(new Integer(n2 += this.writeLine(this.mWriter, "endobj")));
        n2 += this.writeLine(this.mWriter, "3 0 obj % Document");
        n2 += this.writeLine(this.mWriter, "<<");
        n2 += this.writeLine(this.mWriter, "/Type /Outlines");
        n2 += this.writeLine(this.mWriter, "/Count 0");
        n2 += this.writeLine(this.mWriter, ">>");
        this.mPDFFileOffsets.add(new Integer(n2 += this.writeLine(this.mWriter, "endobj")));
        n2 += this.writeLine(this.mWriter, "4 0 obj % Page Tree Node");
        n2 += this.writeLine(this.mWriter, "<<");
        n2 += this.writeLine(this.mWriter, "/Type /Pages");
        n2 += this.writeLine(this.mWriter, "/Kids [5 0 R]");
        n2 += this.writeLine(this.mWriter, "/Count 1");
        n2 += this.writeLine(this.mWriter, ">>");
        this.mPDFFileOffsets.add(new Integer(n2 += this.writeLine(this.mWriter, "endobj")));
        this.mMediaBox = bl ? "[0 0 " + l2 + " " + l + "]" : "[0 0 " + l + " " + l2 + "]";
        this.mWriter.flush();
        this.mPDFExtGStateObjects = new HashMap();
        this.mPDFImageObjects = new HashMap();
        this.mPDFIncludedFiles = new ArrayList();
        this.mPDFIncludedPages = new ArrayList();
        this.mPDFGeometryStringWriter = new StringWriter();
        this.mPDFGeometryWriter = new PrintWriter(this.mPDFGeometryStringWriter);
        if (bl) {
            this.writeLine(this.mPDFGeometryWriter, "0 1 -1 0 0 0 cm");
            this.writeLine(this.mPDFGeometryWriter, "1 0 0 1 0 " + -l2 + " cm");
        }
        if (color != null) {
            float[] fArray = color.getColorComponents(null);
            this.writeLine(this.mPDFGeometryWriter, "q");
            this.writeLine(this.mPDFGeometryWriter, "0 0 " + l + " " + l2 + " re");
            for (int i = 0; i < fArray.length; ++i) {
                this.writeLine(this.mPDFGeometryWriter, this.mCoordinateDecimal.format(fArray[i]));
            }
            this.writeLine(this.mPDFGeometryWriter, "rg f Q");
        }
        this.writeLine(this.mPDFGeometryWriter, "0 0 0 RG 0 0 0 rg");
        double d3 = 2.834645669291339;
        this.writeLine(this.mPDFGeometryWriter, d3 + " 0 0 " + d3 + " 0 0 cm");
        for (int i = 0; i < this.mAfmFiles.size(); ++i) {
            String string3 = this.mAfmFiles.get(i);
            BufferedReader bufferedReader = null;
            AdobeFontMetrics adobeFontMetrics = null;
            try {
                bufferedReader = new BufferedReader(new FileReader(string3));
                adobeFontMetrics = new AdobeFontMetrics(bufferedReader, string3, this.mEncodeAsISOLatin1);
                this.mPDFFonts.add(adobeFontMetrics);
                continue;
            }
            finally {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
        }
    }

    private void writePDFResources() throws IOException, MapyrusException {
        Serializable serializable;
        Object object;
        int n;
        Object object2;
        int n2;
        int n3 = 6;
        String string = "\r\n";
        StringBuffer stringBuffer = new StringBuffer(4096);
        ArrayList<Serializable> arrayList = new ArrayList<Serializable>();
        stringBuffer.append("<<").append(string);
        for (n2 = 0; n2 < PDF_FONTS.length; ++n2) {
            stringBuffer.append("/" + this.mPDFFontPrefix + n2);
            stringBuffer.append(string);
            stringBuffer.append("<< /Type /Font /Subtype /Type1");
            stringBuffer.append(" /BaseFont /" + PDF_FONTS[n2] + " /Name /" + this.mPDFFontPrefix + n2);
            if (this.mEncodeAsISOLatin1.contains(PDF_FONTS[n2])) {
                stringBuffer.append(" /Encoding /WinAnsiEncoding");
            }
            stringBuffer.append(" >>");
            stringBuffer.append(string);
        }
        for (n2 = 0; n2 < this.mPDFFonts.size(); ++n2) {
            object2 = this.mPDFFonts.get(n2);
            boolean bl = false;
            n = 0;
            object = null;
            while (n < this.mPfbFiles.size() && !bl) {
                object = this.mPfbFiles.get(n);
                if (((PostScriptFont)object).getName().equals(((AdobeFontMetrics)object2).getFontName())) {
                    bl = true;
                    continue;
                }
                ++n;
            }
            stringBuffer.append("/" + this.mPDFFontPrefix + (PDF_FONTS.length + n2));
            stringBuffer.append(string);
            stringBuffer.append("<< /Type /Font /Subtype /Type1");
            stringBuffer.append(" /BaseFont /").append(((AdobeFontMetrics)object2).getFontName());
            stringBuffer.append(" /FirstChar ").append(((AdobeFontMetrics)object2).getFirstChar());
            stringBuffer.append(" /LastChar ").append(((AdobeFontMetrics)object2).getLastChar());
            stringBuffer.append(" /Widths ").append(n3).append(" 0 R");
            serializable = new StringBuffer();
            ((StringBuffer)serializable).append(n3).append(" 0 obj % Character Widths for ").append(((AdobeFontMetrics)object2).getFontName());
            ((StringBuffer)serializable).append(string);
            ++n3;
            ((StringBuffer)serializable).append("[");
            for (int i = ((AdobeFontMetrics)object2).getFirstChar(); i <= ((AdobeFontMetrics)object2).getLastChar(); ++i) {
                if (i % 16 == 0) {
                    ((StringBuffer)serializable).append(string);
                }
                ((StringBuffer)serializable).append(' ').append(((AdobeFontMetrics)object2).getCharWidth(i));
            }
            ((StringBuffer)serializable).append("]").append(string).append("endobj").append(string);
            arrayList.add(serializable);
            stringBuffer.append(" /FontDescriptor ").append(n3).append(" 0 R");
            serializable = new StringBuffer();
            ((StringBuffer)serializable).append(n3).append(" 0 obj % Font Descriptor");
            ((StringBuffer)serializable).append(string);
            ++n3;
            ((StringBuffer)serializable).append("<<");
            ((StringBuffer)serializable).append(string);
            ((StringBuffer)serializable).append("/Type /FontDescriptor");
            ((StringBuffer)serializable).append(string);
            ((StringBuffer)serializable).append("/FontName /").append(((AdobeFontMetrics)object2).getFontName());
            ((StringBuffer)serializable).append(string);
            ((StringBuffer)serializable).append("/Flags ").append(((AdobeFontMetrics)object2).getFlags());
            ((StringBuffer)serializable).append(string);
            Rectangle rectangle = ((AdobeFontMetrics)object2).getFontBBox();
            ((StringBuffer)serializable).append("/FontBBox [" + Math.round(rectangle.getMinX()) + " " + Math.round(rectangle.getMinY()) + " " + Math.round(rectangle.getMaxX()) + " " + Math.round(rectangle.getMaxY()) + "]");
            ((StringBuffer)serializable).append(string);
            ((StringBuffer)serializable).append("/ItalicAngle ").append(((AdobeFontMetrics)object2).getItalicAngle());
            ((StringBuffer)serializable).append(string);
            ((StringBuffer)serializable).append("/Ascent ").append(((AdobeFontMetrics)object2).getAscender());
            ((StringBuffer)serializable).append(string);
            ((StringBuffer)serializable).append("/Descent ").append(((AdobeFontMetrics)object2).getDescender());
            ((StringBuffer)serializable).append(string);
            ((StringBuffer)serializable).append("/CapHeight ").append(((AdobeFontMetrics)object2).getCapHeight());
            ((StringBuffer)serializable).append(string);
            ((StringBuffer)serializable).append("/StemV 105");
            ((StringBuffer)serializable).append(string);
            if (bl) {
                ((StringBuffer)serializable).append("/FontFile ").append(n3).append(" 0 R").append(string);
            }
            ((StringBuffer)serializable).append(">>").append(string);
            ((StringBuffer)serializable).append("endobj").append(string);
            arrayList.add(serializable);
            if (bl) {
                serializable = new StringBuffer();
                ((StringBuffer)serializable).append(n3).append(" 0 obj % Font File for ").append(((PostScriptFont)object).getName());
                ((StringBuffer)serializable).append(string);
                ++n3;
                ((StringBuffer)serializable).append(((PostScriptFont)object).getFontDefinition()).append(string);
                ((StringBuffer)serializable).append("endobj").append(string);
                arrayList.add(serializable);
            }
            if (this.mEncodeAsISOLatin1.contains(((AdobeFontMetrics)object2).getFontName())) {
                stringBuffer.append("/Encoding /WinAnsiEncoding");
            }
            stringBuffer.append(" >>").append(string);
        }
        for (n2 = 0; n2 < this.mPDFIncludedFiles.size(); ++n2) {
            object2 = this.mPDFIncludedFiles.get(n2);
            ArrayList<Integer> arrayList2 = this.mPDFIncludedPages.get(n2);
            for (n = 0; n < arrayList2.size(); ++n) {
                object = arrayList2.get(n);
                serializable = ((PDFFile)object2).getFont((Integer)object, n3);
                if (serializable == null || ((ArrayList)serializable).isEmpty()) continue;
                stringBuffer.append(((ArrayList)serializable).get(0).toString());
                for (int i = 1; i < ((ArrayList)serializable).size(); ++i) {
                    arrayList.add((Serializable)((ArrayList)serializable).get(i));
                    ++n3;
                }
            }
        }
        stringBuffer.append(">>").append(string);
        Integer n4 = this.mPDFFileOffsets.get(this.mPDFFileOffsets.size() - 1);
        int n5 = n4;
        n5 += this.writeLine(this.mWriter, "5 0 obj % Single Page");
        n5 += this.writeLine(this.mWriter, "<<");
        n5 += this.writeLine(this.mWriter, "/Type /Page");
        n5 += this.writeLine(this.mWriter, "/Parent 4 0 R");
        n5 += this.writeLine(this.mWriter, "/MediaBox " + this.mMediaBox);
        n5 += this.writeLine(this.mWriter, "/Contents " + n3 + " 0 R");
        n5 += this.writeLine(this.mWriter, "/Resources");
        n5 += this.writeLine(this.mWriter, "<<");
        n5 += this.writeLine(this.mWriter, "/ProcSet [/PDF /Text /ImageB /ImageC]");
        n5 += this.writeLine(this.mWriter, "/ExtGState " + ++n3 + " 0 R");
        n5 += this.writeLine(this.mWriter, "/ColorSpace " + ++n3 + " 0 R");
        n5 += this.writeLine(this.mWriter, "/Pattern " + ++n3 + " 0 R");
        n5 += this.writeLine(this.mWriter, "/Shading " + ++n3 + " 0 R");
        n5 += this.writeLine(this.mWriter, "/XObject " + ++n3 + " 0 R");
        ++n3;
        n5 += this.writeLine(this.mWriter, "/Font");
        n5 += this.writeLine(this.mWriter, stringBuffer.toString());
        n5 += this.writeLine(this.mWriter, ">>");
        n5 += this.writeLine(this.mWriter, ">>");
        this.mPDFFileOffsets.add(new Integer(n5 += this.writeLine(this.mWriter, "endobj")));
        for (int i = 0; i < arrayList.size(); ++i) {
            this.mPDFFileOffsets.add(new Integer(n5 += this.writeLine(this.mWriter, ((StringBuffer)arrayList.get(i)).toString())));
        }
    }

    private void writePostScriptScaling() {
        this.writeLine(this.mWriter, "% Set scaling so that (x, y) coordinates are given in millimetres");
        this.writeLine(this.mWriter, "72 25.4 div dup scale");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeSVGHeader(double d, double d2, String string, Color color) throws IOException, MapyrusException {
        String[] stringArray;
        this.writeLine(this.mWriter, "<?xml version=\"1.0\" encoding=\"ISO-8859-1\" standalone=\"no\"?>");
        Date date = new Date();
        this.writeLine(this.mWriter, "<!-- Created by Mapyrus " + Constants.getVersion() + " on " + date.toString() + " -->");
        double d3 = (double)Constants.getScreenResolution() / 25.4;
        this.writeLine(this.mWriter, "<svg width=\"" + this.mCoordinateDecimal.format(d * d3) + "\"");
        this.writeLine(this.mWriter, "  height=\"" + this.mCoordinateDecimal.format(d2 * d3) + "\"");
        this.writeLine(this.mWriter, "  version=\"1.1\"");
        this.writeLine(this.mWriter, "  overflow=\"hidden\"");
        this.writeLine(this.mWriter, "  xml:space=\"preserve\"");
        this.writeLine(this.mWriter, "  xmlns=\"http://www.w3.org/2000/svg\">");
        if (string != null) {
            stringArray = null;
            try {
                String string2;
                stringArray = new FileOrURL(string).getReader();
                while ((string2 = stringArray.readLine()) != null) {
                    this.writeLine(this.mWriter, string2);
                }
            }
            finally {
                if (stringArray != null) {
                    stringArray.close();
                }
            }
        }
        if (color != null) {
            this.writeLine(this.mWriter, "<rect x=\"0\" y=\"0\" width=\"100%\"");
            this.writeLine(this.mWriter, "  height=\"100%\" stroke=\"none\"");
            this.writeLine(this.mWriter, "  fill=\"" + ColorDatabase.toHexString(color) + "\" fill-opacity=\"1\"/>");
        }
        this.writeLine(this.mWriter, "<g transform=\"scale(" + d3 + ")\"");
        this.writeLine(this.mWriter, "  style=\"fill-rule:nonzero;fill-opacity:1;stroke-opacity:1;stroke-dasharray:none;\"");
        this.writeLine(this.mWriter, "  clip-rule=\"nonzero\">");
        this.mSVGOpenGTags.push(1);
        this.writeLine(this.mWriter, "<defs>");
        stringArray = new String[]{"normal", "multiply", "screen", "darken", "lighten"};
        for (int i = 0; i < stringArray.length; ++i) {
            this.writeLine(this.mWriter, "<filter id=\"" + stringArray[i] + "\">");
            this.writeLine(this.mWriter, "<feBlend mode=\"" + stringArray[i] + "\" in2=\"BackgroundImage\" in=\"SourceGraphic\"/>");
            this.writeLine(this.mWriter, "</filter>");
        }
        this.writeLine(this.mWriter, "</defs>");
    }

    private void setupBufferedImage(double d, Color color, boolean bl, boolean bl2, boolean bl3) {
        double d2 = d / 25.4;
        if (color != null) {
            Color color2 = this.mGraphics2D.getColor();
            this.mGraphics2D.setColor(color);
            this.mGraphics2D.fillRect(0, 0, this.mImage.getWidth(), this.mImage.getHeight());
            this.mGraphics2D.setColor(color2);
        }
        this.mGraphics2D.translate(0, this.mImage.getHeight());
        this.mGraphics2D.scale(d2, -d2);
        if (bl) {
            this.mGraphics2D.addRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        } else {
            this.mGraphics2D.addRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF));
        }
        if (bl2) {
            this.mGraphics2D.addRenderingHints(new RenderingHints(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON));
        } else {
            this.mGraphics2D.addRenderingHints(new RenderingHints(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF));
        }
        if (bl3) {
            this.mGraphics2D.addRenderingHints(new RenderingHints(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON));
        } else {
            this.mGraphics2D.addRenderingHints(new RenderingHints(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF));
        }
    }

    private boolean isSupportedImageFormat(String string) {
        boolean bl = false;
        String[] stringArray = ImageIOWrapper.getWriterFormatNames();
        for (int i = 0; i < stringArray.length && !bl; ++i) {
            if (!string.equalsIgnoreCase(stringArray[i])) continue;
            bl = true;
        }
        return bl;
    }

    private String isoLatinEncode(String string) {
        return "/" + string + " findfont" + Constants.LINE_SEPARATOR + "dup length dict begin" + Constants.LINE_SEPARATOR + "{1 index /FID ne {def} {pop pop} ifelse} forall" + Constants.LINE_SEPARATOR + "/Encoding ISOLatin1Encoding def" + Constants.LINE_SEPARATOR + "currentdict" + Constants.LINE_SEPARATOR + "end" + Constants.LINE_SEPARATOR + "/" + string + " exch definefont pop";
    }

    private String getUniqueKey() {
        StringBuffer stringBuffer = new StringBuffer();
        long l = System.currentTimeMillis() & Integer.MAX_VALUE;
        String string = Long.toHexString(l);
        int n = 8 - string.length();
        stringBuffer.append("Mapyrus".charAt(0));
        while (n-- > 0) {
            stringBuffer.append("0");
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setOutput(String string, double d, double d2, String string2, PrintStream printStream) throws IOException, MapyrusException {
        Object object;
        Object object2;
        ArrayList<PostScriptFont> arrayList = new ArrayList<PostScriptFont>();
        this.mEncodeAsISOLatin1 = new HashSet();
        this.mTTFFonts = new HashMap();
        this.mPDFFonts = new ArrayList();
        this.mAfmFiles = new ArrayList();
        this.mSVGOpenGTags = new Stack();
        this.mIsUpdatingFile = false;
        boolean bl = false;
        Color color = null;
        boolean bl2 = true;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        String string3 = null;
        Rectangle rectangle = null;
        this.mUniqueKey = this.getUniqueKey();
        this.mPDFFontPrefix = this.mUniqueKey + "F";
        this.mPDFImagePrefix = this.mUniqueKey + "Img";
        this.mPDFGstatePrefix = this.mUniqueKey + "Gstate";
        this.mSVGClipPathPrefix = this.mUniqueKey + "C";
        int n = this.mOutputType == 4 ? 300 : (this.mOutputType == 6 ? 72 : Constants.getScreenResolution());
        this.mAdobeFontMetrics = null;
        this.mMinimumLineWidth = 0.0;
        StringTokenizer stringTokenizer = new StringTokenizer(string2);
        while (stringTokenizer.hasMoreTokens()) {
            Iterator<String> iterator;
            Object object3;
            object2 = stringTokenizer.nextToken();
            if (((String)object2).startsWith("pfafiles=") && this.mOutputType != 6 || ((String)object2).startsWith("pfbfiles=") && this.mOutputType == 6) {
                boolean bl6 = this.mOutputType == 6;
                object = new StringTokenizer(((String)object2).substring(9), ",");
                while (((StringTokenizer)object).hasMoreTokens()) {
                    object3 = ((StringTokenizer)object).nextToken();
                    if (((String)object3).length() <= 0) continue;
                    iterator = new WildcardFile((String)object3);
                    Iterator<String> iterator2 = ((WildcardFile)((Object)iterator)).getMatchingFiles().iterator();
                    while (iterator2.hasNext()) {
                        arrayList.add(new PostScriptFont(iterator2.next(), bl6));
                    }
                }
            }
            if (((String)object2).startsWith("afmfiles=")) {
                StringTokenizer stringTokenizer2 = new StringTokenizer(((String)object2).substring(9), ",");
                while (stringTokenizer2.hasMoreTokens()) {
                    object = stringTokenizer2.nextToken();
                    if (((String)object).length() <= 0) continue;
                    object3 = new WildcardFile((String)object);
                    iterator = ((WildcardFile)object3).getMatchingFiles().iterator();
                    while (iterator.hasNext()) {
                        this.mAfmFiles.add((String)iterator.next());
                    }
                }
                continue;
            }
            if (((String)object2).startsWith("isolatinfonts=")) {
                StringTokenizer stringTokenizer3 = new StringTokenizer(((String)object2).substring(14), ",");
                while (stringTokenizer3.hasMoreTokens()) {
                    object = stringTokenizer3.nextToken();
                    if (((String)object).length() <= 0) continue;
                    this.mEncodeAsISOLatin1.add((String)object);
                }
                continue;
            }
            if (((String)object2).startsWith("resolution=")) {
                String string4 = ((String)object2).substring(11);
                try {
                    n = Integer.parseInt(string4);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new MapyrusException(MapyrusMessages.get("invalidpageresolution") + ": " + string4);
                }
                if (n >= 1) continue;
                throw new MapyrusException(MapyrusMessages.get("invalidpageresolution") + ": " + string4);
            }
            if (((String)object2).startsWith("ttffiles=")) {
                StringTokenizer stringTokenizer4 = new StringTokenizer(((String)object2).substring(9), ",");
                while (stringTokenizer4.hasMoreTokens()) {
                    object = stringTokenizer4.nextToken();
                    if (((String)object).length() <= 0) continue;
                    object3 = new WildcardFile((String)object);
                    for (String string4 : ((WildcardFile)object3).getMatchingFiles()) {
                        TrueTypeFont trueTypeFont = new TrueTypeFont(string4);
                        String string5 = trueTypeFont.getName();
                        this.mTTFFonts.put(string5, trueTypeFont);
                        this.mTTFFonts.put(string5.toLowerCase(), trueTypeFont);
                        this.mTTFFonts.put(string5.toUpperCase(), trueTypeFont);
                    }
                }
                continue;
            }
            if (((String)object2).startsWith("turnpage=")) {
                String string6 = ((String)object2).substring(9);
                bl = string6.equalsIgnoreCase("true");
                continue;
            }
            if (((String)object2).startsWith("labelantialiasing=")) {
                String string7 = ((String)object2).substring(18);
                bl2 = string7.equalsIgnoreCase("true");
                continue;
            }
            if (((String)object2).startsWith("lineantialiasing=")) {
                String string8 = ((String)object2).substring(17);
                bl3 = string8.equalsIgnoreCase("true");
                continue;
            }
            if (((String)object2).startsWith("fractionalfontmetrics=")) {
                String string9 = ((String)object2).substring(22);
                bl4 = string9.equalsIgnoreCase("true");
                continue;
            }
            if (((String)object2).startsWith("update=") && this.mOutputType != 7 && this.mOutputType != 6) {
                String string10 = ((String)object2).substring(7);
                this.mIsUpdatingFile = string10.equalsIgnoreCase("true");
                continue;
            }
            if (((String)object2).startsWith("compress=")) {
                String string11 = ((String)object2).substring(9);
                bl5 = string11.equalsIgnoreCase("true");
                continue;
            }
            if (((String)object2).startsWith("imagemap=") && this.mOutputType == 2) {
                this.mImageMapWriter = new PrintWriter(new FileWriter(((String)object2).substring(9)));
                continue;
            }
            if (((String)object2).startsWith("background=")) {
                String string12 = ((String)object2).substring(11);
                color = ColorDatabase.getColor(string12, 255, Color.BLACK);
                if (color != null) continue;
                throw new MapyrusException(MapyrusMessages.get("colornotfound") + ": " + string12);
            }
            if (((String)object2).startsWith("scriptfile=")) {
                string3 = ((String)object2).substring(11);
                continue;
            }
            if (!((String)object2).startsWith("minimumlinewidth=")) continue;
            String string13 = ((String)object2).substring(17);
            try {
                this.mMinimumLineWidth = Double.parseDouble(string13);
            }
            catch (NumberFormatException numberFormatException) {
                throw new MapyrusException(MapyrusMessages.get("invalidlinewidth") + ": " + numberFormatException.getMessage());
            }
        }
        if (!(this.mOutputType != 4 && this.mOutputType != 5 && this.mOutputType != 6 && this.mOutputType != 2 && this.mOutputType != 7 || this.mIsUpdatingFile)) {
            this.mIsPipedOutput = string.startsWith("|");
            this.mIsStandardOutput = string.equals("-");
            if (this.mIsPipedOutput) {
                object2 = string.substring(1).trim();
                String[] stringArray = Constants.getOSName().indexOf("WIN") >= 0 ? new String[]{object2} : new String[]{"sh", "-c", object2};
                this.mOutputProcess = Runtime.getRuntime().exec(stringArray);
                this.mOutputStream = this.mOutputProcess.getOutputStream();
            } else {
                this.mOutputStream = this.mIsStandardOutput ? printStream : new FileOutputStream(string);
            }
            if (bl5) {
                this.mOutputStream = new GZIPOutputStream(this.mOutputStream);
            }
        }
        object2 = new File(string);
        if (this.mIsUpdatingFile && !((File)object2).canWrite()) {
            throw new IOException(MapyrusMessages.get("readonly") + ": " + string);
        }
        if (this.mOutputType == 4 || this.mOutputType == 5 || this.mOutputType == 6) {
            if (this.mIsUpdatingFile) {
                PostScriptFile postScriptFile = new PostScriptFile(string);
                if (postScriptFile.getNumberOfPages() > 1) {
                    throw new MapyrusException(MapyrusMessages.get("notpsfile") + ": " + string);
                }
                rectangle = postScriptFile.getBoundingBox();
                d = rectangle.getMaxX() / 72.0 * 25.4;
                d2 = rectangle.getMaxY() / 72.0 * 25.4;
                this.mTempFile = File.createTempFile("Mapyrus", null, new File(string).getAbsoluteFile().getParentFile());
                this.mOutputStream = new FileOutputStream(this.mTempFile);
            }
            this.mWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter(this.mOutputStream)));
            this.mSuppliedFontResources = new HashSet();
            if (this.mOutputType == 6) {
                this.writePDFHeader(string, d, d2, n, bl, arrayList, color);
            } else {
                this.writePostScriptHeader(d, d2, n, bl, arrayList, color);
            }
            this.mNeededFontResources = new HashSet();
            if (this.mIsUpdatingFile) {
                this.writeLine(this.mWriter, "save");
                this.writeLine(this.mWriter, "/showpage {} def");
                this.writeLine(this.mWriter, "%%BeginDocument: " + string);
                BufferedReader bufferedReader = null;
                try {
                    bufferedReader = new BufferedReader(new FileReader(string));
                    while ((object = bufferedReader.readLine()) != null) {
                        this.writeLine(this.mWriter, (String)object);
                    }
                }
                finally {
                    try {
                        if (bufferedReader != null) {
                            bufferedReader.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
                this.writeLine(this.mWriter, "%%EndDocument");
                this.writeLine(this.mWriter, "restore");
            }
            if (this.mOutputType != 6) {
                this.writePostScriptScaling();
            }
        } else if (this.mOutputType == 7) {
            this.mWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter(this.mOutputStream)));
            this.writeSVGHeader(d, d2, string3, color);
            BufferedImage bufferedImage = new BufferedImage(1, 1, 2);
            this.mGraphics2D = (Graphics2D)bufferedImage.getGraphics();
        }
        if (this.mOutputType != 4 && this.mOutputType != 7 && this.mOutputType != 6) {
            if (this.mOutputType == 2 || this.mOutputType == 3 || this.mOutputType == 5) {
                if (this.mIsUpdatingFile && this.mOutputType == 2) {
                    this.mImage = ImageIOWrapper.read((File)object2, Color.BLACK);
                    if (this.mImage == null) {
                        throw new MapyrusException(MapyrusMessages.get("invalidformat") + ": " + string);
                    }
                    d = (double)this.mImage.getWidth() / ((double)n / 25.4);
                    d2 = (double)this.mImage.getHeight() / ((double)n / 25.4);
                } else {
                    int n2 = (int)Math.round(d / 25.4 * (double)n);
                    int n3 = (int)Math.round(d2 / 25.4 * (double)n);
                    int n4 = this.mFormatName.equals("jpg") || this.mFormatName.equals("jpeg") || this.mFormatName.equals("ppm") || this.mFormatName.equals("bmp") ? 5 : 2;
                    this.mImage = new BufferedImage(n2, n3, n4);
                }
            } else if (this.mOutputType == 1) {
                d = (double)this.mImage.getWidth() / ((double)n / 25.4);
                d2 = (double)this.mImage.getHeight() / ((double)n / 25.4);
            }
            this.mGraphics2D = (Graphics2D)this.mImage.getGraphics();
            this.setupBufferedImage(n, color, bl3, bl2, bl4);
        }
        if (this.mImageMapWriter != null) {
            this.mImageMapWriter.println("<!-- HTML Imagemap created by Mapyrus for image " + string + " -->");
            this.mImageMapWriter.println("<!-- Surround contents of this file with <map name=\"foo\"> ... </map> and -->");
            this.mImageMapWriter.println("<!-- combine it with the image using HTML like <img src=\"" + string + "\" usemap=\"#foo\"> -->");
        }
        this.mFilename = string;
        this.mPageWidth = d;
        this.mPageHeight = d2;
        this.mResolution = 25.4 / (double)n;
        this.mFontCache = new FontCache();
        this.mJustificationShiftX = 1;
        this.mJustificationShiftY = 32;
        this.mFontOutlineWidth = 0.0;
        this.mFontLineSpacing = 1.0;
        this.mFontRotation = Double.MAX_VALUE;
        this.mPageMask = null;
    }

    public void setImageMapWriter(PrintWriter printWriter) {
        this.mImageMapWriter = printWriter;
    }

    public OutputFormat(String string, String string2, double d, double d2, String string3, PrintStream printStream) throws IOException, MapyrusException {
        this.mFormatName = string2.toLowerCase();
        if (this.mFormatName.equals("ps") || this.mFormatName.equals("postscript") || this.mFormatName.equals("application/postscript")) {
            this.mFormatName = "ps";
            this.mOutputType = 4;
        } else if (this.mFormatName.equals("eps")) {
            this.mOutputType = 4;
        } else if (this.mFormatName.equals("epsimage")) {
            this.mOutputType = 5;
        } else if (this.mFormatName.equals("pdf") || this.mFormatName.equals("application/pdf")) {
            this.mOutputType = 6;
        } else if (this.mFormatName.equals("svg") || this.mFormatName.equals("image/svg+xml")) {
            this.mFormatName = "svg";
            this.mOutputType = 7;
        } else if (this.mFormatName.equals("screen")) {
            this.mOutputType = 3;
        } else {
            if (this.mFormatName.equals("image/x-portable-pixmap")) {
                this.mFormatName = "ppm";
            } else if (this.mFormatName.startsWith("image/")) {
                this.mFormatName = this.mFormatName.substring(6);
            }
            if (!this.isSupportedImageFormat(this.mFormatName)) {
                throw new MapyrusException(MapyrusMessages.get("invalidformat") + ": " + string2);
            }
            this.mOutputType = 2;
        }
        this.setOutput(string, d, d2, string3, printStream);
    }

    public OutputFormat(BufferedImage bufferedImage, String string) throws IOException, MapyrusException {
        this.mOutputType = 1;
        this.mImage = bufferedImage;
        this.mFormatName = "png";
        PrintStream printStream = new PrintStream(new ByteArrayOutputStream());
        this.setOutput("", 0.0, 0.0, string, printStream);
    }

    public double getPageWidth() {
        return this.mPageWidth;
    }

    public double getPageHeight() {
        return this.mPageHeight;
    }

    public String getPageFormat() {
        return this.mFormatName;
    }

    public double getResolution() {
        return this.mResolution;
    }

    public StringDimension getStringDimension(String string, String string2, double d, double d2) throws IOException, MapyrusException {
        String string3;
        StringDimension stringDimension = new StringDimension();
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
        double d3 = 0.0;
        double d4 = 0.0;
        int n = 0;
        while ((string3 = bufferedReader.readLine()) != null) {
            double d5;
            if (this.mOutputType == 4 || this.mOutputType == 6) {
                if (this.mAdobeFontMetrics == null) {
                    this.mAdobeFontMetrics = new AdobeFontMetricsManager(this.mAfmFiles, this.mEncodeAsISOLatin1);
                }
                double d6 = d / 25.4 * 72.0;
                d5 = this.mAdobeFontMetrics.getStringWidth(string2, d6, string3);
                if ((d5 = d5 / 72.0 * 25.4) > d3) {
                    d3 = d5;
                }
                d4 = n == 0 ? (d4 += d) : (d4 += d * d2);
            } else {
                FontRenderContext fontRenderContext = this.mGraphics2D.getFontRenderContext();
                Rectangle2D rectangle2D = this.mBaseFont.getStringBounds(string3, fontRenderContext);
                d5 = rectangle2D.getWidth();
                if (d5 > d3) {
                    d3 = d5;
                }
                d4 = n == 0 ? (d4 += rectangle2D.getHeight()) : (d4 += rectangle2D.getHeight() * d2);
            }
            ++n;
        }
        stringDimension.setSize(d3, d4);
        return stringDimension;
    }

    public PageMask getPageMask() {
        if (this.mPageMask == null) {
            this.mPageMask = new PageMask((int)Math.round(this.mPageWidth), (int)Math.round(this.mPageHeight));
        }
        return this.mPageMask;
    }

    private int writeLine(PrintWriter printWriter, String string) {
        printWriter.write(string);
        printWriter.write("\r\n");
        return string.length() + 2;
    }

    private void writePostScriptOrPDFImage(BufferedImage bufferedImage, double d, double d2, double d3, double d4, double d5) throws IOException, MapyrusException {
        int n;
        PrintWriter printWriter;
        String string = null;
        if (this.mPDFImageObjects != null) {
            string = this.mPDFImagePrefix + this.mPDFImageObjects.size();
        }
        StringWriter stringWriter = null;
        if (this.mOutputType == 6) {
            stringWriter = new StringWriter();
            printWriter = new PrintWriter(stringWriter);
        } else {
            printWriter = this.mWriter;
        }
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        if (n2 <= 16 || n3 <= 16) {
            n = 1;
        } else {
            double d6 = d3 / this.mResolution;
            double d7 = d4 / this.mResolution;
            n = 1;
            while ((double)(n3 / (n + 1)) > d7 && (double)(n2 / (n + 1)) > d6) {
                ++n;
            }
        }
        int n4 = (n2 + n - 1) / n;
        int n5 = (n3 + n - 1) / n;
        Color color = this.getSingleImageColor(bufferedImage);
        if (this.mOutputType == 6) {
            this.writeLine(this.mPDFGeometryWriter, "q");
            this.writeLine(this.mPDFGeometryWriter, "1 0 0 1 " + this.mCoordinateDecimal.format(d) + " " + this.mCoordinateDecimal.format(d2) + " cm % translate");
            double d8 = Math.sin(d5);
            double d9 = Math.cos(d5);
            this.writeLine(this.mPDFGeometryWriter, this.mCoordinateDecimal.format(d9) + " " + this.mCoordinateDecimal.format(d8) + " " + this.mCoordinateDecimal.format(-d8) + " " + this.mCoordinateDecimal.format(d9) + " 0 0 cm % rotate " + this.mCoordinateDecimal.format(d5));
            this.writeLine(this.mPDFGeometryWriter, this.mCoordinateDecimal.format(d3) + " 0 0 " + this.mCoordinateDecimal.format(d4) + " 0 0 cm % scale");
            this.writeLine(this.mPDFGeometryWriter, "1 0 0 1 -0.5 -0.5 cm % translate");
            if (color != null) {
                float[] fArray = color.getColorComponents(null);
                this.writeLine(this.mPDFGeometryWriter, this.mCoordinateDecimal.format(fArray[0]) + " " + this.mCoordinateDecimal.format(fArray[1]) + " " + this.mCoordinateDecimal.format(fArray[2]) + " rg");
            }
            this.writeLine(this.mPDFGeometryWriter, "/" + string + " Do");
            this.writeLine(this.mPDFGeometryWriter, "Q");
        } else {
            this.writeLine(printWriter, "q");
            this.writeLine(printWriter, "/DeviceRGB setcolorspace");
            this.writeLine(printWriter, d + " " + d2 + " translate");
            this.writeLine(printWriter, d5 + " radtodeg rotate");
            this.writeLine(printWriter, d3 + " " + d4 + " scale");
            this.writeLine(printWriter, "-0.5 -0.5 translate");
            if (color != null) {
                float[] fArray = color.getColorComponents(null);
                this.writeLine(printWriter, this.mCoordinateDecimal.format(fArray[0]) + " " + this.mCoordinateDecimal.format(fArray[1]) + " " + this.mCoordinateDecimal.format(fArray[2]) + " RG");
            }
        }
        this.writeLine(printWriter, "% original image size " + n2 + "x" + n3 + " with reduction factor " + n);
        this.writeLine(printWriter, "<<");
        if (this.mOutputType == 6) {
            this.writeLine(printWriter, "/Type /XObject /Subtype /Image");
            if (color == null) {
                this.writeLine(printWriter, "/ColorSpace /DeviceRGB");
            }
        } else {
            this.writeLine(printWriter, "/ImageType 1");
        }
        this.writeLine(printWriter, "/Width " + n4);
        this.writeLine(printWriter, "/Height " + n5);
        if (color != null) {
            this.writeLine(printWriter, "/BitsPerComponent 1");
            this.writeLine(printWriter, "/Decode [0 1]");
            if (this.mOutputType == 6) {
                this.writeLine(printWriter, "/ImageMask true");
            }
        } else {
            this.writeLine(printWriter, "/BitsPerComponent 8");
            this.writeLine(printWriter, "/Decode [0 1 0 1 0 1]");
        }
        if (this.mOutputType == 6) {
            this.writeLine(printWriter, "/Filter [/ASCII85Decode /FlateDecode]");
        } else {
            this.writeLine(printWriter, "/ImageMatrix [" + n4 + " 0 0 " + -n5 + " 0 " + n5 + "]");
            this.writeLine(printWriter, "/DataSource currentfile /ASCII85Decode filter");
            this.writeLine(printWriter, ">>");
            if (color != null) {
                this.writeLine(printWriter, "imagemask");
            } else {
                this.writeLine(printWriter, "image");
            }
        }
        StringWriter stringWriter2 = null;
        PrintWriter printWriter2 = null;
        if (this.mOutputType == 6) {
            int n6 = n5 * n4 * 3 / 2;
            stringWriter2 = new StringWriter(n6 + 1);
            printWriter2 = new PrintWriter(stringWriter2);
        } else {
            printWriter2 = printWriter;
        }
        ASCII85Writer aSCII85Writer = new ASCII85Writer(printWriter2, this.mOutputType == 6);
        int n7 = 0;
        int n8 = 0;
        for (int i = 0; i < n3; i += n) {
            Throttle.sleep();
            for (int j = 0; j < n2; j += n) {
                int n9;
                int n10 = bufferedImage.getRGB(j, i);
                if (color != null) {
                    n9 = n10 >> 24 == 0 ? 1 : 0;
                    n7 |= (n9 <<= 7 - n8);
                    if (++n8 != 8 && j + n < n2) continue;
                    aSCII85Writer.write(n7);
                    n8 = 0;
                    n7 = 0;
                    continue;
                }
                n9 = n10 & 0xFF;
                int n11 = n10 >> 8 & 0xFF;
                int n12 = n10 >> 16 & 0xFF;
                aSCII85Writer.write(n12);
                aSCII85Writer.write(n11);
                aSCII85Writer.write(n9);
            }
        }
        aSCII85Writer.close();
        this.writeLine(printWriter2, "~>");
        if (this.mOutputType == 6) {
            printWriter2.flush();
            String string2 = stringWriter2.toString();
            this.writeLine(printWriter, "/Length " + (string2.length() + 2));
            this.writeLine(printWriter, ">>");
            this.writeLine(printWriter, "stream");
            this.writeLine(printWriter, string2);
            this.writeLine(printWriter, "endstream");
            printWriter.flush();
            this.mPDFImageObjects.put(string, stringWriter);
        } else {
            this.writeLine(printWriter, "Q");
        }
    }

    public void saveState() {
        if (this.mOutputType == 4) {
            this.writeLine(this.mWriter, "q");
        } else if (this.mOutputType == 6) {
            this.writeLine(this.mPDFGeometryWriter, "q");
        } else if (this.mOutputType == 7) {
            this.writeLine(this.mWriter, "<g>");
            this.mSVGOpenGTags.push(1);
        }
    }

    public boolean restoreState() {
        boolean bl;
        if (this.mOutputType == 4) {
            this.writeLine(this.mWriter, "Q");
            bl = true;
        } else if (this.mOutputType == 6) {
            this.writeLine(this.mPDFGeometryWriter, "Q");
            bl = false;
        } else {
            if (this.mOutputType == 7) {
                int n = this.mSVGOpenGTags.pop();
                for (int i = 0; i < n; ++i) {
                    this.writeLine(this.mWriter, "</g>");
                }
            }
            bl = false;
        }
        return bl;
    }

    public void closeOutputFormat() throws IOException, MapyrusException {
        if (this.mOutputType == 4 || this.mOutputType == 5) {
            if (this.mOutputType == 5) {
                this.writePostScriptOrPDFImage(this.mImage, this.mPageWidth / 2.0, this.mPageHeight / 2.0, this.mPageWidth, this.mPageHeight, 0.0);
            }
            if (this.mFormatName.equals("ps")) {
                this.writeLine(this.mWriter, "showpage");
            }
            this.writeLine(this.mWriter, "%%Trailer");
            this.writeLine(this.mWriter, "%%DocumentNeededResources:");
            for (String string : this.mNeededFontResources) {
                if (this.mSuppliedFontResources.contains(string)) continue;
                this.writeLine(this.mWriter, "%%+ font " + string);
            }
            this.writeLine(this.mWriter, "%%EOF");
            if (this.mIsStandardOutput) {
                this.mWriter.flush();
            } else {
                this.mWriter.close();
            }
            if (this.mWriter.checkError()) {
                throw new MapyrusException(this.mFilename + ": " + MapyrusMessages.get("errorps"));
            }
            if (!(this.mTempFile == null || new File(this.mFilename).delete() && this.mTempFile.renameTo(new File(this.mFilename)))) {
                this.mTempFile.delete();
                throw new MapyrusException(MapyrusMessages.get("readonly") + ": " + this.mFilename);
            }
        } else if (this.mOutputType == 6) {
            int n;
            Serializable serializable;
            Object object;
            this.writePDFResources();
            this.mPDFGeometryWriter.flush();
            StringBuffer stringBuffer = this.mPDFGeometryStringWriter.getBuffer();
            int n2 = stringBuffer.length();
            StringWriter stringWriter = new StringWriter(n2);
            ASCII85Writer aSCII85Writer = new ASCII85Writer(stringWriter, true);
            for (int i = 0; i < n2; ++i) {
                aSCII85Writer.write(stringBuffer.charAt(i));
            }
            aSCII85Writer.close();
            stringWriter.write("~>");
            StringBuffer stringBuffer2 = stringWriter.getBuffer();
            int n3 = stringBuffer2.length() + 2;
            int n4 = this.mPDFFileOffsets.size();
            int n5 = this.writeLine(this.mWriter, n4 + " 0 obj % Geometry Object");
            ++n4;
            n5 += this.writeLine(this.mWriter, "<< /Length " + n3);
            n5 += this.writeLine(this.mWriter, "/Filter [/ASCII85Decode /FlateDecode] >>");
            n5 += this.writeLine(this.mWriter, "stream");
            n5 += this.writeLine(this.mWriter, stringBuffer2.toString());
            n5 += this.writeLine(this.mWriter, "endstream");
            Integer n6 = this.mPDFFileOffsets.get(this.mPDFFileOffsets.size() - 1);
            this.mPDFFileOffsets.add(new Integer(n6 + (n5 += this.writeLine(this.mWriter, "endobj"))));
            n5 = this.writeLine(this.mWriter, n4 + " 0 obj % Graphics States");
            ++n4;
            n5 += this.writeLine(this.mWriter, "<<");
            Object[] objectArray = this.mPDFExtGStateObjects.keySet().toArray();
            Arrays.sort(objectArray);
            int n7 = 0;
            for (int i = 0; i < objectArray.length; ++i) {
                String string = objectArray[i].toString();
                n5 += this.writeLine(this.mWriter, "/" + string + " " + (n4 + n7 + 4) + " 0 R");
                ++n7;
            }
            ArrayList<StringBuffer> arrayList = new ArrayList<StringBuffer>();
            for (int i = 0; i < this.mPDFIncludedFiles.size(); ++i) {
                PDFFile pDFFile = this.mPDFIncludedFiles.get(i);
                object = this.mPDFIncludedPages.get(i);
                for (int j = 0; j < ((ArrayList)object).size(); ++j) {
                    Integer n8 = ((ArrayList)object).get(j);
                    serializable = pDFFile.getExtGState(n8, n4 + n7 + 4);
                    if (serializable == null || ((ArrayList)serializable).isEmpty()) continue;
                    n5 += this.writeLine(this.mWriter, ((ArrayList)serializable).get(0).toString());
                    for (int k = 1; k < ((ArrayList)serializable).size(); ++k) {
                        arrayList.add((StringBuffer)((ArrayList)serializable).get(k));
                        ++n7;
                    }
                }
            }
            n5 += this.writeLine(this.mWriter, ">>");
            n6 = this.mPDFFileOffsets.get(this.mPDFFileOffsets.size() - 1);
            this.mPDFFileOffsets.add(new Integer(n6 + (n5 += this.writeLine(this.mWriter, "endobj"))));
            n5 = this.writeLine(this.mWriter, n4 + " 0 obj % ColorSpace");
            ++n4;
            n5 += this.writeLine(this.mWriter, "<<");
            ArrayList<StringBuffer> arrayList2 = new ArrayList<StringBuffer>();
            for (int i = 0; i < this.mPDFIncludedFiles.size(); ++i) {
                object = this.mPDFIncludedFiles.get(i);
                ArrayList<Integer> arrayList3 = this.mPDFIncludedPages.get(i);
                for (int j = 0; j < arrayList3.size(); ++j) {
                    serializable = arrayList3.get(j);
                    ArrayList<StringBuffer> arrayList4 = ((PDFFile)object).getColorSpace((Integer)serializable, n4 + n7 + 3);
                    if (arrayList4 == null || arrayList4.isEmpty()) continue;
                    n5 += this.writeLine(this.mWriter, arrayList4.get(0).toString());
                    for (int k = 1; k < arrayList4.size(); ++k) {
                        arrayList2.add(arrayList4.get(k));
                        ++n7;
                    }
                }
            }
            n5 += this.writeLine(this.mWriter, ">>");
            n6 = this.mPDFFileOffsets.get(this.mPDFFileOffsets.size() - 1);
            this.mPDFFileOffsets.add(new Integer(n6 + (n5 += this.writeLine(this.mWriter, "endobj"))));
            n5 = this.writeLine(this.mWriter, n4 + " 0 obj % Pattern");
            ++n4;
            n5 += this.writeLine(this.mWriter, "<<");
            n5 += this.writeLine(this.mWriter, ">>");
            n6 = this.mPDFFileOffsets.get(this.mPDFFileOffsets.size() - 1);
            this.mPDFFileOffsets.add(new Integer(n6 + (n5 += this.writeLine(this.mWriter, "endobj"))));
            n5 = this.writeLine(this.mWriter, n4 + " 0 obj % Shading");
            ++n4;
            n5 += this.writeLine(this.mWriter, "<<");
            n5 += this.writeLine(this.mWriter, ">>");
            n6 = this.mPDFFileOffsets.get(this.mPDFFileOffsets.size() - 1);
            this.mPDFFileOffsets.add(new Integer(n6 + (n5 += this.writeLine(this.mWriter, "endobj"))));
            n5 = this.writeLine(this.mWriter, n4 + " 0 obj % Image Dictionary");
            ++n4;
            n5 += this.writeLine(this.mWriter, "<<");
            Object[] objectArray2 = this.mPDFImageObjects.keySet().toArray();
            Arrays.sort(objectArray2);
            for (int i = 0; i < objectArray2.length; ++i) {
                String string = objectArray2[i].toString();
                n5 += this.writeLine(this.mWriter, "/" + string + " " + (n4 + n7) + " 0 R");
                ++n7;
            }
            ArrayList<StringBuffer> arrayList5 = new ArrayList<StringBuffer>();
            for (n = 0; n < this.mPDFIncludedFiles.size(); ++n) {
                PDFFile pDFFile = this.mPDFIncludedFiles.get(n);
                serializable = this.mPDFIncludedPages.get(n);
                for (int i = 0; i < ((ArrayList)serializable).size(); ++i) {
                    Integer n9 = (Integer)((ArrayList)serializable).get(i);
                    ArrayList<StringBuffer> arrayList6 = pDFFile.getXObject(n9, n4 + n7);
                    if (arrayList6 == null || arrayList6.isEmpty()) continue;
                    n5 += this.writeLine(this.mWriter, arrayList6.get(0).toString());
                    for (int j = 1; j < arrayList6.size(); ++j) {
                        arrayList5.add(arrayList6.get(j));
                        ++n7;
                    }
                }
            }
            n5 += this.writeLine(this.mWriter, ">>");
            n5 += this.writeLine(this.mWriter, "endobj");
            for (n = 0; n < objectArray.length; ++n) {
                n6 = this.mPDFFileOffsets.get(this.mPDFFileOffsets.size() - 1);
                this.mPDFFileOffsets.add(new Integer(n6 + n5));
                Object object2 = objectArray[n];
                n5 = this.writeLine(this.mWriter, n4 + " 0 obj % " + object2);
                n5 += this.writeLine(this.mWriter, this.mPDFExtGStateObjects.get(object2).toString());
                n5 += this.writeLine(this.mWriter, "endobj");
                ++n4;
            }
            for (n = 0; n < arrayList.size(); ++n) {
                n6 = this.mPDFFileOffsets.get(this.mPDFFileOffsets.size() - 1);
                this.mPDFFileOffsets.add(new Integer(n6 + n5));
                String string = ((StringBuffer)arrayList.get(n)).toString();
                n5 = this.writeLine(this.mWriter, string);
                ++n4;
            }
            for (n = 0; n < arrayList2.size(); ++n) {
                n6 = this.mPDFFileOffsets.get(this.mPDFFileOffsets.size() - 1);
                this.mPDFFileOffsets.add(new Integer(n6 + n5));
                String string = ((StringBuffer)arrayList2.get(n)).toString();
                n5 = this.writeLine(this.mWriter, string);
                ++n4;
            }
            for (n = 0; n < objectArray2.length; ++n) {
                n6 = this.mPDFFileOffsets.get(this.mPDFFileOffsets.size() - 1);
                this.mPDFFileOffsets.add(new Integer(n6 + n5));
                Object object3 = objectArray2[n];
                n5 = this.writeLine(this.mWriter, n4 + " 0 obj % " + object3);
                n5 += this.writeLine(this.mWriter, this.mPDFImageObjects.get(object3).toString());
                n5 += this.writeLine(this.mWriter, "endobj");
                ++n4;
            }
            for (n = 0; n < arrayList5.size(); ++n) {
                n6 = this.mPDFFileOffsets.get(this.mPDFFileOffsets.size() - 1);
                this.mPDFFileOffsets.add(new Integer(n6 + n5));
                String string = ((StringBuffer)arrayList5.get(n)).toString();
                n5 = this.writeLine(this.mWriter, string);
                ++n4;
            }
            this.writeLine(this.mWriter, "xref");
            this.writeLine(this.mWriter, "0 " + (this.mPDFFileOffsets.size() + 1));
            this.writeLine(this.mWriter, "0000000000 65535 f");
            Iterator<Integer> iterator = this.mPDFFileOffsets.iterator();
            while (iterator.hasNext()) {
                String string = ((Object)iterator.next()).toString();
                int n10 = 10 - string.length();
                StringBuffer stringBuffer3 = new StringBuffer();
                while (n10-- > 0) {
                    stringBuffer3.append('0');
                }
                stringBuffer3.append(string);
                stringBuffer3.append(" 00000 n");
                this.writeLine(this.mWriter, stringBuffer3.toString());
            }
            this.writeLine(this.mWriter, "trailer");
            this.writeLine(this.mWriter, "<<");
            this.writeLine(this.mWriter, "/Size " + (this.mPDFFileOffsets.size() + 1));
            this.writeLine(this.mWriter, "/Root 1 0 R");
            this.writeLine(this.mWriter, "/Info 2 0 R");
            this.writeLine(this.mWriter, ">>");
            this.writeLine(this.mWriter, "startxref");
            n6 = this.mPDFFileOffsets.get(this.mPDFFileOffsets.size() - 1);
            this.writeLine(this.mWriter, Integer.toString(n6 + n5));
            this.writeLine(this.mWriter, "%%EOF");
            if (this.mIsStandardOutput) {
                this.mWriter.flush();
            } else {
                this.mWriter.close();
            }
            for (int i = 0; i < this.mPDFIncludedFiles.size(); ++i) {
                PDFFile pDFFile = this.mPDFIncludedFiles.get(i);
                pDFFile.close();
            }
            if (this.mWriter.checkError()) {
                throw new MapyrusException(this.mFilename + ": " + MapyrusMessages.get("errorps"));
            }
        } else if (this.mOutputType == 7) {
            int n = this.mSVGOpenGTags.pop();
            for (int i = 0; i < n; ++i) {
                this.writeLine(this.mWriter, "</g>");
            }
            this.writeLine(this.mWriter, "</svg>");
            if (this.mIsStandardOutput) {
                this.mWriter.flush();
            } else {
                this.mWriter.close();
            }
            if (this.mWriter.checkError()) {
                throw new MapyrusException(this.mFilename + ": " + MapyrusMessages.get("errorsvg"));
            }
        } else if (this.mOutputType == 2) {
            if (this.mIsUpdatingFile) {
                this.mOutputStream = new FileOutputStream(this.mFilename);
            }
            ImageIOWrapper.write(this.mImage, this.mFormatName, this.mOutputStream);
            if (this.mIsStandardOutput) {
                this.mOutputStream.flush();
            } else {
                this.mOutputStream.close();
            }
        } else if (this.mOutputType == 3) {
            String string = "Mapyrus: " + this.mFilename;
            MapyrusFrame mapyrusFrame = new MapyrusFrame(string, this.mImage);
            mapyrusFrame.waitForClose();
        }
        this.mImage = null;
        this.mGraphics2D = null;
        if (this.mOutputType != 1 && this.mIsPipedOutput) {
            int n = 0;
            try {
                n = this.mOutputProcess.waitFor();
            }
            catch (InterruptedException interruptedException) {
                throw new MapyrusException(this.mFilename + ": " + interruptedException.getMessage());
            }
            if (n != 0) {
                throw new MapyrusException(MapyrusMessages.get("processerror") + ": " + n + ": " + this.mFilename);
            }
        }
        if (this.mImageMapWriter != null) {
            this.mImageMapWriter.close();
        }
    }

    public void setFontAttribute(String string, double d, double d2, double d3, double d4) throws IOException, MapyrusException {
        if (this.mOutputType == 4) {
            if (this.mEncodeAsISOLatin1.contains(string)) {
                this.writeLine(this.mWriter, this.isoLatinEncode(string));
                this.mEncodeAsISOLatin1.remove(string);
            }
            this.writeLine(this.mWriter, "/" + string + " " + d + " " + d2 + " " + d4 + " " + d3 + " font");
            this.mNeededFontResources.add(string);
        } else if (this.mOutputType != 6) {
            int n = 0;
            if (string.endsWith("-Bold")) {
                n = 1;
                string = string.substring(0, string.length() - 5);
            } else if (string.endsWith("-Italic")) {
                n = 2;
                string = string.substring(0, string.length() - 7);
            } else if (string.endsWith("-BoldItalic")) {
                n = 3;
                string = string.substring(0, string.length() - 11);
            }
            Font font = this.mGraphics2D.getFont();
            float f = (float)d;
            float f2 = font.getSize2D();
            String string2 = font.getName();
            if (f != f2 || n != font.getStyle() || !string.equals(string2) || d2 != this.mFontRotation) {
                Object object;
                this.mBaseFont = this.mFontCache.get(string, n, f, 0.0);
                if (this.mBaseFont == null) {
                    object = this.mTTFFonts.get(string);
                    this.mBaseFont = object != null ? ((TrueTypeFont)object).getFont().deriveFont(n, f) : new Font(string, n, (int)f).deriveFont(f);
                    this.mFontCache.put(string, n, f, 0.0, this.mBaseFont);
                }
                if ((object = this.mFontCache.get(string, n, -f, d2)) == null) {
                    AffineTransform affineTransform = AffineTransform.getRotateInstance(d2);
                    affineTransform.scale(1.0, -1.0);
                    object = this.mBaseFont.deriveFont(affineTransform);
                    this.mFontCache.put(string, n, -f, d2, (Font)object);
                }
                this.mGraphics2D.setFont((Font)object);
            }
        }
        this.mFontRotation = d2;
        this.mFontOutlineWidth = d3;
        this.mFontLineSpacing = d4;
        this.mFontName = string;
        this.mFontSize = d;
    }

    public void setJustifyAttribute(int n) {
        this.mJustificationShiftX = (n & 1) != 0 ? 1 : ((n & 2) != 0 ? 2 : 4);
        this.mJustificationShiftY = (n & 0x20) != 0 ? 32 : ((n & 0x10) != 0 ? 16 : 8);
        if (this.mOutputType == 4) {
            this.writeLine(this.mWriter, this.mJustificationShiftX + " " + this.mJustificationShiftY + " ju");
        }
    }

    public void setColorAttribute(Color color) {
        if (this.mOutputType == 4 || this.mOutputType == 6) {
            float[] fArray = color.getRGBColorComponents(null);
            PrintWriter printWriter = this.mOutputType == 6 ? this.mPDFGeometryWriter : this.mWriter;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.mCoordinateDecimal.format(fArray[0]));
            stringBuffer.append(' ');
            stringBuffer.append(this.mCoordinateDecimal.format(fArray[1]));
            stringBuffer.append(' ');
            stringBuffer.append(this.mCoordinateDecimal.format(fArray[2]));
            this.writeLine(printWriter, stringBuffer.toString() + " RG");
            if (this.mOutputType == 6) {
                this.writeLine(printWriter, stringBuffer.toString() + " rg");
                int n = color.getAlpha();
                String string = this.mCoordinateDecimal.format((double)n / 255.0);
                String string2 = this.mPDFGstatePrefix + n;
                this.mPDFExtGStateObjects.put(string2, "<< /Type /ExtGState /CA " + string + " /ca " + string + " >>");
                this.writeLine(printWriter, "/" + string2 + " gs");
            }
        } else {
            this.mGraphics2D.setColor(color);
        }
    }

    public void setBlendAttribute(String string) {
        string = string.toLowerCase().trim();
        if (this.mOutputType == 6) {
            if (string.equals("colordodge")) {
                string = "ColorDodge";
            } else if (string.equals("colorburn")) {
                string = "ColorBurn";
            } else if (string.equals("hardlight")) {
                string = "HardLight";
            } else if (string.equals("softlight")) {
                string = "SoftLight";
            } else if (string.length() > 0) {
                string = Character.toUpperCase(string.charAt(0)) + string.substring(1);
            }
            String string2 = this.mPDFGstatePrefix + string;
            this.mPDFExtGStateObjects.put(string2, "<< /Type /ExtGState /BM /" + string + " >>");
            this.writeLine(this.mPDFGeometryWriter, "/" + string2 + " gs");
        } else if (this.mOutputType != 4) {
            Composite composite = BlendComposite.getBlendComposite(string);
            if (composite == null) {
                composite = AlphaComposite.SrcOver;
            }
            this.mGraphics2D.setComposite(composite);
        }
    }

    public void setLinestyleAttribute(BasicStroke basicStroke) {
        double d = basicStroke.getLineWidth();
        if (this.mOutputType == 4 || this.mOutputType == 6) {
            PrintWriter printWriter = this.mOutputType == 6 ? this.mPDFGeometryWriter : this.mWriter;
            int n = basicStroke.getEndCap();
            n = n == 0 ? 0 : (n == 1 ? 1 : 2);
            int n2 = basicStroke.getLineJoin();
            n2 = n2 == 0 ? 0 : (n2 == 1 ? 1 : 2);
            if (d < this.mMinimumLineWidth) {
                d = this.mMinimumLineWidth;
            }
            this.writeLine(printWriter, this.mCoordinateDecimal.format(d) + " w " + n + " J " + n2 + " j " + this.mCoordinateDecimal.format(basicStroke.getMiterLimit()) + " M");
            float[] fArray = basicStroke.getDashArray();
            if (fArray != null) {
                StringBuffer stringBuffer = new StringBuffer("[");
                for (int i = 0; i < fArray.length; ++i) {
                    if (i > 0) {
                        stringBuffer.append(" ");
                    }
                    stringBuffer.append(this.mCoordinateDecimal.format(fArray[i]));
                }
                stringBuffer.append("] ");
                stringBuffer.append(basicStroke.getDashPhase());
                stringBuffer.append(" d");
                this.writeLine(printWriter, stringBuffer.toString());
            } else {
                this.writeLine(printWriter, "[] 0 d");
            }
        } else {
            if (d < this.mMinimumLineWidth) {
                float[] fArray = basicStroke.getDashArray();
                basicStroke = fArray == null ? new BasicStroke((float)this.mMinimumLineWidth, basicStroke.getEndCap(), basicStroke.getLineJoin(), basicStroke.getMiterLimit()) : new BasicStroke((float)this.mMinimumLineWidth, basicStroke.getEndCap(), basicStroke.getLineJoin(), basicStroke.getMiterLimit(), fArray, basicStroke.getDashPhase());
            }
            this.mGraphics2D.setStroke(basicStroke);
        }
    }

    public void setClipAttribute(ArrayList arrayList) {
        if (this.mOutputType != 4 && this.mOutputType != 6 && this.mOutputType != 7) {
            boolean bl;
            this.mGraphics2D.setClip(null);
            boolean bl2 = bl = arrayList != null && arrayList.size() > 0;
            if (bl) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    GeometricPath geometricPath = (GeometricPath)arrayList.get(i);
                    this.mGraphics2D.clip(geometricPath.getShape());
                }
            }
        }
    }

    private void writeShape(Shape shape, int n, PrintWriter printWriter, String string) {
        String string2;
        PathIterator pathIterator = n == 8 ? shape.getPathIterator(null, this.mResolution) : shape.getPathIterator(null);
        float[] fArray = new float[6];
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        float f7 = (float)(this.mResolution * this.mResolution);
        int n2 = 4;
        boolean bl = false;
        int n3 = 0;
        while (!pathIterator.isDone()) {
            n2 = pathIterator.currentSegment(fArray);
            switch (n2) {
                case 0: {
                    f3 = f = fArray[0];
                    f4 = f2 = fArray[1];
                    ++n3;
                    if (n == 7) {
                        this.writeLine(printWriter, "M " + this.mCoordinateDecimal.format(f) + " " + this.mCoordinateDecimal.format(this.mPageHeight - (double)f2));
                    } else if (n == 8) {
                        if (n3 == 1) {
                            this.mImageMapWriter.print("<area shape=\"polygon\" coords=\"");
                        } else {
                            this.mImageMapWriter.print(",");
                        }
                        this.mImageMapWriter.println(Math.round((double)f / this.mResolution) + "," + Math.round((this.mPageHeight - (double)f2) / this.mResolution));
                    } else {
                        this.writeLine(printWriter, this.mCoordinateDecimal.format(f) + " " + this.mCoordinateDecimal.format(f2) + " m");
                    }
                    bl = false;
                    break;
                }
                case 1: {
                    f5 = fArray[0];
                    f6 = fArray[1];
                    float f8 = (f - f5) * (f - f5) + (f2 - f6) * (f2 - f6);
                    if (f8 >= f7) {
                        if (n == 7) {
                            string2 = this.mCoordinateDecimal.format(f5);
                            String string3 = this.mCoordinateDecimal.format(this.mPageHeight - (double)f6);
                            if (f5 == f) {
                                this.writeLine(printWriter, "V " + string3);
                            } else if (f6 == f2) {
                                this.writeLine(printWriter, "H " + string2);
                            } else {
                                this.writeLine(printWriter, "L " + string2 + " " + string3);
                            }
                        } else if (n == 8) {
                            this.mImageMapWriter.println("," + Math.round((double)f5 / this.mResolution) + "," + Math.round((this.mPageHeight - (double)f6) / this.mResolution));
                        } else {
                            this.writeLine(printWriter, this.mCoordinateDecimal.format(f5) + " " + this.mCoordinateDecimal.format(f6) + " l");
                        }
                        f = f5;
                        f2 = f6;
                        bl = false;
                        break;
                    }
                    bl = true;
                    break;
                }
                case 4: {
                    if (bl) {
                        if (n == 7) {
                            this.writeLine(printWriter, "L " + this.mCoordinateDecimal.format(f5) + " " + this.mCoordinateDecimal.format(this.mPageHeight - (double)f6));
                        } else if (n == 8) {
                            if (n3 > 0) {
                                this.mImageMapWriter.println("," + Math.round((double)f5 / this.mResolution) + "," + Math.round((this.mPageHeight - (double)f6) / this.mResolution));
                            }
                        } else {
                            this.writeLine(printWriter, this.mCoordinateDecimal.format(f5) + " " + this.mCoordinateDecimal.format(f6) + " l");
                        }
                    }
                    if (n == 7) {
                        this.writeLine(printWriter, "z");
                    } else if (n == 8) {
                        if (n3 > 0) {
                            this.mImageMapWriter.println("," + Math.round((double)f3 / this.mResolution) + "," + Math.round((this.mPageHeight - (double)f4) / this.mResolution));
                        }
                    } else {
                        this.writeLine(printWriter, "h");
                    }
                    bl = false;
                    break;
                }
                case 3: {
                    if (n == 7) {
                        this.writeLine(printWriter, "C " + this.mCoordinateDecimal.format(fArray[0]) + " " + this.mCoordinateDecimal.format(this.mPageHeight - (double)fArray[1]) + " " + this.mCoordinateDecimal.format(fArray[2]) + " " + this.mCoordinateDecimal.format(this.mPageHeight - (double)fArray[3]) + " " + this.mCoordinateDecimal.format(fArray[4]) + " " + this.mCoordinateDecimal.format(this.mPageHeight - (double)fArray[5]));
                    } else {
                        this.writeLine(printWriter, this.mCoordinateDecimal.format(fArray[0]) + " " + this.mCoordinateDecimal.format(fArray[1]) + " " + this.mCoordinateDecimal.format(fArray[2]) + " " + this.mCoordinateDecimal.format(fArray[3]) + " " + this.mCoordinateDecimal.format(fArray[4]) + " " + this.mCoordinateDecimal.format(fArray[5]) + " " + "c");
                    }
                    f = fArray[4];
                    f2 = fArray[5];
                    bl = false;
                }
            }
            pathIterator.next();
        }
        if (bl) {
            if (n == 7) {
                this.writeLine(printWriter, "L " + this.mCoordinateDecimal.format(f5) + " " + this.mCoordinateDecimal.format(this.mPageHeight - (double)f6));
            } else if (n == 8) {
                if (n3 > 0) {
                    this.mImageMapWriter.println("," + Math.round((double)f5 / this.mResolution) + "," + Math.round((this.mPageHeight - (double)f6) / this.mResolution));
                }
            } else {
                this.writeLine(printWriter, this.mCoordinateDecimal.format(f5) + " " + this.mCoordinateDecimal.format(f6) + " l");
            }
        }
        if (n == 8 && n3 > 0) {
            string2 = "\" " + string + " >";
            this.mImageMapWriter.println(string2);
        }
    }

    private Color getSingleImageColor(BufferedImage bufferedImage) {
        Color color = Color.BLACK;
        boolean bl = false;
        boolean bl2 = false;
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        for (int i = 0; i < n2 && !bl; ++i) {
            for (int j = 0; j < n && !bl; ++j) {
                int n3 = bufferedImage.getRGB(j, i);
                if ((n3 & 0xFF000000) == 0) continue;
                if (!bl2) {
                    bl2 = true;
                    color = new Color(n3 & 0xFFFFFF);
                    continue;
                }
                bl = n3 != color.getRGB();
            }
        }
        if (bl) {
            color = null;
        }
        return color;
    }

    public void drawIcon(ArrayList arrayList, BufferedImage bufferedImage, double d, double d2, double d3) throws IOException, MapyrusException {
        block11: {
            double d4;
            double d5;
            int n;
            int n2;
            block10: {
                n2 = bufferedImage.getWidth();
                n = bufferedImage.getHeight();
                if (d <= 0.0) {
                    d = (double)Math.max(n2, n) * (25.4 / (double)Constants.getScreenResolution());
                }
                d *= d3;
                if (n2 > n) {
                    d5 = d;
                    d4 = d * ((double)n / (double)n2);
                } else {
                    d4 = d;
                    d5 = d * ((double)n2 / (double)n);
                }
                if (this.mOutputType != 4 && this.mOutputType != 6) break block10;
                for (int i = 0; i < arrayList.size(); ++i) {
                    Point2D point2D = (Point2D)arrayList.get(i);
                    double d6 = point2D.getX();
                    double d7 = point2D.getY();
                    if (!(d6 + d5 >= 0.0) || !(d6 - d5 <= this.mPageWidth) || !(d7 + d4 >= 0.0) || !(d7 - d4 <= this.mPageHeight)) continue;
                    this.writePostScriptOrPDFImage(bufferedImage, d6, d7, d5, d4, d2);
                }
                break block11;
            }
            if (this.mOutputType == 7) break block11;
            double d8 = 25.4 / (double)Constants.getScreenResolution();
            double d9 = d5 / d8 / (double)n2;
            double d10 = d4 / d8 / (double)n;
            int n3 = (int)Math.round(1.0 / d9);
            int n4 = 1;
            Image image = bufferedImage;
            while (n3 > 1) {
                n3 /= 2;
                n4 *= 2;
            }
            if (n4 > 2) {
                int n5 = n2 / n4;
                int n6 = n / n4;
                if (n5 > 0 && n6 > 0) {
                    image = bufferedImage.getScaledInstance(n5, n6, 4);
                    d9 *= (double)n2 / (double)n5;
                    d10 *= (double)n / (double)n6;
                    n2 = n5;
                    n = n6;
                }
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                Point2D point2D = (Point2D)arrayList.get(i);
                double d11 = point2D.getX();
                double d12 = point2D.getY();
                AffineTransform affineTransform = AffineTransform.getTranslateInstance(d11, d12);
                affineTransform.scale(d8, d8 * -1.0);
                affineTransform.rotate(-d2);
                affineTransform.scale(d9, d10);
                affineTransform.translate((double)(-n2) / 2.0, (double)(-n) / 2.0);
                try {
                    this.mGraphics2D.drawImage(image, affineTransform, null);
                    continue;
                }
                catch (NullPointerException nullPointerException) {
                    throw new OutOfMemoryError("Failed loading icon.");
                }
            }
        }
    }

    public void drawGeoImage(BufferedImage bufferedImage, double d, double d2, double d3, double d4) throws MapyrusException, IOException {
        if (this.mOutputType == 4 || this.mOutputType == 6) {
            this.writePostScriptOrPDFImage(bufferedImage, d + d3 / 2.0, d2 + d4 / 2.0, d3, d4, 0.0);
        } else {
            AffineTransform affineTransform = AffineTransform.getTranslateInstance(d, d2 + d4);
            affineTransform.scale(1.0, -1.0);
            affineTransform.scale(d3 / (double)bufferedImage.getWidth(), d4 / (double)bufferedImage.getHeight());
            this.mGraphics2D.drawImage(bufferedImage, affineTransform, null);
        }
    }

    private void drawBoundingBoxes(ArrayList arrayList, double d, double d2) {
        GeneralPath generalPath = new GeneralPath();
        Color color = this.mGraphics2D.getColor();
        this.mGraphics2D.setColor(new Color(127, 127, 127, 127));
        for (int i = 0; i < arrayList.size(); ++i) {
            Point2D point2D = (Point2D)arrayList.get(i);
            double d3 = point2D.getX();
            double d4 = point2D.getY();
            double d5 = Math.cos(d2) * d / 2.0;
            double d6 = Math.sin(d2) * d / 2.0;
            generalPath.reset();
            generalPath.moveTo((float)(d3 - d5 + d6), (float)(d4 - d6 - d5));
            Point2D point2D2 = generalPath.getCurrentPoint();
            generalPath.lineTo((float)(point2D2.getX() - d6 - d6), (float)(point2D2.getY() + d5 + d5));
            point2D2 = generalPath.getCurrentPoint();
            generalPath.lineTo((float)(point2D2.getX() + d5 + d5), (float)(point2D2.getY() + d6 + d6));
            point2D2 = generalPath.getCurrentPoint();
            generalPath.lineTo((float)(point2D2.getX() + d6 + d6), (float)(point2D2.getY() - d5 - d5));
            generalPath.closePath();
            this.fill(generalPath, null);
        }
        this.mGraphics2D.setColor(color);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawEPS(ArrayList arrayList, String string, double d, double d2, double d3) throws IOException, MapyrusException {
        PostScriptFile postScriptFile = new PostScriptFile(string);
        Rectangle rectangle = postScriptFile.getBoundingBox();
        int n = (int)rectangle.getWidth();
        int n2 = (int)rectangle.getHeight();
        if (d <= 0.0) {
            d = (double)Math.max(n, n2) * 0.35277777777777775;
        }
        d *= d3;
        if (this.mOutputType == 4) {
            for (int i = 0; i < arrayList.size(); ++i) {
                Point2D point2D = (Point2D)arrayList.get(i);
                double d4 = point2D.getX();
                double d5 = point2D.getY();
                if (!(d4 + d >= 0.0) || !(d4 - d <= this.mPageWidth) || !(d5 + d >= 0.0) || !(d5 - d <= this.mPageHeight)) continue;
                this.writeLine(this.mWriter, "save");
                this.writeLine(this.mWriter, d4 + " " + d5 + " translate");
                this.writeLine(this.mWriter, d2 + " radtodeg rotate");
                this.writeLine(this.mWriter, -(d / 2.0) + " " + -(d / 2.0) + " translate");
                double d6 = d / (double)Math.max(n, n2);
                this.writeLine(this.mWriter, d6 + " dup scale");
                this.writeLine(this.mWriter, -rectangle.getMinX() + " " + -rectangle.getMinY() + " translate");
                this.writeLine(this.mWriter, "/showpage {} def");
                this.writeLine(this.mWriter, "0 setgray 0 setlinecap 1 setlinewidth");
                this.writeLine(this.mWriter, "0 setlinejoin 10 setmiterlimit [] 0 setdash newpath");
                this.writeLine(this.mWriter, "%%BeginDocument: (" + string + ")");
                LineNumberReader lineNumberReader = null;
                try {
                    String string2;
                    lineNumberReader = new FileOrURL(string).getReader();
                    while ((string2 = ((BufferedReader)lineNumberReader).readLine()) != null) {
                        this.writeLine(this.mWriter, string2);
                    }
                    this.writeLine(this.mWriter, "%%EndDocument");
                    this.writeLine(this.mWriter, "restore");
                    continue;
                }
                finally {
                    if (lineNumberReader != null) {
                        lineNumberReader.close();
                    }
                }
            }
        } else {
            this.drawBoundingBoxes(arrayList, d, d2);
        }
    }

    public void drawSVG(ArrayList arrayList, String string, double d, double d2, double d3) throws IOException, MapyrusException {
        SVGFile sVGFile = new SVGFile(string);
        Rectangle2D rectangle2D = sVGFile.getBoundingBox();
        int n = (int)rectangle2D.getWidth();
        int n2 = (int)rectangle2D.getHeight();
        if (d <= 0.0) {
            d = (double)Math.max(n, n2) * 0.35277777777777775;
        }
        d *= d3;
        if (this.mOutputType == 7) {
            for (int i = 0; i < arrayList.size(); ++i) {
                Point2D point2D = (Point2D)arrayList.get(i);
                double d4 = point2D.getX();
                double d5 = point2D.getY();
                if (!(d4 + d >= 0.0) || !(d4 - d <= this.mPageWidth) || !(d5 + d >= 0.0) || !(d5 - d <= this.mPageHeight)) continue;
                this.writeLine(this.mWriter, "<!-- begin " + string + " -->");
                this.writeLine(this.mWriter, "<g");
                this.writeLine(this.mWriter, sVGFile.getSVGAttributes());
                this.writeLine(this.mWriter, "transform=\"translate(" + d4 + "," + (this.mPageHeight - d5) + ")");
                this.writeLine(this.mWriter, "rotate(" + Math.toDegrees(-d2) + ")");
                this.writeLine(this.mWriter, "translate(" + this.mCoordinateDecimal.format(-d / 2.0) + "," + this.mCoordinateDecimal.format(-d / 2.0) + ")");
                double d6 = d / (double)Math.max(n, n2);
                this.writeLine(this.mWriter, "scale(" + d6 + ")\">");
                this.writeLine(this.mWriter, sVGFile.toString());
                this.writeLine(this.mWriter, "<!-- end " + string + " -->");
                this.writeLine(this.mWriter, "</g>");
            }
        } else {
            this.drawBoundingBoxes(arrayList, d, d2);
        }
    }

    public void addSVGCode(String string) throws IOException, MapyrusException {
        if (this.mOutputType == 7) {
            this.writeLine(this.mWriter, "<!-- svgcode -->");
            this.writeLine(this.mWriter, string);
        }
    }

    public void drawPDF(ArrayList arrayList, String string, int n, double d, double d2, double d3) throws IOException, MapyrusException {
        Integer n2;
        ArrayList<Integer> arrayList2;
        PDFFile pDFFile = null;
        int n3 = 0;
        while (n3 < this.mPDFIncludedFiles.size() && pDFFile == null) {
            arrayList2 = this.mPDFIncludedFiles.get(n3);
            if (((PDFFile)((Object)arrayList2)).getFilename().equals(string)) {
                pDFFile = arrayList2;
                continue;
            }
            ++n3;
        }
        if (pDFFile == null) {
            pDFFile = new PDFFile(string);
            this.mPDFIncludedFiles.add(pDFFile);
            this.mPDFIncludedPages.add(new ArrayList());
            n3 = this.mPDFIncludedFiles.size() - 1;
        }
        if (n < 1 || n > pDFFile.getPageCount()) {
            throw new MapyrusException(MapyrusMessages.get("invalidpagenumber") + ": " + pDFFile.getFilename() + ": " + n);
        }
        arrayList2 = this.mPDFIncludedPages.get(n3);
        if (!arrayList2.contains(n2 = new Integer(n))) {
            arrayList2.add(n2);
        }
        int[] nArray = pDFFile.getMediaBox(n);
        int n4 = nArray[2] - nArray[0];
        int n5 = nArray[3] - nArray[1];
        if (d <= 0.0) {
            d = (double)Math.max(n4, n5) * 0.35277777777777775;
        }
        d *= d3;
        if (this.mOutputType == 6) {
            byte[] byArray = pDFFile.getContents(n);
            for (int i = 0; i < arrayList.size(); ++i) {
                Point2D point2D = (Point2D)arrayList.get(i);
                double d4 = point2D.getX();
                double d5 = point2D.getY();
                if (!(d4 + d >= 0.0) || !(d4 - d <= this.mPageWidth) || !(d5 + d >= 0.0) || !(d5 - d <= this.mPageHeight)) continue;
                this.writeLine(this.mPDFGeometryWriter, "% " + string);
                this.writeLine(this.mPDFGeometryWriter, "q");
                this.setColorAttribute(Color.BLACK);
                this.writeLine(this.mPDFGeometryWriter, "1 0 0 1 " + this.mCoordinateDecimal.format(d4) + " " + this.mCoordinateDecimal.format(d5) + " cm");
                double d6 = Math.cos(d2);
                double d7 = Math.sin(d2);
                this.writeLine(this.mPDFGeometryWriter, d6 + " " + d7 + " " + -d7 + " " + d6 + " 0 0 cm");
                this.writeLine(this.mPDFGeometryWriter, "1 0 0 1 " + -(d / 2.0) + " " + -(d / 2.0) + " cm");
                double d8 = d / (double)Math.max(n4, n5);
                this.writeLine(this.mPDFGeometryWriter, d8 + " 0 0 " + d8 + " 0 0 cm");
                this.writeLine(this.mPDFGeometryWriter, "1 0 0 1 " + -nArray[0] + " " + -nArray[1] + " cm");
                for (int j = 0; j < byArray.length; ++j) {
                    this.mPDFGeometryWriter.write(byArray[j]);
                }
                this.writeLine(this.mPDFGeometryWriter, " Q");
            }
        } else {
            this.drawBoundingBoxes(arrayList, d, d2);
        }
    }

    public void stroke(Shape shape, String string) {
        if (this.mOutputType == 4 || this.mOutputType == 7 || this.mOutputType == 6) {
            if (shape.intersects(0.0, 0.0, this.mPageWidth, this.mPageHeight)) {
                if (this.mOutputType == 7) {
                    int n;
                    this.writeLine(this.mWriter, "<path d=\"");
                    this.writeShape(shape, this.mOutputType, this.mWriter, null);
                    this.writeLine(this.mWriter, "\"");
                    Color color = this.mGraphics2D.getColor();
                    BasicStroke basicStroke = (BasicStroke)this.mGraphics2D.getStroke();
                    float f = basicStroke.getLineWidth();
                    int n2 = basicStroke.getEndCap();
                    int n3 = basicStroke.getLineJoin();
                    float[] fArray = basicStroke.getDashArray();
                    float f2 = basicStroke.getDashPhase();
                    String string2 = n2 == 0 ? "butt" : (n2 == 2 ? "square" : "round");
                    String string3 = n3 == 2 ? "bevel" : (n3 == 0 ? "miter" : "round");
                    this.writeLine(this.mWriter, "  style=\"stroke:" + ColorDatabase.toHexString(color) + ";stroke-width:" + f + ";stroke-linecap:" + string2 + ";stroke-linejoin:" + string3);
                    if (fArray != null) {
                        StringBuffer stringBuffer = new StringBuffer(";stroke-dasharray:");
                        for (int i = 0; i < fArray.length; ++i) {
                            if (i > 0) {
                                stringBuffer.append(",");
                            }
                            stringBuffer.append(this.mCoordinateDecimal.format(fArray[i]));
                        }
                        this.writeLine(this.mWriter, stringBuffer.toString());
                        this.writeLine(this.mWriter, ";stroke-dashoffset:" + f2);
                    }
                    if ((n = color.getAlpha()) != 255) {
                        this.writeLine(this.mWriter, ";stroke-opacity:" + (float)n / 255.0f);
                    }
                    this.writeLine(this.mWriter, ";fill:none\"");
                    Composite composite = this.mGraphics2D.getComposite();
                    if (composite instanceof BlendComposite) {
                        BlendComposite blendComposite = (BlendComposite)composite;
                        this.writeLine(this.mWriter, "filter=\"url(#" + blendComposite.getName() + ")\"");
                    }
                    if (string != null) {
                        this.writeLine(this.mWriter, string);
                    }
                    this.writeLine(this.mWriter, "/>");
                } else {
                    PrintWriter printWriter = this.mOutputType == 6 ? this.mPDFGeometryWriter : this.mWriter;
                    this.writeShape(shape, this.mOutputType, printWriter, null);
                    this.writeLine(printWriter, "S");
                }
            }
        } else {
            this.mGraphics2D.draw(shape);
        }
    }

    public void fill(Shape shape, String string) {
        if (this.mOutputType == 4 || this.mOutputType == 7 || this.mOutputType == 6) {
            if (shape.intersects(0.0, 0.0, this.mPageWidth, this.mPageHeight)) {
                if (this.mOutputType == 7) {
                    this.writeLine(this.mWriter, "<path d=\"");
                    this.writeShape(shape, this.mOutputType, this.mWriter, null);
                    this.writeLine(this.mWriter, "\"");
                    Color color = this.mGraphics2D.getColor();
                    int n = color.getAlpha();
                    StringBuffer stringBuffer = new StringBuffer("  style=\"fill:");
                    stringBuffer.append(ColorDatabase.toHexString(color));
                    if (n != 255) {
                        stringBuffer.append(";fill-opacity:" + (float)n / 255.0f);
                    }
                    stringBuffer.append(";stroke:none\" ");
                    Composite composite = this.mGraphics2D.getComposite();
                    if (composite instanceof BlendComposite) {
                        BlendComposite blendComposite = (BlendComposite)composite;
                        this.writeLine(this.mWriter, "filter=\"url(#" + blendComposite.getName() + ")\"");
                    }
                    if (string != null) {
                        stringBuffer.append(string);
                    }
                    stringBuffer.append("/>");
                    this.writeLine(this.mWriter, stringBuffer.toString());
                } else {
                    PrintWriter printWriter = this.mOutputType == 6 ? this.mPDFGeometryWriter : this.mWriter;
                    this.writeShape(shape, this.mOutputType, printWriter, null);
                    this.writeLine(printWriter, "f");
                }
            }
        } else {
            this.mGraphics2D.fill(shape);
        }
    }

    public void setEventScript(Shape shape, String string) {
        if (this.mImageMapWriter != null) {
            this.writeShape(shape, 8, this.mWriter, string);
        } else if (this.mOutputType == 7) {
            this.writeLine(this.mWriter, "<path d=\"");
            this.writeShape(shape, this.mOutputType, this.mWriter, string);
            this.writeLine(this.mWriter, "\"");
            this.writeLine(this.mWriter, string);
            this.writeLine(this.mWriter, "/>");
        }
    }

    public void gradientFill(Shape shape, boolean bl, Color color, Color color2) {
        if (this.mOutputType == 7 && shape.intersects(0.0, 0.0, this.mPageWidth, this.mPageHeight)) {
            String string = "gradient" + this.mGradientCounter++;
            this.writeLine(this.mWriter, "<defs>");
            this.writeLine(this.mWriter, "<linearGradient id=\"" + string + "\"");
            if (bl) {
                this.writeLine(this.mWriter, "x1=\"0%\" y1=\"100%\" x2=\"0%\" y2=\"0%\"");
            }
            this.writeLine(this.mWriter, ">");
            this.writeLine(this.mWriter, "<stop offset=\"0%\" stop-color=\"" + ColorDatabase.toHexString(color) + "\"/>");
            this.writeLine(this.mWriter, "<stop offset=\"100%\" stop-color=\"" + ColorDatabase.toHexString(color2) + "\"/>");
            this.writeLine(this.mWriter, "</linearGradient>");
            this.writeLine(this.mWriter, "</defs>");
            this.writeLine(this.mWriter, "<path d=\"");
            this.writeShape(shape, this.mOutputType, this.mWriter, null);
            this.writeLine(this.mWriter, "\"");
            Composite composite = this.mGraphics2D.getComposite();
            if (composite instanceof BlendComposite) {
                BlendComposite blendComposite = (BlendComposite)composite;
                this.writeLine(this.mWriter, "filter=\"url(#" + blendComposite.getName() + ")\"");
            }
            this.writeLine(this.mWriter, "  fill=\"url(#" + string + ")\" stroke=\"none\"/>");
        }
    }

    public void clip(Shape shape) {
        if (this.mOutputType == 4 || this.mOutputType == 6) {
            PrintWriter printWriter = this.mOutputType == 6 ? this.mPDFGeometryWriter : this.mWriter;
            if (shape.intersects(0.0, 0.0, this.mPageWidth, this.mPageHeight)) {
                this.writeShape(shape, this.mOutputType, printWriter, null);
            } else {
                this.writeShape(new Rectangle2D.Float(-1.0f, -1.0f, 0.1f, 0.1f), this.mOutputType, printWriter, null);
            }
            this.writeLine(printWriter, "W n");
        } else if (this.mOutputType == 7) {
            ++this.mClipPathCounter;
            this.writeLine(this.mWriter, "<clipPath id=\"" + this.mSVGClipPathPrefix + this.mClipPathCounter + "\">");
            this.writeLine(this.mWriter, "<path d=\"");
            this.writeShape(shape, this.mOutputType, this.mWriter, null);
            this.writeLine(this.mWriter, "\"/>");
            this.writeLine(this.mWriter, "</clipPath>");
            this.writeLine(this.mWriter, "<g clip-path=\"url(#" + this.mSVGClipPathPrefix + this.mClipPathCounter + ")\">");
            Integer n = this.mSVGOpenGTags.pop();
            this.mSVGOpenGTags.push(n + 1);
        }
    }

    private int writePostScriptString(PrintWriter printWriter, String string, String string2) {
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        if (string != null) {
            stringBuffer.append(string).append(' ');
        }
        stringBuffer.append("(");
        for (int i = 0; i < string2.length(); ++i) {
            char c;
            if (stringBuffer.length() > 72) {
                stringBuffer.append('\\');
                n += this.writeLine(printWriter, stringBuffer.toString());
                stringBuffer.setLength(0);
            }
            if ((c = string2.charAt(i)) == '\\') {
                stringBuffer.append("\\\\");
                continue;
            }
            if (c == '(' || c == ')' || c == '%' || c < ' ' || c > 'z') {
                int n2 = c;
                int n3 = n2 / 64;
                int n4 = (n2 -= n3 * 64) / 8;
                int n5 = n2 -= n4 * 8;
                stringBuffer.append('\\');
                stringBuffer.append(n3);
                stringBuffer.append(n4);
                stringBuffer.append(n5);
                continue;
            }
            stringBuffer.append(c);
        }
        stringBuffer.append(")");
        return n += this.writeLine(printWriter, stringBuffer.toString());
    }

    public void label(ArrayList<Point2D> arrayList, String string) throws IOException, MapyrusException {
        double d = 0.0;
        double d2 = 0.0;
        FontRenderContext fontRenderContext = null;
        Stroke stroke = null;
        ArrayList<String> arrayList2 = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, Constants.LINE_SEPARATOR);
        while (stringTokenizer.hasMoreTokens()) {
            arrayList2.add(stringTokenizer.nextToken());
        }
        if (this.mOutputType != 4 && this.mOutputType != 6) {
            fontRenderContext = this.mGraphics2D.getFontRenderContext();
            if (this.mFontOutlineWidth > 0.0) {
                stroke = this.mGraphics2D.getStroke();
                BasicStroke basicStroke = new BasicStroke((float)this.mFontOutlineWidth, 0, 0, 2.0f);
                this.mGraphics2D.setStroke(basicStroke);
            }
        }
        double d3 = 0.0;
        if (this.mJustificationShiftY == 8) {
            d3 = -this.mFontSize;
        } else if (this.mJustificationShiftY == 16) {
            d3 = (double)arrayList2.size() * this.mFontSize + (double)(arrayList2.size() - 1) * this.mFontSize * (this.mFontLineSpacing - 1.0);
            d3 = d3 / 2.0 - this.mFontSize;
        } else {
            d3 = (double)(arrayList2.size() - 1) * this.mFontSize * this.mFontLineSpacing;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            double d4;
            Point2D point2D = arrayList.get(i);
            double d5 = point2D.getX();
            double d6 = point2D.getY();
            if (this.mOutputType == 6) {
                d2 = 0.0;
                d = 0.0;
                this.writeLine(this.mPDFGeometryWriter, "q");
                double d7 = Math.cos(this.mFontRotation);
                d4 = Math.sin(this.mFontRotation);
                this.writeLine(this.mPDFGeometryWriter, this.mCoordinateDecimal.format(d7) + " " + this.mCoordinateDecimal.format(d4) + " " + this.mCoordinateDecimal.format(-d4) + " " + this.mCoordinateDecimal.format(d7) + " " + this.mCoordinateDecimal.format(d5) + " " + this.mCoordinateDecimal.format(d6) + " cm");
                this.writeLine(this.mPDFGeometryWriter, "BT");
                int n = 0;
                int n2 = -1;
                while (n < PDF_FONTS.length && n2 < 0) {
                    if (PDF_FONTS[n].equals(this.mFontName)) {
                        n2 = n;
                        continue;
                    }
                    ++n;
                }
                if (n2 < 0) {
                    for (int j = 0; j < this.mPDFFonts.size() && n2 < 0; ++j) {
                        AdobeFontMetrics adobeFontMetrics = this.mPDFFonts.get(j);
                        if (!adobeFontMetrics.getFontName().equals(this.mFontName)) continue;
                        n2 = j + PDF_FONTS.length;
                    }
                    if (n2 < 0) {
                        n2 = 4;
                    }
                }
                this.writeLine(this.mPDFGeometryWriter, "/" + this.mPDFFontPrefix + n2 + " " + this.mCoordinateDecimal.format(this.mFontSize) + " Tf");
                if (this.mFontOutlineWidth > 0.0) {
                    this.writeLine(this.mPDFGeometryWriter, "1 Tr " + this.mCoordinateDecimal.format(this.mFontOutlineWidth) + " w " + 2 + " M 2 J 0 j [] 0 d");
                } else {
                    this.writeLine(this.mPDFGeometryWriter, "0 Tr");
                }
            }
            Iterator iterator = arrayList2.iterator();
            double d8 = 0.0;
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                if (this.mOutputType == 4) {
                    this.writeLine(this.mWriter, this.mCoordinateDecimal.format(d5) + " " + this.mCoordinateDecimal.format(d6) + " m");
                    this.writeLine(this.mWriter, this.mCoordinateDecimal.format(d8));
                    this.writeLine(this.mWriter, Integer.toString(arrayList2.size()));
                    this.writePostScriptString(this.mWriter, null, string2);
                    this.writeLine(this.mWriter, "t");
                } else if (this.mOutputType == 6) {
                    StringDimension stringDimension = this.getStringDimension(string2, this.mFontName, this.mFontSize, 1.0);
                    d4 = 0.0;
                    if (this.mJustificationShiftX == 4) {
                        d4 = -stringDimension.getWidth();
                    } else if (this.mJustificationShiftX == 2) {
                        d4 = -stringDimension.getWidth() / 2.0;
                    }
                    double d9 = d3 - d8 * this.mFontSize * this.mFontLineSpacing;
                    this.writeLine(this.mPDFGeometryWriter, this.mCoordinateDecimal.format(d4 - d) + " " + this.mCoordinateDecimal.format(d9 - d2) + " Td");
                    d = d4;
                    d2 = d9;
                    this.writePostScriptString(this.mPDFGeometryWriter, null, string2);
                    this.writeLine(this.mPDFGeometryWriter, "Tj");
                } else if (this.mOutputType == 7) {
                    Object object;
                    Composite composite;
                    double d10;
                    double d11;
                    String string3 = this.mJustificationShiftX == 4 ? "end" : (this.mJustificationShiftX == 1 ? "start" : "middle");
                    Color color = this.mGraphics2D.getColor();
                    int n = color.getAlpha();
                    Font font = this.mGraphics2D.getFont();
                    StringBuffer stringBuffer = new StringBuffer();
                    if (font.isBold()) {
                        stringBuffer.append(" font-weight=\"bold\" ");
                    }
                    if (font.isItalic()) {
                        stringBuffer.append(" font-style=\"italic\" ");
                    }
                    if (this.mFontOutlineWidth > 0.0) {
                        stringBuffer.append(" stroke=\"");
                        stringBuffer.append(ColorDatabase.toHexString(color));
                        stringBuffer.append("\" stroke-width=\"");
                        stringBuffer.append(this.mFontOutlineWidth);
                        stringBuffer.append("\" stroke-miterlimit=\"2\" ");
                        if (n != 255) {
                            stringBuffer.append(" stroke-opacity=\"");
                            stringBuffer.append((float)n / 255.0f);
                            stringBuffer.append("\" ");
                        }
                    } else {
                        stringBuffer.append(" fill=\"");
                        stringBuffer.append(ColorDatabase.toHexString(color));
                        stringBuffer.append("\" ");
                        if (n != 255) {
                            stringBuffer.append(" fill-opacity=\"");
                            stringBuffer.append((float)n / 255.0f);
                            stringBuffer.append("\" ");
                        }
                    }
                    double d12 = d6 + d3 - d8 * this.mFontSize * this.mFontLineSpacing;
                    if (this.mFontRotation != 0.0) {
                        this.writeLine(this.mWriter, "<g transform=\"translate(" + this.mCoordinateDecimal.format(d5) + ", " + this.mCoordinateDecimal.format(this.mPageHeight - d12) + ") rotate(" + this.mCoordinateDecimal.format(Math.toDegrees(-this.mFontRotation)) + ")\">");
                        d11 = 0.0;
                        d10 = 0.0;
                    } else {
                        d10 = d5;
                        d11 = this.mPageHeight - d12;
                    }
                    this.writeLine(this.mWriter, "<text x=\"" + this.mCoordinateDecimal.format(d10) + "\" y=\"" + this.mCoordinateDecimal.format(d11) + "\" text-anchor=\"" + string3 + "\"");
                    String string4 = font.getName();
                    if (string4.equalsIgnoreCase("sansserif") || string4.equalsIgnoreCase("dialog")) {
                        string4 = "Courier";
                    }
                    if ((composite = this.mGraphics2D.getComposite()) instanceof BlendComposite) {
                        object = (BlendComposite)composite;
                        stringBuffer.append(" filter=\"url(#");
                        stringBuffer.append(((BlendComposite)object).getName());
                        stringBuffer.append(")\" ");
                    }
                    this.writeLine(this.mWriter, "  font-family=\"" + string4 + "\" " + "font-size=\"" + font.getSize2D() + "\" " + stringBuffer.toString());
                    object = new StringBuffer(string2.length() * 2);
                    for (int j = 0; j < string2.length(); ++j) {
                        char c = string2.charAt(j);
                        if (c == '&' || c == '<' || c == '>' || c == '\"' || c > '\u007f') {
                            ((StringBuffer)object).append("&#").append(Integer.toString(c)).append(";");
                            continue;
                        }
                        ((StringBuffer)object).append(c);
                    }
                    this.writeLine(this.mWriter, ">" + ((StringBuffer)object).toString() + "</text>");
                    if (this.mFontRotation != 0.0) {
                        this.writeLine(this.mWriter, "</g>");
                    }
                } else {
                    Point2D point2D2;
                    if (this.mJustificationShiftX != 1 || this.mJustificationShiftY != 32 || arrayList2.size() > 1 || this.mFontRotation != 0.0) {
                        Rectangle2D rectangle2D = this.mBaseFont.getStringBounds(string2, fontRenderContext);
                        AffineTransform affineTransform = AffineTransform.getTranslateInstance(d5, d6);
                        affineTransform.rotate(this.mFontRotation);
                        d4 = 0.0;
                        if (this.mJustificationShiftX == 4) {
                            d4 = -rectangle2D.getWidth();
                        } else if (this.mJustificationShiftX == 2) {
                            d4 = -rectangle2D.getWidth() / 2.0;
                        }
                        point2D2 = new Point2D.Double(d4, d3 - d8 * this.mFontSize * this.mFontLineSpacing);
                        affineTransform.transform(point2D2, point2D2);
                    } else {
                        point2D2 = point2D;
                    }
                    float f = (float)point2D2.getX();
                    float f2 = (float)point2D2.getY();
                    if (this.mFontOutlineWidth > 0.0) {
                        GlyphVector glyphVector = this.mGraphics2D.getFont().createGlyphVector(fontRenderContext, string2);
                        Shape shape = glyphVector.getOutline(f, f2);
                        this.mGraphics2D.draw(shape);
                    } else {
                        this.mGraphics2D.drawString(string2, f, f2);
                    }
                }
                d8 += 1.0;
            }
            if (this.mOutputType != 6) continue;
            this.writeLine(this.mPDFGeometryWriter, "ET Q");
        }
        if (stroke != null) {
            this.mGraphics2D.setStroke(stroke);
        }
    }
}

