/*
 * Decompiled with CFR 0.152.
 */
package org.mapyrus;

import org.mapyrus.Argument;

public class LegendEntry
implements Comparable {
    public static final int POINT_ENTRY = 1;
    public static final int LINE_ENTRY = 2;
    public static final int ZIGZAG_ENTRY = 3;
    public static final int BOX_ENTRY = 4;
    private String mBlockName;
    private Argument[] mBlockArgs;
    private int mType;
    private String mDescription;
    private int mReferenceCount;

    public LegendEntry(String string, Argument[] argumentArray, int n, String string2) {
        this.mBlockName = string;
        this.mBlockArgs = argumentArray;
        this.mType = n;
        this.mDescription = string2;
        this.mReferenceCount = 1;
    }

    public void addReference() {
        ++this.mReferenceCount;
    }

    public int getReferenceCount() {
        return this.mReferenceCount;
    }

    public static int parseTypeString(String string) {
        int n = -1;
        if (string.equalsIgnoreCase("point")) {
            n = 1;
        } else if (string.equalsIgnoreCase("line")) {
            n = 2;
        } else if (string.equalsIgnoreCase("zigzag")) {
            n = 3;
        } else if (string.equalsIgnoreCase("box")) {
            n = 4;
        }
        return n;
    }

    public int compareTo(Object object) {
        LegendEntry legendEntry = (LegendEntry)object;
        int n = this.mType - legendEntry.mType;
        if (n == 0) {
            n = this.mDescription.compareTo(legendEntry.mDescription);
        }
        return n;
    }

    public String getBlockName() {
        return this.mBlockName;
    }

    public Argument[] getBlockArgs() {
        return this.mBlockArgs;
    }

    public int getType() {
        return this.mType;
    }

    public String getTypeString() {
        String string = this.mType == 1 ? "point" : (this.mType == 2 ? "line" : (this.mType == 3 ? "zigzag" : "box"));
        return string;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public String toString() {
        return this.mBlockName + " " + this.mDescription;
    }
}

