/*
 * Decompiled with CFR 0.152.
 */
package org.mapyrus;

import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.mapyrus.Argument;
import org.mapyrus.ColorDatabase;
import org.mapyrus.Constants;
import org.mapyrus.ContextStack;
import org.mapyrus.DefaultFieldNames;
import org.mapyrus.Expression;
import org.mapyrus.FileOrURL;
import org.mapyrus.LegendEntry;
import org.mapyrus.LegendEntryList;
import org.mapyrus.MapyrusException;
import org.mapyrus.MapyrusMessages;
import org.mapyrus.NumericalAnalysis;
import org.mapyrus.PageSize;
import org.mapyrus.ParsedStatement;
import org.mapyrus.Preprocessor;
import org.mapyrus.Row;
import org.mapyrus.Statement;
import org.mapyrus.Throttle;
import org.mapyrus.function.UserFunction;

public class Interpreter {
    private static final char COMMENT_CHAR = '#';
    private static final char ARGUMENT_SEPARATOR = ',';
    private static final char PARAM_SEPARATOR = ',';
    private static final String BEGIN_KEYWORD = "begin";
    private static final String FUNCTION_KEYWORD = "function";
    private static final String END_KEYWORD = "end";
    private static final String IF_KEYWORD = "if";
    private static final String THEN_KEYWORD = "then";
    private static final String ELSE_KEYWORD = "else";
    private static final String ELIF_KEYWORD = "elif";
    private static final String ENDIF_KEYWORD = "endif";
    private static final String WHILE_KEYWORD = "while";
    private static final String REPEAT_KEYWORD = "repeat";
    private static final String DO_KEYWORD = "do";
    private static final String DONE_KEYWORD = "done";
    private static final String FOR_KEYWORD = "for";
    private static final String IN_KEYWORD = "in";
    private static final int AT_ARGUMENT = 1;
    private static final int AT_SEPARATOR = 2;
    private static final int AT_PARAM = 3;
    private static final int AT_PARAM_SEPARATOR = 4;
    public static final String CAP_BUTT_STRING = "butt";
    public static final String CAP_ROUND_STRING = "round";
    public static final String CAP_SQUARE_STRING = "square";
    public static final String JOIN_BEVEL_STRING = "bevel";
    public static final String JOIN_MITER_STRING = "miter";
    public static final String JOIN_ROUND_STRING = "round";
    private ContextStack mContext;
    private InputStream mStdinStream;
    private PrintStream mStdoutStream;
    Argument[] mExecuteArgs = null;
    private HashMap<String, Statement> mStatementBlocks = new HashMap();
    private HashMap<String, UserFunction> mUserFunctions = new HashMap();
    private static HashMap<String, Integer> mWorldUnitsLookup = new HashMap();
    private boolean mInComment = false;
    private static HashMap<String, ParsedStatement> mKeywordLookup;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setColor(ContextStack contextStack, Argument[] argumentArray, int n) throws MapyrusException {
        int n2 = 255;
        float f = 1.0f;
        if (n == 1 || n == 2) {
            Color color;
            String string = argumentArray[0].getStringValue();
            if (n == 2) {
                f = (float)argumentArray[1].getNumericValue();
                if (f < 0.0f) {
                    f = 0.0f;
                } else if (f > 1.0f) {
                    f = 1.0f;
                }
                n2 = (int)Math.round((double)f * 255.0);
            }
            if ((color = ColorDatabase.getColor(string, n2, contextStack.getColor())) == null) {
                throw new MapyrusException(MapyrusMessages.get("colornotfound") + ": " + string);
            }
            contextStack.setColor(color);
            return;
        } else {
            if (n != 4 && n != 5) throw new MapyrusException(MapyrusMessages.get("invalidcolor"));
            String string = argumentArray[0].getStringValue();
            float f2 = (float)argumentArray[1].getNumericValue();
            float f3 = (float)argumentArray[2].getNumericValue();
            float f4 = (float)argumentArray[3].getNumericValue();
            if (n == 5) {
                f = (float)argumentArray[4].getNumericValue();
                if (f < 0.0f) {
                    f = 0.0f;
                } else if (f > 1.0f) {
                    f = 1.0f;
                }
                n2 = (int)Math.round((double)f * 255.0);
            }
            if (f3 < 0.0f) {
                f3 = 0.0f;
            } else if (f3 > 1.0f) {
                f3 = 1.0f;
            }
            if (f4 < 0.0f) {
                f4 = 0.0f;
            } else if (f4 > 1.0f) {
                f4 = 1.0f;
            }
            if (string.equalsIgnoreCase("hsb")) {
                int n3 = Color.HSBtoRGB(f2, f3, f4);
                contextStack.setColor(new Color((n3 &= 0xFFFFFF) | n2 << 24, true));
                return;
            } else {
                if (!string.equalsIgnoreCase("rgb")) throw new MapyrusException(MapyrusMessages.get("invalidcolortype") + ": " + string);
                if (f2 < 0.0f) {
                    f2 = 0.0f;
                } else if (f2 > 1.0f) {
                    f2 = 1.0f;
                }
                contextStack.setColor(new Color(f2, f3, f4, f));
            }
        }
    }

    private void setLinestyle(ContextStack contextStack, Argument[] argumentArray, int n) throws MapyrusException {
        String string;
        double d = 0.1;
        double d2 = 0.0;
        float[] fArray = null;
        int n2 = 2;
        int n3 = 0;
        if (n == 0) {
            throw new MapyrusException(MapyrusMessages.get("invalidlinestyle"));
        }
        d = argumentArray[0].getNumericValue();
        if (d < 0.0) {
            throw new MapyrusException(MapyrusMessages.get("invalidlinewidth") + ": " + d);
        }
        if (n >= 2) {
            string = argumentArray[1].getStringValue().toLowerCase();
            if (string.equals(CAP_BUTT_STRING)) {
                n2 = 0;
            } else if (string.equals("round")) {
                n2 = 1;
            } else if (string.equals(CAP_SQUARE_STRING)) {
                n2 = 2;
            } else {
                throw new MapyrusException(MapyrusMessages.get("invalidendcap") + ": " + string);
            }
        }
        if (n >= 3) {
            string = argumentArray[2].getStringValue().toLowerCase();
            if (string.equals(JOIN_BEVEL_STRING)) {
                n3 = 2;
            } else if (string.equals(JOIN_MITER_STRING)) {
                n3 = 0;
            } else if (string.equals("round")) {
                n3 = 1;
            } else {
                throw new MapyrusException(MapyrusMessages.get("invalidlinejoin") + ": " + string);
            }
        }
        if (n >= 4 && (d2 = argumentArray[3].getNumericValue()) < 0.0) {
            throw new MapyrusException(MapyrusMessages.get("invaliddashphase") + ": " + d2);
        }
        if (n >= 5) {
            fArray = new float[n - 4];
            for (int i = 4; i < n; ++i) {
                fArray[i - 4] = (float)argumentArray[i].getNumericValue();
                if (!((double)fArray[i - 4] <= 0.0)) continue;
                throw new MapyrusException(MapyrusMessages.get("invaliddashpattern") + ": " + fArray[i - 4]);
            }
        }
        contextStack.setLinestyle(d, n2, n3, d2, fArray);
    }

    private void setJustify(ContextStack contextStack, String string) {
        int n = (string = string.toLowerCase()).indexOf("center") >= 0 || string.indexOf("centre") >= 0 ? 2 : (string.indexOf("right") >= 0 ? 4 : 1);
        n = string.indexOf("top") >= 0 ? (n |= 8) : (string.indexOf("middle") >= 0 ? (n |= 0x10) : (n |= 0x20));
        contextStack.setJustify(n);
    }

    private void setFont(ContextStack contextStack, Argument[] argumentArray, int n) throws MapyrusException {
        double d;
        double d2 = 0.0;
        double d3 = 1.0;
        if (n == 2 || n == 3) {
            d = argumentArray[1].getNumericValue();
            if (d <= 0.0) {
                throw new MapyrusException(MapyrusMessages.get("invalidsize") + ": " + d);
            }
            if (n == 3) {
                String string = argumentArray[2].getStringValue();
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                while (stringTokenizer.hasMoreTokens()) {
                    String string2;
                    String string3 = stringTokenizer.nextToken();
                    if (string3.startsWith("outlinewidth=")) {
                        string2 = string3.substring(13);
                        try {
                            d2 = Double.parseDouble(string2);
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new MapyrusException(MapyrusMessages.get("invalidlinewidth") + ": " + string2);
                        }
                        if (!(d2 < 0.0)) continue;
                        throw new MapyrusException(MapyrusMessages.get("invalidlinewidth") + ": " + d2);
                    }
                    if (!string3.startsWith("linespacing=")) continue;
                    string2 = string3.substring(12);
                    try {
                        d3 = Double.parseDouble(string2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new MapyrusException(MapyrusMessages.get("invalidspacing") + ": " + string2);
                    }
                }
            }
        } else {
            throw new MapyrusException(MapyrusMessages.get("invalidfont"));
        }
        contextStack.setFont(argumentArray[0].getStringValue(), d, d2, d3);
    }

    private void displayLegend(Statement statement, ContextStack contextStack, double d) throws MapyrusException, IOException {
        LegendEntryList legendEntryList = contextStack.getLegendEntries();
        ArrayList arrayList = contextStack.getMoveTos();
        legendEntryList.ignoreAdditions();
        long l = Math.min(legendEntryList.size(), arrayList.size());
        int n = 0;
        while ((long)n < l) {
            int n2;
            LegendEntry legendEntry = legendEntryList.pop();
            String string = legendEntry.getBlockName();
            Statement statement2 = this.mStatementBlocks.get(string);
            if (statement2 == null) {
                throw new MapyrusException(statement.getFilenameAndLineNumber() + ": " + MapyrusMessages.get("undefinedproc") + ": " + string);
            }
            ArrayList arrayList2 = statement2.getBlockParameters();
            if (legendEntry.getBlockArgs().length != arrayList2.size()) {
                throw new MapyrusException(statement.getFilenameAndLineNumber() + ": " + MapyrusMessages.get("wrongparameters"));
            }
            contextStack.saveState(string);
            Point2D.Float float_ = (Point2D.Float)arrayList.get(n);
            contextStack.setTranslation(float_.x, float_.y);
            contextStack.clearPath();
            contextStack.moveTo(d * 1.1 + 2.0, d / 2.0);
            String string2 = legendEntry.getDescription();
            while ((n2 = string2.indexOf("(#)")) >= 0) {
                string2 = string2.substring(0, n2 + 1) + legendEntry.getReferenceCount() + string2.substring(n2 + 2);
            }
            contextStack.label(string2);
            contextStack.clearPath();
            if (legendEntry.getType() == 1) {
                contextStack.setTranslation(d / 2.0, d / 2.0);
                contextStack.moveTo(0.0, 0.0);
            } else if (legendEntry.getType() == 2) {
                contextStack.moveTo(0.0, d / 2.0);
                contextStack.lineTo(d, d / 2.0);
            } else if (legendEntry.getType() == 3) {
                contextStack.moveTo(0.0, d / 2.0);
                contextStack.lineTo(d / 3.0, d);
                contextStack.lineTo(d * 2.0 / 3.0, 0.0);
                contextStack.lineTo(d, d / 2.0);
            } else if (legendEntry.getType() == 4) {
                contextStack.moveTo(0.0, 0.0);
                contextStack.lineTo(0.0, d);
                contextStack.lineTo(d, d);
                contextStack.lineTo(d, 0.0);
                contextStack.lineTo(0.0, 0.0);
            }
            if (legendEntry.getType() == 4) {
                contextStack.saveState(string);
            }
            this.makeCall(statement2, arrayList2, legendEntry.getBlockArgs());
            if (legendEntry.getType() == 4) {
                contextStack.restoreState();
                contextStack.setColor(Color.BLACK);
                contextStack.setLinestyle(0.1, 0, 2, 0.0, null);
                contextStack.stroke(null);
            }
            contextStack.restoreState();
            ++n;
        }
        legendEntryList.acceptAdditions();
    }

    private int addGeometryToPath(ContextStack contextStack, double[] dArray, int n) throws MapyrusException {
        int n2 = (int)dArray[n];
        int n3 = (int)dArray[n + 1];
        n += 2;
        switch (n2) {
            case 100: 
            case 101: 
            case 102: {
                for (int i = 0; i < n3; ++i) {
                    double d = dArray[n + 1];
                    double d2 = dArray[n + 2];
                    if (dArray[n] == 0.0) {
                        contextStack.moveTo(d, d2);
                    } else {
                        contextStack.lineTo(d, d2);
                    }
                    n += 3;
                }
                break;
            }
            case 103: 
            case 104: 
            case 105: 
            case 106: {
                for (int i = 0; i < n3; ++i) {
                    n = this.addGeometryToPath(contextStack, dArray, n);
                }
                break;
            }
        }
        return n;
    }

    private void execute(Statement statement, ContextStack contextStack) throws MapyrusException, IOException {
        int n;
        double d = 0.0;
        if (Thread.interrupted()) {
            throw new MapyrusException(MapyrusMessages.get("interrupted"));
        }
        Throttle.sleep();
        Expression[] expressionArray = statement.getExpressions();
        int n2 = expressionArray.length;
        int n3 = statement.getType();
        if (n3 == 71) {
            for (n = 0; n < n2; ++n) {
                String string = expressionArray[n].getVariableName();
                if (string == null) {
                    throw new MapyrusException(MapyrusMessages.get("variableexpected"));
                }
                contextStack.setLocalScope(string);
            }
        } else {
            if (this.mExecuteArgs == null || n2 > this.mExecuteArgs.length) {
                this.mExecuteArgs = new Argument[n2];
            }
            String string = statement.getFilename();
            for (int i = 0; i < n2; ++i) {
                this.mExecuteArgs[i] = expressionArray[i].evaluate(contextStack, string);
            }
        }
        switch (n3) {
            case 9: {
                this.setColor(contextStack, this.mExecuteArgs, n2);
                break;
            }
            case 10: {
                if (n2 == 1) {
                    contextStack.setBlend(this.mExecuteArgs[0].getStringValue());
                    break;
                }
                throw new MapyrusException(MapyrusMessages.get("invalidblend"));
            }
            case 11: {
                this.setLinestyle(contextStack, this.mExecuteArgs, n2);
                break;
            }
            case 12: {
                this.setFont(contextStack, this.mExecuteArgs, n2);
                break;
            }
            case 13: {
                if (n2 == 1) {
                    this.setJustify(contextStack, this.mExecuteArgs[0].getStringValue());
                    break;
                }
                throw new MapyrusException(MapyrusMessages.get("invalidjustify"));
            }
            case 14: 
            case 15: 
            case 16: {
                if (n2 > 0 && n2 % 2 == 0) {
                    for (n = 0; n < n2; n += 2) {
                        if (n3 == 14) {
                            contextStack.moveTo(this.mExecuteArgs[n].getNumericValue(), this.mExecuteArgs[n + 1].getNumericValue());
                            continue;
                        }
                        if (n3 == 15) {
                            contextStack.lineTo(this.mExecuteArgs[n].getNumericValue(), this.mExecuteArgs[n + 1].getNumericValue());
                            continue;
                        }
                        contextStack.rlineTo(this.mExecuteArgs[n].getNumericValue(), this.mExecuteArgs[n + 1].getNumericValue());
                    }
                    break;
                }
                throw new MapyrusException(MapyrusMessages.get("wrongcoordinate"));
            }
            case 17: {
                if (n2 == 5) {
                    n = this.mExecuteArgs[0].getNumericValue() > 0.0 ? 1 : -1;
                    contextStack.arcTo(n, this.mExecuteArgs[1].getNumericValue(), this.mExecuteArgs[2].getNumericValue(), this.mExecuteArgs[3].getNumericValue(), this.mExecuteArgs[4].getNumericValue());
                    break;
                }
                throw new MapyrusException(MapyrusMessages.get("invalidarc"));
            }
            case 18: {
                if (n2 == 3) {
                    double d2 = this.mExecuteArgs[0].getNumericValue();
                    double d3 = this.mExecuteArgs[1].getNumericValue();
                    d = this.mExecuteArgs[2].getNumericValue();
                    if (!(d > 0.0)) break;
                    contextStack.moveTo(d2 - d, d3);
                    contextStack.arcTo(1, d2, d3, d2 - d, d3);
                    contextStack.closePath();
                    break;
                }
                throw new MapyrusException(MapyrusMessages.get("invalidcircle"));
            }
            case 19: {
                if (n2 == 4) {
                    double d4 = this.mExecuteArgs[0].getNumericValue();
                    double d5 = this.mExecuteArgs[1].getNumericValue();
                    double d6 = this.mExecuteArgs[2].getNumericValue();
                    double d7 = this.mExecuteArgs[3].getNumericValue();
                    if (!(d6 > 0.0) || !(d7 > 0.0)) break;
                    contextStack.ellipseTo(d4 - d6, d5 - d7, d4 + d6, d5 + d7);
                    break;
                }
                throw new MapyrusException(MapyrusMessages.get("invalidellipse"));
            }
            case 20: {
                if (n2 == 4) {
                    double d8 = this.mExecuteArgs[0].getNumericValue();
                    double d9 = this.mExecuteArgs[1].getNumericValue();
                    d = this.mExecuteArgs[2].getNumericValue();
                    double d10 = this.mExecuteArgs[3].getNumericValue();
                    if (!(d > 0.0) || !(d10 > 0.0)) break;
                    double d11 = d * 0.552285;
                    double d12 = d11 / 2.0;
                    contextStack.moveTo(d8 - d, d9);
                    contextStack.curveTo(d8 - d, d9 - d12, d8 - d11, d9 - d / 2.0, d8, d9 - d / 2.0);
                    contextStack.curveTo(d8 + d11, d9 - d / 2.0, d8 + d, d9 - d12, d8 + d, d9);
                    contextStack.lineTo(d8 + d, d9 + d10);
                    contextStack.curveTo(d8 + d, d9 + d10 - d12, d8 + d11, d9 + d10 - d / 2.0, d8, d9 + d10 - d / 2.0);
                    contextStack.curveTo(d8 - d11, d9 + d10 - d / 2.0, d8 - d, d9 + d10 - d12, d8 - d, d9 + d10);
                    contextStack.closePath();
                    contextStack.ellipseTo(d8 - d, d9 + d10 - d / 2.0, d8 + d, d9 + d10 + d / 2.0);
                    break;
                }
                throw new MapyrusException(MapyrusMessages.get("invalidcylinder"));
            }
            case 21: {
                if (n2 == 3) {
                    double d13 = this.mExecuteArgs[0].getNumericValue();
                    double d14 = this.mExecuteArgs[1].getNumericValue();
                    d = this.mExecuteArgs[2].getNumericValue();
                    if (!(d > 0.0)) break;
                    double d15 = d;
                    contextStack.moveTo(d13 - d, d14);
                    contextStack.arcTo(-1, d13, d14, d13 + d, d14);
                    contextStack.curveTo(d13 + d, d14 + d15, d13, d14 + d * 3.0 - d15, d13, d14 + d * 3.0);
                    contextStack.curveTo(d13, d14 + d * 3.0 - d15, d13 - d, d14 + d15, d13 - d, d14);
                    contextStack.closePath();
                    break;
                }
                throw new MapyrusException(MapyrusMessages.get("invalidraindrop"));
            }
            case 22: {
                if (n2 == 6) {
                    double d16 = this.mExecuteArgs[0].getNumericValue();
                    double d17 = this.mExecuteArgs[1].getNumericValue();
                    double d18 = this.mExecuteArgs[2].getNumericValue();
                    double d19 = this.mExecuteArgs[3].getNumericValue();
                    double d20 = this.mExecuteArgs[4].getNumericValue();
                    double d21 = this.mExecuteArgs[5].getNumericValue();
                    contextStack.curveTo(d16, d17, d18, d19, d20, d21);
                    break;
                }
                throw new MapyrusException(MapyrusMessages.get("invalidbezier"));
            }
            case 23: {
                if (n2 == 4) {
                    double d22 = this.mExecuteArgs[0].getNumericValue();
                    double d23 = this.mExecuteArgs[1].getNumericValue();
                    double d24 = this.mExecuteArgs[2].getNumericValue();
                    double d25 = this.mExecuteArgs[3].getNumericValue();
                    contextStack.sineWaveTo(d22, d23, d24, d25);
                    break;
                }
                throw new MapyrusException(MapyrusMessages.get("invalidsinewave"));
            }
            case 24: {
                if (n2 == 5 || n2 == 6) {
                    double d26 = this.mExecuteArgs[0].getNumericValue();
                    double d27 = this.mExecuteArgs[1].getNumericValue();
                    d = this.mExecuteArgs[2].getNumericValue();
                    double d28 = this.mExecuteArgs[3].getNumericValue();
                    double d29 = this.mExecuteArgs[4].getNumericValue();
                    double d30 = d28 + d29;
                    double d31 = n2 == 6 ? this.mExecuteArgs[5].getNumericValue() : 0.0;
                    int n4 = d29 > 0.0 ? -1 : 1;
                    d28 = Math.toRadians(d28);
                    d30 = Math.toRadians(d30);
                    if (!(d > 0.0) || d29 == 0.0) break;
                    double d32 = Math.cos(d28);
                    double d33 = Math.sin(d28);
                    double d34 = Math.cos(d30);
                    double d35 = Math.sin(d30);
                    double d36 = d26 + d32 * d;
                    double d37 = d27 + d33 * d;
                    double d38 = d26 + d34 * d;
                    double d39 = d27 + d35 * d;
                    contextStack.moveTo(d26, d27);
                    contextStack.lineTo(d36, d37);
                    contextStack.arcTo(n4, d26, d27, d38, d39);
                    contextStack.closePath();
                    if (!(d31 > 0.0)) break;
                    if (n4 == 1 && d32 < 0.0 || n4 == -1 && d32 > 0.0) {
                        contextStack.moveTo(d36, d37);
                        contextStack.lineTo(d36, d37 - d31);
                        contextStack.lineTo(d26, d27 - d31);
                        contextStack.lineTo(d26, d27);
                        contextStack.closePath();
                    }
                    if (n4 == 1 && d34 > 0.0 || n4 == -1 && d34 < 0.0) {
                        contextStack.moveTo(d38, d39);
                        contextStack.lineTo(d38, d39 - d31);
                        contextStack.lineTo(d26, d27 - d31);
                        contextStack.lineTo(d26, d27);
                        contextStack.closePath();
                    }
                    if (!(d33 < 0.0) && !(d35 < 0.0) && !(Math.abs(d29) > 180.0)) break;
                    double d40 = d36;
                    double d41 = d37;
                    if (d33 > 0.0) {
                        d40 = d26 + d * (double)n4;
                        d41 = d27;
                    }
                    contextStack.moveTo(d40, d41);
                    contextStack.lineTo(d40, d41 - d31);
                    double d42 = d38;
                    double d43 = d39;
                    if (d35 > 0.0) {
                        d42 = d26 - d * (double)n4;
                        d43 = d27;
                    }
                    contextStack.arcTo(n4, d26, d27 - d31, d42, d43 - d31);
                    contextStack.lineTo(d42, d43);
                    contextStack.arcTo(-n4, d26, d27, d40, d41);
                    contextStack.closePath();
                    break;
                }
                throw new MapyrusException(MapyrusMessages.get("invalidwedge"));
            }
            case 25: {
                if (n2 == 5) {
                    double d44 = this.mExecuteArgs[0].getNumericValue();
                    double d45 = this.mExecuteArgs[1].getNumericValue();
                    d = this.mExecuteArgs[2].getNumericValue();
                    double d46 = this.mExecuteArgs[3].getNumericValue();
                    double d47 = this.mExecuteArgs[4].getNumericValue();
                    d47 = Math.toRadians(d47);
                    if (!(d > 0.0) || d46 == 0.0) break;
                    double d48 = contextStack.getResolution();
                    double d49 = Math.acos((d - d48) / d);
                    double d50 = d49 / (Math.PI * 2);
                    d50 /= Math.abs(d46);
                    double d51 = 1.0;
                    int n5 = 0;
                    while (d51 > 0.0) {
                        double d52 = d * d51 * Math.cos(Math.PI * 2 * d46 * d51 + d47) + d44;
                        double d53 = d * d51 * Math.sin(Math.PI * 2 * d46 * d51 + d47) + d45;
                        if (n5 == 0) {
                            contextStack.moveTo(d52, d53);
                        } else {
                            contextStack.lineTo(d52, d53);
                        }
                        d51 = 1.0 - (double)(++n5) * d50;
                    }
                    contextStack.lineTo(d44, d45);
                    break;
                }
                throw new MapyrusException(MapyrusMessages.get("invalidspiral"));
            }
            case 30: {
                if (n2 == 3) {
                    double d54 = this.mExecuteArgs[0].getNumericValue();
                    double d55 = this.mExecuteArgs[1].getNumericValue();
                    d = this.mExecuteArgs[2].getNumericValue();
                    double d56 = 0.8660254 * d;
                    double d57 = 0.5 * d;
                    if (!(d > 0.0)) break;
                    contextStack.moveTo(d54 - d57, d55 - d56);
                    contextStack.lineTo(d54 + d57, d55 - d56);
                    contextStack.lineTo(d54 + d, d55);
                    contextStack.lineTo(d54 + d57, d55 + d56);
                    contextStack.lineTo(d54 - d57, d55 + d56);
                    contextStack.lineTo(d54 - d, d55);
                    contextStack.closePath();
                    break;
                }
                throw new MapyrusException(MapyrusMessages.get("invalidhexagon"));
            }
            case 31: {
                if (n2 == 3) {
                    double d58 = this.mExecuteArgs[0].getNumericValue();
                    double d59 = this.mExecuteArgs[1].getNumericValue();
                    d = this.mExecuteArgs[2].getNumericValue();
                    double d60 = 0.809017 * d;
                    double d61 = 0.59778525 * d;
                    double d62 = 0.309017 * d;
                    double d63 = 0.95105652 * d;
                    if (!(d > 0.0)) break;
                    contextStack.moveTo(d58 - d61, d59 - d60);
                    contextStack.lineTo(d58 + d61, d59 - d60);
                    contextStack.lineTo(d58 + d63, d59 + d62);
                    contextStack.lineTo(d58, d59 + d);
                    contextStack.lineTo(d58 - d63, d59 + d62);
                    contextStack.closePath();
                    break;
                }
                throw new MapyrusException(MapyrusMessages.get("invalidpentagon"));
            }
            case 32: {
                if (n2 == 4) {
                    double d64 = this.mExecuteArgs[0].getNumericValue();
                    double d65 = this.mExecuteArgs[1].getNumericValue();
                    d = this.mExecuteArgs[2].getNumericValue();
                    double d66 = this.mExecuteArgs[3].getNumericValue();
                    d66 = Math.toRadians(d66);
                    double d67 = 0.5 * d;
                    double d68 = 0.8660254 * d;
                    AffineTransform affineTransform = AffineTransform.getTranslateInstance(d64, d65);
                    affineTransform.rotate(d66);
                    Point2D.Double double_ = new Point2D.Double(0.0, d);
                    affineTransform.transform(double_, double_);
                    contextStack.moveTo(double_.x, double_.y);
                    double_.x = d68;
                    double_.y = -d67;
                    affineTransform.transform(double_, double_);
                    contextStack.lineTo(double_.x, double_.y);
                    double_.x = -d68;
                    double_.y = -d67;
                    affineTransform.transform(double_, double_);
                    contextStack.lineTo(double_.x, double_.y);
                    contextStack.closePath();
                    break;
                }
                throw new MapyrusException(MapyrusMessages.get("invalidtriangle"));
            }
            case 33: {
                if (n2 == 4) {
                    double d69 = this.mExecuteArgs[0].getNumericValue();
                    double d70 = this.mExecuteArgs[1].getNumericValue();
                    d = this.mExecuteArgs[2].getNumericValue();
                    n = (int)this.mExecuteArgs[3].getNumericValue();
                    if (!(d > 0.0) || n <= 0) break;
                    double d71 = Math.PI * 2 / (double)n;
                    double d72 = 1.5707963267948966;
                    double d73 = d71 / 3.0;
                    double d74 = d * Math.sin(d73 / 2.0) / Math.sin(Math.PI - d73 / 2.0 - d71 / 2.0);
                    for (int i = 0; i < n; ++i) {
                        double d75 = d69 + Math.cos(d72) * d;
                        double d76 = d70 + Math.sin(d72) * d;
                        if (i == 0) {
                            contextStack.moveTo(d75, d76);
                        } else {
                            contextStack.lineTo(d75, d76);
                        }
                        d75 = d69 + Math.cos(d72 - d71 / 2.0) * d74;
                        d76 = d70 + Math.sin(d72 - d71 / 2.0) * d74;
                        contextStack.lineTo(d75, d76);
                        d72 -= d71;
                    }
                    contextStack.closePath();
                    break;
                }
                throw new MapyrusException(MapyrusMessages.get("invalidstar"));
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 44: 
            case 49: 
            case 50: {
                if (n2 == 4 || (n3 == 27 || n3 == 28 || n3 == 29) && n2 == 5) {
                    double d77;
                    double d78;
                    double d79;
                    double d80;
                    double d81;
                    double d82;
                    double d83 = this.mExecuteArgs[0].getNumericValue();
                    double d84 = this.mExecuteArgs[1].getNumericValue();
                    double d85 = this.mExecuteArgs[2].getNumericValue();
                    double d86 = this.mExecuteArgs[3].getNumericValue();
                    double d87 = 1.0;
                    double d88 = 0.0;
                    if (d83 < d85) {
                        d82 = d83;
                        d81 = d85;
                    } else {
                        d82 = d85;
                        d81 = d83;
                    }
                    if (d84 < d86) {
                        d80 = d84;
                        d79 = d86;
                    } else {
                        d80 = d86;
                        d79 = d84;
                    }
                    if (n3 == 27) {
                        d78 = d79 - d80;
                        d77 = d81 - d82;
                        if (n2 == 5) {
                            d = this.mExecuteArgs[4].getNumericValue();
                            if (d > d77 / 2.0) {
                                d = d77 / 2.0;
                            }
                            if (d > d78 / 2.0) {
                                d = d78 / 2.0;
                            }
                        } else {
                            d = Math.min(d77 / 10.0, d78 / 10.0);
                        }
                        if (d <= 0.0) {
                            n3 = 26;
                        }
                    } else if (n3 == 28) {
                        d88 = Math.min(d81 - d82, d79 - d80);
                        if (n2 == 5) {
                            d88 = this.mExecuteArgs[4].getNumericValue();
                        }
                    } else if (n3 == 29) {
                        if (n2 == 5) {
                            d87 = this.mExecuteArgs[4].getNumericValue();
                        }
                        if (d87 <= 0.0) {
                            throw new MapyrusException(MapyrusMessages.get("invalidsize") + ": " + d87);
                        }
                    }
                    if (n3 == 26 || n3 == 28) {
                        contextStack.moveTo(d82, d80);
                        contextStack.lineTo(d82, d79);
                        contextStack.lineTo(d81, d79);
                        contextStack.lineTo(d81, d80);
                        contextStack.closePath();
                        if (n3 != 28) break;
                        d78 = Math.cos(Math.toRadians(30.0));
                        d77 = Math.sin(Math.toRadians(30.0));
                        d83 = d81 + d88 * d78;
                        d84 = d79 + d88 * d77;
                        contextStack.moveTo(d81, d79);
                        contextStack.lineTo(d83, d84);
                        contextStack.lineTo(d83, d84 - (d79 - d80));
                        contextStack.lineTo(d81, d80);
                        contextStack.closePath();
                        d83 = d82 + d88 * d78;
                        d84 = d79 + d88 * d77;
                        contextStack.moveTo(d82, d79);
                        contextStack.lineTo(d83, d84);
                        contextStack.lineTo(d83 + (d81 - d82), d84);
                        contextStack.lineTo(d81, d79);
                        contextStack.closePath();
                        break;
                    }
                    if (n3 == 27) {
                        contextStack.moveTo(d82, d79 - d);
                        contextStack.arcTo(1, d82 + d, d79 - d, d82 + d, d79);
                        contextStack.lineTo(d81 - d, d79);
                        contextStack.arcTo(1, d81 - d, d79 - d, d81, d79 - d);
                        contextStack.lineTo(d81, d80 + d);
                        contextStack.arcTo(1, d81 - d, d80 + d, d81 - d, d80);
                        contextStack.lineTo(d82 + d, d80);
                        contextStack.arcTo(1, d82 + d, d80 + d, d82, d80 + d);
                        contextStack.closePath();
                        break;
                    }
                    if (n3 == 29) {
                        int n6 = 0;
                        d84 = d80;
                        while (d84 < d79) {
                            d86 = d84 + d87;
                            if (d86 > d79) {
                                d86 = d79;
                            }
                            int n7 = 0;
                            d83 = d82;
                            while (d83 < d81) {
                                if ((n6 + n7) % 2 == 0) {
                                    d85 = d83 + d87;
                                    if (d85 > d81) {
                                        d85 = d81;
                                    }
                                    contextStack.moveTo(d83, d84);
                                    contextStack.lineTo(d83, d86);
                                    contextStack.lineTo(d85, d86);
                                    contextStack.lineTo(d85, d84);
                                    contextStack.closePath();
                                }
                                d83 = d82 + (double)(++n7) * d87;
                            }
                            d84 = d80 + (double)(++n6) * d87;
                        }
                        break;
                    }
                    if (n3 == 44) {
                        contextStack.guillotine(d82, d80, d81, d79);
                        break;
                    }
                    if (n3 == 49) {
                        contextStack.protect(d82, d80, d81, d79);
                        break;
                    }
                    contextStack.unprotect(d82, d80, d81, d79);
                    break;
                }
                if (n2 == 1 && (n3 == 49 || n3 == 50)) {
                    Argument argument = this.mExecuteArgs[0];
                    if (n3 == 49) {
                        contextStack.protect(argument);
                        break;
                    }
                    contextStack.unprotect(argument);
                    break;
                }
                if (n2 == 0 && n3 == 49) {
                    contextStack.protect();
                    break;
                }
                if (n2 == 0 && n3 == 50) {
                    contextStack.unprotect();
                    break;
                }
                throw new MapyrusException(MapyrusMessages.get("invalidbox"));
            }
            case 34: {
                for (n = 0; n < n2; ++n) {
                    double[] dArray = this.mExecuteArgs[n].getGeometryValue();
                    this.addGeometryToPath(contextStack, dArray, 0);
                }
                break;
            }
            case 35: {
                if (n2 > 0) {
                    throw new MapyrusException(MapyrusMessages.get("unexpectedvalues"));
                }
                contextStack.clearPath();
                break;
            }
            case 36: {
                if (n2 > 0) {
                    throw new MapyrusException(MapyrusMessages.get("unexpectedvalues"));
                }
                contextStack.closePath();
                break;
            }
            case 37: {
                if (n2 == 2) {
                    contextStack.samplePath(this.mExecuteArgs[0].getNumericValue(), this.mExecuteArgs[1].getNumericValue());
                    break;
                }
                throw new MapyrusException(MapyrusMessages.get("invalidpathsample"));
            }
            case 38: {
                if (n2 == 2) {
                    double d89 = this.mExecuteArgs[1].getNumericValue();
                    contextStack.stripePath(this.mExecuteArgs[0].getNumericValue(), Math.toRadians(d89));
                    break;
                }
                throw new MapyrusException(MapyrusMessages.get("invalidpathstripe"));
            }
            case 39: {
                if (n2 == 2) {
                    contextStack.translatePath(this.mExecuteArgs[0].getNumericValue(), this.mExecuteArgs[1].getNumericValue());
                    break;
                }
                throw new MapyrusException(MapyrusMessages.get("invalidpathshift"));
            }
            case 40: {
                if (n2 > 0) {
                    double[] dArray = new double[n2];
                    for (int i = 0; i < n2; ++i) {
                        dArray[i] = this.mExecuteArgs[i].getNumericValue();
                    }
                    contextStack.parallelPath(dArray);
                    break;
                }
                throw new MapyrusException(MapyrusMessages.get("invaliddistance"));
            }
            case 41: {
                if (n2 > 0 && n2 % 2 == 0) {
                    double[] dArray = new double[n2 / 2];
                    double[] dArray2 = new double[n2 / 2];
                    for (int i = 0; i < n2 / 2; ++i) {
                        dArray[i] = this.mExecuteArgs[i * 2].getNumericValue();
                        dArray2[i] = this.mExecuteArgs[i * 2 + 1].getNumericValue();
                    }
                    contextStack.selectPath(dArray, dArray2);
                    break;
                }
                throw new MapyrusException(MapyrusMessages.get("unexpectedvalues"));
            }
            case 42: {
                if (n2 > 0) {
                    throw new MapyrusException(MapyrusMessages.get("unexpectedvalues"));
                }
                contextStack.reversePath();
                break;
            }
            case 43: {
                if (n2 > 0) {
                    throw new MapyrusException(MapyrusMessages.get("unexpectedvalues"));
                }
                contextStack.createSinkhole();
                break;
            }
            case 45: {
                if (n2 > 0) {
                    StringBuffer stringBuffer = new StringBuffer(this.mExecuteArgs[0].getStringValue());
                    for (int i = 1; i < n2; ++i) {
                        stringBuffer.append(this.mExecuteArgs[i].getStringValue()).append(Constants.LINE_SEPARATOR);
                    }
                    contextStack.stroke(stringBuffer.toString());
                    break;
                }
                contextStack.stroke(null);
                break;
            }
            case 46: {
                if (n2 > 0) {
                    StringBuffer stringBuffer = new StringBuffer(this.mExecuteArgs[0].getStringValue());
                    for (int i = 1; i < n2; ++i) {
                        stringBuffer.append(this.mExecuteArgs[i].getStringValue()).append(Constants.LINE_SEPARATOR);
                    }
                    contextStack.fill(stringBuffer.toString());
                    break;
                }
                contextStack.fill(null);
                break;
            }
            case 47: {
                if (n2 == 4 || n2 == 5) {
                    Color color = contextStack.getColor();
                    Color color2 = ColorDatabase.getColor(this.mExecuteArgs[0].toString(), 255, color);
                    if (color2 == null) {
                        throw new MapyrusException(MapyrusMessages.get("invalidcolor") + ": " + this.mExecuteArgs[0].toString());
                    }
                    Color color3 = ColorDatabase.getColor(this.mExecuteArgs[1].toString(), 255, color);
                    if (color3 == null) {
                        throw new MapyrusException(MapyrusMessages.get("invalidcolor") + ": " + this.mExecuteArgs[1].toString());
                    }
                    Color color4 = ColorDatabase.getColor(this.mExecuteArgs[2].toString(), 255, color);
                    if (color4 == null) {
                        throw new MapyrusException(MapyrusMessages.get("invalidcolor") + ": " + this.mExecuteArgs[2].toString());
                    }
                    Color color5 = ColorDatabase.getColor(this.mExecuteArgs[3].toString(), 255, color);
                    if (color5 == null) {
                        throw new MapyrusException(MapyrusMessages.get("invalidcolor") + ": " + this.mExecuteArgs[3].toString());
                    }
                    Color color6 = null;
                    if (n2 == 5 && (color6 = ColorDatabase.getColor(this.mExecuteArgs[4].toString(), 255, color)) == null) {
                        throw new MapyrusException(MapyrusMessages.get("invalidcolor") + ": " + this.mExecuteArgs[4].toString());
                    }
                    contextStack.gradientFill(color2, color3, color4, color5, color6);
                    break;
                }
                throw new MapyrusException(MapyrusMessages.get("invalidgradientfill"));
            }
            case 48: {
                if (n2 >= 1) {
                    StringBuffer stringBuffer = new StringBuffer();
                    for (int i = 0; i < n2; ++i) {
                        if (i > 0) {
                            stringBuffer.append(Constants.LINE_SEPARATOR);
                        }
                        stringBuffer.append(this.mExecuteArgs[i].toString());
                    }
                    contextStack.setEventScript(stringBuffer.toString());
                    break;
                }
                throw new MapyrusException(MapyrusMessages.get("invalidscript"));
            }
            case 51: {
                if (n2 != 1) {
                    throw new MapyrusException(MapyrusMessages.get("noclipside"));
                }
                String string = this.mExecuteArgs[0].toString();
                if (string.startsWith(IN_KEYWORD) || string.startsWith("IN")) {
                    contextStack.clipInside();
                    break;
                }
                contextStack.clipOutside();
                break;
            }
            case 69: {
                if (n2 == 1) {
                    PrintStream printStream;
                    String string = this.mExecuteArgs[0].getStringValue();
                    if (string.equals("-")) {
                        printStream = this.mStdoutStream;
                    } else if (string.startsWith("|")) {
                        String string2 = string.substring(1).trim();
                        String[] stringArray = Constants.getOSName().indexOf("WIN") >= 0 ? new String[]{string2} : new String[]{"sh", "-c", string2};
                        Process process = Runtime.getRuntime().exec(stringArray);
                        OutputStream outputStream = process.getOutputStream();
                        printStream = new PrintStream(outputStream);
                    } else {
                        FileOutputStream fileOutputStream = new FileOutputStream(string);
                        printStream = new PrintStream(fileOutputStream);
                    }
                    contextStack.setStdout(printStream);
                    break;
                }
                throw new MapyrusException(MapyrusMessages.get("invalidsetoutput"));
            }
            case 52: 
            case 53: 
            case 70: {
                String string;
                int n8;
                int n9 = 0;
                double d90 = 0.0;
                double d91 = 0.0;
                if (n3 == 53) {
                    if (n2 < 2) {
                        throw new MapyrusException(MapyrusMessages.get("invalidpathoffset"));
                    }
                    d91 = this.mExecuteArgs[0].getNumericValue();
                    d90 = this.mExecuteArgs[1].getNumericValue();
                    n8 = 2;
                } else {
                    n8 = 0;
                }
                if (n2 == n8 + 1) {
                    string = this.mExecuteArgs[n8].toString();
                    n9 += string.length();
                } else {
                    StringBuffer stringBuffer = new StringBuffer();
                    for (int i = n8; i < n2; ++i) {
                        if (i > n8) {
                            stringBuffer.append(' ');
                        }
                        String string3 = this.mExecuteArgs[i].toString();
                        stringBuffer.append(string3);
                        n9 += string3.length();
                    }
                    string = stringBuffer.toString();
                }
                if (n3 == 70) {
                    contextStack.getStdout().println(string);
                    break;
                }
                if (n9 <= 0) break;
                if (n3 == 53) {
                    contextStack.flowLabel(d91, d90, string);
                    break;
                }
                contextStack.label(string);
                break;
            }
            case 54: 
            case 55: {
                if (n3 == 55 && n2 == 2 || n3 == 54 && n2 >= 2) {
                    String string = this.mExecuteArgs[0].getStringValue();
                    ArrayList<Argument> arrayList = new ArrayList<Argument>(n2 - 1);
                    for (int i = 1; i < n2; ++i) {
                        Argument argument;
                        if (this.mExecuteArgs[i].getType() == 2) {
                            argument = this.mExecuteArgs[i];
                        } else {
                            argument = new Argument();
                            argument.addHashMapEntry("1", this.mExecuteArgs[i]);
                        }
                        arrayList.add(argument);
                    }
                    if (n3 == 54) {
                        contextStack.drawTable(string, arrayList);
                        break;
                    }
                    contextStack.drawTree(string, (Argument)arrayList.get(0));
                    break;
                }
                if (n3 == 54) {
                    throw new MapyrusException(MapyrusMessages.get("invalidtable"));
                }
                throw new MapyrusException(MapyrusMessages.get("invalidtree"));
            }
            case 56: {
                if (n2 == 1 || n2 == 2) {
                    double d92 = n2 == 2 ? this.mExecuteArgs[1].getNumericValue() : 0.0;
                    contextStack.drawIcon(this.mExecuteArgs[0].getStringValue(), d92);
                    break;
                }
                throw new MapyrusException(MapyrusMessages.get("invalidicon"));
            }
            case 57: {
                if (n2 == 1 || n2 == 2) {
                    String string = this.mExecuteArgs[0].getStringValue();
                    String string4 = n2 == 2 ? this.mExecuteArgs[1].getStringValue() : "";
                    contextStack.drawGeoImage(string, string4);
                    break;
                }
                throw new MapyrusException(MapyrusMessages.get("invalidgeoimage"));
            }
            case 58: {
                if (n2 == 1 || n2 == 2) {
                    double d93 = n2 == 2 ? this.mExecuteArgs[1].getNumericValue() : 0.0;
                    contextStack.drawEPS(this.mExecuteArgs[0].getStringValue(), d93);
                    break;
                }
                throw new MapyrusException(MapyrusMessages.get("invalideps"));
            }
            case 59: {
                if (n2 == 1 || n2 == 2) {
                    double d94 = n2 == 2 ? this.mExecuteArgs[1].getNumericValue() : 0.0;
                    contextStack.drawSVG(this.mExecuteArgs[0].getStringValue(), d94);
                    break;
                }
                throw new MapyrusException(MapyrusMessages.get("invalidsvg"));
            }
            case 60: {
                for (int i = 0; i < n2; ++i) {
                    contextStack.addSVGCode(this.mExecuteArgs[i].getStringValue());
                }
                break;
            }
            case 61: {
                if (n2 == 2 || n2 == 3) {
                    double d95 = n2 == 3 ? this.mExecuteArgs[2].getNumericValue() : 0.0;
                    long l = Math.round(this.mExecuteArgs[1].getNumericValue());
                    contextStack.drawPDF(this.mExecuteArgs[0].getStringValue(), (int)l, d95);
                    break;
                }
                throw new MapyrusException(MapyrusMessages.get("invalidpdf"));
            }
            case 62: {
                if (n2 == 1) {
                    double d96 = this.mExecuteArgs[0].getNumericValue();
                    contextStack.setScaling(d96);
                    break;
                }
                throw new MapyrusException(MapyrusMessages.get("invalidscaling"));
            }
            case 63: {
                if (n2 == 1) {
                    double d97 = this.mExecuteArgs[0].getNumericValue();
                    contextStack.setRotation(Math.toRadians(d97));
                    break;
                }
                throw new MapyrusException(MapyrusMessages.get("invalidrotation"));
            }
            case 64: {
                double d98;
                double d99;
                double d100;
                double d101;
                if (n2 == 4 || n2 == 5) {
                    d101 = 0.0;
                    d100 = 0.0;
                    d99 = 0.0;
                    d98 = 0.0;
                } else if (n2 == 8 || n2 == 9) {
                    d98 = this.mExecuteArgs[4].getNumericValue();
                    d99 = this.mExecuteArgs[5].getNumericValue();
                    d100 = this.mExecuteArgs[6].getNumericValue();
                    d101 = this.mExecuteArgs[7].getNumericValue();
                } else {
                    throw new MapyrusException(MapyrusMessages.get("invalidworlds"));
                }
                double d102 = this.mExecuteArgs[0].getNumericValue();
                double d103 = this.mExecuteArgs[1].getNumericValue();
                double d104 = this.mExecuteArgs[2].getNumericValue();
                double d105 = this.mExecuteArgs[3].getNumericValue();
                int n10 = 1;
                boolean bl = false;
                String string = n2 == 5 ? this.mExecuteArgs[4].getStringValue() : (n2 == 9 ? this.mExecuteArgs[8].getStringValue() : "");
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                while (stringTokenizer.hasMoreTokens()) {
                    String string5;
                    String string6 = stringTokenizer.nextToken();
                    if (string6.startsWith("units=")) {
                        string5 = string6.substring(6);
                        Integer n11 = mWorldUnitsLookup.get(string5);
                        if (n11 == null) {
                            throw new MapyrusException(MapyrusMessages.get("invalidworldunits") + ": " + string5);
                        }
                        n10 = n11;
                        continue;
                    }
                    if (!string6.startsWith("distortion=")) continue;
                    string5 = string6.substring(11);
                    bl = string5.equalsIgnoreCase("true");
                }
                contextStack.setWorlds(d102, d103, d104, d105, d98, d99, d100, d101, n10, bl);
                break;
            }
            case 65: {
                if (n2 == 3) {
                    contextStack.setDataset(this.mExecuteArgs[0].getStringValue(), this.mExecuteArgs[1].getStringValue(), this.mExecuteArgs[2].getStringValue(), this.mStdinStream);
                    break;
                }
                throw new MapyrusException(MapyrusMessages.get("invaliddataset"));
            }
            case 66: {
                Row row = contextStack.fetchRow();
                String[] stringArray = contextStack.getDatasetFieldNames();
                for (int i = 0; i < row.size(); ++i) {
                    String string = stringArray != null ? stringArray[i] : DefaultFieldNames.get(i);
                    contextStack.defineVariable(string, (Argument)row.get(i));
                }
                break;
            }
            case 67: {
                if (n2 >= 3 && n2 <= 5) {
                    int n12;
                    double d106;
                    double d107;
                    String string = this.mExecuteArgs[0].getStringValue();
                    String string7 = this.mExecuteArgs[1].getStringValue();
                    if (n2 == 3 || this.mExecuteArgs[2].getType() == 1) {
                        String string8 = this.mExecuteArgs[2].getStringValue();
                        PageSize pageSize = new PageSize(string8);
                        d107 = pageSize.getDimension().getX();
                        d106 = pageSize.getDimension().getY();
                        n12 = 3;
                    } else {
                        d107 = this.mExecuteArgs[2].getNumericValue();
                        d106 = this.mExecuteArgs[3].getNumericValue();
                        n12 = 4;
                    }
                    String string9 = n12 < n2 ? this.mExecuteArgs[n12].getStringValue() : "";
                    if (d107 <= 0.0) {
                        throw new MapyrusException(MapyrusMessages.get("invalidpagesize") + ": " + d107);
                    }
                    if (d106 <= 0.0) {
                        throw new MapyrusException(MapyrusMessages.get("invalidpagesize") + ": " + d106);
                    }
                    contextStack.setOutputFormat(string, string7, d107, d106, string9, contextStack.getStdout());
                    break;
                }
                throw new MapyrusException(MapyrusMessages.get("invalidpage"));
            }
            case 68: {
                contextStack.closeOutputFormat();
                break;
            }
            case 71: {
                break;
            }
            case 73: {
                if (n2 == 1) {
                    String string = this.mExecuteArgs[0].getStringValue();
                    StringReader stringReader = new StringReader(string);
                    String string10 = "(in eval)";
                    FileOrURL fileOrURL = new FileOrURL(stringReader, string10);
                    byte[] byArray = new byte[]{};
                    this.interpret(contextStack, fileOrURL, new ByteArrayInputStream(byArray), contextStack.getStdout());
                    break;
                }
                throw new MapyrusException(MapyrusMessages.get("invalideval"));
            }
            case 72: {
                break;
            }
            case 74: {
                if (n2 >= 2) {
                    String string = this.mExecuteArgs[0].getStringValue();
                    String string11 = this.mExecuteArgs[1].getStringValue();
                    int n13 = LegendEntry.parseTypeString(string);
                    if (n13 < 0) {
                        throw new MapyrusException(MapyrusMessages.get("invalidlegendtype") + ": " + string);
                    }
                    this.mContext.addLegendEntry(string11, n13, this.mExecuteArgs, 2, n2 - 2);
                    break;
                }
                throw new MapyrusException(MapyrusMessages.get("invalidlegendentry"));
            }
            case 75: {
                if (n2 == 1) {
                    double d108 = this.mExecuteArgs[0].getNumericValue();
                    this.displayLegend(statement, contextStack, d108);
                    break;
                }
                throw new MapyrusException(MapyrusMessages.get("nolegendsize"));
            }
            case 76: {
                if (n2 == 1) {
                    String string = this.mExecuteArgs[0].getStringValue();
                    String string12 = "HTTP/1.0 200 OK" + Constants.LINE_SEPARATOR + "Content-Type" + ": " + string + Constants.LINE_SEPARATOR;
                    contextStack.setHTTPReponse(string12);
                    break;
                }
                throw new MapyrusException(MapyrusMessages.get("nomimetype"));
            }
            case 77: {
                StringBuffer stringBuffer = new StringBuffer(128);
                for (int i = 0; i < n2; ++i) {
                    stringBuffer.append(this.mExecuteArgs[i].getStringValue());
                    stringBuffer.append(Constants.LINE_SEPARATOR);
                }
                contextStack.setHTTPReponse(stringBuffer.toString());
            }
        }
    }

    private String parseWord(int n, Preprocessor preprocessor) throws IOException, MapyrusException {
        StringBuffer stringBuffer = new StringBuffer();
        if (!Character.isLetter((char)n) && n != 36) {
            throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("invalidkeyword"));
        }
        do {
            stringBuffer.append((char)n);
        } while (Character.isLetterOrDigit((char)(n = preprocessor.read())) || n == 46 || n == 95 || n == 58);
        preprocessor.unread(n);
        return stringBuffer.toString();
    }

    private int readSkipComments(Preprocessor preprocessor) throws IOException, MapyrusException {
        int n = preprocessor.read();
        while (this.mInComment || n == 35) {
            if (n == 35) {
                this.mInComment = true;
                n = preprocessor.read();
                continue;
            }
            if (n == 10 || n == -1) {
                this.mInComment = false;
                continue;
            }
            n = preprocessor.read();
        }
        return n;
    }

    private Statement parseSimpleStatement(String string, Preprocessor preprocessor) throws MapyrusException, IOException {
        ArrayList<Expression> arrayList = new ArrayList<Expression>();
        Statement statement = null;
        boolean bl = false;
        int n = 1;
        int n2 = this.readSkipComments(preprocessor);
        while (!bl) {
            if (n2 == -1 || n2 == 10) {
                bl = true;
                continue;
            }
            if (Character.isWhitespace((char)n2)) {
                n2 = this.readSkipComments(preprocessor);
                continue;
            }
            if (n == 2) {
                if (n2 != 44) {
                    throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("expected") + ": '" + ',' + "'");
                }
                n2 = this.readSkipComments(preprocessor);
                n = 1;
                continue;
            }
            preprocessor.unread(n2);
            Expression expression = new Expression(preprocessor, this.mUserFunctions);
            arrayList.add(expression);
            n2 = this.readSkipComments(preprocessor);
            n = 2;
        }
        if (n2 == -1 && arrayList.size() == 0) {
            statement = null;
        } else {
            Expression[] expressionArray = new Expression[arrayList.size()];
            for (int i = 0; i < expressionArray.length; ++i) {
                expressionArray[i] = (Expression)arrayList.get(i);
            }
            statement = new Statement(string, expressionArray);
            statement.setFilenameAndLineNumber(preprocessor.getCurrentFilename(), preprocessor.getCurrentLineNumber());
        }
        return statement;
    }

    private ArrayList parseParameters(Preprocessor preprocessor) throws IOException, MapyrusException {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 3;
        int n2 = this.readSkipComments(preprocessor);
        while (n2 != -1 && n2 != 10) {
            if (Character.isWhitespace((char)n2)) {
                n2 = this.readSkipComments(preprocessor);
                continue;
            }
            if (n == 3) {
                arrayList.add(this.parseWord(n2, preprocessor));
                n = 4;
                n2 = this.readSkipComments(preprocessor);
                continue;
            }
            if (n2 != 44) {
                throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("expected") + ": '" + ',' + "'");
            }
            n = 3;
            n2 = this.readSkipComments(preprocessor);
        }
        return arrayList;
    }

    private ParsedStatement parseProcedureBlock(Preprocessor preprocessor, boolean bl) throws IOException, MapyrusException {
        ArrayList<Statement> arrayList = new ArrayList<Statement>();
        boolean bl2 = false;
        UserFunction userFunction = null;
        int n = this.readSkipComments(preprocessor);
        while (Character.isWhitespace((char)n)) {
            n = this.readSkipComments(preprocessor);
        }
        String string = this.parseWord(n, preprocessor);
        ArrayList arrayList2 = this.parseParameters(preprocessor);
        if (bl) {
            userFunction = new UserFunction(string, arrayList2, null, this);
            this.mUserFunctions.put(string, userFunction);
        }
        do {
            ParsedStatement parsedStatement;
            if ((parsedStatement = this.parseStatementOrKeyword(preprocessor, true)) == null) {
                throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("unexpectedeof"));
            }
            if (parsedStatement.isStatement()) {
                arrayList.add(parsedStatement.getStatement());
                continue;
            }
            if (parsedStatement.getKeywordType() == 1) {
                bl2 = true;
                continue;
            }
            throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("expected") + ": " + END_KEYWORD);
        } while (!bl2);
        if (bl) {
            userFunction.setStatements(arrayList);
        }
        Statement statement = new Statement(string, arrayList2, arrayList);
        return new ParsedStatement(statement);
    }

    private ParsedStatement parseLoopStatement(Preprocessor preprocessor, boolean bl, boolean bl2) throws IOException, MapyrusException {
        ArrayList<Statement> arrayList = new ArrayList<Statement>();
        String string = preprocessor.getCurrentFilename();
        int n = preprocessor.getCurrentLineNumber();
        Expression expression = new Expression(preprocessor, this.mUserFunctions);
        ParsedStatement parsedStatement = this.parseStatementOrKeyword(preprocessor, bl2);
        if (parsedStatement == null) {
            throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("unexpectedeof"));
        }
        if (parsedStatement.isStatement() || parsedStatement.getKeywordType() != 7) {
            throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("expected") + ": " + DO_KEYWORD);
        }
        parsedStatement = this.parseStatementOrKeyword(preprocessor, bl2);
        if (parsedStatement == null) {
            throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("unexpectedeof"));
        }
        while (parsedStatement.isStatement()) {
            arrayList.add(parsedStatement.getStatement());
            parsedStatement = this.parseStatementOrKeyword(preprocessor, bl2);
            if (parsedStatement != null) continue;
            throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("unexpectedeof"));
        }
        if (parsedStatement.getKeywordType() != 8) {
            throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("expected") + ": " + DONE_KEYWORD);
        }
        Statement statement = new Statement(expression, arrayList, bl);
        statement.setFilenameAndLineNumber(string, n);
        return new ParsedStatement(statement);
    }

    private ParsedStatement parseForStatement(Preprocessor preprocessor, boolean bl) throws IOException, MapyrusException {
        ArrayList<Statement> arrayList = new ArrayList<Statement>();
        String string = preprocessor.getCurrentFilename();
        int n = preprocessor.getCurrentLineNumber();
        Expression expression = new Expression(preprocessor, this.mUserFunctions);
        ParsedStatement parsedStatement = this.parseStatementOrKeyword(preprocessor, bl);
        if (parsedStatement == null) {
            throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("unexpectedeof"));
        }
        if (parsedStatement.isStatement() || parsedStatement.getKeywordType() != 9) {
            throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("expected") + ": " + IN_KEYWORD);
        }
        Expression expression2 = new Expression(preprocessor, this.mUserFunctions);
        parsedStatement = this.parseStatementOrKeyword(preprocessor, bl);
        if (parsedStatement == null) {
            throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("unexpectedeof"));
        }
        if (parsedStatement.isStatement() || parsedStatement.getKeywordType() != 7) {
            throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("expected") + ": " + DO_KEYWORD);
        }
        parsedStatement = this.parseStatementOrKeyword(preprocessor, bl);
        if (parsedStatement == null) {
            throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("unexpectedeof"));
        }
        while (parsedStatement.isStatement()) {
            arrayList.add(parsedStatement.getStatement());
            parsedStatement = this.parseStatementOrKeyword(preprocessor, bl);
            if (parsedStatement != null) continue;
            throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("unexpectedeof"));
        }
        if (parsedStatement.getKeywordType() != 8) {
            throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("expected") + ": " + DONE_KEYWORD);
        }
        Statement statement = new Statement(expression, expression2, arrayList);
        statement.setFilenameAndLineNumber(string, n);
        return new ParsedStatement(statement);
    }

    private ParsedStatement parseIfStatement(Preprocessor preprocessor, boolean bl) throws IOException, MapyrusException {
        String string = preprocessor.getCurrentFilename();
        int n = preprocessor.getCurrentLineNumber();
        ArrayList<Statement> arrayList = new ArrayList<Statement>();
        ArrayList<Statement> arrayList2 = new ArrayList<Statement>();
        boolean bl2 = true;
        Expression expression = new Expression(preprocessor, this.mUserFunctions);
        ParsedStatement parsedStatement = this.parseStatementOrKeyword(preprocessor, bl);
        if (parsedStatement == null) {
            throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("unexpectedeof"));
        }
        if (parsedStatement.isStatement() || parsedStatement.getKeywordType() != 2) {
            throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("expected") + ": " + THEN_KEYWORD);
        }
        parsedStatement = this.parseStatementOrKeyword(preprocessor, bl);
        if (parsedStatement == null) {
            throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("unexpectedeof"));
        }
        while (parsedStatement.isStatement()) {
            arrayList.add(parsedStatement.getStatement());
            parsedStatement = this.parseStatementOrKeyword(preprocessor, bl);
            if (parsedStatement != null) continue;
            throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("unexpectedeof"));
        }
        if (parsedStatement.getKeywordType() == 3) {
            parsedStatement = this.parseStatementOrKeyword(preprocessor, bl);
            if (parsedStatement == null) {
                throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("unexpectedeof"));
            }
            while (parsedStatement.isStatement()) {
                arrayList2.add(parsedStatement.getStatement());
                parsedStatement = this.parseStatementOrKeyword(preprocessor, bl);
                if (parsedStatement != null) continue;
                throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("unexpectedeof"));
            }
        } else if (parsedStatement.getKeywordType() == 4) {
            parsedStatement = this.parseIfStatement(preprocessor, bl);
            if (!parsedStatement.isStatement()) {
                throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("expected") + ": " + ENDIF_KEYWORD);
            }
            arrayList2.add(parsedStatement.getStatement());
            bl2 = false;
        }
        if (bl2 && parsedStatement.getKeywordType() != 5) {
            throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("expected") + ": " + ENDIF_KEYWORD);
        }
        Statement statement = new Statement(expression, arrayList, arrayList2);
        statement.setFilenameAndLineNumber(string, n);
        return new ParsedStatement(statement);
    }

    private ParsedStatement parseStatementOrKeyword(Preprocessor preprocessor, boolean bl) throws MapyrusException, IOException {
        ParsedStatement parsedStatement = null;
        boolean bl2 = false;
        int n = this.readSkipComments(preprocessor);
        bl2 = false;
        while (!bl2) {
            if (n == -1) {
                bl2 = true;
                break;
            }
            if (Character.isWhitespace((char)n)) {
                n = this.readSkipComments(preprocessor);
                continue;
            }
            String string = this.parseWord(n, preprocessor);
            String string2 = string.toLowerCase();
            if (string2.equals(BEGIN_KEYWORD) || string2.equals(FUNCTION_KEYWORD)) {
                if (bl) {
                    throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("nestedproc"));
                }
                parsedStatement = this.parseProcedureBlock(preprocessor, string2.equals(FUNCTION_KEYWORD));
            } else if (string2.equals(IF_KEYWORD)) {
                parsedStatement = this.parseIfStatement(preprocessor, bl);
            } else if (string2.equals(WHILE_KEYWORD)) {
                parsedStatement = this.parseLoopStatement(preprocessor, true, bl);
            } else if (string2.equals(REPEAT_KEYWORD)) {
                parsedStatement = this.parseLoopStatement(preprocessor, false, bl);
            } else if (string2.equals(FOR_KEYWORD)) {
                parsedStatement = this.parseForStatement(preprocessor, bl);
            } else {
                parsedStatement = mKeywordLookup.get(string2);
                if (parsedStatement == null) {
                    Statement statement = this.parseSimpleStatement(string, preprocessor);
                    parsedStatement = new ParsedStatement(statement);
                }
            }
            bl2 = true;
        }
        return parsedStatement;
    }

    private Statement parseStatement(Preprocessor preprocessor) throws IOException, MapyrusException {
        ParsedStatement parsedStatement = this.parseStatementOrKeyword(preprocessor, false);
        if (parsedStatement == null) {
            return null;
        }
        if (!parsedStatement.isStatement()) {
            throw new MapyrusException(preprocessor.getCurrentFilenameAndLineNumber() + ": " + MapyrusMessages.get("invalidkeyword"));
        }
        return parsedStatement.getStatement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interpret(ContextStack contextStack, FileOrURL fileOrURL, InputStream inputStream, PrintStream printStream) throws IOException, MapyrusException {
        Preprocessor preprocessor = new Preprocessor(fileOrURL);
        this.mInComment = false;
        this.mStdinStream = inputStream;
        this.mStdoutStream = printStream;
        this.mContext = contextStack;
        contextStack.setStdout(printStream);
        try {
            Statement statement;
            while ((statement = this.parseStatement(preprocessor)) != null) {
                Argument argument = this.executeStatement(statement);
                if (argument == null) continue;
                break;
            }
        }
        finally {
            preprocessor.close();
        }
    }

    private void makeCall(Statement statement, ArrayList arrayList, Argument[] argumentArray) throws IOException, MapyrusException {
        Statement statement2;
        for (int i = 0; i < argumentArray.length; ++i) {
            String string = (String)arrayList.get(i);
            this.mContext.setLocalScope(string);
            this.mContext.defineVariable(string, argumentArray[i]);
        }
        ArrayList arrayList2 = statement.getStatementBlock();
        for (int i = 0; i < arrayList2.size() && this.executeStatement(statement2 = (Statement)arrayList2.get(i)) == null; ++i) {
        }
    }

    public Argument executeStatement(Statement statement) throws IOException, MapyrusException {
        Argument argument;
        block30: {
            int n;
            block34: {
                Argument argument2;
                block33: {
                    Argument argument3;
                    block32: {
                        Argument argument4;
                        block31: {
                            block29: {
                                n = statement.getType();
                                argument = null;
                                if (n != 6) break block29;
                                this.mStatementBlocks.put(statement.getBlockName(), statement);
                                break block30;
                            }
                            if (n != 1001) break block31;
                            Expression[] expressionArray = statement.getExpressions();
                            if (expressionArray.length > 1) {
                                throw new MapyrusException(MapyrusMessages.get("invalidexpression"));
                            }
                            argument = expressionArray.length == 0 ? Argument.emptyString : expressionArray[0].evaluate(this.mContext, statement.getFilename());
                            break block30;
                        }
                        if (n != 2) break block32;
                        Expression[] expressionArray = statement.getExpressions();
                        try {
                            argument4 = expressionArray[0].evaluate(this.mContext, statement.getFilename());
                        }
                        catch (MapyrusException mapyrusException) {
                            throw new MapyrusException(statement.getFilenameAndLineNumber() + ": " + mapyrusException.getMessage());
                        }
                        if (argument4.getType() != 0) {
                            throw new MapyrusException(statement.getFilenameAndLineNumber() + ": " + MapyrusMessages.get("invalidexpression"));
                        }
                        ArrayList arrayList = argument4.getNumericValue() != 0.0 ? statement.getThenStatements() : statement.getElseStatements();
                        if (arrayList == null) break block30;
                        for (int i = 0; i < arrayList.size() && (argument = this.executeStatement(statement = (Statement)arrayList.get(i))) == null; ++i) {
                        }
                        break block30;
                    }
                    if (n != 4 && n != 3) break block33;
                    Expression[] expressionArray = statement.getExpressions();
                    ArrayList arrayList = statement.getLoopStatements();
                    try {
                        argument3 = expressionArray[0].evaluate(this.mContext, statement.getFilename());
                    }
                    catch (MapyrusException mapyrusException) {
                        throw new MapyrusException(statement.getFilenameAndLineNumber() + ": " + mapyrusException.getMessage());
                    }
                    if (argument3.getType() != 0) {
                        throw new MapyrusException(statement.getFilenameAndLineNumber() + ": " + MapyrusMessages.get("invalidexpression"));
                    }
                    int n2 = 0;
                    if (n == 3) {
                        double d = argument3.getNumericValue();
                        n2 = NumericalAnalysis.equals(d, (double)((int)d)) ? (int)Math.round(d) : (int)argument3.getNumericValue();
                    }
                    int n3 = n;
                    for (int i = 0; argument == null && (n3 == 4 && argument3.getNumericValue() != 0.0 || n3 == 3 && i < n2); ++i) {
                        Statement statement2;
                        for (int j = 0; j < arrayList.size() && (argument = this.executeStatement(statement2 = (Statement)arrayList.get(j))) == null; ++j) {
                        }
                        if (n3 != 4 || argument != null || (argument3 = expressionArray[0].evaluate(this.mContext, statement.getFilename())).getType() == 0) continue;
                        throw new MapyrusException(statement.getFilenameAndLineNumber() + ": " + MapyrusMessages.get("invalidexpression"));
                    }
                    break block30;
                }
                if (n != 5) break block34;
                Expression[] expressionArray = statement.getExpressions();
                Expression expression = statement.getForHashMap();
                ArrayList arrayList = statement.getLoopStatements();
                String string = expressionArray[0].getVariableName();
                try {
                    argument2 = expression.evaluate(this.mContext, statement.getFilename());
                }
                catch (MapyrusException mapyrusException) {
                    throw new MapyrusException(statement.getFilenameAndLineNumber() + ": " + mapyrusException.getMessage());
                }
                if (string == null) {
                    throw new MapyrusException(statement.getFilenameAndLineNumber() + ": " + MapyrusMessages.get("variableexpected"));
                }
                if (argument2.getType() != 2) break block30;
                Object[] objectArray = argument2.getHashMapKeys();
                boolean bl = false;
                for (int i = 0; i < objectArray.length && !bl; ++i) {
                    Statement statement3;
                    String string2 = (String)objectArray[i];
                    this.mContext.defineVariable(string, new Argument(1, string2));
                    for (int j = 0; j < arrayList.size() && (argument = this.executeStatement(statement3 = (Statement)arrayList.get(j))) == null; ++j) {
                    }
                }
                break block30;
            }
            if (n == 1000) {
                int n4;
                Argument[] argumentArray;
                String string = statement.getBlockName();
                Statement statement4 = this.mStatementBlocks.get(string);
                if (statement4 == null) {
                    throw new MapyrusException(statement.getFilenameAndLineNumber() + ": " + MapyrusMessages.get("undefinedproc") + ": " + string);
                }
                ArrayList arrayList = statement4.getBlockParameters();
                Expression[] expressionArray = statement.getExpressions();
                if (expressionArray.length != arrayList.size()) {
                    throw new MapyrusException(statement.getFilenameAndLineNumber() + ": " + MapyrusMessages.get("wrongparameters"));
                }
                try {
                    argumentArray = new Argument[expressionArray.length];
                    for (n4 = 0; n4 < argumentArray.length; ++n4) {
                        argumentArray[n4] = expressionArray[n4].evaluate(this.mContext, statement.getFilename());
                    }
                }
                catch (MapyrusException mapyrusException) {
                    throw new MapyrusException(statement.getFilenameAndLineNumber() + ": " + mapyrusException.getMessage());
                }
                n4 = this.mContext.getMoveToCount();
                int n5 = this.mContext.getLineToCount();
                if (n4 > 0 && n5 == 0) {
                    ArrayList arrayList2 = this.mContext.getMoveTos();
                    ArrayList arrayList3 = this.mContext.getMoveToRotations();
                    for (int i = 0; i < n4; ++i) {
                        this.mContext.saveState(string);
                        Point2D.Float float_ = (Point2D.Float)arrayList2.get(i);
                        this.mContext.setTranslation(float_.x, float_.y);
                        this.mContext.clearPath();
                        double d = (Double)arrayList3.get(i);
                        this.mContext.setRotation(d);
                        this.makeCall(statement4, arrayList, argumentArray);
                        this.mContext.restoreState();
                    }
                } else {
                    this.mContext.saveState(string);
                    this.makeCall(statement4, arrayList, argumentArray);
                    this.mContext.restoreState();
                }
            } else {
                try {
                    this.execute(statement, this.mContext);
                }
                catch (MapyrusException mapyrusException) {
                    throw new MapyrusException(statement.getFilenameAndLineNumber() + ": " + mapyrusException.getMessage());
                }
                catch (IOException iOException) {
                    throw new MapyrusException(statement.getFilenameAndLineNumber() + ": " + iOException.getMessage());
                }
            }
        }
        return argument;
    }

    public Object clone() {
        Interpreter interpreter = new Interpreter();
        interpreter.mExecuteArgs = null;
        interpreter.mContext = null;
        interpreter.mInComment = false;
        interpreter.mStatementBlocks = new HashMap(this.mStatementBlocks.size());
        interpreter.mStatementBlocks.putAll(this.mStatementBlocks);
        interpreter.mUserFunctions = new HashMap(this.mUserFunctions.size());
        for (String string : this.mUserFunctions.keySet()) {
            UserFunction userFunction = this.mUserFunctions.get(string);
            interpreter.mUserFunctions.put(string, userFunction.clone(interpreter));
        }
        interpreter.mStdinStream = null;
        interpreter.mStdoutStream = null;
        return interpreter;
    }

    static {
        mWorldUnitsLookup.put("m", 1);
        mWorldUnitsLookup.put("metres", 1);
        mWorldUnitsLookup.put("meters", 1);
        mWorldUnitsLookup.put("feet", 2);
        mWorldUnitsLookup.put("foot", 2);
        mWorldUnitsLookup.put("ft", 2);
        mWorldUnitsLookup.put("degrees", 3);
        mWorldUnitsLookup.put("degree", 3);
        mWorldUnitsLookup.put("deg", 3);
        mKeywordLookup = new HashMap();
        mKeywordLookup.put(END_KEYWORD, new ParsedStatement(1));
        mKeywordLookup.put(THEN_KEYWORD, new ParsedStatement(2));
        mKeywordLookup.put(ELSE_KEYWORD, new ParsedStatement(3));
        mKeywordLookup.put(ELIF_KEYWORD, new ParsedStatement(4));
        mKeywordLookup.put(ENDIF_KEYWORD, new ParsedStatement(5));
        mKeywordLookup.put(DO_KEYWORD, new ParsedStatement(7));
        mKeywordLookup.put(DONE_KEYWORD, new ParsedStatement(8));
        mKeywordLookup.put(IN_KEYWORD, new ParsedStatement(9));
    }
}

