/*
 * Decompiled with CFR 0.152.
 */
package org.mapyrus;

import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.mapyrus.Constants;
import org.mapyrus.MapyrusException;
import org.mapyrus.MapyrusMessages;
import org.mapyrus.NumericalAnalysis;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Argument
implements Comparable<Argument> {
    public static final int NUMERIC = 0;
    public static final int STRING = 1;
    public static final int HASHMAP = 2;
    public static final int VARIABLE = 3;
    public static final int GEOMETRY = 4;
    public static final int GEOMETRY_POINT = 100;
    public static final int GEOMETRY_LINESTRING = 101;
    public static final int GEOMETRY_POLYGON = 102;
    public static final int GEOMETRY_MULTIPOINT = 103;
    public static final int GEOMETRY_MULTILINESTRING = 104;
    public static final int GEOMETRY_MULTIPOLYGON = 105;
    public static final int GEOMETRY_COLLECTION = 106;
    public static final int MOVETO = 0;
    public static final int LINETO = 1;
    public static final Argument numericZero = new Argument(0.0);
    public static final Argument numericOne = new Argument(1.0);
    public static final Argument numericMinusOne = new Argument(-1.0);
    public static final Argument emptyString = new Argument(1, "");
    public static final Argument emptyGeometry = new Argument(100, new double[]{100.0, 0.0});
    private int mType;
    private double mNumericValue;
    private String mStringValue;
    private String mVarname;
    private double[] mGeometryValue;
    private Rectangle2D.Double mGeometryBoundingBox;
    private HashMap<String, Argument> mHashMap;

    public Argument(double d) {
        this.mType = 0;
        this.mNumericValue = d;
    }

    public Argument(int n, String string) {
        this.mType = n;
        if (n == 1) {
            this.mStringValue = string;
        } else {
            this.mVarname = string;
        }
        this.mNumericValue = Double.NaN;
        this.mGeometryValue = null;
    }

    public Argument() {
        this.mType = 2;
        this.mHashMap = new HashMap();
    }

    public Argument(int n, double[] dArray) {
        this.mType = n;
        this.mGeometryValue = dArray;
    }

    private int parseCoordinateList(String string, StringTokenizer stringTokenizer, int n, boolean bl) throws MapyrusException {
        String string2;
        int n2 = n;
        int n3 = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        while (!bl4 && !bl2 && stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            bl4 = string2.equals("(");
            bl2 = string2.equals("EMPTY");
        }
        if (bl4) {
            while (!bl3 && stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
                char c = string2.charAt(0);
                if (Character.isDigit(c) || c == '-' || c == '.') {
                    try {
                        if (!bl6) {
                            if (bl) {
                                this.mGeometryValue[n2] = 100.0;
                                this.mGeometryValue[n2 + 1] = 1.0;
                                this.mGeometryValue[n2 + 2] = 0.0;
                                n2 += 3;
                            } else if (n3 == 0) {
                                this.mGeometryValue[n2] = 0.0;
                                ++n2;
                            } else {
                                this.mGeometryValue[n2] = 1.0;
                                ++n2;
                            }
                            this.mGeometryValue[n2] = Double.parseDouble(string2);
                            ++n2;
                            bl6 = true;
                            continue;
                        }
                        if (!bl5) {
                            this.mGeometryValue[n2] = Double.parseDouble(string2);
                            ++n2;
                            bl5 = true;
                            ++n3;
                            continue;
                        }
                        throw new MapyrusException(MapyrusMessages.get("invalidogcwkt") + ": " + string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new MapyrusException(MapyrusMessages.get("invalidogcwkt") + ": " + string);
                    }
                }
                if (c == ')' && bl5) {
                    bl3 = true;
                    continue;
                }
                if (c == ',' && bl5) {
                    bl5 = false;
                    bl6 = false;
                    continue;
                }
                if (c == ' ') continue;
                throw new MapyrusException(MapyrusMessages.get("invalidogcwkt") + ": " + string);
            }
        }
        if (bl4 && !bl3 || bl6 && !bl5) {
            throw new MapyrusException(MapyrusMessages.get("invalidogcwkt") + ": " + string);
        }
        return n3;
    }

    private int parseRing(String string, StringTokenizer stringTokenizer, int n, boolean bl) throws MapyrusException {
        String string2;
        int n2 = 0;
        int n3 = n + 1;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        bl4 = false;
        bl3 = false;
        while (!bl3 && !bl4 && stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            bl3 = string2.equals("(");
            bl4 = string2.equals("EMPTY");
        }
        if (!bl4) {
            while (bl3 && !bl2 && stringTokenizer.hasMoreTokens()) {
                int n4;
                if (bl) {
                    this.mGeometryValue[n3] = 101.0;
                    n4 = this.parseCoordinateList(string, stringTokenizer, ++n3 + 1, false);
                    this.mGeometryValue[n3] = n4;
                    ++n3;
                    ++n2;
                } else {
                    n4 = this.parseCoordinateList(string, stringTokenizer, n3, false);
                    n2 += n4;
                }
                n3 += n4 * 3;
                bl3 = false;
                while (!bl3 && !bl2 && stringTokenizer.hasMoreTokens()) {
                    string2 = stringTokenizer.nextToken();
                    bl3 = string2.equals(",");
                    bl2 = string2.equals(")");
                }
            }
            if (!bl2) {
                throw new MapyrusException(MapyrusMessages.get("invalidogcwkt") + ": " + string);
            }
        }
        this.mGeometryValue[n] = n2;
        return n3;
    }

    private int parseGeometry(String string, StringTokenizer stringTokenizer, int n) throws MapyrusException {
        if (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            while (string2.equals(" ") && stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
            }
            if (string2.equals("POINT")) {
                this.mGeometryValue[n] = 100.0;
                int n2 = this.parseCoordinateList(string, stringTokenizer, ++n + 1, false);
                this.mGeometryValue[n] = n2;
                ++n;
                n += n2 * 3;
            } else if (string2.equals("LINESTRING")) {
                this.mGeometryValue[n] = 101.0;
                int n3 = this.parseCoordinateList(string, stringTokenizer, ++n + 1, false);
                this.mGeometryValue[n] = n3;
                ++n;
                n += n3 * 3;
            } else if (string2.equals("MULTIPOINT")) {
                this.mGeometryValue[n] = 103.0;
                int n4 = this.parseCoordinateList(string, stringTokenizer, ++n + 1, true);
                this.mGeometryValue[n] = n4;
                ++n;
                n += n4 * 5;
            } else {
                if (string2.equals("POLYGON")) {
                    this.mGeometryValue[n] = 102.0;
                } else if (string2.equals("MULTILINESTRING")) {
                    this.mGeometryValue[n] = 104.0;
                } else if (string2.equals("MULTIPOLYGON")) {
                    this.mGeometryValue[n] = 105.0;
                } else if (string2.equals("GEOMETRYCOLLECTION")) {
                    this.mGeometryValue[n] = 106.0;
                } else {
                    throw new MapyrusException(MapyrusMessages.get("invalidogcwkt") + ": " + string);
                }
                if (this.mGeometryValue[n] == 102.0) {
                    n = this.parseRing(string, stringTokenizer, n + 1, false);
                } else if (this.mGeometryValue[n] == 104.0) {
                    n = this.parseRing(string, stringTokenizer, n + 1, true);
                } else {
                    String string3;
                    boolean bl = false;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    while (!bl3 && !bl && stringTokenizer.hasMoreTokens()) {
                        string3 = stringTokenizer.nextToken();
                        bl3 = string3.equals("(");
                        bl = string3.equals("EMPTY");
                    }
                    int n5 = (int)this.mGeometryValue[n];
                    int n6 = 0;
                    int n7 = n + 1;
                    n += 2;
                    while (bl3 && !bl2 && stringTokenizer.hasMoreTokens()) {
                        if (n5 == 105) {
                            this.mGeometryValue[n] = 102.0;
                            n = this.parseRing(string, stringTokenizer, n + 1, false);
                        } else {
                            n = this.parseGeometry(string, stringTokenizer, n);
                        }
                        ++n6;
                        boolean bl4 = false;
                        while (!bl4 && !bl2 && stringTokenizer.hasMoreTokens()) {
                            string3 = stringTokenizer.nextToken();
                            if (string3.equals(",")) {
                                bl4 = true;
                                continue;
                            }
                            if (!string3.equals(")")) continue;
                            bl2 = true;
                        }
                    }
                    this.mGeometryValue[n7] = n6;
                    if (bl3 && !bl2) {
                        throw new MapyrusException(MapyrusMessages.get("invalidogcwkt") + ": " + string);
                    }
                }
            }
        } else {
            throw new MapyrusException(MapyrusMessages.get("invalidogcwkt") + ": " + string);
        }
        return n;
    }

    public Argument(String string) throws MapyrusException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",() ", true);
        this.mGeometryValue = new double[stringTokenizer.countTokens() + 1];
        this.parseGeometry(string, stringTokenizer, 0);
        this.mType = (int)this.mGeometryValue[0];
    }

    public int getType() {
        int n = this.mType == 0 || this.mType == 1 || this.mType == 3 || this.mType == 2 ? this.mType : 4;
        return n;
    }

    public double getNumericValue() throws MapyrusException {
        if (this.mType == 1) {
            if (Double.isNaN(this.mNumericValue)) {
                try {
                    this.mNumericValue = Double.parseDouble(this.mStringValue);
                }
                catch (NumberFormatException numberFormatException) {
                    this.mNumericValue = 0.0;
                }
            }
        } else {
            if (this.mType == 2) {
                throw new MapyrusException(MapyrusMessages.get("hashmapnotnumeric"));
            }
            if (this.mType != 0) {
                throw new MapyrusException(MapyrusMessages.get("geometrynotnumeric"));
            }
        }
        return this.mNumericValue;
    }

    public String getStringValue() {
        return this.toString();
    }

    public String getVariableName() {
        return this.mVarname;
    }

    public double[] getGeometryValue() throws MapyrusException {
        if (this.mType == 0 || this.mType == 2 || this.mType == 3) {
            throw new MapyrusException(MapyrusMessages.get("invalidgeometry"));
        }
        if (this.mGeometryValue == null) {
            StringTokenizer stringTokenizer = new StringTokenizer(this.mStringValue, ",() ", true);
            this.mGeometryValue = new double[stringTokenizer.countTokens() + 1];
            this.parseGeometry(this.mStringValue, stringTokenizer, 0);
        }
        return this.mGeometryValue;
    }

    private Rectangle2D.Double getGeometryBoundingBox(double[] dArray, int[] nArray, Rectangle2D.Double double_) {
        int n = nArray[0];
        int n2 = (int)dArray[n];
        int n3 = (int)dArray[n + 1];
        if (n3 == 0) {
            n += 2;
        } else {
            switch (n2) {
                case 100: {
                    double d = dArray[n + 3];
                    double d2 = dArray[n + 4];
                    if (double_ == null) {
                        double_ = new Rectangle2D.Double(d, d2, 0.0, 0.0);
                    } else {
                        double_.add(d, d2);
                    }
                    n += 5;
                    break;
                }
                case 101: 
                case 102: {
                    double d = dArray[n + 3];
                    double d3 = dArray[n + 4];
                    if (double_ == null) {
                        double_ = new Rectangle2D.Double(d, d3, 0.0, 0.0);
                    } else {
                        double_.add(d, d3);
                    }
                    int n4 = 6;
                    for (int i = 1; i < n3; ++i) {
                        d = dArray[n + n4];
                        d3 = dArray[n + n4 + 1];
                        double_.add(d, d3);
                        n4 += 3;
                    }
                    n += 2 + n3 * 3;
                    break;
                }
                case 103: 
                case 104: 
                case 105: 
                case 106: {
                    nArray[0] = n += 2;
                    for (int i = 0; i < n3; ++i) {
                        double_ = this.getGeometryBoundingBox(dArray, nArray, double_);
                    }
                    n = nArray[0];
                }
            }
        }
        nArray[0] = n;
        return double_;
    }

    public Rectangle2D.Double getGeometryBoundingBox() throws MapyrusException {
        Rectangle2D.Double double_ = this.mGeometryBoundingBox;
        if (double_ == null) {
            double[] dArray = this.getGeometryValue();
            int[] nArray = new int[]{0};
            double_ = this.getGeometryBoundingBox(dArray, nArray, null);
            if (dArray[0] != 100.0) {
                this.mGeometryBoundingBox = double_;
            }
        }
        return double_;
    }

    private int transformGeometry(AffineTransform affineTransform, double[] dArray, double[] dArray2, int n) throws MapyrusException {
        int n2 = (int)dArray[n];
        int n3 = (int)dArray[n + 1];
        if (n3 == 0) {
            n += 2;
        } else {
            switch (n2) {
                case 100: {
                    affineTransform.transform(dArray, n + 3, dArray2, n + 3, 1);
                    n += 5;
                    break;
                }
                case 101: 
                case 102: {
                    int n4 = n + 3;
                    for (int i = 0; i < n3; ++i) {
                        affineTransform.transform(dArray, n4, dArray2, n4, 1);
                        n4 += 3;
                    }
                    n += 2 + n3 * 3;
                    break;
                }
                case 103: 
                case 104: 
                case 105: 
                case 106: {
                    n += 2;
                    for (int i = 0; i < n3; ++i) {
                        n = this.transformGeometry(affineTransform, dArray, dArray2, n);
                    }
                    break;
                }
            }
        }
        return n;
    }

    public Argument transformGeometry(AffineTransform affineTransform) throws MapyrusException {
        double[] dArray = this.getGeometryValue();
        double[] dArray2 = new double[dArray.length];
        System.arraycopy(dArray, 0, dArray2, 0, dArray.length);
        this.transformGeometry(affineTransform, dArray, dArray2, 0);
        Argument argument = new Argument((int)dArray2[0], dArray2);
        return argument;
    }

    public Argument getHashMapEntry(String string) {
        Argument argument = this.mHashMap.get(string);
        if (argument == null) {
            argument = emptyString;
        }
        return argument;
    }

    public void addHashMapEntry(String string, Argument argument) {
        this.mHashMap.put(string, argument);
    }

    public Object[] getHashMapKeys() {
        Object[] objectArray = new String[this.mHashMap.size()];
        Iterator<String> iterator = this.mHashMap.keySet().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            objectArray[n++] = iterator.next();
        }
        Arrays.sort(objectArray, new NumericAndStringComparator());
        return objectArray;
    }

    public Object[] getHashMapKeysSortedByValue() {
        Object[] objectArray = this.mHashMap.keySet().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            for (int j = i + 1; j < objectArray.length; ++j) {
                Argument argument;
                Argument argument2 = this.mHashMap.get(objectArray[i]);
                if (argument2.compareTo(argument = this.mHashMap.get(objectArray[j])) <= 0) continue;
                Object object = objectArray[i];
                objectArray[i] = objectArray[j];
                objectArray[j] = object;
            }
        }
        return objectArray;
    }

    public int getHashMapSize() {
        return this.mHashMap.size();
    }

    private int createOGCWKT(double[] dArray, int n, StringBuffer stringBuffer, boolean bl) {
        int n2 = (int)dArray[n];
        int n3 = (int)dArray[n + 1];
        int n4 = n + 2;
        if (bl) {
            if (n2 == 100) {
                stringBuffer.append("POINT ");
            } else if (n2 == 101) {
                stringBuffer.append("LINESTRING ");
            } else if (n2 == 102) {
                stringBuffer.append("POLYGON ");
            } else if (n2 == 103) {
                stringBuffer.append("MULTIPOINT ");
            } else if (n2 == 104) {
                stringBuffer.append("MULTILINESTRING ");
            } else if (n2 == 105) {
                stringBuffer.append("MULTIPOLYGON ");
            } else {
                stringBuffer.append("GEOMETRYCOLLECTION ");
            }
        }
        if (n3 == 0) {
            stringBuffer.append("EMPTY ");
        } else if (n2 == 100) {
            if (bl) {
                stringBuffer.append("(");
            }
            stringBuffer.append(dArray[n4 + 1]);
            stringBuffer.append(" ");
            stringBuffer.append(dArray[n4 + 2]);
            if (bl) {
                stringBuffer.append(")");
            }
            n4 += 3;
        } else if (n2 == 101 || n2 == 102) {
            if (n2 == 102) {
                stringBuffer.append("(");
            }
            for (int i = 0; i < n3; ++i) {
                if (dArray[n4] == 0.0) {
                    if (i > 0) {
                        stringBuffer.append("), ");
                    }
                    stringBuffer.append("(");
                } else if (i > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(this.mGeometryValue[n4 + 1]);
                stringBuffer.append(" ");
                stringBuffer.append(this.mGeometryValue[n4 + 2]);
                n4 += 3;
            }
            if (n2 == 101) {
                stringBuffer.append(")");
            } else {
                stringBuffer.append("))");
            }
        } else {
            stringBuffer.append("( ");
            boolean bl2 = n2 == 106;
            for (int i = 0; i < n3; ++i) {
                if (i > 0) {
                    stringBuffer.append(", ");
                }
                n4 = this.createOGCWKT(dArray, n4, stringBuffer, bl2);
            }
            stringBuffer.append(")");
        }
        return n4;
    }

    public String toString() {
        String string = null;
        if (this.mType == 1) {
            string = this.mStringValue;
        } else if (this.mType == 3) {
            string = this.mVarname;
        } else if (this.mType == 0) {
            double d = this.mNumericValue >= 0.0 ? this.mNumericValue : -this.mNumericValue;
            DecimalFormat decimalFormat = d != 0.0 && (d < 0.01 || d > 1.0E7) ? new DecimalFormat("#.################E0", Constants.US_DECIMAL_FORMAT_SYMBOLS) : new DecimalFormat("#.################", Constants.US_DECIMAL_FORMAT_SYMBOLS);
            string = decimalFormat.format(this.mNumericValue);
        } else if (this.mType == 2) {
            StringBuffer stringBuffer = new StringBuffer();
            Object[] objectArray = this.getHashMapKeys();
            for (int i = 0; i < objectArray.length; ++i) {
                stringBuffer.append(objectArray[i]);
                stringBuffer.append(' ');
                Argument argument = this.mHashMap.get(objectArray[i]);
                stringBuffer.append(argument.getStringValue());
                stringBuffer.append(Constants.LINE_SEPARATOR);
            }
            string = stringBuffer.toString();
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            this.createOGCWKT(this.mGeometryValue, 0, stringBuffer, true);
            string = stringBuffer.toString().trim();
        }
        return string;
    }

    public Object clone() {
        Argument argument;
        if (this.mType == 1 || this.mType == 3) {
            argument = new Argument(this.mType, this.mStringValue);
        } else if (this.mType == 0) {
            argument = new Argument(this.mNumericValue);
        } else if (this.mType == 2) {
            argument = new Argument();
            argument.mHashMap = new HashMap(this.mHashMap.size());
            for (String string : this.mHashMap.keySet()) {
                argument.mHashMap.put(string, this.mHashMap.get(string));
            }
        } else {
            argument = new Argument(this.mType, this.mGeometryValue);
        }
        return argument;
    }

    @Override
    public int compareTo(Argument argument) {
        int n;
        if (this.getType() == 0 && argument.getType() == 0) {
            double d = 1.0;
            double d2 = 0.0;
            try {
                d = this.getNumericValue();
                d2 = argument.getNumericValue();
            }
            catch (MapyrusException mapyrusException) {
                // empty catch block
            }
            n = NumericalAnalysis.equals(d, d2) ? 0 : (d > d2 ? 1 : -1);
        } else {
            String string = this.getStringValue();
            String string2 = argument.getStringValue();
            n = string.compareTo(string2);
        }
        return n;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NumericAndStringComparator
    implements Comparator<String> {
        private NumericAndStringComparator() {
        }

        @Override
        public int compare(String string, String string2) {
            int n;
            try {
                int n2 = Integer.parseInt(string);
                int n3 = Integer.parseInt(string2);
                n = n2 - n3;
            }
            catch (NumberFormatException numberFormatException) {
                n = string.compareTo(string2);
            }
            return n;
        }
    }
}

