/*
 * Decompiled with CFR 0.152.
 */
package org.mapyrus.dataset;

import java.awt.geom.Rectangle2D;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import org.mapyrus.Argument;
import org.mapyrus.MapyrusException;
import org.mapyrus.MapyrusMessages;
import org.mapyrus.Row;
import org.mapyrus.dataset.ConnectionPool;
import org.mapyrus.dataset.GeographicDataset;
import org.mapyrus.dataset.OracleGeometry;
import org.mapyrus.dataset.WKBGeometryParser;

public class JDBCDataset
implements GeographicDataset {
    private Connection mConnection = null;
    private Statement mStatement = null;
    private ResultSet mResultSet = null;
    private String mSql;
    private String mUrl;
    private String[] mFieldNames;
    private int[] mFieldTypes;

    public JDBCDataset(String string, String string2) throws MapyrusException {
        String string3 = null;
        Properties properties = new Properties();
        this.mSql = string;
        StringTokenizer stringTokenizer = new StringTokenizer(string2);
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            int n = string4.indexOf(61);
            if (n <= 0) continue;
            String string5 = string4.substring(0, n);
            String string6 = string4.substring(n + 1);
            if (string5.equals("driver")) {
                string3 = string6;
                continue;
            }
            if (string5.equals("url")) {
                this.mUrl = string6;
                continue;
            }
            properties.put(string5, string6);
        }
        try {
            if (string3 != null) {
                Class.forName(string3);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new MapyrusException(MapyrusMessages.get("nojdbcclass") + ": " + classNotFoundException.getMessage() + ": " + string3);
        }
        try {
            this.mConnection = ConnectionPool.get(this.mUrl, properties);
        }
        catch (SQLException sQLException) {
            String string7 = sQLException.getSQLState();
            string7 = string7 != null ? ": " + string7 : "";
            throw new MapyrusException(sQLException.getErrorCode() + ": " + sQLException.getMessage() + string7 + ": " + this.mUrl);
        }
        try {
            this.mStatement = this.mConnection.createStatement();
            try {
                this.mStatement.setQueryTimeout(30);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.mResultSet = this.mStatement.executeQuery(this.mSql);
            ResultSetMetaData resultSetMetaData = this.mResultSet.getMetaData();
            int n = resultSetMetaData.getColumnCount();
            this.mFieldNames = new String[n];
            this.mFieldTypes = new int[n];
            for (int i = 0; i < n; ++i) {
                boolean bl;
                this.mFieldNames[i] = resultSetMetaData.getColumnName(i + 1);
                char c = this.mFieldNames[i].charAt(0);
                boolean bl2 = bl = Character.isLetter(c) || c == '$';
                if (bl) {
                    for (int j = 1; bl && j < this.mFieldNames[i].length(); ++j) {
                        c = this.mFieldNames[i].charAt(j);
                        bl = c == '.' || c == '_' || Character.isLetterOrDigit(c);
                    }
                }
                if (!bl) {
                    throw new MapyrusException(MapyrusMessages.get("invalidfieldname") + ": " + this.mFieldNames[i]);
                }
                this.mFieldTypes[i] = resultSetMetaData.getColumnType(i + 1);
            }
        }
        catch (SQLException sQLException) {
            try {
                this.close(false);
            }
            catch (MapyrusException mapyrusException) {
                // empty catch block
            }
            String string8 = sQLException.getSQLState();
            string8 = string8 != null ? ": " + string8 : "";
            throw new MapyrusException(sQLException.getErrorCode() + ": " + sQLException.getMessage() + string8 + ": " + this.mSql);
        }
        catch (MapyrusException mapyrusException) {
            try {
                this.close(false);
            }
            catch (MapyrusException mapyrusException2) {
                // empty catch block
            }
            throw mapyrusException;
        }
    }

    public String getProjection() {
        return null;
    }

    public Hashtable getMetadata() {
        return null;
    }

    public String[] getFieldNames() {
        return this.mFieldNames;
    }

    public Rectangle2D.Double getWorlds() {
        return new Rectangle2D.Double(-180.0, -90.0, 180.0, 90.0);
    }

    public Row fetch() throws MapyrusException {
        Row row;
        block38: {
            try {
                if (this.mResultSet.next()) {
                    row = new Row();
                    for (int i = 0; i < this.mFieldTypes.length; ++i) {
                        Argument argument;
                        block37: {
                            Object[] objectArray;
                            Object object;
                            if (this.mFieldTypes[i] == -6) {
                                argument = new Argument(this.mResultSet.getByte(i + 1));
                            } else if (this.mFieldTypes[i] == 5) {
                                argument = new Argument(this.mResultSet.getShort(i + 1));
                            } else if (this.mFieldTypes[i] == 4) {
                                argument = new Argument(this.mResultSet.getInt(i + 1));
                            } else if (this.mFieldTypes[i] == -5) {
                                argument = new Argument(this.mResultSet.getLong(i + 1));
                            } else if (this.mFieldTypes[i] == 7) {
                                argument = new Argument(this.mResultSet.getFloat(i + 1));
                            } else if (this.mFieldTypes[i] == 6 || this.mFieldTypes[i] == 8) {
                                argument = new Argument(this.mResultSet.getDouble(i + 1));
                            } else if (this.mFieldTypes[i] == 3 || this.mFieldTypes[i] == 2) {
                                argument = new Argument(this.mResultSet.getDouble(i + 1));
                            } else if (this.mFieldTypes[i] == -7) {
                                boolean bl = this.mResultSet.getBoolean(i + 1);
                                argument = bl ? Argument.numericOne : Argument.numericZero;
                            } else if (this.mFieldTypes[i] == 1 || this.mFieldTypes[i] == 12 || this.mFieldTypes[i] == -1 || this.mFieldTypes[i] == 2005) {
                                object = this.mResultSet.getString(i + 1);
                                argument = object == null ? Argument.emptyString : new Argument(1, (String)object);
                            } else if (this.mFieldTypes[i] == -2 || this.mFieldTypes[i] == -3 || this.mFieldTypes[i] == -4 || this.mFieldTypes[i] == 2004) {
                                object = this.mResultSet.getBytes(i + 1);
                                if (object == null) {
                                    argument = Argument.emptyGeometry;
                                } else {
                                    objectArray = WKBGeometryParser.parse((byte[])object);
                                    argument = new Argument((int)objectArray[0], (double[])objectArray);
                                }
                            } else if (this.mFieldTypes[i] == 91 || this.mFieldTypes[i] == 92 || this.mFieldTypes[i] == 93) {
                                object = this.mResultSet.getString(i + 1);
                                argument = object == null ? Argument.emptyString : new Argument(1, (String)object);
                            } else if (this.mFieldTypes[i] == 1111) {
                                object = this.mResultSet.getBytes(i + 1);
                                if (object == null || ((Object)object).length == 0) {
                                    argument = Argument.emptyString;
                                } else {
                                    try {
                                        objectArray = this.parseHexDigits((byte[])object);
                                        if (objectArray != null) {
                                            double[] dArray = WKBGeometryParser.parse((byte[])objectArray);
                                            argument = new Argument((int)dArray[0], dArray);
                                            break block37;
                                        }
                                        argument = new Argument(1, new String((byte[])object));
                                    }
                                    catch (MapyrusException mapyrusException) {
                                        argument = new Argument(1, new String((byte[])object));
                                    }
                                }
                            } else if (this.mFieldTypes[i] == 2002) {
                                object = this.mResultSet.getObject(i + 1);
                                argument = object == null ? Argument.emptyString : OracleGeometry.parseGeometry(object);
                            } else {
                                throw new MapyrusException(MapyrusMessages.get("unknownfieldtype") + ": " + this.mFieldTypes[i]);
                            }
                        }
                        row.add(argument);
                    }
                    break block38;
                }
                row = null;
            }
            catch (SQLException sQLException) {
                String string = sQLException.getSQLState();
                string = string != null ? ": " + string : "";
                throw new MapyrusException(sQLException.getErrorCode() + ": " + sQLException.getMessage() + string + ": " + this.mSql);
            }
        }
        return row;
    }

    private byte[] parseHexDigits(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length / 2];
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            int n2 = byArray[i];
            if (n2 >= 48 && n2 <= 57) {
                n2 -= 48;
            } else if (n2 >= 65 && n2 <= 70) {
                n2 = n2 - 65 + 10;
            } else if (n2 >= 97 && n2 <= 102) {
                n2 = n2 - 97 + 10;
            } else {
                return null;
            }
            if (i % 2 != 0) {
                byArray2[i / 2] = (byte)(n << 4 | n2);
            }
            n = n2;
        }
        return byArray2;
    }

    private void close(boolean bl) throws MapyrusException {
        try {
            if (this.mStatement != null) {
                this.mStatement.close();
            }
        }
        catch (SQLException sQLException) {
            String string = sQLException.getSQLState();
            string = string != null ? ": " + string : "";
            throw new MapyrusException(sQLException.getErrorCode() + ": " + sQLException.getMessage() + string);
        }
        finally {
            if (this.mConnection != null) {
                ConnectionPool.put(this.mUrl, this.mConnection, bl);
            }
            this.mConnection = null;
            this.mStatement = null;
        }
    }

    public void close() throws MapyrusException {
        this.close(true);
    }
}

