/*
 * Decompiled with CFR 0.152.
 */
package org.mapyrus.font;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.mapyrus.Constants;
import org.mapyrus.MapyrusException;
import org.mapyrus.MapyrusMessages;

public class PostScriptFont {
    private static final int LINE_LENGTH = 30;
    private String mFontName;
    private StringBuffer mFileContents;

    public PostScriptFont(String string, boolean bl) throws IOException, MapyrusException {
        if (bl) {
            if (!string.toLowerCase().endsWith(".pfb")) {
                throw new MapyrusException(MapyrusMessages.get("notapfbfile") + ": " + string);
            }
        } else if (!string.toLowerCase().endsWith(".pfa")) {
            throw new MapyrusException(MapyrusMessages.get("notapfafile") + ": " + string);
        }
        if (bl) {
            this.readPfbFile(string);
        } else {
            this.readPfaFile(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readPfbFile(String string) throws IOException, MapyrusException {
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
            byte[] byArray = new byte[2];
            byte[] byArray2 = new byte[4];
            ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
            int n = 0;
            if (bufferedInputStream.read(byArray) != byArray.length) {
                throw new IOException(MapyrusMessages.get("unexpectedeof") + ": " + string);
            }
            while (byArray[1] != 3) {
                if (byArray[0] != -128) {
                    throw new MapyrusException(MapyrusMessages.get("notapfbfile") + ": " + string);
                }
                if (bufferedInputStream.read(byArray2) != byArray2.length) {
                    throw new IOException(MapyrusMessages.get("unexpectedeof") + ": " + string);
                }
                int n2 = ByteBuffer.wrap(byArray2).order(ByteOrder.LITTLE_ENDIAN).getInt();
                n += n2;
                byte[] byArray3 = new byte[n2];
                if (bufferedInputStream.read(byArray3) != byArray3.length) {
                    throw new IOException(MapyrusMessages.get("unexpectedeof") + ": " + string);
                }
                arrayList.add(byArray3);
                if (bufferedInputStream.read(byArray) == byArray.length) continue;
                throw new IOException(MapyrusMessages.get("unexpectedeof") + ": " + string);
            }
            if (arrayList.size() < 3) {
                throw new MapyrusException(MapyrusMessages.get("notapfbfile") + ": " + string);
            }
            this.mFileContents = new StringBuffer(131072);
            this.mFileContents.append("<< /Type /FontFile /Length ");
            long l = n * 2 + Constants.LINE_SEPARATOR.length();
            this.mFileContents.append(l += (long)(n / 30 * Constants.LINE_SEPARATOR.length()));
            this.mFileContents.append(Constants.LINE_SEPARATOR);
            this.mFileContents.append("/Length1 ");
            this.mFileContents.append(((byte[])arrayList.get(0)).length);
            this.mFileContents.append(" /Length2 ");
            this.mFileContents.append(((byte[])arrayList.get(1)).length);
            this.mFileContents.append(" /Length3 ");
            this.mFileContents.append(((byte[])arrayList.get(2)).length);
            this.mFileContents.append(" /Filter /ASCIIHexDecode >>");
            this.mFileContents.append(Constants.LINE_SEPARATOR);
            this.mFileContents.append("stream");
            this.mFileContents.append(Constants.LINE_SEPARATOR);
            StringBuffer stringBuffer = new StringBuffer();
            int n3 = 0;
            for (int i = 0; i < arrayList.size(); ++i) {
                boolean bl = true;
                byte[] byArray4 = (byte[])arrayList.get(i);
                for (int j = 0; j < byArray4.length; ++j) {
                    String string2;
                    if (i == 0 && bl) {
                        if (byArray4[j] == 13 || byArray4[j] == 10) {
                            bl = false;
                            this.mFontName = this.parseFontName(stringBuffer.toString());
                            if (this.mFontName == null) {
                                throw new MapyrusException(MapyrusMessages.get("notapfafile") + ": " + string);
                            }
                        } else {
                            stringBuffer.append((char)byArray4[j]);
                        }
                    }
                    if ((string2 = Integer.toHexString(byArray4[j] & 0xFF)).length() < 2) {
                        this.mFileContents.append('0');
                    }
                    this.mFileContents.append(string2);
                    if (++n3 % 30 != 0) continue;
                    this.mFileContents.append(Constants.LINE_SEPARATOR);
                }
            }
            this.mFileContents.append(Constants.LINE_SEPARATOR);
            this.mFileContents.append("endstream");
        }
        finally {
            try {
                if (bufferedInputStream != null) {
                    bufferedInputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readPfaFile(String string) throws IOException, MapyrusException {
        BufferedReader bufferedReader = null;
        try {
            String string2;
            bufferedReader = new BufferedReader(new FileReader(string));
            String string3 = bufferedReader.readLine();
            if (string3 == null) {
                throw new MapyrusException(MapyrusMessages.get("notapfafile") + ": " + string);
            }
            this.mFontName = this.parseFontName(string3);
            if (this.mFontName == null) {
                throw new MapyrusException(MapyrusMessages.get("notapfafile") + ": " + string);
            }
            this.mFileContents = new StringBuffer(131072);
            this.mFileContents.append(string3);
            this.mFileContents.append(Constants.LINE_SEPARATOR);
            while ((string2 = bufferedReader.readLine()) != null) {
                this.mFileContents.append(string2);
                this.mFileContents.append(Constants.LINE_SEPARATOR);
            }
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
    }

    private String parseFontName(String string) {
        String string2 = null;
        String string3 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        if (stringTokenizer.countTokens() > 1 && (string3 = stringTokenizer.nextToken()).startsWith("%!PS-AdobeFont")) {
            string2 = stringTokenizer.nextToken();
        }
        return string2;
    }

    public String getName() {
        return this.mFontName;
    }

    public String toString() {
        return "PostScript Font " + this.mFontName;
    }

    public String getFontDefinition() {
        return this.mFileContents.toString();
    }
}

