/*
 * Decompiled with CFR 0.152.
 */
package org.mapyrus.dataset;

import java.awt.geom.Rectangle2D;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.mapyrus.Argument;
import org.mapyrus.DefaultFieldNames;
import org.mapyrus.FileOrURL;
import org.mapyrus.MapyrusException;
import org.mapyrus.MapyrusMessages;
import org.mapyrus.Row;
import org.mapyrus.dataset.GeographicDataset;

public class GrassDataset
implements GeographicDataset {
    private String mFilename;
    private Hashtable<String, String> mMetadata;
    private String[] mFieldNames;
    private Rectangle2D.Double mExtents;
    private boolean mIsThreed;
    private ArrayList<Row> mAllRows;
    int mRowFetchIndex;
    private StringBuffer mAttributeBuffer;

    private String readLine(LineNumberReader lineNumberReader) throws IOException {
        String string;
        while ((string = lineNumberReader.readLine()) != null && string.length() > 0 && string.charAt(0) == '#') {
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GrassDataset(String string, String string2) throws FileNotFoundException, IOException, MapyrusException {
        BufferedReader bufferedReader = null;
        try {
            Row row;
            FileOrURL fileOrURL = new FileOrURL(string);
            bufferedReader = fileOrURL.getReader();
            this.mFilename = string;
            this.mMetadata = new Hashtable();
            this.mAttributeBuffer = new StringBuffer();
            this.mRowFetchIndex = 0;
            String string3 = this.readLine((LineNumberReader)bufferedReader);
            while (string3 != null && string3.length() > 0 && Character.isLetter(string3.charAt(0))) {
                StringTokenizer stringTokenizer = new StringTokenizer(string3, "|");
                if (stringTokenizer.countTokens() > 1) {
                    String string4 = stringTokenizer.nextToken();
                    String string5 = stringTokenizer.nextToken();
                    this.mMetadata.put(string4, string5);
                }
                string3 = this.readLine((LineNumberReader)bufferedReader);
            }
            if (string3 == null || string3.length() == 0) {
                throw new MapyrusException(MapyrusMessages.get("invalidgrassfile") + ": " + string);
            }
            int n = 0;
            int n2 = 0;
            char c = string3.charAt(n2++);
            while (Character.isDigit(c) || c == '.' || c == ':' || c == '-' || c == 'N' || c == 'S' || c == 'E' || c == 'W' || c == '|') {
                if (c == '|') {
                    ++n;
                }
                if (++n2 == string3.length()) break;
                c = string3.charAt(n2);
            }
            this.mIsThreed = n > 2;
            double d = 3.4028234663852886E38;
            double d2 = 3.4028234663852886E38;
            double d3 = 1.4E-45f;
            double d4 = 1.4E-45f;
            this.mAllRows = new ArrayList();
            do {
                row = this.parseRow((LineNumberReader)bufferedReader, string3);
                this.mAllRows.add(row);
                Argument argument = (Argument)row.get(0);
                double[] dArray = argument.getGeometryValue();
                double d5 = dArray[3];
                double d6 = dArray[4];
                if (d5 < d) {
                    d = d5;
                }
                if (d5 > d3) {
                    d3 = d5;
                }
                if (d6 < d2) {
                    d2 = d6;
                }
                if (!(d6 > d4)) continue;
                d4 = d6;
            } while ((string3 = this.readLine((LineNumberReader)bufferedReader)) != null);
            this.mExtents = new Rectangle2D.Double(d, d2, d3 - d, d4 - d2);
            this.mFieldNames = new String[row.size()];
            int n3 = 0;
            int n4 = 1;
            this.mFieldNames[n3++] = "GEOMETRY";
            if (this.mIsThreed) {
                this.mFieldNames[n3++] = "Z";
            }
            while (n3 < this.mFieldNames.length) {
                this.mFieldNames[n3++] = DefaultFieldNames.get(n4++);
            }
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
    }

    public String getProjection() {
        return "";
    }

    public Hashtable getMetadata() {
        return this.mMetadata;
    }

    public String[] getFieldNames() {
        return this.mFieldNames;
    }

    public Rectangle2D.Double getWorlds() {
        return this.mExtents;
    }

    private double parseDMS(String string) {
        double d;
        int n = string.length();
        char c = string.charAt(n - 1);
        if (c == 'N' || c == 'E' || c == 'S' || c == 'W') {
            int n2 = string.indexOf(58);
            String string2 = string.substring(0, n2);
            int n3 = string.indexOf(58, n2 + 1);
            String string3 = string.substring(n2, n3 - n2);
            String string4 = string.substring(n3 + 1, n - n3);
            d = Double.parseDouble(string2) + Double.parseDouble(string3) / 60.0 + Double.parseDouble(string4) / 3600.0;
            if (c == 'S' || c == 'W') {
                d = -d;
            }
        } else {
            d = Double.parseDouble(string);
        }
        return d;
    }

    private Row parseRow(LineNumberReader lineNumberReader, String string) throws MapyrusException {
        Row row = new Row();
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        int n4 = string.indexOf(124);
        if (n4 >= 0) {
            n2 = string.indexOf(124, n4 + 1);
            if (this.mIsThreed && n2 >= 0) {
                n3 = string.indexOf(124, n2 + 1);
            }
        }
        if (n4 < 0 || n2 < 0 || n3 < 0) {
            throw new MapyrusException(MapyrusMessages.get("invalidgrassfile") + ": " + this.mFilename + ":" + lineNumberReader.getLineNumber() + ": " + string);
        }
        try {
            int n5;
            String string2 = string.substring(0, n4);
            double d = this.parseDMS(string2);
            String string3 = string.substring(n4 + 1, n2);
            double d2 = this.parseDMS(string3);
            double[] dArray = new double[]{100.0, 1.0, 0.0, d, d2};
            row.add(new Argument(100, dArray));
            if (this.mIsThreed) {
                String string4 = string.substring(n2 + 1, n3);
                double d3 = this.parseDMS(string4);
                row.add(new Argument(d3));
                n5 = n3 + 1;
            } else {
                n5 = n2 + 1;
            }
            while (n5 < n) {
                boolean bl;
                this.mAttributeBuffer.setLength(0);
                char c = string.charAt(n5);
                ++n5;
                if (c == '#' || c == '%' || Character.isDigit(c)) {
                    if (Character.isDigit(c)) {
                        this.mAttributeBuffer.append(c);
                    }
                    while (n5 < n) {
                        char c2 = string.charAt(n5);
                        ++n5;
                        if (Character.isWhitespace(c2)) break;
                        this.mAttributeBuffer.append(c2);
                    }
                    row.add(new Argument(Double.parseDouble(this.mAttributeBuffer.toString())));
                    continue;
                }
                if (c != '@') continue;
                char c3 = string.charAt(n5);
                boolean bl2 = bl = c3 == '\"';
                if (bl) {
                    ++n5;
                    int n6 = 0;
                    while (n5 < n) {
                        c3 = string.charAt(n5);
                        ++n5;
                        if (c3 == '\"') {
                            if (n6 != 92) break;
                            this.mAttributeBuffer.deleteCharAt(this.mAttributeBuffer.length() - 1);
                        }
                        this.mAttributeBuffer.append(c3);
                    }
                } else {
                    while (n5 < n) {
                        c3 = string.charAt(n5);
                        ++n5;
                        if (!Character.isWhitespace(c3)) {
                            this.mAttributeBuffer.append(c3);
                            continue;
                        }
                        break;
                    }
                }
                row.add(new Argument(1, this.mAttributeBuffer.toString()));
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new MapyrusException(MapyrusMessages.get("invalidgrassfile") + ": " + this.mFilename + ":" + lineNumberReader.getLineNumber() + ": " + string);
        }
        return row;
    }

    public Row fetch() throws MapyrusException {
        Row row = this.mRowFetchIndex < this.mAllRows.size() ? this.mAllRows.get(this.mRowFetchIndex++) : null;
        return row;
    }

    public void close() throws MapyrusException {
        this.mAllRows = null;
    }
}

