/*
 * Decompiled with CFR 0.152.
 */
package org.mapyrus;

import java.util.ArrayList;
import java.util.HashMap;
import org.mapyrus.Expression;

public class Statement {
    public static final int CONDITIONAL = 2;
    public static final int REPEAT_LOOP = 3;
    public static final int WHILE_LOOP = 4;
    public static final int FOR_LOOP = 5;
    public static final int BLOCK = 6;
    public static final int COLOR = 9;
    public static final int BLEND = 10;
    public static final int LINESTYLE = 11;
    public static final int FONT = 12;
    public static final int JUSTIFY = 13;
    public static final int MOVE = 14;
    public static final int DRAW = 15;
    public static final int RDRAW = 16;
    public static final int ARC = 17;
    public static final int CIRCLE = 18;
    public static final int ELLIPSE = 19;
    public static final int CYLINDER = 20;
    public static final int RAINDROP = 21;
    public static final int BEZIER = 22;
    public static final int SINEWAVE = 23;
    public static final int WEDGE = 24;
    public static final int SPIRAL = 25;
    public static final int BOX = 26;
    public static final int ROUNDEDBOX = 27;
    public static final int BOX3D = 28;
    public static final int CHESSBOARD = 29;
    public static final int HEXAGON = 30;
    public static final int PENTAGON = 31;
    public static final int TRIANGLE = 32;
    public static final int STAR = 33;
    public static final int ADDPATH = 34;
    public static final int CLEARPATH = 35;
    public static final int CLOSEPATH = 36;
    public static final int SAMPLEPATH = 37;
    public static final int STRIPEPATH = 38;
    public static final int SHIFTPATH = 39;
    public static final int PARALLELPATH = 40;
    public static final int SELECTPATH = 41;
    public static final int REVERSEPATH = 42;
    public static final int SINKHOLE = 43;
    public static final int GUILLOTINE = 44;
    public static final int STROKE = 45;
    public static final int FILL = 46;
    public static final int GRADIENTFILL = 47;
    public static final int EVENTSCRIPT = 48;
    public static final int PROTECT = 49;
    public static final int UNPROTECT = 50;
    public static final int CLIP = 51;
    public static final int LABEL = 52;
    public static final int FLOWLABEL = 53;
    public static final int TABLE = 54;
    public static final int TREE = 55;
    public static final int ICON = 56;
    public static final int GEOIMAGE = 57;
    public static final int EPS = 58;
    public static final int SVG = 59;
    public static final int SVGCODE = 60;
    public static final int PDF = 61;
    public static final int SCALE = 62;
    public static final int ROTATE = 63;
    public static final int WORLDS = 64;
    public static final int DATASET = 65;
    public static final int FETCH = 66;
    public static final int NEWPAGE = 67;
    public static final int ENDPAGE = 68;
    public static final int SETOUTPUT = 69;
    public static final int PRINT = 70;
    public static final int LOCAL = 71;
    public static final int LET = 72;
    public static final int EVAL = 73;
    public static final int KEY = 74;
    public static final int LEGEND = 75;
    public static final int MIMETYPE = 76;
    public static final int HTTPRESPONSE = 77;
    public static final int CALL = 1000;
    public static final int RETURN = 1001;
    private int mType;
    private ArrayList mThenStatements;
    private ArrayList mElseStatements;
    private ArrayList mLoopStatements;
    private String mBlockName;
    private ArrayList mStatementBlock;
    private ArrayList mParameters;
    private Expression[] mExpressions;
    private Expression mForHashMapExpression;
    private String mFilename;
    private int mLineNumber;
    private static HashMap<String, Integer> mStatementTypeLookup = new HashMap(100);

    private int getStatementType(String string) {
        Integer n = mStatementTypeLookup.get(string.toLowerCase());
        int n2 = n == null ? 1000 : n;
        return n2;
    }

    public Statement(String string, Expression[] expressionArray) {
        this.mType = this.getStatementType(string);
        if (this.mType == 1000) {
            this.mBlockName = string;
        }
        this.mExpressions = expressionArray;
    }

    public Statement(String string, ArrayList arrayList, ArrayList arrayList2) {
        this.mBlockName = string;
        this.mParameters = arrayList;
        this.mStatementBlock = arrayList2;
        this.mType = 6;
    }

    public Statement(Expression expression, ArrayList arrayList, ArrayList arrayList2) {
        this.mType = 2;
        this.mExpressions = new Expression[1];
        this.mExpressions[0] = expression;
        this.mThenStatements = arrayList;
        this.mElseStatements = arrayList2;
    }

    public Statement(Expression expression, ArrayList arrayList, boolean bl) {
        this.mType = bl ? 4 : 3;
        this.mExpressions = new Expression[1];
        this.mExpressions[0] = expression;
        this.mLoopStatements = arrayList;
    }

    public Statement(Expression expression, Expression expression2, ArrayList arrayList) {
        this.mType = 5;
        this.mExpressions = new Expression[1];
        this.mExpressions[0] = expression;
        this.mForHashMapExpression = expression2;
        this.mLoopStatements = arrayList;
    }

    public void setFilenameAndLineNumber(String string, int n) {
        this.mFilename = string;
        this.mLineNumber = n;
    }

    public String getFilenameAndLineNumber() {
        return this.mFilename + ":" + this.mLineNumber;
    }

    public String getFilename() {
        return this.mFilename;
    }

    public int getType() {
        return this.mType;
    }

    public Expression[] getExpressions() {
        return this.mExpressions;
    }

    public ArrayList getThenStatements() {
        return this.mThenStatements;
    }

    public ArrayList getElseStatements() {
        return this.mElseStatements;
    }

    public ArrayList getLoopStatements() {
        return this.mLoopStatements;
    }

    public Expression getForHashMap() {
        return this.mForHashMapExpression;
    }

    public String getBlockName() {
        return this.mBlockName;
    }

    public ArrayList getBlockParameters() {
        return this.mParameters;
    }

    public ArrayList getStatementBlock() {
        return this.mStatementBlock;
    }

    static {
        mStatementTypeLookup.put("color", 9);
        mStatementTypeLookup.put("colour", 9);
        mStatementTypeLookup.put("blend", 10);
        mStatementTypeLookup.put("linestyle", 11);
        mStatementTypeLookup.put("font", 12);
        mStatementTypeLookup.put("justify", 13);
        mStatementTypeLookup.put("move", 14);
        mStatementTypeLookup.put("draw", 15);
        mStatementTypeLookup.put("rdraw", 16);
        mStatementTypeLookup.put("arc", 17);
        mStatementTypeLookup.put("circle", 18);
        mStatementTypeLookup.put("ellipse", 19);
        mStatementTypeLookup.put("cylinder", 20);
        mStatementTypeLookup.put("raindrop", 21);
        mStatementTypeLookup.put("bezier", 22);
        mStatementTypeLookup.put("sinewave", 23);
        mStatementTypeLookup.put("wedge", 24);
        mStatementTypeLookup.put("spiral", 25);
        mStatementTypeLookup.put("box", 26);
        mStatementTypeLookup.put("roundedbox", 27);
        mStatementTypeLookup.put("box3d", 28);
        mStatementTypeLookup.put("chessboard", 29);
        mStatementTypeLookup.put("hexagon", 30);
        mStatementTypeLookup.put("pentagon", 31);
        mStatementTypeLookup.put("triangle", 32);
        mStatementTypeLookup.put("star", 33);
        mStatementTypeLookup.put("addpath", 34);
        mStatementTypeLookup.put("clearpath", 35);
        mStatementTypeLookup.put("closepath", 36);
        mStatementTypeLookup.put("samplepath", 37);
        mStatementTypeLookup.put("stripepath", 38);
        mStatementTypeLookup.put("shiftpath", 39);
        mStatementTypeLookup.put("parallelpath", 40);
        mStatementTypeLookup.put("selectpath", 41);
        mStatementTypeLookup.put("reversepath", 42);
        mStatementTypeLookup.put("sinkhole", 43);
        mStatementTypeLookup.put("guillotine", 44);
        mStatementTypeLookup.put("stroke", 45);
        mStatementTypeLookup.put("fill", 46);
        mStatementTypeLookup.put("gradientfill", 47);
        mStatementTypeLookup.put("eventscript", 48);
        mStatementTypeLookup.put("protect", 49);
        mStatementTypeLookup.put("unprotect", 50);
        mStatementTypeLookup.put("clip", 51);
        mStatementTypeLookup.put("label", 52);
        mStatementTypeLookup.put("flowlabel", 53);
        mStatementTypeLookup.put("table", 54);
        mStatementTypeLookup.put("tree", 55);
        mStatementTypeLookup.put("icon", 56);
        mStatementTypeLookup.put("geoimage", 57);
        mStatementTypeLookup.put("eps", 58);
        mStatementTypeLookup.put("svg", 59);
        mStatementTypeLookup.put("svgcode", 60);
        mStatementTypeLookup.put("pdf", 61);
        mStatementTypeLookup.put("scale", 62);
        mStatementTypeLookup.put("rotate", 63);
        mStatementTypeLookup.put("worlds", 64);
        mStatementTypeLookup.put("dataset", 65);
        mStatementTypeLookup.put("fetch", 66);
        mStatementTypeLookup.put("newpage", 67);
        mStatementTypeLookup.put("endpage", 68);
        mStatementTypeLookup.put("setoutput", 69);
        mStatementTypeLookup.put("print", 70);
        mStatementTypeLookup.put("local", 71);
        mStatementTypeLookup.put("let", 72);
        mStatementTypeLookup.put("eval", 73);
        mStatementTypeLookup.put("key", 74);
        mStatementTypeLookup.put("legend", 75);
        mStatementTypeLookup.put("mimetype", 76);
        mStatementTypeLookup.put("httpresponse", 77);
        mStatementTypeLookup.put("return", 1001);
    }
}

