<?php
/**
* @package Mambo Open Source
* @copyright (C) 2005 - 2006 Mambo Foundation Inc.
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
*
* Mambo was originally developed by Miro (www.miro.com.au) in 2000. Miro assigned the copyright in Mambo to The Mambo Foundation in 2005 to ensure
* that Mambo remained free Open Source software owned and managed by the community.
* Mambo is Free Software
*/

/** Set flag that this is a parent file */
if (!defined('_VALID_MOS')) define( '_VALID_MOS', 1 );

$protects = array('_REQUEST', '_GET', '_POST', '_COOKIE', '_FILES', '_SERVER', '_ENV', 'GLOBALS', '_SESSION');

foreach ($protects as $protect) {
    if ( in_array($protect , array_keys($_REQUEST)) ||
    in_array($protect , array_keys($_GET)) ||
    in_array($protect , array_keys($_POST)) ||
    in_array($protect , array_keys($_COOKIE)) ||
    in_array($protect , array_keys($_FILES))) {
        die("Invalid Request.");
    }
}

/**
* Utility function to return a value from a named array or a specified default
*/
define( "_MOS_NOTRIM", 0x0001 );
define( "_MOS_ALLOWHTML", 0x0002 );
define( "_MOS_ALLOWRAW", 0x0004 );
define( "_MOS_NOMAGIC", 0x0008 );
function mosGetParam( &$arr, $name, $def=null, $mask=0 ) {
    if (isset( $arr[$name] )) {
        if (is_array($arr[$name])) foreach ($arr[$name] as $key=>$element) $result[$key] = mosGetParam ($arr[$name], $key, $def, $mask);
        else {
            $result = $arr[$name];
            if (!($mask&_MOS_NOTRIM)) $result = trim($result);
            if (!is_numeric( $result)) {
                if (!($mask&_MOS_ALLOWHTML)) $result = strip_tags($result);
                if (!($mask&_MOS_ALLOWRAW)) {
                    if (is_numeric($def)) $result = intval($result);
                }
            }
            if (!get_magic_quotes_gpc()) {
                $return = addslashes( $return );
            }
        }
        return $result;
    } else {
        return $def;
    }
}

function sefRelToAbs ($string) {
    $sef =& mosSEF::getInstance();
    return $sef->sefRelToAbs($string);
}

if (!isset($adminside)) $adminside = 0;
if (!isset($indextype)) $indextype = 1;

require_once (dirname(__FILE__).'/includes/database.php');
require_once(dirname(__FILE__).'/includes/core.classes.php');
$configuration =& mamboCore::getMamboCore();
$configuration->handleGlobals();


require($configuration->rootPath().'/includes/version.php');
$_VERSION =& new version();


$version = $_VERSION->PRODUCT .' '. $_VERSION->RELEASE .'.'. $_VERSION->DEV_LEVEL .' '
. $_VERSION->DEV_STATUS
.' [ '.$_VERSION->CODENAME .' ] '. $_VERSION->RELDATE .' '
. $_VERSION->RELTIME .' '. $_VERSION->RELTZ;

if (phpversion() < '4.2.0') require_once( $configuration->rootPath() . '/includes/compat.php41x.php' );
if (phpversion() < '4.3.0') require_once( $configuration->rootPath() . '/includes/compat.php42x.php' );
if (phpversion() < '5.0.0') require_once( $configuration->rootPath() . '/includes/compat.php5xx.php' );

$local_backup_path = $configuration->rootPath().'/administrator/backups';
$media_path = $configuration->rootPath().'/media/';
$image_path = $configuration->rootPath().'/images/stories';
$lang_path = $configuration->rootPath().'/language';
$image_size = 100;

$database =& mamboDatabase::getInstance();
$database->debug(mamboCore::get('mosConfig_debug'));


if (!$adminside) {
    $sefcode = $configuration->rootPath().'/components/com_sef/sef.php';
    if (file_exists($sefcode)) require_once($sefcode);
    else require_once($configuration->rootPath().'/includes/sef.php');
    $urlerror = 0;
    if (mamboCore::get('mosConfig_sef') AND $indextype == 3) {
        $sef =& mosSEF::getInstance();
        $urlerror = $sef->sefRetrieval(mamboCore::get('mosConfig_register_globals'));
        $indextype = 1;
    }
}

/** retrieve some possible request string (or form) arguments */
$type = mosGetParam($_REQUEST, 'type', 1);
$act = mosGetParam( $_REQUEST, 'act', '' );
$do_pdf = mosGetParam( $_REQUEST, 'do_pdf', 0 );
$id = mosGetParam( $_REQUEST, 'id', 0 );
$task = mosGetParam($_REQUEST, 'task', '');
$act = strtolower(mosGetParam($_REQUEST, 'act', ''));
$section = mosGetParam($_REQUEST, 'section', '');
$no_html = strtolower(mosGetParam($_REQUEST, 'no_html', ''));
$cid = (array) mosGetParam( $_POST, 'cid', array() );

ini_set('session.use_trans_sid', 0);
ini_set('session.use_cookies', 1);
ini_set('session.use_only_cookies', 1);


/* initialize i18n */
$lang       = $configuration->current_language->name;
$charset    = $configuration->current_language->charset;
$gettext =& phpgettext();
$gettext->debug       = $configuration->mosConfig_locale_debug;
$gettext->has_gettext = $configuration->mosConfig_locale_use_gettext;
$gettext->setlocale($lang);
$gettext->bindtextdomain($lang, $configuration->rootPath().'/language');
$gettext->textdomain($lang);
#$gettext =& phpgettext(); dump($gettext);

if ($adminside) {
    // Start ACL
    require_once($configuration->rootPath().'/includes/gacl.class.php' );
    require_once($configuration->rootPath().'/includes/gacl_api.class.php' );
    $acl = new gacl_api();
    // Handle special admin side options
    $option = strtolower(mosGetParam($_REQUEST,'option','com_admin'));

    $domain = substr($option, 4);
    session_name(md5(mamboCore::get('mosConfig_live_site')));
    session_start();
    // restore some session variables
    $my = new mosUser();
    $my->getSession();
    if (mosSession::validate($my)) {
        mosSession::purge();
    } else {
        mosSession::purge();
        $my = null;
    }
    if (!$my AND $option == 'login') {
        require_once($configuration->rootPath().'/includes/authenticator.php');
        $authenticator =& mamboAuthenticator::getInstance();
        $my = $authenticator->loginAdmin($acl);
    }
    // Handle the remaining special options
    elseif ($option == 'logout') {
        require($configuration->rootPath().'/administrator/logout.php');
        exit();
    }
    // We can now create the mainframe object
    $mainframe =& new mosMainFrame($database, $option, '..', true);
    // Provided $my is set, we have a valid admin side session and can include remaining code
    if ($my) {
        mamboCore::set('currentUser', $my);
        if ($option == 'simple_mode') $admin_mode = 'on';
        elseif ($option == 'advanced_mode') $admin_mode = 'off';
        else $admin_mode = mosGetParam($_SESSION, 'simple_editing', '');
        $_SESSION['simple_editing'] = mosGetParam($_POST, 'simple_editing', $admin_mode);
        require_once($configuration->rootPath().'/administrator/includes/admin.php');
        require_once( $configuration->rootPath().'/includes/mambo.php' );
        require_once ($configuration->rootPath().'/includes/mambofunc.php');
        require_once ($configuration->rootPath().'/includes/mamboHTML.php');
        require_once( $configuration->rootPath().'/administrator/includes/mosAdminMenus.php');
        require_once($configuration->rootPath().'/administrator/includes/admin.php');
        require_once( $configuration->rootPath() . '/includes/cmtclasses.php' );
        require_once( $configuration->rootPath() . '/components/com_content/content.class.php' );
        $_MAMBOTS =& mosMambotHandler::getInstance();


        // If no_html is set, we avoid starting the template, and go straight to the component
        if ($no_html) {
            if ($path = $mainframe->getPath( "admin" )) require $path;
            exit();
        }
        $configuration->initGzip();
        // When adminside = 3 we assume that HTML is being explicitly written and do nothing more
        if ($adminside != 3) {
            $path = $configuration->rootPath().'/administrator/templates/'.$mainframe->getTemplate().'/index.php';
            require_once($path);
            $configuration->doGzip();
        }
        else {
            if (!isset($popup)) {
                $pop = mosGetParam($_REQUEST, 'pop', '');
                if ($pop) require($configuration->rootPath()."/administrator/popups/$pop");
                else require($configuration->rootPath()."/administrator/popups/index3pop.php");
                $configuration->doGzip();
            }
        }
    }
    // If $my was not set, the only possibility is to offer a login screen
    else {
        $configuration->initGzip();
        $path = $configuration->rootPath().'/administrator/templates/'.$mainframe->getTemplate().'/login.php';
        require_once( $path );
        $configuration->doGzip();
    }
}
// Finished admin side; the rest is user side code:
else {
    $option = $configuration->determineOptionAndItemid();
    $configuration->handleGlobals();
    $Itemid = $configuration->get('Itemid');

    $mainframe =& new mosMainFrame($database, $option, '.');
    if ($option == 'login') $configuration->handleLogin();
    elseif ($option == 'logout') $configuration->handleLogout();

    $session =& mosSession::getCurrent();
    $my =& new mosUser();
    $my->getSessionData();
    mamboCore::set('currentUser',$my);
    $configuration->offlineCheck($my, $database);
    $gid = intval( $my->gid );
    // gets template for page
    $cur_template = $mainframe->getTemplate();

    require_once( $configuration->rootPath().'/includes/frontend.php' );
    require_once( $configuration->rootPath().'/includes/mambo.php' );
    require_once ($configuration->rootPath().'/includes/mambofunc.php');
    require_once ($configuration->rootPath().'/includes/mamboHTML.php');

    if ($indextype == 2 AND $do_pdf == 1 ) {
        include_once('includes/pdf.php');
        exit();
    }

    /** detect first visit */
    $mainframe->detect();

    /** @global mosPlugin $_MAMBOTS */
    $_MAMBOTS =& mosMambotHandler::getInstance();
    require_once( $configuration->rootPath().'/editor/editor.php' );
    require_once( $configuration->rootPath() . '/includes/gacl.class.php' );
    require_once( $configuration->rootPath() . '/includes/gacl_api.class.php' );
    require_once( $configuration->rootPath() . '/components/com_content/content.class.php' );
    $acl = new gacl_api();

    /** Get the component handler */
    require_once( $configuration->rootPath() . '/includes/cmtclasses.php' );
    $c_handler =& mosComponentHandler::getInstance();
    $c_handler->startBuffer();

    if (!$urlerror AND $path = $mainframe->getPath( 'front' )) {
        $menuhandler =& mosMenuHandler::getInstance();
        $ret = $menuhandler->menuCheck($Itemid, $option, $task, $gid);
        $menuhandler->setPathway($Itemid);
        if ($ret) {
            require ($path);
        }
        else mosNotAuth();
    }
    else {
        header ('HTTP/1.1 404 Not Found');
        $mainframe->setPageTitle(T_('404 Error - page not found'));
        include ($configuration->rootPath().'/page404.php');
    }

    $c_handler->endBuffer();

    $configuration->initGzip();

    $configuration->standardHeaders();
    if (mosGetParam($_GET, 'syndstyle', '') == 'yes') mosMainBody();
    elseif ($indextype == 1) {
        // loads template file
        if ( !file_exists( 'templates/'. $cur_template .'/index.php' ) ) {
            echo '<font color=\"red\"><b>'.T_('Template File Not Found! Looking for template').'</b></font>'.$cur_template;
        } else {
            require_once( 'templates/'. $cur_template .'/index.php' );
            $mambothandler =& mosMambotHandler::getInstance();
            $mambothandler->loadBotGroup('system');
            $mambothandler->trigger('afterTemplate', array($configuration));
            echo "<!-- ".time()." -->";
        }
    }
    elseif ($indextype == 2) {
        if ( $no_html == 0 ) {
            // needed to seperate the ISO number from the language file constant _ISO
            $iso = split( '=', _ISO );
            // xml prolog
            echo '<?xml version="1.0" encoding="'. $iso[1] .'"?' .'>';
			?>
			<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
			<html xmlns="http://www.w3.org/1999/xhtml">
			<head>
			<link rel="stylesheet" href="templates/<?php echo $cur_template;?>/css/template_css.css" type="text/css" />
			<meta http-equiv="Content-Type" content="text/html; <?php echo _ISO; ?>" />
			<meta name="robots" content="noindex, nofollow">
			</head>
			<body class="contentpane">
			<?php mosMainBody(); ?>
			</body>
			</html>
			<?php
        } else {
            mosMainBody();
        }
    }

    $configuration->doGzip();
}
// displays queries performed for page
if ($configuration->get('mosConfig_debug') AND $adminside != 3) $database->displayLogged();

?>
