<?php
/**
* @package Mambo Open Source
* @copyright (C) 2005 - 2006 Mambo Foundation Inc.
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
*
* Mambo was originally developed by Miro (www.miro.com.au) in 2000. Miro assigned the copyright in Mambo to The Mambo Foundation in 2005 to ensure
* that Mambo remained free Open Source software owned and managed by the community.
* Mambo is Free Software
*/ 

/** ensure this file is being included by a parent file */
defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );

$query = "SELECT a.hits, a.id, a.sectionid, a.title, a.created, u.name"
. "\n FROM #__content AS a"
. "\n LEFT JOIN #__users AS u ON u.id=a.created_by"
. "\n WHERE a.state <> '-2'"
. "\n ORDER BY hits DESC"
. "\n LIMIT 10"
;
$database->setQuery( $query );
$rows = $database->loadObjectList();
?>

<table class="adminlist">
<tr>
	<th class="title">
	<?php echo T_('Most Popular Items'); ?>
	</th>
	<th class="title">
	<?php echo T_('Created'); ?>
	</th>
	<th class="title">
	<?php echo T_('Hits'); ?>
	</th>
</tr>
<?php
if ($rows) {
	foreach ($rows as $row) {
		if ( $row->sectionid == 0 ) {
			$link = 'index2.php?option=com_typedcontent&amp;task=edit&amp;hidemainmenu=1&amp;id='. $row->id;
		} else {
			$link = 'index2.php?option=com_content&amp;task=edit&amp;hidemainmenu=1&amp;id='. $row->id;
		}
		?>
		<tr>
			<td>
			<a href="<?php echo $link; ?>">
			<?php echo htmlspecialchars($row->title, ENT_QUOTES);?>
			</a>
			</td>
			<td>
			<?php echo $row->created;?>
			</td>
			<td>
			<?php echo $row->hits;?>
			</td>
		</tr>
		<?php
	}	
} else {
	?>
	<tr>
		<td colspan="3">Nothing to show</td>
	</tr>
	<?php
}
?>
</table>