<?php
class saveAction extends Action
{
    function execute(&$controller, &$request)
    {
        $iso639 = strtolower(mosGetParam($_POST, 'iso639'));
        $iso3166 = mosGetParam($_POST, 'iso3166_2');
        $lang  = $iso639;
        $lang .= strlen($iso3166) == 2 ? '_'.$iso3166 : '';
        $root = mamboCore::get('rootPath');
        $langfile = $root.'/language/'.$lang.'.xml';

        switch ($_POST['act'])
        {
            case 'language':
            if (file_exists($langfile)) {
                $this->updatelanguage($lang);
                return $controller->redirect('index', 'language');
            }
            else {
                $this->createlanguage($iso639, $iso3166);
                $request->set('task', 'edit');
                $request->set('act', 'language');
                $request->set('lang', $lang);
                return $controller->forward('edit');
            }
            break;

            case 'catalogs':
            default:
            $this->updatecatalog();
            return $controller->redirect('index', 'catalogs');
            break;
        }
    }



    function createLanguage($iso639, $iso3166) {
        $locales = mamboLanguage::getLocales();
        $default = $locales['locales'][$iso639];
        $lang  = $iso639;
        $lang .= strlen($iso3166) == 2 ? '_'.$iso3166 : '';
        $language =& new mamboLanguage($lang);
        foreach ($default as $k => $v) {
            if (in_array($k, array_keys(get_class_vars(get_class($language))))) {
                $language->$k = $v;
            }
        }
        foreach ($_POST as $k => $v) {
            if (in_array($k, array_keys(get_class_vars(get_class($language))))) {
                $language->$k = $v;
            }
        }
        $language->name = $lang;
        $language->description = $language->title.' Locale';
        if (!empty($language->territory)) $language->description .= ' For '.$language->territory;
        $language->locale = $lang.'.'.$language->charset.','.$lang.','.$iso639.','.strtolower($language->title);
        $language->creationdate = date('d-m-Y');
        $language->author = 'Mambo Foundation Inc.';
        $language->authorurl = 'http://www.mambo-foundation.org';
        $language->authoremail = 'translation@mambo-foundation.org';
        $language->copyright = '(C) 2005 - 2006 Mambo Foundation Inc.';
        $language->license = 'http://www.gnu.org/copyleft/gpl.html GNU/GPL';
        $language->setPlurals($_POST['plural_form']);

        $textdomain = rtrim($language->path, '\/');
        $dir = $textdomain.'/'.$language->name;
        $untranslated = $textdomain.'/untranslated';
        $charset = $language->charset;
        $langfiles  = mosReadDirectory($untranslated,'.pot$');
        @mkdir($dir);
        @mkdir($dir.'/LC_MESSAGES');

        $gettext_admin = new PHPGettextAdmin();
        foreach ($langfiles as $domain)  {
            $domain = substr($domain,0,-4);
            if (file_exists("$textdomain/glossary/$lang.$charset.po")) {
                copy("$textdomain/glossary/$lang.$charset.po", "$dir/$lang.po");
                $gettext_admin->initialize_translation($domain, $textdomain, $lang, $charset);
                $gettext_admin->compile($lang, $textdomain, $charset);
            } else {
                copy("$untranslated/$domain.pot", "$dir/$domain.po");
            }
        }        
        if (!file_exists("$textdomain/$lang/$lang.po")) {
            @copy("$textdomain/glossary/untranslated.pot", "$textdomain/$lang/$lang.po");
        }
        $language->save();
    }
    
    function updatelanguage($lang)
    {

        $language =& new mamboLanguage($lang);
        $language->load();
        foreach ($_POST as $k => $v) {
            if (in_array($k, array_keys(get_class_vars(get_class($language))))) {
                $language->$k = $v;
            }
        }
        $language->setPlurals($_POST['plural_form']);
        $language->save();
    }

    function updatecatalog($compile = true, $add_to_dict = true)
    {

        $domain     = $_POST['domain'];
        $textdomain = $_POST['textdomain'];
        $lang       = $_POST['lang'];

        $catalog = new PHPGettext_catalog($domain, $textdomain);
        $catalog->setproperty('mode', 'po');
        $catalog->setproperty('lang', $lang);
        $catalog->load();

        $catalog->setComments($_POST['comments']);
        $catalog->setHeaders($_POST['headers']);

        foreach ($_POST as $key => $value) {
            if (preg_match('/^([a-z]+)[_]?([0-9]+)?_([0-9]+)$/', $key, $matches))  {
                switch ($matches[1])
                {
                    case 'msgid':
                    $messages[$matches[3]]['msgid'] = $value;
                    break;
                    case 'msgid_plural':
                    $messages[$matches[3]]['msgid_plural'] = $value;
                    break;
                    case 'msgstr':
                    if (!empty($messages[$matches[3]]['msgid_plural'])) {

                        if ($matches[2] != '') {
                            $messages[$matches[3]]['msgstr'][$matches[2]] =  stripslashes($value);
                        } else {
                            $messages[$matches[3]]['msgstr'][0] =  stripslashes($value);
                            $messages[$matches[3]]['msgstr'][1] =  '';
                        }
                    } else {
                        $messages[$matches[3]]['msgstr'] =  stripslashes($value);
                    }
                    break;
                    case 'fuzzy':
                    $messages[$matches[3]]['fuzzy'] = $value == 'true' ? true : false;
                    break;
                }
            }
        }
        foreach ($messages as $index => $arr) {
            if (strcmp($catalog->strings[$index]->msgid, $arr['msgid']) == 0) {
                $catalog->strings[$index]->setmsgstr($arr['msgstr']);
                if ($arr['fuzzy']) {
                    $catalog->strings[$index]->setfuzzy($arr['fuzzy']);
                }
            }
        }
        $catalog->save();


        $gettext_admin = new PHPGettextAdmin();
        $gettext_admin->add_to_dict($domain, $textdomain, $lang);
        $catalog->load();

        if ($compile) {
            $catalog->setproperty('mode', 'mo');
            $catalog->save();
        }
        $language = new mamboLanguage($lang);
        $language->save();
    }
}


?>