/*
 * Decompiled with CFR 0.152.
 */
package SevenZip;

import SevenZip.Compression.LZMA.Decoder;
import SevenZip.Compression.LZMA.Encoder;
import SevenZip.LzmaBench;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;

public class LzmaAlone {
    static void PrintHelp() {
        System.out.println("\nUsage:  LZMA <e|d|b> [<switches>...] inputFile outputFile\n  e: encode file\n  d: decode file\n  b: Benchmark\n<Switches>\n  -a{N}:  set compression mode - [0, 2], default: 2 (max)\n  -d{N}:  set dictionary - [0,28], default: 23 (8MB)\n  -fb{N}: set number of fast bytes - [5, 255], default: 128\n  -lc{N}: set number of literal context bits - [0, 8], default: 3\n  -lp{N}: set number of literal pos bits - [0, 4], default: 0\n  -pb{N}: set number of pos bits - [0, 4], default: 2\n  -mf{MF_ID}: set Match Finder: [bt2, bt4, bt4b, default: bt4\n  -eos:   write End Of Stream marker\n");
    }

    static int IncorrectCommand() throws Exception {
        throw new Exception("Command line error");
    }

    static int main2(String[] stringArray) throws Exception {
        Object object;
        int n;
        System.out.println("\nLZMA# 4.23 Copyright (c) 1999-2004 Igor Pavlov  2004-12-10");
        System.out.println("JAVA LZMA Encoder 4.23.1  myspace\n");
        if (stringArray.length < 1) {
            LzmaAlone.PrintHelp();
            return 0;
        }
        String string = stringArray[0].toLowerCase();
        boolean bl = false;
        int n2 = 0x200000;
        int n3 = 2;
        int n4 = 3;
        int n5 = 0;
        int n6 = 2;
        int n7 = 128;
        String string2 = "bt4";
        int n8 = 0;
        int n9 = 1;
        for (n = 1; n < stringArray.length; ++n) {
            object = stringArray[n].toUpperCase();
            if (((String)object).charAt(0) == '-') {
                if (((String)object).compareToIgnoreCase("--") == 0) {
                    n9 = n + 1;
                    break;
                }
                if (((String)object).equals("-H")) {
                    LzmaAlone.PrintHelp();
                    return 0;
                }
                if (((String)object).equals("-?")) {
                    LzmaAlone.PrintHelp();
                    return 0;
                }
                if (((String)object).startsWith("-A")) {
                    try {
                        n6 = Integer.parseInt(((String)object).substring(2));
                    }
                    catch (NumberFormatException numberFormatException) {
                        LzmaAlone.IncorrectCommand();
                    }
                    continue;
                }
                if (((String)object).startsWith("-D")) {
                    try {
                        n2 = 1 << Integer.parseInt(((String)object).substring(2));
                        bl = true;
                    }
                    catch (NumberFormatException numberFormatException) {
                        LzmaAlone.IncorrectCommand();
                    }
                    continue;
                }
                if (((String)object).startsWith("-FB")) {
                    try {
                        n7 = Integer.parseInt(((String)object).substring(3));
                    }
                    catch (NumberFormatException numberFormatException) {
                        LzmaAlone.IncorrectCommand();
                    }
                    continue;
                }
                if (((String)object).startsWith("-LC")) {
                    try {
                        n4 = Integer.parseInt(((String)object).substring(3));
                    }
                    catch (NumberFormatException numberFormatException) {
                        LzmaAlone.IncorrectCommand();
                    }
                    continue;
                }
                if (((String)object).startsWith("-LP")) {
                    try {
                        n5 = Integer.parseInt(((String)object).substring(3));
                    }
                    catch (NumberFormatException numberFormatException) {
                        LzmaAlone.IncorrectCommand();
                    }
                    continue;
                }
                if (((String)object).startsWith("-PB")) {
                    try {
                        n3 = Integer.parseInt(((String)object).substring(3));
                    }
                    catch (NumberFormatException numberFormatException) {
                        LzmaAlone.IncorrectCommand();
                    }
                    continue;
                }
                if (((String)object).startsWith("-MF")) {
                    string2 = ((String)object).substring(3);
                    string2 = string2.toLowerCase();
                    continue;
                }
                if (((String)object).equals("-EOS")) {
                    n8 = 1;
                    continue;
                }
                LzmaAlone.IncorrectCommand();
                continue;
            }
            n9 = n;
            break;
        }
        if (string.equals("b")) {
            int n10 = 10;
            if (n9 < stringArray.length) {
                try {
                    n10 = Integer.parseInt(stringArray[n9]);
                }
                catch (NumberFormatException numberFormatException) {
                    LzmaAlone.IncorrectCommand();
                }
            }
            return LzmaBench.LzmaBenchmark(n10, n2, string2.equals("bt4"));
        }
        n = 0;
        if (string.equals("e")) {
            n = 1;
        } else if (string.equals("d")) {
            n = 0;
        } else {
            LzmaAlone.IncorrectCommand();
        }
        if (n9 + 2 != stringArray.length) {
            LzmaAlone.IncorrectCommand();
        }
        object = new File(stringArray[n9]);
        FileInputStream fileInputStream = new FileInputStream((File)object);
        FileOutputStream fileOutputStream = new FileOutputStream(new File(stringArray[n9 + 1]));
        if (n != 0) {
            if (!bl) {
                n2 = 0x800000;
            }
            int[] nArray = new int[]{1024, 1088, 1089, 1090, 1136, 1104, 1105, 1168};
            int n11 = -1;
            if (string2.equals("bt2")) {
                n11 = 0;
            } else if (string2.equals("bt4")) {
                n11 = 1;
            } else if (string2.equals("bt4b")) {
                n11 = 2;
            } else {
                LzmaAlone.IncorrectCommand();
            }
            int[] nArray2 = new int[]{n2, n3, n4, n5, n6, n7, n11, n8};
            Encoder encoder = new Encoder();
            encoder.SetCoderProperties(nArray, nArray2);
            encoder.WriteCoderProperties(fileOutputStream);
            long l = n8 == 1 ? -1L : ((File)object).length();
            for (int i = 0; i < 8; ++i) {
                ((OutputStream)fileOutputStream).write((byte)(l >> 8 * i));
            }
            encoder.Code(fileInputStream, fileOutputStream, null);
            fileInputStream.close();
            ((OutputStream)fileOutputStream).close();
        } else if (string.equals("d")) {
            byte[] byArray = new byte[5];
            if (fileInputStream.read(byArray, 0, 5) != 5) {
                throw new Exception("input .lzma is too short");
            }
            Decoder decoder = new Decoder();
            decoder.SetDecoderProperties(byArray);
            long l = 0L;
            for (int i = 0; i < 8; ++i) {
                int n12 = fileInputStream.read();
                if (n12 < 0) {
                    throw new Exception("Can't Read 1");
                }
                l |= (long)n12 << 8 * i;
            }
            if (l == -1L) {
                l = Long.MAX_VALUE;
            }
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            decoder.Code(bufferedInputStream, bufferedOutputStream, l, null);
            bufferedInputStream.close();
            bufferedOutputStream.close();
        } else {
            throw new Exception("Command Error");
        }
        return 0;
    }

    public static void main(String[] stringArray) {
        try {
            long l = System.currentTimeMillis();
            int n = LzmaAlone.main2(stringArray);
            l = System.currentTimeMillis() - l;
            System.out.println("time : " + l + " ms");
            System.exit(n);
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            System.exit(1);
        }
    }
}

