/*
 * Decompiled with CFR 0.152.
 */
package SevenZip.Compression.RangeCoder;

import SevenZip.Compression.RangeCoder.BitEncoder;
import SevenZip.Compression.RangeCoder.Encoder;
import java.io.IOException;

public class BitTreeEncoder {
    BitEncoder[] Models;
    int NumBitLevels;

    public BitTreeEncoder(int n) {
        this.NumBitLevels = n;
        this.Models = new BitEncoder[1 << n];
        for (int i = 1; i < 1 << this.NumBitLevels; ++i) {
            this.Models[i] = new BitEncoder();
        }
    }

    public void Init() {
        for (int i = 1; i < 1 << this.NumBitLevels; ++i) {
            this.Models[i].Init();
        }
    }

    public void Encode(Encoder encoder, int n) throws IOException {
        int n2 = 1;
        int n3 = this.NumBitLevels;
        while (n3 > 0) {
            int n4 = n >> --n3 & 1;
            this.Models[n2].Encode(encoder, n4);
            n2 = n2 << 1 | n4;
        }
    }

    public void ReverseEncode(Encoder encoder, int n) throws IOException {
        int n2 = 1;
        for (int i = 0; i < this.NumBitLevels; ++i) {
            int n3 = n & 1;
            this.Models[n2].Encode(encoder, n3);
            n2 = n2 << 1 | n3;
            n >>= 1;
        }
    }

    public int GetPrice(int n) {
        int n2 = 0;
        int n3 = 1;
        int n4 = this.NumBitLevels;
        while (n4 > 0) {
            int n5 = n >> --n4 & 1;
            n2 += this.Models[n3].GetPrice(n5);
            n3 = (n3 << 1) + n5;
        }
        return n2;
    }

    public int ReverseGetPrice(int n) {
        int n2 = 0;
        int n3 = 1;
        for (int i = this.NumBitLevels; i > 0; --i) {
            int n4 = n & 1;
            n >>= 1;
            n2 += this.Models[n3].GetPrice(n4);
            n3 = n3 << 1 | n4;
        }
        return n2;
    }

    public static int ReverseGetPrice(BitEncoder[] bitEncoderArray, int n, int n2, int n3) {
        int n4 = 0;
        int n5 = 1;
        for (int i = n2; i > 0; --i) {
            int n6 = n3 & 1;
            n3 >>= 1;
            n4 += bitEncoderArray[n + n5].GetPrice(n6);
            n5 = n5 << 1 | n6;
        }
        return n4;
    }

    public static void ReverseEncode(BitEncoder[] bitEncoderArray, int n, Encoder encoder, int n2, int n3) throws IOException {
        int n4 = 1;
        for (int i = 0; i < n2; ++i) {
            int n5 = n3 & 1;
            bitEncoderArray[n + n4].Encode(encoder, n5);
            n4 = n4 << 1 | n5;
            n3 >>= 1;
        }
    }
}

