/*
 * Decompiled with CFR 0.152.
 */
package primitive.collection;

import java.util.Random;
import primitive.collection.IntFunction;
import primitive.collection.IntList;

public class IntStatList
extends IntList {
    public void each(IntFunction intFunction) {
        for (int j = 0; j != this.size(); ++j) {
            intFunction.apply(this.get(j));
        }
    }

    public int reduce(int n, IntFunction intFunction) {
        int n2 = n;
        for (int j = 0; j != this.size(); ++j) {
            n2 = intFunction.accumulate(n2, this.get(j));
        }
        return n2;
    }

    public int sum() {
        IntFunction intFunction = new IntFunction(){

            @Override
            public int accumulate(int n, int n2) {
                return n + n2;
            }
        };
        return this.reduce(0, intFunction);
    }

    public IntStats stats() {
        final IntStats intStats = new IntStats();
        IntFunction intFunction = new IntFunction(){

            @Override
            public void apply(int n) {
                if (n < intStats.min) {
                    intStats.min = n;
                }
                if (n > intStats.max) {
                    intStats.max = n;
                }
                intStats.sum += n;
            }
        };
        this.each(intFunction);
        intStats.n = this.size();
        intStats.avg = (double)intStats.sum / (double)intStats.n;
        intFunction = new IntFunction(){

            @Override
            public void apply(int n) {
                intStats.var += Math.pow(intStats.avg - (double)n, 2.0);
            }
        };
        this.each(intFunction);
        intStats.var /= (double)intStats.n;
        intStats.stdd = Math.pow(intStats.var, 0.5);
        return intStats;
    }

    static IntStatList random(int n) {
        Random random = new Random(0L);
        IntStatList intStatList = new IntStatList();
        for (int j = 0; j != n; ++j) {
            int n2 = random.nextInt();
            intStatList.add(n2);
        }
        return intStatList;
    }

    private static void p(Object object) {
        System.out.println(object);
    }

    public static void main(String[] stringArray) {
        IntStatList intStatList = IntStatList.random(10);
        intStatList.each(new IntFunction(){

            @Override
            public void apply(int n) {
                IntStatList.p(n);
            }
        });
        IntStatList.p(intStatList.stats());
        IntStatList.p(intStatList.sum());
        IntStatList intStatList2 = new IntStatList();
        for (int j = 1; j < 101; ++j) {
            intStatList2.add(j);
        }
        IntStatList.p(intStatList2.stats());
        IntStatList.p(intStatList2.sum());
    }

    class IntStats {
        public int n;
        public int min = Integer.MAX_VALUE;
        public int max = Integer.MIN_VALUE;
        public int sum;
        public double avg;
        public double stdd;
        public double var;

        IntStats() {
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("n    = ");
            stringBuilder.append(this.n);
            stringBuilder.append("\n");
            stringBuilder.append("min  = ");
            stringBuilder.append(this.min);
            stringBuilder.append("\n");
            stringBuilder.append("max  = ");
            stringBuilder.append(this.max);
            stringBuilder.append("\n");
            stringBuilder.append("sum  = ");
            stringBuilder.append(this.sum);
            stringBuilder.append("\n");
            stringBuilder.append("avg  = ");
            stringBuilder.append(this.avg);
            stringBuilder.append("\n");
            stringBuilder.append("stdd = ");
            stringBuilder.append(this.stdd);
            stringBuilder.append("\n");
            stringBuilder.append("var  = ");
            stringBuilder.append(this.var);
            stringBuilder.append("\n");
            return stringBuilder.toString();
        }
    }
}

