/*
 * Decompiled with CFR 0.152.
 */
package primitive.collection;

import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.Random;

public class DoubleList {
    private static final int DEFAULT = 1024;
    private static final double RESIZE = 1.8;
    private double[] underlyingArray;
    private int pos;

    public DoubleList() {
        this.clear();
    }

    public DoubleList(int n) {
        this.underlyingArray = new double[n];
    }

    public DoubleList(double[] dArray) {
        this.underlyingArray = dArray;
        this.pos = dArray.length;
    }

    public boolean add(double d) {
        this.ensureCapacity(1);
        this.underlyingArray[this.pos++] = d;
        return true;
    }

    public void add(int n, double d) {
        throw new UnsupportedOperationException("TBD");
    }

    public boolean addAll(DoubleList doubleList) {
        this.ensureCapacity(doubleList.size());
        System.arraycopy(doubleList.underlyingArray, 0, this.underlyingArray, this.size(), doubleList.size());
        this.pos += doubleList.size();
        return true;
    }

    public boolean addAll(double[] dArray) {
        return this.addAll(dArray, 0, dArray.length);
    }

    public boolean addAll(double[] dArray, int n, int n2) {
        this.ensureCapacity(n2);
        System.arraycopy(dArray, n, this.underlyingArray, this.size(), n2);
        this.pos += dArray.length;
        return true;
    }

    public boolean addAll(int n, DoubleList doubleList) {
        throw new UnsupportedOperationException("TBD");
    }

    public void clear() {
        if (null == this.underlyingArray || 1024 != this.underlyingArray.length) {
            this.underlyingArray = new double[1024];
        }
        this.pos = 0;
    }

    public boolean contains(double d) {
        return this.indexOf(d) != -1;
    }

    public boolean containsAll(DoubleList doubleList) {
        throw new UnsupportedOperationException("TBD");
    }

    public double get(int n) {
        if (n >= this.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.underlyingArray[n];
    }

    public int indexOf(double d) {
        for (int j = 0; j != this.size(); ++j) {
            if (d != this.underlyingArray[j]) continue;
            return j;
        }
        return -1;
    }

    public int lastIndexOf(double d) {
        for (int j = this.size() - 1; j != -1; --j) {
            if (d != this.underlyingArray[j]) continue;
            return j;
        }
        return -1;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Iterator iterator() {
        return new Iterator(this);
    }

    public Iterator iterator(int n) {
        return new Iterator(this, n);
    }

    public boolean remove(double d) {
        throw new UnsupportedOperationException("TBD");
    }

    public double removeIdx(int n) {
        throw new UnsupportedOperationException("TBD");
    }

    public boolean removeAll(DoubleList doubleList) {
        throw new UnsupportedOperationException("TBD");
    }

    public boolean retainAll(DoubleList doubleList) {
        throw new UnsupportedOperationException("TBD");
    }

    public double set(int n, double d) {
        if (n < 0 || n >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        double d2 = this.get(n);
        this.underlyingArray[n] = d;
        return d2;
    }

    public int size() {
        return this.pos;
    }

    public DoubleList subList(int n, int n2) {
        if (n < 0 || n2 > this.size() || n > n2) {
            throw new IndexOutOfBoundsException();
        }
        int n3 = n2 - n;
        double[] dArray = new double[n3];
        System.arraycopy(this.underlyingArray, n, dArray, 0, n3);
        return new DoubleList(dArray);
    }

    public double[] toArray() {
        double[] dArray = new double[this.pos];
        System.arraycopy(this.underlyingArray, 0, dArray, 0, this.pos);
        return dArray;
    }

    private void ensureCapacity(int n) {
        int n2 = this.underlyingArray.length - this.pos;
        if (n2 < n) {
            this.resize(this.underlyingArray.length + n);
        }
    }

    private void resize(int n) {
        int n2 = this.max(n, (int)((double)this.underlyingArray.length * 1.8));
        double[] dArray = new double[n2];
        System.arraycopy(this.underlyingArray, 0, dArray, 0, this.pos);
        this.underlyingArray = dArray;
    }

    private int max(int n, int n2) {
        return n > n2 ? n : n2;
    }

    private static void p(Object object) {
        System.out.println(object);
    }

    public static void main(String[] stringArray) {
        long l = System.currentTimeMillis();
        DoubleList doubleList = new DoubleList();
        Random random = new Random(0L);
        byte[] byArray = new byte[1];
        for (int j = 0; j != 250000; ++j) {
            double d = random.nextDouble();
            doubleList.add(d);
        }
        double[] dArray = doubleList.toArray();
        doubleList.addAll(dArray);
        DoubleList.p("ok...: " + doubleList.size() + " in: " + (System.currentTimeMillis() - l));
        l = System.currentTimeMillis();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int j = 0; j != 250000; ++j) {
            int n = random.nextInt();
            arrayList.add(new Integer(n));
        }
        arrayList.addAll(arrayList);
        DoubleList.p("ok...: " + arrayList.size() + " in: " + (System.currentTimeMillis() - l));
    }

    class Iterator {
        private DoubleList list;
        private int pos;

        public Iterator(DoubleList doubleList2) {
            this.list = doubleList2;
        }

        public Iterator(DoubleList doubleList2, int n) {
            if (n < 0 || n > doubleList2.size()) {
                throw new IndexOutOfBoundsException();
            }
            this.list = doubleList2;
            this.pos = n;
        }

        boolean hasNext() {
            return this.pos < this.list.size();
        }

        double next() {
            if (this.pos >= this.list.size() || this.pos < 0) {
                throw new NoSuchElementException();
            }
            return this.list.get(this.pos++);
        }

        void remove() {
            throw new UnsupportedOperationException("TBD");
        }
    }
}

