/*
 * Decompiled with CFR 0.152.
 */
package primitive.collection;

import java.util.Random;
import primitive.collection.ByteFunction;
import primitive.collection.ByteList;
import primitive.collection.IntStatList;

public class ByteStatList
extends ByteList {
    public void each(ByteFunction byteFunction) {
        for (int j = 0; j != this.size(); ++j) {
            byteFunction.apply(this.get(j));
        }
    }

    public byte reduce(byte by, ByteFunction byteFunction) {
        byte by2 = by;
        for (int j = 0; j != this.size(); ++j) {
            by2 = byteFunction.accumulate(by2, this.get(j));
        }
        return by2;
    }

    public byte sum() {
        ByteFunction byteFunction = new ByteFunction(){

            @Override
            public byte accumulate(byte by, byte by2) {
                return (byte)(by + by2);
            }
        };
        return this.reduce((byte)0, byteFunction);
    }

    public ByteStats stats() {
        final ByteStats byteStats = new ByteStats();
        ByteFunction byteFunction = new ByteFunction(){

            @Override
            public void apply(byte by) {
                if (by < byteStats.min) {
                    byteStats.min = by;
                }
                if (by > byteStats.max) {
                    byteStats.max = by;
                }
                byteStats.sum = (byte)(byteStats.sum + by);
            }
        };
        this.each(byteFunction);
        byteStats.n = this.size();
        byteStats.avg = (double)byteStats.sum / (double)byteStats.n;
        byteFunction = new ByteFunction(){

            @Override
            public void apply(byte by) {
                byteStats.var += Math.pow(byteStats.avg - (double)by, 2.0);
            }
        };
        this.each(byteFunction);
        byteStats.var /= (double)byteStats.n;
        byteStats.stdd = Math.pow(byteStats.var, 0.5);
        return byteStats;
    }

    static ByteStatList random(int n) {
        Random random = new Random(0L);
        ByteStatList byteStatList = new ByteStatList();
        for (int j = 0; j != n; ++j) {
            byte by = (byte)random.nextInt(256);
            byteStatList.add(by);
        }
        return byteStatList;
    }

    private static void p(Object object) {
        System.out.println(object);
    }

    public static void main(String[] stringArray) {
        ByteStatList byteStatList = ByteStatList.random(10);
        byteStatList.each(new ByteFunction(){

            @Override
            public void apply(byte by) {
                ByteStatList.p(by);
            }
        });
        ByteStatList.p(byteStatList.stats());
        ByteStatList.p(byteStatList.sum());
        IntStatList intStatList = new IntStatList();
        for (int j = 1; j < 101; ++j) {
            intStatList.add(j);
        }
        ByteStatList.p(intStatList.stats());
        ByteStatList.p(intStatList.sum());
    }

    class ByteStats {
        public int n;
        public byte min = (byte)127;
        public byte max = (byte)-128;
        public byte sum;
        public double avg;
        public double stdd;
        public double var;

        ByteStats() {
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("n    = ");
            stringBuilder.append(this.n);
            stringBuilder.append("\n");
            stringBuilder.append("min  = ");
            stringBuilder.append(this.min);
            stringBuilder.append("\n");
            stringBuilder.append("max  = ");
            stringBuilder.append(this.max);
            stringBuilder.append("\n");
            stringBuilder.append("sum  = ");
            stringBuilder.append(this.sum);
            stringBuilder.append("\n");
            stringBuilder.append("avg  = ");
            stringBuilder.append(this.avg);
            stringBuilder.append("\n");
            stringBuilder.append("stdd = ");
            stringBuilder.append(this.stdd);
            stringBuilder.append("\n");
            stringBuilder.append("var  = ");
            stringBuilder.append(this.var);
            stringBuilder.append("\n");
            return stringBuilder.toString();
        }
    }
}

