/*
 * Decompiled with CFR 0.152.
 */
package org.racob.com;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.Date;
import org.racob.com.Currency;
import org.racob.com.Dispatch;
import org.racob.com.SafeArray;
import org.racob.com.Variant;

public final class VariantUtilities {
    private static Variant[] EMPTY_ARRAY = new Variant[0];
    private static final BigDecimal LARGEST_DECIMAL = new BigDecimal(new BigInteger("ffffffffffffffffffffffff", 16));
    private static final BigDecimal SMALLEST_DECIMAL = new BigDecimal(new BigInteger("ffffffffffffffffffffffff", 16).negate());

    public static Variant createVariant(Object value2, boolean byRef) {
        if (value2 == null) {
            return new Variant();
        }
        if (value2 instanceof Integer) {
            return new Variant((Integer)value2, byRef);
        }
        if (value2 instanceof Short) {
            return new Variant((Short)value2, byRef);
        }
        if (value2 instanceof String) {
            return new Variant((String)value2, byRef);
        }
        if (value2 instanceof Boolean) {
            return new Variant((Boolean)value2, byRef);
        }
        if (value2 instanceof Double) {
            return new Variant((Double)value2, byRef);
        }
        if (value2 instanceof Float) {
            return new Variant(((Float)value2).floatValue(), byRef);
        }
        if (value2 instanceof BigDecimal) {
            return new Variant((BigDecimal)value2, byRef);
        }
        if (value2 instanceof Byte) {
            return new Variant((Byte)value2, byRef);
        }
        if (value2 instanceof Date) {
            return new Variant((Date)value2, byRef);
        }
        if (value2 instanceof Long) {
            return new Variant(((Long)value2).intValue(), byRef);
        }
        if (value2 instanceof Currency) {
            return new Variant((Currency)value2, byRef);
        }
        if (value2 instanceof SafeArray) {
            return new Variant((SafeArray)value2, byRef);
        }
        if (value2 instanceof Dispatch) {
            return new Variant((Dispatch)value2, byRef);
        }
        if (value2 instanceof Variant) {
            return new Variant((Variant)value2, byRef);
        }
        throw new RuntimeException("createVariant() not implemented for " + value2.getClass());
    }

    public static Variant objectToVariant(Object value2) {
        if (value2 == null) {
            return new Variant();
        }
        if (value2 instanceof Variant) {
            return (Variant)value2;
        }
        if (value2.getClass().isArray()) {
            value2 = SafeArray.create(value2);
        }
        return VariantUtilities.createVariant(value2, false);
    }

    protected static Variant[] objectsToVariants(Object[] array) {
        if (array.length == 0) {
            return EMPTY_ARRAY;
        }
        Variant[] variants = new Variant[array.length];
        for (int i2 = 0; i2 < array.length; ++i2) {
            variants[i2] = VariantUtilities.objectToVariant(array[i2]);
        }
        return variants;
    }

    protected static Object variantToObject(Variant sourceData) {
        if (sourceData == null) {
            return null;
        }
        if (sourceData.isArray()) {
            return sourceData.getArray();
        }
        switch (sourceData.getType()) {
            case 0: 
            case 1: {
                return null;
            }
            case 2: 
            case 18: {
                return sourceData.getShort();
            }
            case 3: 
            case 21: {
                return sourceData.getInt();
            }
            case 4: {
                return Float.valueOf(sourceData.getFloat());
            }
            case 5: {
                return sourceData.getDouble();
            }
            case 6: {
                return sourceData.getCurrency();
            }
            case 7: {
                return sourceData.getDate();
            }
            case 8: {
                return sourceData.getString();
            }
            case 9: {
                return sourceData.getDispatch();
            }
            case 10: {
                throw new RuntimeException("toJavaObject() Not implemented for VariantError");
            }
            case 11: {
                return sourceData.getBoolean();
            }
            case 12: {
                return sourceData.getVariant();
            }
            case 13: {
                throw new RuntimeException("toJavaObject() Not implemented for VariantObject");
            }
            case 14: {
                return sourceData.getDecimal();
            }
            case 17: {
                return new Byte(sourceData.getByte());
            }
            case 19: 
            case 20: {
                return sourceData.getLong();
            }
            case 4095: {
                throw new RuntimeException("toJavaObject() Not implemented for VariantTypeMask");
            }
            case 8192: {
                throw new RuntimeException("toJavaObject() Not implemented for VariantArray");
            }
            case 16384: {
                throw new RuntimeException("toJavaObject() Not implemented for VariantByref");
            }
        }
        throw new RuntimeException("Unknown return type: " + sourceData.getType());
    }

    protected static void validateDecimalScaleAndBits(BigDecimal in) {
        BigInteger allWordBigInt = in.unscaledValue();
        if (in.scale() > 28) {
            throw new IllegalArgumentException("VT_DECIMAL only supports a maximum scale of 28 and the passed in value has a scale of " + in.scale());
        }
        if (in.scale() < 0) {
            throw new IllegalArgumentException("VT_DECIMAL only supports a minimum scale of 0 and the passed in value has a scale of " + in.scale());
        }
        if (allWordBigInt.bitLength() > 96) {
            throw new IllegalArgumentException("VT_DECIMAL supports a maximum of 96 bits not counting scale and the number passed in has " + allWordBigInt.bitLength());
        }
    }

    protected static void validateDecimalMinMax(BigDecimal in) {
        if (in == null) {
            throw new IllegalArgumentException("null is not a supported Decimal value.");
        }
        if (LARGEST_DECIMAL.compareTo(in) < 0) {
            throw new IllegalArgumentException("Value too large for VT_DECIMAL data type:" + in.toString() + " integer: " + in.toBigInteger().toString(16) + " scale: " + in.scale());
        }
        if (SMALLEST_DECIMAL.compareTo(in) > 0) {
            throw new IllegalArgumentException("Value too small for VT_DECIMAL data type:" + in.toString() + " integer: " + in.toBigInteger().toString(16) + " scale: " + in.scale());
        }
    }

    public static BigDecimal roundToMSDecimal(BigDecimal sourceDecimal) {
        BigInteger sourceDecimalIntComponent = sourceDecimal.unscaledValue();
        BigDecimal destinationDecimal = new BigDecimal(sourceDecimalIntComponent, sourceDecimal.scale());
        int roundingModel = 4;
        VariantUtilities.validateDecimalMinMax(destinationDecimal);
        BigInteger allWordBigInt = destinationDecimal.unscaledValue();
        if (allWordBigInt.bitLength() > 96) {
            destinationDecimal = destinationDecimal.round(new MathContext(29));
            if (allWordBigInt.bitLength() > 96) {
                destinationDecimal = destinationDecimal.round(new MathContext(28));
            }
        }
        if (destinationDecimal.scale() > 28) {
            destinationDecimal = destinationDecimal.setScale(28, roundingModel);
        }
        if (destinationDecimal.scale() < 0) {
            destinationDecimal = destinationDecimal.setScale(0, roundingModel);
        }
        return destinationDecimal;
    }
}

