/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.type;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.util.Arrays;
import org.msgpack.MessageTypeException;
import org.msgpack.packer.Packer;
import org.msgpack.type.AbstractRawValue;
import org.msgpack.type.RawValue;
import org.msgpack.type.Value;

class ByteArrayRawValueImpl
extends AbstractRawValue {
    private static ByteArrayRawValueImpl emptyInstance = new ByteArrayRawValueImpl(new byte[0], true);
    private byte[] bytes;

    public static RawValue getEmptyInstance() {
        return emptyInstance;
    }

    ByteArrayRawValueImpl(byte[] bytes2, boolean gift) {
        if (gift) {
            this.bytes = bytes2;
        } else {
            this.bytes = new byte[bytes2.length];
            System.arraycopy(bytes2, 0, this.bytes, 0, bytes2.length);
        }
    }

    ByteArrayRawValueImpl(byte[] b, int off, int len) {
        this.bytes = new byte[len];
        System.arraycopy(b, off, this.bytes, 0, len);
    }

    @Override
    public byte[] getByteArray() {
        return this.bytes;
    }

    @Override
    public String getString() {
        CharsetDecoder decoder = Charset.forName("UTF-8").newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
        try {
            return decoder.decode(ByteBuffer.wrap(this.bytes)).toString();
        }
        catch (CharacterCodingException ex) {
            throw new MessageTypeException(ex);
        }
    }

    @Override
    public void writeTo(Packer pk) throws IOException {
        pk.write(this.bytes);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Value)) {
            return false;
        }
        Value v = (Value)o;
        if (!v.isRawValue()) {
            return false;
        }
        return Arrays.equals(this.bytes, v.asRawValue().getByteArray());
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.bytes);
    }
}

