/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.template.builder;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.msgpack.MessageTypeException;
import org.msgpack.packer.Packer;
import org.msgpack.template.AbstractTemplate;
import org.msgpack.template.Template;
import org.msgpack.template.TemplateRegistry;
import org.msgpack.template.builder.AbstractTemplateBuilder;
import org.msgpack.template.builder.DefaultFieldEntry;
import org.msgpack.template.builder.FieldEntry;
import org.msgpack.template.builder.ReflectionBeansTemplateBuilder;
import org.msgpack.unpacker.Unpacker;

public class ReflectionTemplateBuilder
extends AbstractTemplateBuilder {
    private static Logger LOG = Logger.getLogger(ReflectionBeansTemplateBuilder.class.getName());

    public ReflectionTemplateBuilder(TemplateRegistry registry) {
        super(registry);
    }

    @Override
    public boolean matchType(Type targetType, boolean hasAnnotation) {
        Class targetClass = (Class)targetType;
        boolean matched2 = ReflectionTemplateBuilder.matchAtClassTemplateBuilder(targetClass, hasAnnotation);
        if (matched2 && LOG.isLoggable(Level.FINE)) {
            LOG.fine("matched type: " + targetClass.getName());
        }
        return matched2;
    }

    @Override
    public <T> Template<T> buildTemplate(Class<T> targetClass, FieldEntry[] entries2) {
        if (entries2 == null) {
            throw new NullPointerException("entries is null: " + targetClass);
        }
        ReflectionFieldTemplate[] tmpls = this.toTemplates(entries2);
        return new ReflectionClassTemplate<T>(targetClass, tmpls);
    }

    protected ReflectionFieldTemplate[] toTemplates(FieldEntry[] entries2) {
        for (FieldEntry entry : entries2) {
            Field field2 = ((DefaultFieldEntry)entry).getField();
            int mod = field2.getModifiers();
            if (Modifier.isPublic(mod)) continue;
            field2.setAccessible(true);
        }
        ReflectionFieldTemplate[] templates = new ReflectionFieldTemplate[entries2.length];
        for (int i2 = 0; i2 < entries2.length; ++i2) {
            FieldEntry entry = entries2[i2];
            Template template = this.registry.lookup(entry.getGenericType());
            templates[i2] = new FieldTemplateImpl(entry, template);
        }
        return templates;
    }

    protected static class ReflectionClassTemplate<T>
    extends AbstractTemplate<T> {
        protected Class<T> targetClass;
        protected ReflectionFieldTemplate[] templates;

        protected ReflectionClassTemplate(Class<T> targetClass, ReflectionFieldTemplate[] templates) {
            this.targetClass = targetClass;
            this.templates = templates;
        }

        @Override
        public void write(Packer packer, T target, boolean required) throws IOException {
            if (target == null) {
                if (required) {
                    throw new MessageTypeException("attempted to write null");
                }
                packer.writeNil();
                return;
            }
            try {
                packer.writeArrayBegin(this.templates.length);
                for (ReflectionFieldTemplate tmpl : this.templates) {
                    if (!tmpl.entry.isAvailable()) {
                        packer.writeNil();
                        continue;
                    }
                    Object obj = tmpl.entry.get(target);
                    if (obj == null) {
                        if (tmpl.entry.isNotNullable()) {
                            throw new MessageTypeException(tmpl.entry.getName() + " cannot be null by @NotNullable");
                        }
                        packer.writeNil();
                        continue;
                    }
                    tmpl.write(packer, obj, true);
                }
                packer.writeArrayEnd();
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new MessageTypeException(e);
            }
        }

        @Override
        public T read(Unpacker unpacker, T to, boolean required) throws IOException {
            if (!required && unpacker.trySkipNil()) {
                return null;
            }
            try {
                if (to == null) {
                    to = this.targetClass.newInstance();
                }
                unpacker.readArrayBegin();
                for (int i2 = 0; i2 < this.templates.length; ++i2) {
                    ReflectionFieldTemplate tmpl = this.templates[i2];
                    if (!tmpl.entry.isAvailable()) {
                        unpacker.skip();
                        continue;
                    }
                    if (tmpl.entry.isOptional() && unpacker.trySkipNil()) continue;
                    tmpl.read(unpacker, to, false);
                }
                unpacker.readArrayEnd();
                return to;
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new MessageTypeException(e);
            }
        }
    }

    static final class FieldTemplateImpl
    extends ReflectionFieldTemplate {
        private Template template;

        public FieldTemplateImpl(FieldEntry entry, Template template) {
            super(entry);
            this.template = template;
        }

        @Override
        public void write(Packer packer, Object v, boolean required) throws IOException {
            this.template.write(packer, v, required);
        }

        @Override
        public Object read(Unpacker unpacker, Object to, boolean required) throws IOException {
            Object f = this.entry.get(to);
            Object o = this.template.read(unpacker, f, required);
            if (o != f) {
                this.entry.set(to, o);
            }
            return o;
        }
    }

    protected static abstract class ReflectionFieldTemplate
    extends AbstractTemplate<Object> {
        protected FieldEntry entry;

        ReflectionFieldTemplate(FieldEntry entry) {
            this.entry = entry;
        }

        void setNil(Object v) {
            this.entry.set(v, null);
        }
    }
}

