/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.template;

import java.io.IOException;
import org.msgpack.MessageTypeException;
import org.msgpack.packer.Packer;
import org.msgpack.template.AbstractTemplate;
import org.msgpack.unpacker.Unpacker;

public class IntegerArrayTemplate
extends AbstractTemplate<int[]> {
    static final IntegerArrayTemplate instance = new IntegerArrayTemplate();

    private IntegerArrayTemplate() {
    }

    @Override
    public void write(Packer pk, int[] target, boolean required) throws IOException {
        if (target == null) {
            if (required) {
                throw new MessageTypeException("Attempted to write null");
            }
            pk.writeNil();
            return;
        }
        pk.writeArrayBegin(target.length);
        for (int a : target) {
            pk.write(a);
        }
        pk.writeArrayEnd();
    }

    @Override
    public int[] read(Unpacker u, int[] to, boolean required) throws IOException {
        if (!required && u.trySkipNil()) {
            return null;
        }
        int n = u.readArrayBegin();
        int[] array = to != null && to.length == n ? to : new int[n];
        for (int i2 = 0; i2 < n; ++i2) {
            array[i2] = u.readInt();
        }
        u.readArrayEnd();
        return array;
    }

    public static IntegerArrayTemplate getInstance() {
        return instance;
    }
}

