/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.jruby;

import java.io.IOException;
import org.jcodings.Encoding;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.msgpack.MessagePack;
import org.msgpack.MessageTypeException;
import org.msgpack.type.ArrayValue;
import org.msgpack.type.BooleanValue;
import org.msgpack.type.FloatValue;
import org.msgpack.type.IntegerValue;
import org.msgpack.type.MapValue;
import org.msgpack.type.RawValue;
import org.msgpack.type.Value;
import org.msgpack.unpacker.MessagePackBufferUnpacker;

public class RubyObjectUnpacker {
    private final MessagePack msgPack;

    public RubyObjectUnpacker(MessagePack messagePack) {
        this.msgPack = messagePack;
    }

    public IRubyObject unpack(RubyString rubyString, RubyHash rubyHash) throws IOException {
        return this.unpack(rubyString.getRuntime(), rubyString.getBytes(), new CompiledOptions(rubyHash));
    }

    public IRubyObject unpack(Ruby ruby2, byte[] byArray, RubyHash rubyHash) throws IOException {
        return this.unpack(ruby2, byArray, new CompiledOptions(rubyHash));
    }

    public IRubyObject unpack(Ruby ruby2, byte[] byArray, CompiledOptions compiledOptions) throws IOException {
        MessagePackBufferUnpacker messagePackBufferUnpacker = new MessagePackBufferUnpacker(this.msgPack);
        messagePackBufferUnpacker.wrap(byArray);
        return this.valueToRubyObject(ruby2, messagePackBufferUnpacker.readValue(), compiledOptions);
    }

    IRubyObject valueToRubyObject(Ruby ruby2, Value value2, RubyHash rubyHash) throws IOException {
        return this.valueToRubyObject(ruby2, value2, new CompiledOptions(rubyHash));
    }

    IRubyObject valueToRubyObject(Ruby ruby2, Value value2, CompiledOptions compiledOptions) {
        switch (value2.getType()) {
            case NIL: {
                return ruby2.getNil();
            }
            case BOOLEAN: {
                return this.convert(ruby2, value2.asBooleanValue());
            }
            case INTEGER: {
                return this.convert(ruby2, value2.asIntegerValue());
            }
            case FLOAT: {
                return this.convert(ruby2, value2.asFloatValue());
            }
            case ARRAY: {
                return this.convert(ruby2, value2.asArrayValue(), compiledOptions);
            }
            case MAP: {
                return this.convert(ruby2, value2.asMapValue(), compiledOptions);
            }
            case RAW: {
                return this.convert(ruby2, value2.asRawValue(), compiledOptions);
            }
        }
        throw ruby2.newArgumentError(String.format("Unexpected value: %s", value2.toString()));
    }

    private IRubyObject convert(Ruby ruby2, BooleanValue booleanValue) {
        return RubyBoolean.newBoolean(ruby2, booleanValue.asBooleanValue().getBoolean());
    }

    private IRubyObject convert(Ruby ruby2, IntegerValue integerValue) {
        IntegerValue integerValue2 = integerValue.asIntegerValue();
        try {
            return RubyFixnum.newFixnum(ruby2, integerValue2.getLong());
        }
        catch (MessageTypeException messageTypeException) {
            return RubyBignum.newBignum(ruby2, integerValue2.getBigInteger());
        }
    }

    private IRubyObject convert(Ruby ruby2, FloatValue floatValue) {
        return RubyFloat.newFloat(ruby2, floatValue.asFloatValue().getDouble());
    }

    private IRubyObject convert(Ruby ruby2, ArrayValue arrayValue, CompiledOptions compiledOptions) {
        Value[] valueArray = arrayValue.asArrayValue().getElementArray();
        int n = valueArray.length;
        IRubyObject[] iRubyObjectArray = new IRubyObject[n];
        for (int j = 0; j < n; ++j) {
            iRubyObjectArray[j] = this.valueToRubyObject(ruby2, valueArray[j], compiledOptions);
        }
        return RubyArray.newArray(ruby2, iRubyObjectArray);
    }

    private IRubyObject convert(Ruby ruby2, MapValue mapValue, CompiledOptions compiledOptions) {
        Value[] valueArray = mapValue.asMapValue().getKeyValueArray();
        int n = valueArray.length;
        RubyHash rubyHash = RubyHash.newHash(ruby2);
        for (int j = 0; j < n; j += 2) {
            Value value2 = valueArray[j];
            Value value3 = valueArray[j + 1];
            IRubyObject iRubyObject = this.valueToRubyObject(ruby2, value2, compiledOptions);
            IRubyObject iRubyObject2 = this.valueToRubyObject(ruby2, value3, compiledOptions);
            if (compiledOptions.symbolizeKeys) {
                iRubyObject = ruby2.newSymbol(iRubyObject.asString().getByteList());
            }
            rubyHash.put(iRubyObject, iRubyObject2);
        }
        return rubyHash;
    }

    private IRubyObject convert(Ruby ruby2, RawValue rawValue, CompiledOptions compiledOptions) {
        RubyString rubyString = RubyString.newString(ruby2, rawValue.asRawValue().getByteArray());
        if (compiledOptions.encoding != null) {
            rubyString.setEncoding(compiledOptions.encoding);
        }
        return rubyString;
    }

    public static class CompiledOptions {
        public final boolean symbolizeKeys;
        public final Encoding encoding;

        public CompiledOptions() {
            this(null);
        }

        public CompiledOptions(RubyHash rubyHash) {
            if (rubyHash == null) {
                this.symbolizeKeys = false;
                this.encoding = null;
            } else {
                Ruby ruby2 = rubyHash.getRuntime();
                ThreadContext threadContext = ruby2.getCurrentContext();
                RubySymbol rubySymbol = ruby2.newSymbol("symbolize_keys");
                IRubyObject iRubyObject = rubyHash.fastARef(rubySymbol);
                this.symbolizeKeys = iRubyObject != null && iRubyObject.isTrue();
                IRubyObject iRubyObject2 = rubyHash.fastARef(ruby2.newSymbol("encoding"));
                this.encoding = ruby2.getEncodingService().getEncodingFromObject(iRubyObject2);
            }
        }
    }
}

