/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl.impl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.X509CRL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DLSequence;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Certificate;
import org.jruby.ext.openssl.impl.PKCS7;
import org.jruby.ext.openssl.impl.PKCS7Exception;
import org.jruby.ext.openssl.impl.SignerInfoWithPkey;
import org.jruby.ext.openssl.x509store.X509AuxCertificate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Signed {
    private int version;
    private Collection<X509CRL> crl = new ArrayList<X509CRL>();
    private Collection<X509AuxCertificate> cert = new ArrayList<X509AuxCertificate>();
    private Set<AlgorithmIdentifier> mdAlgs = new HashSet<AlgorithmIdentifier>();
    private Collection<SignerInfoWithPkey> signerInfo = new ArrayList<SignerInfoWithPkey>();
    PKCS7 contents;

    public final int getVersion() {
        return this.version;
    }

    public final void setVersion(int newVersion) {
        this.version = newVersion;
    }

    public final Collection<SignerInfoWithPkey> getSignerInfo() {
        return this.signerInfo;
    }

    public final void setSignerInfo(Collection<SignerInfoWithPkey> newSignerInfo) {
        this.signerInfo = newSignerInfo;
    }

    public final Set<AlgorithmIdentifier> getMdAlgs() {
        return this.mdAlgs;
    }

    public final void setMdAlgs(Set<AlgorithmIdentifier> newMdAlgs) {
        this.mdAlgs = newMdAlgs;
    }

    public final PKCS7 getContents() {
        return this.contents;
    }

    public final void setContents(PKCS7 newContents) {
        this.contents = newContents;
    }

    public final Collection<X509AuxCertificate> getCert() {
        return this.cert;
    }

    public final void setCert(Collection<X509AuxCertificate> newCert) {
        this.cert = newCert;
    }

    public final Collection<X509CRL> getCrl() {
        return this.crl;
    }

    public final void setCrl(Collection<X509CRL> newCrl) {
        this.crl = newCrl;
    }

    public String toString() {
        return "#<Signed version=" + this.version + " mdAlgs=" + this.mdAlgs + " content=" + this.contents + " cert=" + this.cert + " crls=" + this.crl + " signerInfos=" + this.signerInfo + ">";
    }

    public ASN1Encodable asASN1() {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add(new ASN1Integer(this.version));
        vector.add(this.digestAlgorithmsToASN1Set());
        if (this.contents == null) {
            this.contents = PKCS7.newEmpty();
        }
        vector.add(this.contents.asASN1());
        if (this.cert != null && this.cert.size() > 0) {
            if (this.cert.size() > 1) {
                vector.add(new DERTaggedObject(false, 0, this.certificatesToASN1Set()));
            } else {
                vector.add(new DERTaggedObject(true, 0, this.firstCertificatesToASN1()));
            }
        }
        if (this.crl != null && this.crl.size() > 0) {
            vector.add(new DERTaggedObject(false, 1, this.crlsToASN1Set()));
        }
        vector.add(this.signerInfosToASN1Set());
        return new DLSequence(vector);
    }

    private ASN1Set digestAlgorithmsToASN1Set() {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        for (AlgorithmIdentifier ai : this.mdAlgs) {
            vector.add(ai.toASN1Primitive());
        }
        return new DERSet(vector);
    }

    private ASN1Set certificatesToASN1Set() {
        try {
            ASN1EncodableVector vector = new ASN1EncodableVector();
            for (X509AuxCertificate c : this.cert) {
                vector.add(new ASN1InputStream(new ByteArrayInputStream(c.getEncoded())).readObject());
            }
            return new DERSet(vector);
        }
        catch (Exception e) {
            return null;
        }
    }

    private ASN1Sequence firstCertificatesToASN1() {
        try {
            X509AuxCertificate c = this.cert.iterator().next();
            return (ASN1Sequence)new ASN1InputStream(new ByteArrayInputStream(c.getEncoded())).readObject();
        }
        catch (Exception exception2) {
            return null;
        }
    }

    private ASN1Set crlsToASN1Set() {
        throw new RuntimeException("TODO: implement CRL part");
    }

    private ASN1Set signerInfosToASN1Set() {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        for (SignerInfoWithPkey si : this.signerInfo) {
            vector.add(si.toASN1Object());
        }
        return new DERSet(vector);
    }

    public static Signed fromASN1(ASN1Encodable content) throws PKCS7Exception {
        ASN1Sequence sequence = (ASN1Sequence)content;
        ASN1Integer version = (ASN1Integer)sequence.getObjectAt(0);
        ASN1Set digestAlgos = (ASN1Set)sequence.getObjectAt(1);
        ASN1Encodable contentInfo = sequence.getObjectAt(2);
        ASN1Primitive certificates = null;
        ASN1Primitive crls = null;
        int index2 = 3;
        ASN1Encodable tmp = sequence.getObjectAt(index2);
        if (tmp instanceof ASN1TaggedObject && ((ASN1TaggedObject)tmp).getTagNo() == 0) {
            certificates = ((ASN1TaggedObject)tmp).getObject();
            ++index2;
        }
        if ((tmp = sequence.getObjectAt(index2)) instanceof ASN1TaggedObject && ((ASN1TaggedObject)tmp).getTagNo() == 1) {
            crls = ((ASN1TaggedObject)tmp).getObject();
            ++index2;
        }
        ASN1Set signerInfos = (ASN1Set)sequence.getObjectAt(index2);
        Signed signed = new Signed();
        signed.setVersion(version.getValue().intValue());
        signed.setMdAlgs(Signed.algorithmIdentifiersFromASN1Set(digestAlgos));
        signed.setContents(PKCS7.fromASN1(contentInfo));
        if (certificates != null) {
            signed.setCert(Signed.certificatesFromASN1Set(certificates));
        }
        if (crls != null) {
            throw new RuntimeException("TODO: implement CRL part");
        }
        signed.setSignerInfo(Signed.signerInfosFromASN1Set(signerInfos));
        return signed;
    }

    private static Collection<X509AuxCertificate> certificatesFromASN1Set(ASN1Encodable content) throws PKCS7Exception {
        ArrayList<X509AuxCertificate> result2 = new ArrayList<X509AuxCertificate>();
        if (content instanceof ASN1Sequence) {
            try {
                Enumeration enm = ((ASN1Sequence)content).getObjects();
                while (enm.hasMoreElements()) {
                    ASN1Encodable current2 = (ASN1Encodable)enm.nextElement();
                    result2.add(Signed.certificateFromASN1(current2));
                }
            }
            catch (IllegalArgumentException iae) {
                result2.add(Signed.certificateFromASN1(content));
            }
        } else if (content instanceof ASN1Set) {
            Enumeration enm = ((ASN1Set)content).getObjects();
            while (enm.hasMoreElements()) {
                ASN1Encodable current3 = (ASN1Encodable)enm.nextElement();
                result2.add(Signed.certificateFromASN1(current3));
            }
        } else {
            throw new PKCS7Exception(120, 117, "unknown certificates format");
        }
        return result2;
    }

    private static X509AuxCertificate certificateFromASN1(ASN1Encodable current2) throws PKCS7Exception {
        Certificate struct = Certificate.getInstance(current2);
        try {
            return new X509AuxCertificate(struct);
        }
        catch (IOException e) {
            throw new PKCS7Exception(120, 117, e);
        }
        catch (CertificateException e) {
            throw new PKCS7Exception(120, 117, e);
        }
    }

    private static Set<AlgorithmIdentifier> algorithmIdentifiersFromASN1Set(ASN1Encodable content) {
        ASN1Set set = (ASN1Set)content;
        HashSet<AlgorithmIdentifier> result2 = new HashSet<AlgorithmIdentifier>();
        Enumeration e = set.getObjects();
        while (e.hasMoreElements()) {
            result2.add(AlgorithmIdentifier.getInstance(e.nextElement()));
        }
        return result2;
    }

    private static Collection<SignerInfoWithPkey> signerInfosFromASN1Set(ASN1Encodable content) {
        ASN1Set set = (ASN1Set)content;
        ArrayList<SignerInfoWithPkey> result2 = new ArrayList<SignerInfoWithPkey>();
        Enumeration e = set.getObjects();
        while (e.hasMoreElements()) {
            result2.add(SignerInfoWithPkey.getInstance(e.nextElement()));
        }
        return result2;
    }
}

