/*
 * Decompiled with CFR 0.152.
 */
package org.jbson;

import java.math.BigInteger;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import org.bson.BasicBSONEncoder;
import org.bson.io.BasicOutputBuffer;
import org.bson.io.OutputBuffer;
import org.bson.types.BSONTimestamp;
import org.bson.types.Binary;
import org.bson.types.CodeWScope;
import org.bson.types.Symbol;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyNil;
import org.jruby.RubyObject;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.RubyTime;
import org.jruby.exceptions.RaiseException;
import org.jruby.java.proxies.JavaProxy;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyBSONEncoder
extends BasicBSONEncoder {
    private static final boolean DEBUG = false;
    private Ruby _runtime;
    private RubyModule _rbclsByteBuffer;
    private RubyModule _rbclsInvalidDocument;
    private RubyModule _rbclsInvalidKeyName;
    private RubyModule _rbclsRangeError;
    private RubySymbol _idAsSym;
    private RubyString _idAsString;
    private RubyString _tfAsString;
    private boolean _check_keys;
    private boolean _move_id;
    private static final int DEFAULT_MAX_BSON_SIZE = 0x400000;
    private static int _max_bson_size = 0x400000;
    private static final int BIT_SIZE = 64;
    private static final long MAX = Long.MAX_VALUE;
    private static final BigInteger LONG_MAX = BigInteger.valueOf(Long.MAX_VALUE);
    private static final BigInteger LONG_MIN = BigInteger.valueOf(Long.MIN_VALUE);
    private OutputBuffer _buf;
    private CharBuffer _stringC = CharBuffer.wrap(new char[257]);
    private ByteBuffer _stringB = ByteBuffer.wrap(new byte[1025]);
    private CharsetEncoder _encoder = Charset.forName("UTF-8").newEncoder();

    public RubyBSONEncoder(Ruby ruby2, boolean bl, boolean bl2, int n) {
        _max_bson_size = n;
        this._check_keys = bl;
        this._move_id = bl2;
        this._runtime = ruby2;
        this._rbclsByteBuffer = ruby2.getClassFromPath("BSON::ByteBuffer");
        this._rbclsInvalidDocument = ruby2.getClassFromPath("BSON::InvalidDocument");
        this._rbclsInvalidKeyName = ruby2.getClassFromPath("BSON::InvalidKeyName");
        this._rbclsRangeError = ruby2.getClassFromPath("RangeError");
        this._idAsSym = ruby2.newSymbol("_id");
        this._tfAsString = ruby2.newString("_transientFields");
        if (this._idAsString == null) {
            this._idAsString = this._runtime.newString("_id");
        }
    }

    public static RubyFixnum max_bson_size(RubyObject rubyObject) {
        Ruby ruby2 = rubyObject.getRuntime();
        return ruby2.newFixnum(_max_bson_size);
    }

    public static RubyFixnum update_max_bson_size(RubyObject rubyObject, RubyObject rubyObject2) {
        Ruby ruby2 = rubyObject.getRuntime();
        _max_bson_size = ((Long)JavaEmbedUtils.invokeMethod(ruby2, rubyObject2, "max_bson_size", new Object[0], Object.class)).intValue();
        return ruby2.newFixnum(_max_bson_size);
    }

    public RubyString encode(Object object) {
        RubyHash rubyHash = (RubyHash)object;
        BasicOutputBuffer basicOutputBuffer = new BasicOutputBuffer();
        this.set(basicOutputBuffer);
        this.putObject(rubyHash);
        this.done();
        return RubyString.newString(this._runtime, basicOutputBuffer.toByteArray());
    }

    public void set(OutputBuffer outputBuffer) {
        if (this._buf != null) {
            this.done();
            throw new IllegalStateException("Error! The output buffer is in an illegal state.");
        }
        this._buf = outputBuffer;
    }

    public void done() {
        this._buf = null;
    }

    protected boolean handleSpecialObjects(String string2, RubyObject rubyObject) {
        return false;
    }

    public int putObject(RubyObject rubyObject) {
        return this.putObject(null, rubyObject);
    }

    int putObject(String string2, RubyObject rubyObject) {
        boolean bl;
        if (rubyObject == null) {
            throw new NullPointerException("Error! Null objects are not permitted.");
        }
        int n = this._buf.getPosition();
        byte by = 3;
        if (rubyObject instanceof RubyArray) {
            by = 4;
        }
        if (this.handleSpecialObjects(string2, rubyObject)) {
            return this._buf.getPosition() - n;
        }
        if (string2 != null) {
            this._put(by, string2);
        }
        int n2 = this._buf.getPosition();
        this._buf.writeInt(0);
        RubyObject rubyObject2 = null;
        boolean bl2 = bl = this._move_id && by == 3 && string2 == null;
        if (by == 3) {
            RubyObject rubyObject3;
            if (bl) {
                if (this._rbHashHasKey((RubyHash)rubyObject, "_id")) {
                    this._putObjectField("_id", this._rbHashGet((RubyHash)rubyObject, this._idAsString));
                } else if (this._rbHashHasKey((RubyHash)rubyObject, this._idAsSym)) {
                    this._putObjectField("_id", this._rbHashGet((RubyHash)rubyObject, this._idAsSym));
                }
                rubyObject3 = (RubyObject)this._rbHashGet((RubyHash)rubyObject, this._tfAsString);
                if (rubyObject3 instanceof RubyArray) {
                    rubyObject2 = rubyObject3;
                }
            } else if (this._rbHashHasKey((RubyHash)rubyObject, "_id") && this._rbHashHasKey((RubyHash)rubyObject, this._idAsSym)) {
                ((RubyHash)rubyObject).fastDelete(this._idAsSym);
            }
            rubyObject3 = (RubyArray)JavaEmbedUtils.invokeMethod(this._runtime, rubyObject, "keys", new Object[0], Object.class);
            for (Object e : rubyObject3) {
                String string3 = "";
                if (e instanceof String) {
                    string3 = e.toString();
                } else if (e instanceof RubyString) {
                    string3 = ((RubyString)e).asJavaString();
                } else if (e instanceof RubySymbol) {
                    string3 = ((RubySymbol)e).asJavaString();
                }
                if (bl && string3.equals("_id")) continue;
                RubyObject rubyObject4 = (RubyObject)this._rbHashGet((RubyHash)rubyObject, e);
                this._putObjectField(string3, rubyObject4);
            }
        }
        if (this._buf.size() > _max_bson_size) {
            this._rbRaise((RubyClass)this._rbclsInvalidDocument, "Error! Document is too large (" + this._buf.size() + "). BSON documents are limited to " + _max_bson_size + " bytes.");
        }
        this._buf.write(0);
        this._buf.writeInt(n2, this._buf.getPosition() - n2);
        return this._buf.getPosition() - n;
    }

    protected void _putObjectField(String string2, Object object) {
        if (this._check_keys) {
            this.testValidKey(string2);
        } else {
            this.testNull(string2);
        }
        if (string2.equals("_transientFields")) {
            return;
        }
        if (string2.equals("$where") && object instanceof String) {
            this._put((byte)13, string2);
            this._putValueString(object.toString());
            return;
        }
        if (object instanceof String) {
            this.putString(string2, object.toString());
        } else if (object instanceof Number) {
            if (object instanceof Float || object instanceof Double) {
                this._put((byte)1, string2);
                this._buf.writeDouble(((Number)object).doubleValue());
            } else {
                long l = ((Number)object).longValue();
                if (l >= Integer.MIN_VALUE && l <= Integer.MAX_VALUE) {
                    this._put((byte)16, string2);
                    this._buf.writeInt((int)l);
                } else {
                    this._put((byte)18, string2);
                    this._buf.writeLong(l);
                }
            }
        } else if (object instanceof Boolean) {
            this.putBoolean(string2, (Boolean)object);
        } else if (object instanceof Map) {
            this.putMap(string2, (Map)object);
        } else if (object instanceof Iterable) {
            this.putIterable(string2, (Iterable)object);
        } else if (object instanceof Date) {
            this.putDate(string2, ((Date)object).getTime());
        } else if (object instanceof byte[]) {
            this.putBinary(string2, (byte[])object);
        } else if (object == null) {
            this.putNull(string2);
        } else if (object.getClass().isArray()) {
            this.putIterable(string2, Arrays.asList((Object[])object));
        } else if (object instanceof RubyObject) {
            if (object instanceof RubyString) {
                this.putRubyString(string2, (RubyString)object);
            } else if (object instanceof RubySymbol) {
                this.putSymbol(string2, new Symbol(object.toString()));
            } else if (object instanceof RubyFixnum) {
                long l = ((RubyFixnum)object).getLongValue();
                if (l >= Integer.MIN_VALUE && l <= Integer.MAX_VALUE) {
                    this._put((byte)16, string2);
                    this._buf.writeInt((int)l);
                } else {
                    this._put((byte)18, string2);
                    this._buf.writeLong(l);
                }
            } else if (object instanceof RubyFloat) {
                double d = ((RubyFloat)object).getValue();
                this._put((byte)1, string2);
                this._buf.writeDouble(d);
            } else if (object instanceof JavaProxy) {
                Object object2 = ((JavaProxy)object).getObject();
                if (object2 instanceof ArrayList) {
                    this.putIterable(string2, (ArrayList)object2);
                } else {
                    this._rbRaise((RubyClass)this._rbclsInvalidDocument, "Error! Received a JavaProxy object that can't serialized as a BSON type.");
                }
            } else if (object instanceof RubyNil) {
                this.putNull(string2);
            } else if (object instanceof RubyTime) {
                this.putDate(string2, ((RubyTime)object).getDateTime().getMillis());
            } else if (object instanceof RubyBoolean) {
                this.putBoolean(string2, (Boolean)((RubyBoolean)object).toJava(Boolean.class));
            } else if (object instanceof RubyRegexp) {
                this.putRubyRegexp(string2, (RubyRegexp)object);
            } else if (object instanceof RubyBignum) {
                BigInteger bigInteger = ((RubyBignum)object).getValue();
                if (bigInteger.compareTo(LONG_MAX) > 0 || bigInteger.compareTo(LONG_MIN) < 0) {
                    this._rbRaise((RubyClass)this._rbclsRangeError, "Error! Only 8 byte integer values can be serialized.");
                } else {
                    long l = bigInteger.longValue();
                    this._put((byte)18, string2);
                    this._buf.writeLong(l);
                }
            } else {
                String string3 = JavaEmbedUtils.invokeMethod(this._runtime, object, "class", new Object[0], Object.class).toString();
                if (string3.equals("BSON::ObjectId")) {
                    this.putRubyObjectId(string2, (RubyObject)object);
                } else if (string3.equals("BSON::ObjectID")) {
                    this.putRubyObjectId(string2, (RubyObject)object);
                } else if (string3.equals("Java::JavaUtil::ArrayList")) {
                    this.putIterable(string2, (Iterable)object);
                } else if (string3.equals("BSON::Code")) {
                    this.putRubyCodeWScope(string2, (RubyObject)object);
                } else if (string3.equals("BSON::Binary")) {
                    this.putRubyBinary(string2, (RubyObject)object);
                } else if (string3.equals("BSON::MinKey")) {
                    this._put((byte)-1, string2);
                } else if (string3.equals("BSON::MaxKey")) {
                    this._put((byte)127, string2);
                } else if (string3.equals("BSON::Timestamp")) {
                    this.putRubyTimestamp(string2, (RubyObject)object);
                } else if (string3.equals("BSON::DBRef")) {
                    RubyHash rubyHash = (RubyHash)JavaEmbedUtils.invokeMethod(this._runtime, object, "to_hash", new Object[0], Object.class);
                    this.putMap(string2, rubyHash);
                } else if (string3.equals("Date") || string3.equals("DateTime") || string3.equals("ActiveSupport::TimeWithZone")) {
                    this._rbRaise((RubyClass)this._rbclsInvalidDocument, "Error! " + string3 + " is not currently supported; use a UTC Time instance instead.");
                } else {
                    this._rbRaise((RubyClass)this._rbclsInvalidDocument, "Error! Cannot serialize " + string3 + " as a BSON type; " + "it either isn't supported or won't translate to BSON.");
                }
            }
        } else {
            String string4 = JavaEmbedUtils.invokeMethod(this._runtime, object, "class", new Object[0], Object.class).toString();
            this._rbRaise((RubyClass)this._rbclsInvalidDocument, "Error! Cannot serialize " + string4 + " as a BSON type; " + "it either isn't supported or won't translate to BSON.");
        }
    }

    private void testNull(String string2) {
        byte[] byArray = string2.getBytes();
        for (int j = 0; j < byArray.length; ++j) {
            if (byArray[j] != 0) continue;
            this._rbRaise((RubyClass)this._rbclsInvalidDocument, "Error! Null values are not permitted.");
        }
    }

    private void testValidKey(String string2) {
        byte[] byArray = string2.getBytes();
        if (byArray[0] == 36) {
            this._rbRaise((RubyClass)this._rbclsInvalidKeyName, "Error! The '$' character is not allowed in key name.");
        }
        for (int j = 0; j < byArray.length; ++j) {
            if (byArray[j] == 0) {
                this._rbRaise((RubyClass)this._rbclsInvalidDocument, "Error! Null values are not permitted.");
            }
            if (byArray[j] != 46) continue;
            this._rbRaise((RubyClass)this._rbclsInvalidKeyName, "Error! Key names must not contain '.' (" + string2 + ").");
        }
    }

    private void putIterable(String string2, Iterable iterable) {
        this._put((byte)4, string2);
        int n = this._buf.getPosition();
        this._buf.writeInt(0);
        int n2 = 0;
        for (Object t : iterable) {
            this._putObjectField(String.valueOf(n2), t);
            ++n2;
        }
        this._buf.write(0);
        this._buf.writeInt(n, this._buf.getPosition() - n);
    }

    private void putMap(String string2, Map map) {
        this._put((byte)3, string2);
        int n = this._buf.getPosition();
        this._buf.writeInt(0);
        RubyArray rubyArray = (RubyArray)JavaEmbedUtils.invokeMethod(this._runtime, map, "keys", new Object[0], Object.class);
        for (Object e : rubyArray) {
            String string3 = "";
            if (e instanceof String) {
                string3 = e.toString();
            } else if (e instanceof RubyString) {
                string3 = ((RubyString)e).asJavaString();
            } else if (e instanceof RubySymbol) {
                string3 = ((RubySymbol)e).asJavaString();
            }
            RubyObject rubyObject = (RubyObject)this._rbHashGet((RubyHash)map, e);
            this._putObjectField(string3, rubyObject);
        }
        this._buf.write(0);
        this._buf.writeInt(n, this._buf.getPosition() - n);
    }

    protected void putNull(String string2) {
        this._put((byte)10, string2);
    }

    protected void putUndefined(String string2) {
        this._put((byte)6, string2);
    }

    protected void putTimestamp(String string2, BSONTimestamp bSONTimestamp) {
        this._put((byte)17, string2);
        this._buf.writeInt(bSONTimestamp.getInc());
        this._buf.writeInt(bSONTimestamp.getTime());
    }

    protected void putRubyTimestamp(String string2, RubyObject rubyObject) {
        this._put((byte)17, string2);
        Number number = (Number)JavaEmbedUtils.invokeMethod(this._runtime, rubyObject, "increment", new Object[0], Object.class);
        Number number2 = (Number)JavaEmbedUtils.invokeMethod(this._runtime, rubyObject, "seconds", new Object[0], Object.class);
        this._buf.writeInt((int)number.longValue());
        this._buf.writeInt((int)number2.longValue());
    }

    protected void putRubyCodeWScope(String string2, RubyObject rubyObject) {
        this._put((byte)15, string2);
        int n = this._buf.getPosition();
        this._buf.writeInt(0);
        String string3 = (String)JavaEmbedUtils.invokeMethod(this._runtime, rubyObject, "code", new Object[0], Object.class);
        this._putValueString(string3);
        this.putObject((RubyObject)JavaEmbedUtils.invokeMethod(this._runtime, rubyObject, "scope", new Object[0], Object.class));
        this._buf.writeInt(n, this._buf.getPosition() - n);
    }

    protected void putCodeWScope(String string2, CodeWScope codeWScope) {
        this._put((byte)15, string2);
        int n = this._buf.getPosition();
        this._buf.writeInt(0);
        this._putValueString(codeWScope.getCode());
        this._buf.writeInt(n, this._buf.getPosition() - n);
    }

    protected void putBoolean(String string2, Boolean bl) {
        this._put((byte)8, string2);
        this._buf.write(bl != false ? 1 : 0);
    }

    protected void putDate(String string2, long l) {
        this._put((byte)9, string2);
        this._buf.writeLong(l);
    }

    private void putRubyBinary(String string2, RubyObject rubyObject) {
        RubyArray rubyArray = (RubyArray)JavaEmbedUtils.invokeMethod(this._runtime, rubyObject, "to_a", new Object[0], Object.class);
        Long l = (Long)JavaEmbedUtils.invokeMethod(this._runtime, rubyObject, "subtype", new Object[0], Object.class);
        long l2 = l;
        byte[] byArray = this.ra2ba(rubyArray);
        if (l2 == 2L) {
            this.putBinaryTypeTwo(string2, byArray);
        } else {
            this._put((byte)5, string2);
            this._buf.writeInt(byArray.length);
            this._buf.write((byte)l2);
            this._buf.write(byArray);
        }
    }

    protected void putBinaryTypeTwo(String string2, byte[] byArray) {
        this._put((byte)5, string2);
        this._buf.writeInt(4 + byArray.length);
        this._buf.write(2);
        this._buf.writeInt(byArray.length);
        this._buf.write(byArray);
    }

    protected void putBinary(String string2, byte[] byArray) {
        this._put((byte)5, string2);
        this._buf.writeInt(byArray.length);
        this._buf.write(0);
        this._buf.write(byArray);
    }

    protected void putBinary(String string2, Binary binary) {
        this._put((byte)5, string2);
        this._buf.writeInt(binary.length());
        this._buf.write(binary.getType());
        this._buf.write(binary.getData());
    }

    protected void putUUID(String string2, UUID uUID) {
        this._put((byte)5, string2);
        this._buf.writeInt(132);
        this._buf.write(3);
        this._buf.writeLong(uUID.getMostSignificantBits());
        this._buf.writeLong(uUID.getLeastSignificantBits());
    }

    protected void putSymbol(String string2, Symbol symbol) {
        this._putString(string2, symbol.getSymbol(), (byte)14);
    }

    protected void putRubyString(String string2, RubyString rubyString) {
        byte[] byArray = rubyString.getBytes();
        this._put((byte)2, string2);
        this._buf.writeInt(byArray.length + 1);
        this._buf.write(byArray);
        this._buf.write(0);
    }

    protected void putString(String string2, String string3) {
        this._putString(string2, string3, (byte)2);
    }

    private void _putString(String string2, String string3, byte by) {
        this._put(by, string2);
        this._putValueString(string3);
    }

    private void putRubyObjectId(String string2, RubyObject rubyObject) {
        this._put((byte)7, string2);
        RubyArray rubyArray = (RubyArray)JavaEmbedUtils.invokeMethod(this._runtime, rubyObject, "data", new Object[0], Object.class);
        byte[] byArray = this.ra2ba(rubyArray);
        this._buf.writeInt(this.convertToInt(byArray, 0));
        this._buf.writeInt(this.convertToInt(byArray, 4));
        this._buf.writeInt(this.convertToInt(byArray, 8));
    }

    private void putRubyRegexp(String string2, RubyRegexp rubyRegexp) {
        RubyString rubyString = (RubyString)rubyRegexp.source();
        this.testNull(rubyString.toString());
        this._put((byte)11, string2);
        this._put((String)rubyString.toJava(String.class));
        int n = (int)((RubyFixnum)rubyRegexp.options()).getLongValue();
        String string3 = "";
        if ((n & 1) != 0) {
            string3 = string3.concat("i");
        }
        if ((n & 4) != 0) {
            string3 = string3.concat("m");
            string3 = string3.concat("s");
        }
        if ((n & 2) != 0) {
            string3 = string3.concat("x");
        }
        this._put(string3);
    }

    private int convertToInt(byte[] byArray, int n) {
        return (byArray[n + 3] & 0xFF) << 24 | (byArray[n + 2] & 0xFF) << 16 | (byArray[n + 1] & 0xFF) << 8 | byArray[n] & 0xFF;
    }

    private byte[] ra2ba(RubyArray rubyArray) {
        int n = rubyArray.getLength();
        byte[] byArray = new byte[n];
        int n2 = 0;
        for (Object e : rubyArray) {
            byArray[n2] = (byte)((Long)e).intValue();
            ++n2;
        }
        return byArray;
    }

    private IRubyObject _rbHashGet(RubyHash rubyHash, Object object) {
        if (object instanceof String) {
            return rubyHash.op_aref(this._runtime.getCurrentContext(), this._runtime.newString((String)object));
        }
        return rubyHash.op_aref(this._runtime.getCurrentContext(), (RubyObject)object);
    }

    private boolean _rbHashHasKey(RubyHash rubyHash, String string2) {
        RubyBoolean rubyBoolean = rubyHash.has_key_p(this._runtime.newString(string2));
        return rubyBoolean == this._runtime.getTrue();
    }

    private boolean _rbHashHasKey(RubyHash rubyHash, RubySymbol rubySymbol) {
        RubyBoolean rubyBoolean = rubyHash.has_key_p(rubySymbol);
        return rubyBoolean == this._runtime.getTrue();
    }

    private IRubyObject _rbHashSet(RubyHash rubyHash, String string2, IRubyObject iRubyObject) {
        return rubyHash.op_aset(this._runtime.getCurrentContext(), this._runtime.newString(string2), iRubyObject);
    }

    private RubyArray _rbHashKeys(RubyHash rubyHash) {
        return rubyHash.keys();
    }

    private RaiseException _rbRaise(RubyClass rubyClass, String string2) {
        this.done();
        throw new RaiseException(this._runtime, rubyClass, string2, true);
    }

    protected void _put(byte by, String string2) {
        this._buf.write(by);
        this._put(string2);
    }

    protected void _putWithoutCheck(byte by, String string2) {
        this._buf.write(by);
        this._put(string2);
    }

    protected void _putValueString(String string2) {
        int n = this._buf.getPosition();
        this._buf.writeInt(0);
        int n2 = this._put(string2);
        this._buf.writeInt(n, n2);
    }

    void _reset(Buffer buffer) {
        buffer.position(0);
        buffer.limit(buffer.capacity());
    }

    protected int _put(String string2) {
        int n;
        int n2 = 0;
        int n3 = string2.length();
        for (int j = 0; j < n3; j += n) {
            this._reset(this._stringC);
            this._reset(this._stringB);
            n = Math.min(this._stringC.capacity() - 1, n3 - j);
            this._stringC.put(string2, j, j + n);
            this._stringC.flip();
            CoderResult coderResult = this._encoder.encode(this._stringC, this._stringB, false);
            if (coderResult.isMalformed() || coderResult.isUnmappable()) {
                throw new IllegalArgumentException("Error! Received a malformed string.");
            }
            if (coderResult.isOverflow()) {
                throw new RuntimeException("Error! Encoder overflow cannot be enabled.");
            }
            if (coderResult.isError()) {
                throw new RuntimeException("Error! An encoder error has ocurred.");
            }
            if (!coderResult.isUnderflow()) {
                throw new RuntimeException("Error! Encoder underflow must be enabled.");
            }
            n2 += this._stringB.position();
            this._buf.write(this._stringB.array(), 0, this._stringB.position());
        }
        this._buf.write(0);
        return ++n2;
    }

    public void writeInt(int n) {
        this._buf.writeInt(n);
    }

    public void writeLong(long l) {
        this._buf.writeLong(l);
    }

    public void writeCString(String string2) {
        this._put(string2);
    }
}

