/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport.local;

import java.io.IOException;
import java.io.NotSerializableException;
import org.elasticsearch.common.io.ThrowableObjectOutputStream;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.CachedStreamOutput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.transport.NotSerializableTransportException;
import org.elasticsearch.transport.RemoteTransportException;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportResponseOptions;
import org.elasticsearch.transport.local.LocalTransport;
import org.elasticsearch.transport.support.TransportStatus;

public class LocalTransportChannel
implements TransportChannel {
    private final LocalTransport sourceTransport;
    private final LocalTransport targetTransport;
    private final String action;
    private final long requestId;

    public LocalTransportChannel(LocalTransport sourceTransport, LocalTransport targetTransport, String action, long requestId) {
        this.sourceTransport = sourceTransport;
        this.targetTransport = targetTransport;
        this.action = action;
        this.requestId = requestId;
    }

    @Override
    public String action() {
        return this.action;
    }

    @Override
    public void sendResponse(TransportResponse response) throws IOException {
        this.sendResponse(response, TransportResponseOptions.EMPTY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendResponse(TransportResponse response, TransportResponseOptions options2) throws IOException {
        CachedStreamOutput.Entry cachedEntry = CachedStreamOutput.popEntry();
        try {
            StreamOutput stream = cachedEntry.handles();
            stream.writeLong(this.requestId);
            byte status2 = 0;
            status2 = TransportStatus.setResponse(status2);
            stream.writeByte(status2);
            response.writeTo(stream);
            stream.close();
            final byte[] data2 = cachedEntry.bytes().bytes().copyBytesArray().toBytes();
            this.targetTransport.threadPool().generic().execute(new Runnable(){

                @Override
                public void run() {
                    LocalTransportChannel.this.targetTransport.messageReceived(data2, LocalTransportChannel.this.action, LocalTransportChannel.this.sourceTransport, null);
                }
            });
        }
        finally {
            CachedStreamOutput.pushEntry(cachedEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendResponse(Throwable error2) throws IOException {
        CachedStreamOutput.Entry cachedEntry = CachedStreamOutput.popEntry();
        try {
            BytesStreamOutput stream;
            try {
                stream = cachedEntry.bytes();
                this.writeResponseExceptionHeader(stream);
                RemoteTransportException tx = new RemoteTransportException(this.targetTransport.nodeName(), this.targetTransport.boundAddress().boundAddress(), this.action, error2);
                ThrowableObjectOutputStream too = new ThrowableObjectOutputStream(stream);
                too.writeObject(tx);
                too.close();
            }
            catch (NotSerializableException e) {
                cachedEntry.reset();
                stream = cachedEntry.bytes();
                this.writeResponseExceptionHeader(stream);
                RemoteTransportException tx = new RemoteTransportException(this.targetTransport.nodeName(), this.targetTransport.boundAddress().boundAddress(), this.action, new NotSerializableTransportException(error2));
                ThrowableObjectOutputStream too = new ThrowableObjectOutputStream(stream);
                too.writeObject(tx);
                too.close();
            }
            final byte[] data2 = stream.bytes().copyBytesArray().toBytes();
            this.targetTransport.threadPool().generic().execute(new Runnable(){

                @Override
                public void run() {
                    LocalTransportChannel.this.targetTransport.messageReceived(data2, LocalTransportChannel.this.action, LocalTransportChannel.this.sourceTransport, null);
                }
            });
        }
        finally {
            CachedStreamOutput.pushEntry(cachedEntry);
        }
    }

    private void writeResponseExceptionHeader(BytesStreamOutput stream) throws IOException {
        stream.writeLong(this.requestId);
        byte status2 = 0;
        status2 = TransportStatus.setResponse(status2);
        status2 = TransportStatus.setError(status2);
        stream.writeByte(status2);
    }
}

