/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.transport.TransportException;

public class ActionTransportException
extends TransportException {
    private TransportAddress address;
    private String action;

    public ActionTransportException(String msg, Throwable cause2) {
        super(msg, cause2);
    }

    public ActionTransportException(String name2, TransportAddress address2, String action, Throwable cause2) {
        super(ActionTransportException.buildMessage(name2, address2, action, null), cause2);
        this.address = address2;
        this.action = action;
    }

    public ActionTransportException(String name2, TransportAddress address2, String action, String msg, Throwable cause2) {
        super(ActionTransportException.buildMessage(name2, address2, action, msg), cause2);
        this.address = address2;
        this.action = action;
    }

    public TransportAddress address() {
        return this.address;
    }

    public String action() {
        return this.action;
    }

    private static String buildMessage(String name2, TransportAddress address2, String action, String msg) {
        StringBuilder sb = new StringBuilder();
        if (name2 != null) {
            sb.append('[').append(name2).append(']');
        }
        if (address2 != null) {
            sb.append('[').append(address2).append(']');
        }
        if (action != null) {
            sb.append('[').append(action).append(']');
        }
        if (msg != null) {
            sb.append(" ").append(msg);
        }
        return sb.toString();
    }
}

