/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.sort;

import java.io.IOException;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortOrder;

public class FieldSortBuilder
extends SortBuilder {
    private final String fieldName;
    private SortOrder order;
    private Object missing;
    private Boolean ignoreUnampped;

    public FieldSortBuilder(String fieldName) {
        if (fieldName == null) {
            throw new ElasticSearchIllegalArgumentException("fieldName must not be null");
        }
        this.fieldName = fieldName;
    }

    @Override
    public FieldSortBuilder order(SortOrder order2) {
        this.order = order2;
        return this;
    }

    @Override
    public FieldSortBuilder missing(Object missing) {
        this.missing = missing;
        return this;
    }

    public FieldSortBuilder ignoreUnmapped(boolean ignoreUnmapped) {
        this.ignoreUnampped = ignoreUnmapped;
        return this;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params2) throws IOException {
        builder.startObject(this.fieldName);
        if (this.order != null) {
            builder.field("order", this.order.toString());
        }
        if (this.missing != null) {
            builder.field("missing", this.missing);
        }
        if (this.ignoreUnampped != null) {
            builder.field("ignore_unmapped", (Object)this.ignoreUnampped);
        }
        builder.endObject();
        return builder;
    }
}

