/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.highlight;

import java.io.IOException;
import java.util.Arrays;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.text.StringText;
import org.elasticsearch.common.text.Text;

public class HighlightField
implements Streamable {
    private String name;
    private Text[] fragments;

    HighlightField() {
    }

    public HighlightField(String name2, Text[] fragments) {
        this.name = name2;
        this.fragments = fragments;
    }

    public String name() {
        return this.name;
    }

    public String getName() {
        return this.name();
    }

    public Text[] fragments() {
        return this.fragments;
    }

    public Text[] getFragments() {
        return this.fragments();
    }

    public String toString() {
        return "[" + this.name + "], fragments[" + Arrays.toString(this.fragments) + "]";
    }

    public static HighlightField readHighlightField(StreamInput in) throws IOException {
        HighlightField field2 = new HighlightField();
        field2.readFrom(in);
        return field2;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.name = in.readUTF();
        if (in.readBoolean()) {
            int size2 = in.readVInt();
            if (size2 == 0) {
                this.fragments = StringText.EMPTY_ARRAY;
            } else {
                this.fragments = new Text[size2];
                for (int i2 = 0; i2 < size2; ++i2) {
                    this.fragments[i2] = in.readText();
                }
            }
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeUTF(this.name);
        if (this.fragments == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeVInt(this.fragments.length);
            for (Text fragment : this.fragments) {
                out.writeText(fragment);
            }
        }
    }
}

