/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.highlight;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class HighlightBuilder
implements ToXContent {
    private List<Field> fields;
    private String tagsSchema;
    private String[] preTags;
    private String[] postTags;
    private String order;
    private String encoder;
    private Boolean requireFieldMatch;
    private String highlighterType;
    private String fragmenter;

    public HighlightBuilder field(String name2) {
        if (this.fields == null) {
            this.fields = Lists.newArrayList();
        }
        this.fields.add(new Field(name2));
        return this;
    }

    public HighlightBuilder field(String name2, int fragmentSize) {
        if (this.fields == null) {
            this.fields = Lists.newArrayList();
        }
        this.fields.add(new Field(name2).fragmentSize(fragmentSize));
        return this;
    }

    public HighlightBuilder field(String name2, int fragmentSize, int numberOfFragments) {
        if (this.fields == null) {
            this.fields = Lists.newArrayList();
        }
        this.fields.add(new Field(name2).fragmentSize(fragmentSize).numOfFragments(numberOfFragments));
        return this;
    }

    public HighlightBuilder field(String name2, int fragmentSize, int numberOfFragments, int fragmentOffset) {
        if (this.fields == null) {
            this.fields = Lists.newArrayList();
        }
        this.fields.add(new Field(name2).fragmentSize(fragmentSize).numOfFragments(numberOfFragments).fragmentOffset(fragmentOffset));
        return this;
    }

    public HighlightBuilder field(Field field2) {
        if (this.fields == null) {
            this.fields = Lists.newArrayList();
        }
        this.fields.add(field2);
        return this;
    }

    public HighlightBuilder tagsSchema(String schemaName) {
        this.tagsSchema = schemaName;
        return this;
    }

    public HighlightBuilder encoder(String encoder) {
        this.encoder = encoder;
        return this;
    }

    public HighlightBuilder preTags(String ... preTags) {
        this.preTags = preTags;
        return this;
    }

    public HighlightBuilder postTags(String ... postTags) {
        this.postTags = postTags;
        return this;
    }

    public HighlightBuilder order(String order2) {
        this.order = order2;
        return this;
    }

    public HighlightBuilder requireFieldMatch(boolean requireFieldMatch) {
        this.requireFieldMatch = requireFieldMatch;
        return this;
    }

    public HighlightBuilder highlighterType(String highlighterType) {
        this.highlighterType = highlighterType;
        return this;
    }

    public HighlightBuilder fragmenter(String fragmenter) {
        this.fragmenter = fragmenter;
        return this;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params2) throws IOException {
        builder.startObject("highlight");
        if (this.tagsSchema != null) {
            builder.field("tags_schema", this.tagsSchema);
        }
        if (this.preTags != null) {
            builder.array("pre_tags", this.preTags);
        }
        if (this.postTags != null) {
            builder.array("post_tags", this.postTags);
        }
        if (this.order != null) {
            builder.field("order", this.order);
        }
        if (this.encoder != null) {
            builder.field("encoder", this.encoder);
        }
        if (this.requireFieldMatch != null) {
            builder.field("require_field_match", (Object)this.requireFieldMatch);
        }
        if (this.highlighterType != null) {
            builder.field("type", this.highlighterType);
        }
        if (this.fragmenter != null) {
            builder.field("fragmenter", this.fragmenter);
        }
        if (this.fields != null) {
            builder.startObject("fields");
            for (Field field2 : this.fields) {
                builder.startObject(field2.name());
                if (field2.fragmentSize != -1) {
                    builder.field("fragment_size", field2.fragmentSize);
                }
                if (field2.numOfFragments != -1) {
                    builder.field("number_of_fragments", field2.numOfFragments);
                }
                if (field2.fragmentOffset != -1) {
                    builder.field("fragment_offset", field2.fragmentOffset);
                }
                if (field2.requireFieldMatch != null) {
                    builder.field("require_field_match", (Object)field2.requireFieldMatch);
                }
                if (field2.highlighterType != null) {
                    builder.field("type", field2.highlighterType);
                }
                if (field2.fragmenter != null) {
                    builder.field("fragmenter", field2.fragmenter);
                }
                builder.endObject();
            }
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    public static class Field {
        final String name;
        int fragmentSize = -1;
        int fragmentOffset = -1;
        int numOfFragments = -1;
        Boolean requireFieldMatch;
        String highlighterType;
        String fragmenter;

        public Field(String name2) {
            this.name = name2;
        }

        public String name() {
            return this.name;
        }

        public Field fragmentSize(int fragmentSize) {
            this.fragmentSize = fragmentSize;
            return this;
        }

        public Field fragmentOffset(int fragmentOffset) {
            this.fragmentOffset = fragmentOffset;
            return this;
        }

        public Field numOfFragments(int numOfFragments) {
            this.numOfFragments = numOfFragments;
            return this;
        }

        public Field requireFieldMatch(boolean requireFieldMatch) {
            this.requireFieldMatch = requireFieldMatch;
            return this;
        }

        public Field highlighterType(String highlighterType) {
            this.highlighterType = highlighterType;
            return this;
        }

        public Field fragmenter(String fragmenter) {
            this.fragmenter = fragmenter;
            return this;
        }
    }
}

