/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.trove.ExtTIntArrayList;
import org.elasticsearch.transport.TransportRequest;

public class FetchSearchRequest
extends TransportRequest {
    private long id;
    private int[] docIds;
    private int size;

    public FetchSearchRequest() {
    }

    public FetchSearchRequest(TransportRequest request, long id2, ExtTIntArrayList list2) {
        super(request);
        this.id = id2;
        this.docIds = list2.unsafeArray();
        this.size = list2.size();
    }

    public long id() {
        return this.id;
    }

    public int[] docIds() {
        return this.docIds;
    }

    public int docIdsSize() {
        return this.size;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.id = in.readLong();
        this.size = in.readVInt();
        this.docIds = new int[this.size];
        for (int i2 = 0; i2 < this.size; ++i2) {
            this.docIds[i2] = in.readVInt();
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeLong(this.id);
        out.writeVInt(this.size);
        for (int i2 = 0; i2 < this.size; ++i2) {
            out.writeVInt(this.docIds[i2]);
        }
    }
}

