/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.document.ResetFieldSelector;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.FieldMappers;
import org.elasticsearch.index.mapper.Uid;
import org.elasticsearch.index.mapper.internal.UidFieldMapper;
import org.elasticsearch.index.mapper.selector.AllButSourceFieldSelector;
import org.elasticsearch.index.mapper.selector.FieldMappersFieldSelector;
import org.elasticsearch.index.mapper.selector.UidAndSourceFieldSelector;
import org.elasticsearch.index.mapper.selector.UidFieldSelector;
import org.elasticsearch.indices.TypeMissingException;
import org.elasticsearch.search.SearchHitField;
import org.elasticsearch.search.SearchParseElement;
import org.elasticsearch.search.SearchPhase;
import org.elasticsearch.search.fetch.FetchPhaseExecutionException;
import org.elasticsearch.search.fetch.FetchSubPhase;
import org.elasticsearch.search.fetch.FieldsParseElement;
import org.elasticsearch.search.fetch.explain.ExplainFetchSubPhase;
import org.elasticsearch.search.fetch.matchedfilters.MatchedFiltersFetchSubPhase;
import org.elasticsearch.search.fetch.partial.PartialFieldsFetchSubPhase;
import org.elasticsearch.search.fetch.script.ScriptFieldsFetchSubPhase;
import org.elasticsearch.search.fetch.version.VersionFetchSubPhase;
import org.elasticsearch.search.highlight.HighlightPhase;
import org.elasticsearch.search.internal.InternalSearchHit;
import org.elasticsearch.search.internal.InternalSearchHitField;
import org.elasticsearch.search.internal.InternalSearchHits;
import org.elasticsearch.search.internal.SearchContext;

public class FetchPhase
implements SearchPhase {
    private final FetchSubPhase[] fetchSubPhases;

    @Inject
    public FetchPhase(HighlightPhase highlightPhase, ScriptFieldsFetchSubPhase scriptFieldsPhase, PartialFieldsFetchSubPhase partialFieldsPhase, MatchedFiltersFetchSubPhase matchFiltersPhase, ExplainFetchSubPhase explainPhase, VersionFetchSubPhase versionPhase) {
        this.fetchSubPhases = new FetchSubPhase[]{scriptFieldsPhase, partialFieldsPhase, matchFiltersPhase, explainPhase, highlightPhase, versionPhase};
    }

    @Override
    public Map<String, ? extends SearchParseElement> parseElements() {
        ImmutableMap.Builder<String, ? extends SearchParseElement> parseElements = ImmutableMap.builder();
        parseElements.put("fields", new FieldsParseElement());
        for (FetchSubPhase fetchSubPhase : this.fetchSubPhases) {
            parseElements.putAll(fetchSubPhase.parseElements());
        }
        return parseElements.build();
    }

    @Override
    public void preProcess(SearchContext context) {
    }

    @Override
    public void execute(SearchContext context) {
        ResetFieldSelector fieldSelector;
        ArrayList<String> extractFieldNames = null;
        boolean sourceRequested = false;
        if (!context.hasFieldNames()) {
            if (context.hasPartialFields()) {
                fieldSelector = new UidAndSourceFieldSelector();
                sourceRequested = false;
            } else if (context.hasScriptFields()) {
                fieldSelector = UidFieldSelector.INSTANCE;
                sourceRequested = false;
            } else {
                fieldSelector = new UidAndSourceFieldSelector();
                sourceRequested = true;
            }
        } else if (context.fieldNames().isEmpty()) {
            fieldSelector = UidFieldSelector.INSTANCE;
            sourceRequested = false;
        } else {
            boolean loadAllStored = false;
            FieldMappersFieldSelector fieldSelectorMapper = null;
            for (String fieldName : context.fieldNames()) {
                if (fieldName.equals("*")) {
                    loadAllStored = true;
                    continue;
                }
                if (fieldName.equals("_source")) {
                    sourceRequested = true;
                    continue;
                }
                FieldMappers x = context.smartNameFieldMappers(fieldName);
                if (x != null && x.mapper().stored()) {
                    if (fieldSelectorMapper == null) {
                        fieldSelectorMapper = new FieldMappersFieldSelector();
                    }
                    fieldSelectorMapper.add(x);
                    continue;
                }
                if (extractFieldNames == null) {
                    extractFieldNames = Lists.newArrayList();
                }
                extractFieldNames.add(fieldName);
            }
            if (loadAllStored) {
                fieldSelector = sourceRequested || extractFieldNames != null ? null : AllButSourceFieldSelector.INSTANCE;
            } else if (fieldSelectorMapper != null) {
                fieldSelectorMapper.add(UidFieldMapper.NAME);
                if (extractFieldNames != null || sourceRequested) {
                    fieldSelectorMapper.add("_source");
                }
                fieldSelector = fieldSelectorMapper;
            } else {
                fieldSelector = extractFieldNames != null || sourceRequested ? new UidAndSourceFieldSelector() : UidFieldSelector.INSTANCE;
            }
        }
        InternalSearchHit[] hits = new InternalSearchHit[context.docIdsToLoadSize()];
        for (int index2 = 0; index2 < context.docIdsToLoadSize(); ++index2) {
            SearchHitField hitField;
            InternalSearchHit searchHit;
            int docId = context.docIdsToLoad()[context.docIdsToLoadFrom() + index2];
            Document doc = this.loadDocument(context, fieldSelector, docId);
            Uid uid2 = this.extractUid(context, doc, fieldSelector);
            DocumentMapper documentMapper = context.mapperService().documentMapper(uid2.type());
            if (documentMapper == null) {
                throw new TypeMissingException(new Index(context.shardTarget().index()), uid2.type(), "failed to find type loaded for doc [" + uid2.id() + "]");
            }
            byte[] source2 = this.extractSource(doc, documentMapper);
            hits[index2] = searchHit = new InternalSearchHit(docId, uid2.id(), uid2.type(), (byte[])(sourceRequested ? source2 : null), null);
            for (Fieldable oField : doc.getFields()) {
                FieldMapper mapper;
                Fieldable field2 = oField;
                String name2 = field2.name();
                if (name2.equals(UidFieldMapper.NAME) || name2.equals("_source")) continue;
                Object value2 = null;
                FieldMappers fieldMappers = documentMapper.mappers().indexName(field2.name());
                if (fieldMappers != null && (mapper = fieldMappers.mapper()) != null) {
                    name2 = mapper.names().fullName();
                    value2 = mapper.valueForSearch(field2);
                }
                if (value2 == null) {
                    value2 = field2.isBinary() ? new BytesArray(field2.getBinaryValue(), field2.getBinaryOffset(), field2.getBinaryLength()) : field2.stringValue();
                }
                if (searchHit.fieldsOrNull() == null) {
                    searchHit.fields(new HashMap<String, SearchHitField>(2));
                }
                if ((hitField = searchHit.fields().get(name2)) == null) {
                    hitField = new InternalSearchHitField(name2, new ArrayList<Object>(2));
                    searchHit.fields().put(name2, hitField);
                }
                hitField.values().add(value2);
            }
            int readerIndex = context.searcher().readerIndex(docId);
            IndexReader subReader = context.searcher().subReaders()[readerIndex];
            int subDoc = docId - context.searcher().docStarts()[readerIndex];
            context.lookup().setNextReader(subReader);
            context.lookup().setNextDocId(subDoc);
            if (source2 != null) {
                context.lookup().source().setNextSource(new BytesArray(source2));
            }
            if (extractFieldNames != null) {
                for (String extractFieldName : extractFieldNames) {
                    Object value3 = context.lookup().source().extractValue(extractFieldName);
                    if (value3 == null) continue;
                    if (searchHit.fieldsOrNull() == null) {
                        searchHit.fields(new HashMap<String, SearchHitField>(2));
                    }
                    if ((hitField = searchHit.fields().get(extractFieldName)) == null) {
                        hitField = new InternalSearchHitField(extractFieldName, new ArrayList<Object>(2));
                        searchHit.fields().put(extractFieldName, hitField);
                    }
                    hitField.values().add(value3);
                }
            }
            for (FetchSubPhase fetchSubPhase : this.fetchSubPhases) {
                FetchSubPhase.HitContext hitContext = new FetchSubPhase.HitContext();
                if (!fetchSubPhase.hitExecutionNeeded(context)) continue;
                hitContext.reset(searchHit, subReader, subDoc, context.searcher().getIndexReader(), docId, doc);
                fetchSubPhase.hitExecute(context, hitContext);
            }
        }
        for (FetchSubPhase fetchSubPhase : this.fetchSubPhases) {
            if (!fetchSubPhase.hitsExecutionNeeded(context)) continue;
            fetchSubPhase.hitsExecute(context, hits);
        }
        context.fetchResult().hits(new InternalSearchHits(hits, context.queryResult().topDocs().totalHits, context.queryResult().topDocs().getMaxScore()));
    }

    private byte[] extractSource(Document doc, DocumentMapper documentMapper) {
        Fieldable sourceField = doc.getFieldable("_source");
        if (sourceField != null) {
            return documentMapper.sourceMapper().nativeValue(sourceField);
        }
        return null;
    }

    private Uid extractUid(SearchContext context, Document doc, @Nullable ResetFieldSelector fieldSelector) {
        String sUid = doc.get(UidFieldMapper.NAME);
        if (sUid != null) {
            return Uid.createUid(sUid);
        }
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (Fieldable field2 : doc.getFields()) {
            fieldNames.add(field2.name());
        }
        throw new FetchPhaseExecutionException(context, "Failed to load uid from the index, missing internal _uid field, current fields in the doc [" + fieldNames + "], selector [" + fieldSelector + "]");
    }

    private Document loadDocument(SearchContext context, @Nullable ResetFieldSelector fieldSelector, int docId) {
        try {
            if (fieldSelector != null) {
                fieldSelector.reset();
            }
            return context.searcher().doc(docId, fieldSelector);
        }
        catch (IOException e) {
            throw new FetchPhaseExecutionException(context, "Failed to fetch doc id [" + docId + "]", (Throwable)e);
        }
    }
}

