/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.termsstats;

import java.util.Comparator;
import java.util.List;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.search.facet.Facet;

public interface TermsStatsFacet
extends Facet,
Iterable<Entry> {
    public static final String TYPE = "terms_stats";

    public long missingCount();

    public long getMissingCount();

    public List<? extends Entry> entries();

    public List<? extends Entry> getEntries();

    public static interface Entry
    extends Comparable<Entry> {
        public String term();

        public String getTerm();

        public Number termAsNumber();

        public Number getTermAsNumber();

        public long count();

        public long getCount();

        public long totalCount();

        public long getTotalCount();

        public double min();

        public double getMin();

        public double max();

        public double getMax();

        public double total();

        public double getTotal();

        public double mean();

        public double getMean();
    }

    public static enum ComparatorType {
        COUNT(0, new Comparator<Entry>(){

            @Override
            public int compare(Entry o1, Entry o2) {
                int i2;
                if (o1 == null) {
                    if (o2 == null) {
                        return 0;
                    }
                    return 1;
                }
                if (o2 == null) {
                    return -1;
                }
                int n = o2.count() < o1.count() ? -1 : (i2 = o1.count() == o2.count() ? 0 : 1);
                if (i2 == 0) {
                    i2 = o2.compareTo(o1);
                }
                return i2;
            }
        }),
        REVERSE_COUNT(1, new Comparator<Entry>(){

            @Override
            public int compare(Entry o1, Entry o2) {
                if (o1 == null) {
                    if (o2 == null) {
                        return 0;
                    }
                    return 1;
                }
                if (o2 == null) {
                    return -1;
                }
                return -COUNT.comparator().compare(o1, o2);
            }
        }),
        TERM(2, new Comparator<Entry>(){

            @Override
            public int compare(Entry o1, Entry o2) {
                if (o1 == null) {
                    if (o2 == null) {
                        return 0;
                    }
                    return 1;
                }
                if (o2 == null) {
                    return -1;
                }
                int i2 = o1.compareTo(o2);
                if (i2 == 0) {
                    i2 = COUNT.comparator().compare(o1, o2);
                }
                return i2;
            }
        }),
        REVERSE_TERM(3, new Comparator<Entry>(){

            @Override
            public int compare(Entry o1, Entry o2) {
                if (o1 == null) {
                    if (o2 == null) {
                        return 0;
                    }
                    return 1;
                }
                if (o2 == null) {
                    return -1;
                }
                return -TERM.comparator().compare(o1, o2);
            }
        }),
        TOTAL(4, new Comparator<Entry>(){

            @Override
            public int compare(Entry o1, Entry o2) {
                if (o1 == null) {
                    if (o2 == null) {
                        return 0;
                    }
                    return 1;
                }
                if (o2 == null) {
                    return -1;
                }
                int i2 = -Double.compare(o1.total(), o2.total());
                if (i2 == 0) {
                    i2 = COUNT.comparator().compare(o1, o2);
                }
                return i2;
            }
        }),
        REVERSE_TOTAL(5, new Comparator<Entry>(){

            @Override
            public int compare(Entry o1, Entry o2) {
                if (o1 == null) {
                    if (o2 == null) {
                        return 0;
                    }
                    return 1;
                }
                if (o2 == null) {
                    return -1;
                }
                return -TOTAL.comparator().compare(o1, o2);
            }
        }),
        MIN(6, new Comparator<Entry>(){

            @Override
            public int compare(Entry o1, Entry o2) {
                if (o1 == null) {
                    if (o2 == null) {
                        return 0;
                    }
                    return 1;
                }
                if (o2 == null) {
                    return -1;
                }
                int i2 = Double.compare(o1.min(), o2.min());
                if (i2 == 0) {
                    i2 = COUNT.comparator().compare(o1, o2);
                }
                return i2;
            }
        }),
        REVERSE_MIN(7, new Comparator<Entry>(){

            @Override
            public int compare(Entry o1, Entry o2) {
                if (o1 == null) {
                    if (o2 == null) {
                        return 0;
                    }
                    return 1;
                }
                if (o2 == null) {
                    return -1;
                }
                return -MIN.comparator().compare(o1, o2);
            }
        }),
        MAX(8, new Comparator<Entry>(){

            @Override
            public int compare(Entry o1, Entry o2) {
                if (o1 == null) {
                    if (o2 == null) {
                        return 0;
                    }
                    return 1;
                }
                if (o2 == null) {
                    return -1;
                }
                int i2 = -Double.compare(o1.max(), o2.max());
                if (i2 == 0) {
                    i2 = COUNT.comparator().compare(o1, o2);
                }
                return i2;
            }
        }),
        REVERSE_MAX(9, new Comparator<Entry>(){

            @Override
            public int compare(Entry o1, Entry o2) {
                if (o1 == null) {
                    if (o2 == null) {
                        return 0;
                    }
                    return 1;
                }
                if (o2 == null) {
                    return -1;
                }
                return -MAX.comparator().compare(o1, o2);
            }
        }),
        MEAN(10, new Comparator<Entry>(){

            @Override
            public int compare(Entry o1, Entry o2) {
                if (o1 == null) {
                    if (o2 == null) {
                        return 0;
                    }
                    return 1;
                }
                if (o2 == null) {
                    return -1;
                }
                int i2 = -Double.compare(o1.mean(), o2.mean());
                if (i2 == 0) {
                    i2 = COUNT.comparator().compare(o1, o2);
                }
                return i2;
            }
        }),
        REVERSE_MEAN(11, new Comparator<Entry>(){

            @Override
            public int compare(Entry o1, Entry o2) {
                if (o1 == null) {
                    if (o2 == null) {
                        return 0;
                    }
                    return 1;
                }
                if (o2 == null) {
                    return -1;
                }
                return -MEAN.comparator().compare(o1, o2);
            }
        });

        private final byte id;
        private final Comparator<Entry> comparator;

        private ComparatorType(byte id2, Comparator<Entry> comparator) {
            this.id = id2;
            this.comparator = comparator;
        }

        public byte id() {
            return this.id;
        }

        public Comparator<Entry> comparator() {
            return this.comparator;
        }

        public static ComparatorType fromId(byte id2) {
            if (id2 == COUNT.id()) {
                return COUNT;
            }
            if (id2 == REVERSE_COUNT.id()) {
                return REVERSE_COUNT;
            }
            if (id2 == TERM.id()) {
                return TERM;
            }
            if (id2 == REVERSE_TERM.id()) {
                return REVERSE_TERM;
            }
            if (id2 == TOTAL.id()) {
                return TOTAL;
            }
            if (id2 == REVERSE_TOTAL.id()) {
                return REVERSE_TOTAL;
            }
            if (id2 == MIN.id()) {
                return MIN;
            }
            if (id2 == REVERSE_MIN.id()) {
                return REVERSE_MIN;
            }
            if (id2 == MAX.id()) {
                return MAX;
            }
            if (id2 == REVERSE_MAX.id()) {
                return REVERSE_MAX;
            }
            if (id2 == MEAN.id()) {
                return MEAN;
            }
            if (id2 == REVERSE_MEAN.id()) {
                return REVERSE_MEAN;
            }
            throw new ElasticSearchIllegalArgumentException("No type argument match for terms facet comparator [" + id2 + "]");
        }

        public static ComparatorType fromString(String type2) {
            if ("count".equals(type2)) {
                return COUNT;
            }
            if ("term".equals(type2)) {
                return TERM;
            }
            if ("reverse_count".equals(type2) || "reverseCount".equals(type2)) {
                return REVERSE_COUNT;
            }
            if ("reverse_term".equals(type2) || "reverseTerm".equals(type2)) {
                return REVERSE_TERM;
            }
            if ("total".equals(type2)) {
                return TOTAL;
            }
            if ("reverse_total".equals(type2) || "reverseTotal".equals(type2)) {
                return REVERSE_TOTAL;
            }
            if ("min".equals(type2)) {
                return MIN;
            }
            if ("reverse_min".equals(type2) || "reverseMin".equals(type2)) {
                return REVERSE_MIN;
            }
            if ("max".equals(type2)) {
                return MAX;
            }
            if ("reverse_max".equals(type2) || "reverseMax".equals(type2)) {
                return REVERSE_MAX;
            }
            if ("mean".equals(type2)) {
                return MEAN;
            }
            if ("reverse_mean".equals(type2) || "reverseMean".equals(type2)) {
                return REVERSE_MEAN;
            }
            throw new ElasticSearchIllegalArgumentException("No type argument match for terms stats facet comparator [" + type2 + "]");
        }
    }
}

