/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.terms.strings;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.util.PriorityQueue;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.common.CacheRecycler;
import org.elasticsearch.common.collect.BoundedTreeSet;
import org.elasticsearch.common.collect.ImmutableSet;
import org.elasticsearch.index.cache.field.data.FieldDataCache;
import org.elasticsearch.index.field.data.FieldData;
import org.elasticsearch.index.field.data.FieldDataType;
import org.elasticsearch.index.field.data.strings.StringFieldData;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.search.facet.AbstractFacetCollector;
import org.elasticsearch.search.facet.Facet;
import org.elasticsearch.search.facet.terms.TermsFacet;
import org.elasticsearch.search.facet.terms.strings.InternalStringTermsFacet;
import org.elasticsearch.search.facet.terms.support.EntryPriorityQueue;
import org.elasticsearch.search.internal.SearchContext;

public class TermsStringOrdinalsFacetCollector
extends AbstractFacetCollector {
    private final FieldDataCache fieldDataCache;
    private final String indexFieldName;
    private final TermsFacet.ComparatorType comparatorType;
    private final int size;
    private final int numberOfShards;
    private final int minCount;
    private final FieldDataType fieldDataType;
    private StringFieldData fieldData;
    private final List<ReaderAggregator> aggregators;
    private ReaderAggregator current;
    long missing;
    long total;
    private final ImmutableSet<String> excluded;
    private final Matcher matcher;

    public TermsStringOrdinalsFacetCollector(String facetName, String fieldName, int size2, TermsFacet.ComparatorType comparatorType, boolean allTerms, SearchContext context, ImmutableSet<String> excluded, Pattern pattern) {
        super(facetName);
        this.fieldDataCache = context.fieldDataCache();
        this.size = size2;
        this.comparatorType = comparatorType;
        this.numberOfShards = context.numberOfShards();
        MapperService.SmartNameFieldMappers smartMappers = context.smartFieldMappers(fieldName);
        if (smartMappers == null || !smartMappers.hasMapper()) {
            throw new ElasticSearchIllegalArgumentException("Field [" + fieldName + "] doesn't have a type, can't run terms long facet collector on it");
        }
        if (smartMappers.explicitTypeInNameWithDocMapper()) {
            this.setFilter(context.filterCache().cache(smartMappers.docMapper().typeFilter()));
        }
        if (smartMappers.mapper().fieldDataType() != FieldDataType.DefaultTypes.STRING) {
            throw new ElasticSearchIllegalArgumentException("Field [" + fieldName + "] is not of string type, can't run terms string facet collector on it");
        }
        this.indexFieldName = smartMappers.mapper().names().indexName();
        this.fieldDataType = smartMappers.mapper().fieldDataType();
        this.excluded = excluded == null || excluded.isEmpty() ? null : excluded;
        this.matcher = pattern != null ? pattern.matcher("") : null;
        this.minCount = allTerms ? -1 : 0;
        this.aggregators = new ArrayList<ReaderAggregator>(context.searcher().subReaders().length);
    }

    @Override
    protected void doSetNextReader(IndexReader reader, int docBase) throws IOException {
        if (this.current != null) {
            this.missing += (long)this.current.counts[0];
            this.total += (long)(this.current.total - this.current.counts[0]);
            if (this.current.values.length > 1) {
                this.aggregators.add(this.current);
            }
        }
        this.fieldData = (StringFieldData)this.fieldDataCache.cache(this.fieldDataType, reader, this.indexFieldName);
        this.current = new ReaderAggregator(this.fieldData);
    }

    @Override
    protected void doCollect(int doc) throws IOException {
        this.fieldData.forEachOrdinalInDoc(doc, this.current);
    }

    @Override
    public Facet facet() {
        ReaderAggregator agg;
        Object ordered;
        if (this.current != null) {
            this.missing += (long)this.current.counts[0];
            this.total += (long)(this.current.total - this.current.counts[0]);
            if (this.current.values.length > 1) {
                this.aggregators.add(this.current);
            }
        }
        AggregatorPriorityQueue queue = new AggregatorPriorityQueue(this.aggregators.size());
        for (ReaderAggregator aggregator : this.aggregators) {
            if (!aggregator.nextPosition()) continue;
            queue.add(aggregator);
        }
        if (this.size < 5000) {
            ordered = new EntryPriorityQueue(this.size, this.comparatorType.comparator());
            while (queue.size() > 0) {
                agg = (ReaderAggregator)queue.top();
                String value2 = agg.current;
                int count2 = 0;
                do {
                    count2 += agg.counts[agg.position];
                    if (agg.nextPosition()) {
                        agg = (ReaderAggregator)queue.updateTop();
                        continue;
                    }
                    queue.pop();
                    agg = (ReaderAggregator)queue.top();
                } while (agg != null && value2.equals(agg.current));
                if (count2 <= this.minCount || this.excluded != null && this.excluded.contains(value2) || this.matcher != null && !this.matcher.reset(value2).matches()) continue;
                InternalStringTermsFacet.StringEntry entry = new InternalStringTermsFacet.StringEntry(value2, count2);
                ((PriorityQueue)ordered).insertWithOverflow(entry);
            }
            InternalStringTermsFacet.StringEntry[] list2 = new InternalStringTermsFacet.StringEntry[((PriorityQueue)ordered).size()];
            for (int i2 = ((PriorityQueue)ordered).size() - 1; i2 >= 0; --i2) {
                list2[i2] = (InternalStringTermsFacet.StringEntry)((PriorityQueue)ordered).pop();
            }
            for (ReaderAggregator aggregator : this.aggregators) {
                CacheRecycler.pushIntArray(aggregator.counts);
            }
            return new InternalStringTermsFacet(this.facetName, this.comparatorType, this.size, Arrays.asList(list2), this.missing, this.total);
        }
        ordered = new BoundedTreeSet<TermsFacet.Entry>(this.comparatorType.comparator(), this.size);
        while (queue.size() > 0) {
            agg = (ReaderAggregator)queue.top();
            String value3 = agg.current;
            int count3 = 0;
            do {
                count3 += agg.counts[agg.position];
                if (agg.nextPosition()) {
                    agg = (ReaderAggregator)queue.updateTop();
                    continue;
                }
                queue.pop();
                agg = (ReaderAggregator)queue.top();
            } while (agg != null && value3.equals(agg.current));
            if (count3 <= this.minCount || this.excluded != null && this.excluded.contains(value3) || this.matcher != null && !this.matcher.reset(value3).matches()) continue;
            InternalStringTermsFacet.StringEntry entry = new InternalStringTermsFacet.StringEntry(value3, count3);
            ((BoundedTreeSet)ordered).add(entry);
        }
        for (ReaderAggregator aggregator : this.aggregators) {
            CacheRecycler.pushIntArray(aggregator.counts);
        }
        return new InternalStringTermsFacet(this.facetName, this.comparatorType, this.size, (Collection<InternalStringTermsFacet.StringEntry>)ordered, this.missing, this.total);
    }

    public static class AggregatorPriorityQueue
    extends PriorityQueue<ReaderAggregator> {
        public AggregatorPriorityQueue(int size2) {
            this.initialize(size2);
        }

        @Override
        protected boolean lessThan(ReaderAggregator a, ReaderAggregator b) {
            return a.current.compareTo(b.current) < 0;
        }
    }

    public static class ReaderAggregator
    implements FieldData.OrdinalInDocProc {
        final String[] values;
        final int[] counts;
        int position = 0;
        String current;
        int total;

        public ReaderAggregator(StringFieldData fieldData) {
            this.values = fieldData.values();
            this.counts = CacheRecycler.popIntArray(fieldData.values().length);
        }

        @Override
        public void onOrdinal(int docId, int ordinal) {
            int n = ordinal;
            this.counts[n] = this.counts[n] + 1;
            ++this.total;
        }

        public boolean nextPosition() {
            if (++this.position >= this.values.length) {
                return false;
            }
            this.current = this.values[this.position];
            return true;
        }
    }
}

