/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.terms.ints;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.elasticsearch.common.CacheRecycler;
import org.elasticsearch.common.collect.BoundedTreeSet;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.trove.iterator.TIntIntIterator;
import org.elasticsearch.common.trove.map.hash.TIntIntHashMap;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.search.facet.Facet;
import org.elasticsearch.search.facet.InternalFacet;
import org.elasticsearch.search.facet.terms.InternalTermsFacet;
import org.elasticsearch.search.facet.terms.TermsFacet;

public class InternalIntTermsFacet
extends InternalTermsFacet {
    private static final String STREAM_TYPE = "iTerms";
    static InternalFacet.Stream STREAM = new InternalFacet.Stream(){

        @Override
        public Facet readFacet(String type2, StreamInput in) throws IOException {
            return InternalIntTermsFacet.readTermsFacet(in);
        }
    };
    private String name;
    int requiredSize;
    long missing;
    long total;
    Collection<IntEntry> entries = ImmutableList.of();
    TermsFacet.ComparatorType comparatorType;

    public static void registerStream() {
        InternalFacet.Streams.registerStream(STREAM, STREAM_TYPE);
    }

    @Override
    public String streamType() {
        return STREAM_TYPE;
    }

    InternalIntTermsFacet() {
    }

    public InternalIntTermsFacet(String name2, TermsFacet.ComparatorType comparatorType, int requiredSize, Collection<IntEntry> entries2, long missing, long total2) {
        this.name = name2;
        this.comparatorType = comparatorType;
        this.requiredSize = requiredSize;
        this.entries = entries2;
        this.missing = missing;
        this.total = total2;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String type() {
        return "terms";
    }

    @Override
    public String getType() {
        return this.type();
    }

    public List<IntEntry> entries() {
        if (!(this.entries instanceof List)) {
            this.entries = ImmutableList.copyOf(this.entries);
        }
        return (List)this.entries;
    }

    public List<IntEntry> getEntries() {
        return this.entries();
    }

    @Override
    public Iterator<TermsFacet.Entry> iterator() {
        return this.entries.iterator();
    }

    @Override
    public long missingCount() {
        return this.missing;
    }

    @Override
    public long getMissingCount() {
        return this.missingCount();
    }

    @Override
    public long totalCount() {
        return this.total;
    }

    @Override
    public long getTotalCount() {
        return this.totalCount();
    }

    @Override
    public long otherCount() {
        long other = this.total;
        for (IntEntry entry : this.entries) {
            other -= (long)entry.count();
        }
        return other;
    }

    @Override
    public long getOtherCount() {
        return this.otherCount();
    }

    @Override
    public Facet reduce(String name2, List<Facet> facets) {
        if (facets.size() == 1) {
            return facets.get(0);
        }
        InternalIntTermsFacet first2 = (InternalIntTermsFacet)facets.get(0);
        TIntIntHashMap aggregated = CacheRecycler.popIntIntMap();
        long missing = 0L;
        long total2 = 0L;
        for (Facet facet : facets) {
            InternalIntTermsFacet mFacet = (InternalIntTermsFacet)facet;
            missing += mFacet.missingCount();
            total2 += mFacet.totalCount();
            for (IntEntry entry : mFacet.entries) {
                aggregated.adjustOrPutValue(entry.term, entry.count(), entry.count());
            }
        }
        BoundedTreeSet<TermsFacet.Entry> ordered = new BoundedTreeSet<TermsFacet.Entry>(first2.comparatorType.comparator(), first2.requiredSize);
        TIntIntIterator it = aggregated.iterator();
        while (it.hasNext()) {
            it.advance();
            ordered.add(new IntEntry(it.key(), it.value()));
        }
        first2.entries = ordered;
        first2.missing = missing;
        first2.total = total2;
        CacheRecycler.pushIntIntMap(aggregated);
        return first2;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params2) throws IOException {
        builder.startObject(this.name);
        builder.field(Fields._TYPE, "terms");
        builder.field(Fields.MISSING, this.missing);
        builder.field(Fields.TOTAL, this.total);
        builder.field(Fields.OTHER, this.otherCount());
        builder.startArray(Fields.TERMS);
        for (IntEntry entry : this.entries) {
            builder.startObject();
            builder.field(Fields.TERM, entry.term);
            builder.field(Fields.COUNT, entry.count());
            builder.endObject();
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    public static InternalIntTermsFacet readTermsFacet(StreamInput in) throws IOException {
        InternalIntTermsFacet facet = new InternalIntTermsFacet();
        facet.readFrom(in);
        return facet;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.name = in.readUTF();
        this.comparatorType = TermsFacet.ComparatorType.fromId(in.readByte());
        this.requiredSize = in.readVInt();
        this.missing = in.readVLong();
        this.total = in.readVLong();
        int size2 = in.readVInt();
        this.entries = new ArrayList<IntEntry>(size2);
        for (int i2 = 0; i2 < size2; ++i2) {
            this.entries.add(new IntEntry(in.readInt(), in.readVInt()));
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeByte(this.comparatorType.id());
        out.writeVInt(this.requiredSize);
        out.writeVLong(this.missing);
        out.writeVLong(this.total);
        out.writeVInt(this.entries.size());
        for (IntEntry entry : this.entries) {
            out.writeInt(entry.term);
            out.writeVInt(entry.count());
        }
    }

    static final class Fields {
        static final XContentBuilderString _TYPE = new XContentBuilderString("_type");
        static final XContentBuilderString MISSING = new XContentBuilderString("missing");
        static final XContentBuilderString TOTAL = new XContentBuilderString("total");
        static final XContentBuilderString OTHER = new XContentBuilderString("other");
        static final XContentBuilderString TERMS = new XContentBuilderString("terms");
        static final XContentBuilderString TERM = new XContentBuilderString("term");
        static final XContentBuilderString COUNT = new XContentBuilderString("count");

        Fields() {
        }
    }

    public static class IntEntry
    implements TermsFacet.Entry {
        int term;
        int count;

        public IntEntry(int term, int count2) {
            this.term = term;
            this.count = count2;
        }

        @Override
        public String term() {
            return Integer.toString(this.term);
        }

        @Override
        public String getTerm() {
            return this.term();
        }

        @Override
        public Number termAsNumber() {
            return this.term;
        }

        @Override
        public Number getTermAsNumber() {
            return this.termAsNumber();
        }

        @Override
        public int count() {
            return this.count;
        }

        @Override
        public int getCount() {
            return this.count();
        }

        @Override
        public int compareTo(TermsFacet.Entry o) {
            int anotherVal = ((IntEntry)o).term;
            int i2 = this.term - anotherVal;
            if (i2 == 0 && (i2 = this.count - o.count()) == 0) {
                i2 = System.identityHashCode(this) - System.identityHashCode(o);
            }
            return i2;
        }
    }
}

