/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.terms.doubles;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.elasticsearch.common.CacheRecycler;
import org.elasticsearch.common.collect.BoundedTreeSet;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.trove.iterator.TDoubleIntIterator;
import org.elasticsearch.common.trove.map.hash.TDoubleIntHashMap;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.search.facet.Facet;
import org.elasticsearch.search.facet.InternalFacet;
import org.elasticsearch.search.facet.terms.InternalTermsFacet;
import org.elasticsearch.search.facet.terms.TermsFacet;

public class InternalDoubleTermsFacet
extends InternalTermsFacet {
    private static final String STREAM_TYPE = "dTerms";
    static InternalFacet.Stream STREAM = new InternalFacet.Stream(){

        @Override
        public Facet readFacet(String type2, StreamInput in) throws IOException {
            return InternalDoubleTermsFacet.readTermsFacet(in);
        }
    };
    private String name;
    int requiredSize;
    long missing;
    long total;
    Collection<DoubleEntry> entries = ImmutableList.of();
    TermsFacet.ComparatorType comparatorType;

    public static void registerStream() {
        InternalFacet.Streams.registerStream(STREAM, STREAM_TYPE);
    }

    @Override
    public String streamType() {
        return STREAM_TYPE;
    }

    InternalDoubleTermsFacet() {
    }

    public InternalDoubleTermsFacet(String name2, TermsFacet.ComparatorType comparatorType, int requiredSize, Collection<DoubleEntry> entries2, long missing, long total2) {
        this.name = name2;
        this.comparatorType = comparatorType;
        this.requiredSize = requiredSize;
        this.entries = entries2;
        this.missing = missing;
        this.total = total2;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String type() {
        return "terms";
    }

    @Override
    public String getType() {
        return this.type();
    }

    public List<DoubleEntry> entries() {
        if (!(this.entries instanceof List)) {
            this.entries = ImmutableList.copyOf(this.entries);
        }
        return (List)this.entries;
    }

    public List<DoubleEntry> getEntries() {
        return this.entries();
    }

    @Override
    public Iterator<TermsFacet.Entry> iterator() {
        return this.entries.iterator();
    }

    @Override
    public long missingCount() {
        return this.missing;
    }

    @Override
    public long getMissingCount() {
        return this.missingCount();
    }

    @Override
    public long totalCount() {
        return this.total;
    }

    @Override
    public long getTotalCount() {
        return this.totalCount();
    }

    @Override
    public long otherCount() {
        long other = this.total;
        for (DoubleEntry entry : this.entries) {
            other -= (long)entry.count();
        }
        return other;
    }

    @Override
    public long getOtherCount() {
        return this.otherCount();
    }

    @Override
    public Facet reduce(String name2, List<Facet> facets) {
        if (facets.size() == 1) {
            return facets.get(0);
        }
        InternalDoubleTermsFacet first2 = (InternalDoubleTermsFacet)facets.get(0);
        TDoubleIntHashMap aggregated = CacheRecycler.popDoubleIntMap();
        long missing = 0L;
        long total2 = 0L;
        for (Facet facet : facets) {
            InternalDoubleTermsFacet mFacet = (InternalDoubleTermsFacet)facet;
            missing += mFacet.missingCount();
            total2 += mFacet.totalCount();
            for (DoubleEntry entry : mFacet.entries) {
                aggregated.adjustOrPutValue(entry.term, entry.count(), entry.count());
            }
        }
        BoundedTreeSet<TermsFacet.Entry> ordered = new BoundedTreeSet<TermsFacet.Entry>(first2.comparatorType.comparator(), first2.requiredSize);
        TDoubleIntIterator it = aggregated.iterator();
        while (it.hasNext()) {
            it.advance();
            ordered.add(new DoubleEntry(it.key(), it.value()));
        }
        first2.entries = ordered;
        first2.missing = missing;
        first2.total = total2;
        CacheRecycler.pushDoubleIntMap(aggregated);
        return first2;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params2) throws IOException {
        builder.startObject(this.name);
        builder.field(Fields._TYPE, "terms");
        builder.field(Fields.MISSING, this.missing);
        builder.field(Fields.TOTAL, this.total);
        builder.field(Fields.OTHER, this.otherCount());
        builder.startArray(Fields.TERMS);
        for (DoubleEntry entry : this.entries) {
            builder.startObject();
            builder.field(Fields.TERM, entry.term);
            builder.field(Fields.COUNT, entry.count());
            builder.endObject();
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    public static InternalDoubleTermsFacet readTermsFacet(StreamInput in) throws IOException {
        InternalDoubleTermsFacet facet = new InternalDoubleTermsFacet();
        facet.readFrom(in);
        return facet;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.name = in.readUTF();
        this.comparatorType = TermsFacet.ComparatorType.fromId(in.readByte());
        this.requiredSize = in.readVInt();
        this.missing = in.readVLong();
        this.total = in.readVLong();
        int size2 = in.readVInt();
        this.entries = new ArrayList<DoubleEntry>(size2);
        for (int i2 = 0; i2 < size2; ++i2) {
            this.entries.add(new DoubleEntry(in.readDouble(), in.readVInt()));
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeByte(this.comparatorType.id());
        out.writeVInt(this.requiredSize);
        out.writeVLong(this.missing);
        out.writeVLong(this.total);
        out.writeVInt(this.entries.size());
        for (DoubleEntry entry : this.entries) {
            out.writeDouble(entry.term);
            out.writeVInt(entry.count());
        }
    }

    static final class Fields {
        static final XContentBuilderString _TYPE = new XContentBuilderString("_type");
        static final XContentBuilderString MISSING = new XContentBuilderString("missing");
        static final XContentBuilderString TOTAL = new XContentBuilderString("total");
        static final XContentBuilderString OTHER = new XContentBuilderString("other");
        static final XContentBuilderString TERMS = new XContentBuilderString("terms");
        static final XContentBuilderString TERM = new XContentBuilderString("term");
        static final XContentBuilderString COUNT = new XContentBuilderString("count");

        Fields() {
        }
    }

    public static class DoubleEntry
    implements TermsFacet.Entry {
        double term;
        int count;

        public DoubleEntry(double term, int count2) {
            this.term = term;
            this.count = count2;
        }

        @Override
        public String term() {
            return Double.toString(this.term);
        }

        @Override
        public String getTerm() {
            return this.term();
        }

        @Override
        public Number termAsNumber() {
            return this.term;
        }

        @Override
        public Number getTermAsNumber() {
            return this.termAsNumber();
        }

        @Override
        public int count() {
            return this.count;
        }

        @Override
        public int getCount() {
            return this.count();
        }

        @Override
        public int compareTo(TermsFacet.Entry o) {
            double anotherVal = ((DoubleEntry)o).term;
            if (this.term < anotherVal) {
                return -1;
            }
            if (this.term == anotherVal) {
                int i2 = this.count - o.count();
                if (i2 == 0) {
                    i2 = System.identityHashCode(this) - System.identityHashCode(o);
                }
                return i2;
            }
            return 1;
        }
    }
}

