/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.terms;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.elasticsearch.common.collect.ImmutableCollection;
import org.elasticsearch.common.collect.ImmutableSet;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.field.data.FieldDataType;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.ip.IpFieldMapper;
import org.elasticsearch.search.facet.Facet;
import org.elasticsearch.search.facet.FacetCollector;
import org.elasticsearch.search.facet.FacetProcessor;
import org.elasticsearch.search.facet.terms.InternalTermsFacet;
import org.elasticsearch.search.facet.terms.TermsFacet;
import org.elasticsearch.search.facet.terms.bytes.TermsByteFacetCollector;
import org.elasticsearch.search.facet.terms.bytes.TermsByteOrdinalsFacetCollector;
import org.elasticsearch.search.facet.terms.doubles.TermsDoubleFacetCollector;
import org.elasticsearch.search.facet.terms.doubles.TermsDoubleOrdinalsFacetCollector;
import org.elasticsearch.search.facet.terms.floats.TermsFloatFacetCollector;
import org.elasticsearch.search.facet.terms.floats.TermsFloatOrdinalsFacetCollector;
import org.elasticsearch.search.facet.terms.index.IndexNameFacetCollector;
import org.elasticsearch.search.facet.terms.ints.TermsIntFacetCollector;
import org.elasticsearch.search.facet.terms.ints.TermsIntOrdinalsFacetCollector;
import org.elasticsearch.search.facet.terms.ip.TermsIpFacetCollector;
import org.elasticsearch.search.facet.terms.ip.TermsIpOrdinalsFacetCollector;
import org.elasticsearch.search.facet.terms.longs.TermsLongFacetCollector;
import org.elasticsearch.search.facet.terms.longs.TermsLongOrdinalsFacetCollector;
import org.elasticsearch.search.facet.terms.shorts.TermsShortFacetCollector;
import org.elasticsearch.search.facet.terms.shorts.TermsShortOrdinalsFacetCollector;
import org.elasticsearch.search.facet.terms.strings.FieldsTermsStringFacetCollector;
import org.elasticsearch.search.facet.terms.strings.ScriptTermsStringFieldFacetCollector;
import org.elasticsearch.search.facet.terms.strings.TermsStringFacetCollector;
import org.elasticsearch.search.facet.terms.strings.TermsStringOrdinalsFacetCollector;
import org.elasticsearch.search.internal.SearchContext;

public class TermsFacetProcessor
extends AbstractComponent
implements FacetProcessor {
    @Inject
    public TermsFacetProcessor(Settings settings) {
        super(settings);
        InternalTermsFacet.registerStreams();
    }

    @Override
    public String[] types() {
        return new String[]{"terms"};
    }

    @Override
    public FacetCollector parse(String facetName, XContentParser parser, SearchContext context) throws IOException {
        XContentParser.Token token;
        String field2 = null;
        int size2 = 10;
        String[] fieldsNames = null;
        ImmutableCollection excluded = ImmutableSet.of();
        String regex = null;
        String regexFlags = null;
        TermsFacet.ComparatorType comparatorType = TermsFacet.ComparatorType.COUNT;
        String scriptLang = null;
        String script = null;
        Map<String, Object> params2 = null;
        boolean allTerms = false;
        String executionHint = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if (!"params".equals(currentFieldName)) continue;
                params2 = parser.map();
                continue;
            }
            if (token == XContentParser.Token.START_ARRAY) {
                if ("exclude".equals(currentFieldName)) {
                    ImmutableSet.Builder builder = ImmutableSet.builder();
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        builder.add(parser.text());
                    }
                    excluded = builder.build();
                    continue;
                }
                if (!"fields".equals(currentFieldName)) continue;
                ArrayList<String> fields2 = Lists.newArrayListWithCapacity(4);
                while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                    fields2.add(parser.text());
                }
                fieldsNames = fields2.toArray(new String[fields2.size()]);
                continue;
            }
            if (!token.isValue()) continue;
            if ("field".equals(currentFieldName)) {
                field2 = parser.text();
                continue;
            }
            if ("script_field".equals(currentFieldName)) {
                script = parser.text();
                continue;
            }
            if ("size".equals(currentFieldName)) {
                size2 = parser.intValue();
                continue;
            }
            if ("all_terms".equals(currentFieldName) || "allTerms".equals(currentFieldName)) {
                allTerms = parser.booleanValue();
                continue;
            }
            if ("regex".equals(currentFieldName)) {
                regex = parser.text();
                continue;
            }
            if ("regex_flags".equals(currentFieldName) || "regexFlags".equals(currentFieldName)) {
                regexFlags = parser.text();
                continue;
            }
            if ("order".equals(currentFieldName) || "comparator".equals(currentFieldName)) {
                comparatorType = TermsFacet.ComparatorType.fromString(parser.text());
                continue;
            }
            if ("script".equals(currentFieldName)) {
                script = parser.text();
                continue;
            }
            if ("lang".equals(currentFieldName)) {
                scriptLang = parser.text();
                continue;
            }
            if (!"execution_hint".equals(currentFieldName) && !"executionHint".equals(currentFieldName)) continue;
            executionHint = parser.textOrNull();
        }
        if ("_index".equals(field2)) {
            return new IndexNameFacetCollector(facetName, context.shardTarget().index(), comparatorType, size2);
        }
        Pattern pattern = null;
        if (regex != null) {
            pattern = Regex.compile(regex, regexFlags);
        }
        if (fieldsNames != null) {
            return new FieldsTermsStringFacetCollector(facetName, fieldsNames, size2, comparatorType, allTerms, context, (ImmutableSet<String>)excluded, pattern, scriptLang, script, params2);
        }
        if (field2 == null && fieldsNames == null && script != null) {
            return new ScriptTermsStringFieldFacetCollector(facetName, size2, comparatorType, context, (ImmutableSet<String>)excluded, pattern, scriptLang, script, params2);
        }
        FieldMapper fieldMapper = context.smartNameFieldMapper(field2);
        if (fieldMapper != null) {
            if (fieldMapper instanceof IpFieldMapper) {
                if (script != null || "map".equals(executionHint)) {
                    return new TermsIpFacetCollector(facetName, field2, size2, comparatorType, allTerms, context, scriptLang, script, params2);
                }
                return new TermsIpOrdinalsFacetCollector(facetName, field2, size2, comparatorType, allTerms, context, null);
            }
            if (fieldMapper.fieldDataType() == FieldDataType.DefaultTypes.LONG) {
                if (script != null || "map".equals(executionHint)) {
                    return new TermsLongFacetCollector(facetName, field2, size2, comparatorType, allTerms, context, (ImmutableSet<String>)excluded, scriptLang, script, params2);
                }
                return new TermsLongOrdinalsFacetCollector(facetName, field2, size2, comparatorType, allTerms, context, (ImmutableSet<String>)excluded);
            }
            if (fieldMapper.fieldDataType() == FieldDataType.DefaultTypes.DOUBLE) {
                if (script != null) {
                    return new TermsDoubleFacetCollector(facetName, field2, size2, comparatorType, allTerms, context, (ImmutableSet<String>)excluded, scriptLang, script, params2);
                }
                return new TermsDoubleOrdinalsFacetCollector(facetName, field2, size2, comparatorType, allTerms, context, (ImmutableSet<String>)excluded);
            }
            if (fieldMapper.fieldDataType() == FieldDataType.DefaultTypes.INT) {
                if (script != null || "map".equals(executionHint)) {
                    return new TermsIntFacetCollector(facetName, field2, size2, comparatorType, allTerms, context, (ImmutableSet<String>)excluded, scriptLang, script, params2);
                }
                return new TermsIntOrdinalsFacetCollector(facetName, field2, size2, comparatorType, allTerms, context, (ImmutableSet<String>)excluded);
            }
            if (fieldMapper.fieldDataType() == FieldDataType.DefaultTypes.FLOAT) {
                if (script != null || "map".equals(executionHint)) {
                    return new TermsFloatFacetCollector(facetName, field2, size2, comparatorType, allTerms, context, (ImmutableSet<String>)excluded, scriptLang, script, params2);
                }
                return new TermsFloatOrdinalsFacetCollector(facetName, field2, size2, comparatorType, allTerms, context, (ImmutableSet<String>)excluded);
            }
            if (fieldMapper.fieldDataType() == FieldDataType.DefaultTypes.SHORT) {
                if (script != null || "map".equals(executionHint)) {
                    return new TermsShortFacetCollector(facetName, field2, size2, comparatorType, allTerms, context, (ImmutableSet<String>)excluded, scriptLang, script, params2);
                }
                return new TermsShortOrdinalsFacetCollector(facetName, field2, size2, comparatorType, allTerms, context, (ImmutableSet<String>)excluded);
            }
            if (fieldMapper.fieldDataType() == FieldDataType.DefaultTypes.BYTE) {
                if (script != null || "map".equals(executionHint)) {
                    return new TermsByteFacetCollector(facetName, field2, size2, comparatorType, allTerms, context, (ImmutableSet<String>)excluded, scriptLang, script, params2);
                }
                return new TermsByteOrdinalsFacetCollector(facetName, field2, size2, comparatorType, allTerms, context, (ImmutableSet<String>)excluded);
            }
            if (fieldMapper.fieldDataType() == FieldDataType.DefaultTypes.STRING && script == null && !"map".equals(executionHint)) {
                return new TermsStringOrdinalsFacetCollector(facetName, field2, size2, comparatorType, allTerms, context, (ImmutableSet<String>)excluded, pattern);
            }
        }
        return new TermsStringFacetCollector(facetName, field2, size2, comparatorType, allTerms, context, (ImmutableSet<String>)excluded, pattern, scriptLang, script, params2);
    }

    @Override
    public Facet reduce(String name2, List<Facet> facets) {
        InternalTermsFacet first2 = (InternalTermsFacet)facets.get(0);
        return first2.reduce(name2, facets);
    }
}

