/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.terms;

import java.util.Comparator;
import java.util.List;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.search.facet.Facet;

public interface TermsFacet
extends Facet,
Iterable<Entry> {
    public static final String TYPE = "terms";

    public long missingCount();

    public long getMissingCount();

    public long totalCount();

    public long getTotalCount();

    public long otherCount();

    public long getOtherCount();

    public List<? extends Entry> entries();

    public List<? extends Entry> getEntries();

    public static enum ComparatorType {
        COUNT(0, new Comparator<Entry>(){

            @Override
            public int compare(Entry o1, Entry o2) {
                int i2 = o2.count() - o1.count();
                if (i2 == 0 && (i2 = o2.compareTo(o1)) == 0) {
                    i2 = System.identityHashCode(o2) - System.identityHashCode(o1);
                }
                return i2;
            }
        }),
        REVERSE_COUNT(1, new Comparator<Entry>(){

            @Override
            public int compare(Entry o1, Entry o2) {
                return -COUNT.comparator().compare(o1, o2);
            }
        }),
        TERM(2, new Comparator<Entry>(){

            @Override
            public int compare(Entry o1, Entry o2) {
                return o1.compareTo(o2);
            }
        }),
        REVERSE_TERM(3, new Comparator<Entry>(){

            @Override
            public int compare(Entry o1, Entry o2) {
                return -TERM.comparator().compare(o1, o2);
            }
        });

        private final byte id;
        private final Comparator<Entry> comparator;

        private ComparatorType(byte id2, Comparator<Entry> comparator) {
            this.id = id2;
            this.comparator = comparator;
        }

        public byte id() {
            return this.id;
        }

        public Comparator<Entry> comparator() {
            return this.comparator;
        }

        public static ComparatorType fromId(byte id2) {
            if (id2 == COUNT.id()) {
                return COUNT;
            }
            if (id2 == REVERSE_COUNT.id()) {
                return REVERSE_COUNT;
            }
            if (id2 == TERM.id()) {
                return TERM;
            }
            if (id2 == REVERSE_TERM.id()) {
                return REVERSE_TERM;
            }
            throw new ElasticSearchIllegalArgumentException("No type argument match for terms facet comparator [" + id2 + "]");
        }

        public static ComparatorType fromString(String type2) {
            if ("count".equals(type2)) {
                return COUNT;
            }
            if ("term".equals(type2)) {
                return TERM;
            }
            if ("reverse_count".equals(type2) || "reverseCount".equals(type2)) {
                return REVERSE_COUNT;
            }
            if ("reverse_term".equals(type2) || "reverseTerm".equals(type2)) {
                return REVERSE_TERM;
            }
            throw new ElasticSearchIllegalArgumentException("No type argument match for terms facet comparator [" + type2 + "]");
        }
    }

    public static interface Entry
    extends Comparable<Entry> {
        public String term();

        public String getTerm();

        public Number termAsNumber();

        public Number getTermAsNumber();

        public int count();

        public int getCount();
    }
}

