/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.histogram.unbounded;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.elasticsearch.common.CacheRecycler;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.trove.iterator.TLongLongIterator;
import org.elasticsearch.common.trove.map.hash.TLongLongHashMap;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.search.facet.Facet;
import org.elasticsearch.search.facet.InternalFacet;
import org.elasticsearch.search.facet.histogram.HistogramFacet;
import org.elasticsearch.search.facet.histogram.InternalHistogramFacet;

public class InternalCountHistogramFacet
extends InternalHistogramFacet {
    private static final String STREAM_TYPE = "cHistogram";
    static InternalFacet.Stream STREAM = new InternalFacet.Stream(){

        @Override
        public Facet readFacet(String type2, StreamInput in) throws IOException {
            return InternalCountHistogramFacet.readHistogramFacet(in);
        }
    };
    private String name;
    HistogramFacet.ComparatorType comparatorType;
    TLongLongHashMap counts;
    boolean cachedCounts;
    CountEntry[] entries = null;

    public static void registerStreams() {
        InternalFacet.Streams.registerStream(STREAM, STREAM_TYPE);
    }

    @Override
    public String streamType() {
        return STREAM_TYPE;
    }

    private InternalCountHistogramFacet() {
    }

    public InternalCountHistogramFacet(String name2, HistogramFacet.ComparatorType comparatorType, TLongLongHashMap counts, boolean cachedCounts) {
        this.name = name2;
        this.comparatorType = comparatorType;
        this.counts = counts;
        this.cachedCounts = cachedCounts;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public String type() {
        return "histogram";
    }

    @Override
    public String getType() {
        return this.type();
    }

    public List<CountEntry> entries() {
        return Arrays.asList(this.computeEntries());
    }

    public List<CountEntry> getEntries() {
        return this.entries();
    }

    @Override
    public Iterator<HistogramFacet.Entry> iterator() {
        return this.entries().iterator();
    }

    private CountEntry[] computeEntries() {
        if (this.entries != null) {
            return this.entries;
        }
        this.entries = new CountEntry[this.counts.size()];
        int i2 = 0;
        TLongLongIterator it = this.counts.iterator();
        while (it.hasNext()) {
            it.advance();
            this.entries[i2++] = new CountEntry(it.key(), it.value());
        }
        this.releaseCache();
        Arrays.sort(this.entries, this.comparatorType.comparator());
        return this.entries;
    }

    void releaseCache() {
        if (this.cachedCounts) {
            CacheRecycler.pushLongLongMap(this.counts);
            this.cachedCounts = false;
            this.counts = null;
        }
    }

    @Override
    public Facet reduce(String name2, List<Facet> facets) {
        if (facets.size() == 1) {
            return facets.get(0);
        }
        TLongLongHashMap counts = CacheRecycler.popLongLongMap();
        for (Facet facet : facets) {
            InternalCountHistogramFacet histoFacet = (InternalCountHistogramFacet)facet;
            TLongLongIterator it = histoFacet.counts.iterator();
            while (it.hasNext()) {
                it.advance();
                counts.adjustOrPutValue(it.key(), it.value(), it.value());
            }
            histoFacet.releaseCache();
        }
        return new InternalCountHistogramFacet(name2, this.comparatorType, counts, true);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params2) throws IOException {
        builder.startObject(this.name);
        builder.field(Fields._TYPE, "histogram");
        builder.startArray(Fields.ENTRIES);
        for (CountEntry entry : this.computeEntries()) {
            builder.startObject();
            builder.field(Fields.KEY, entry.key());
            builder.field(Fields.COUNT, entry.count());
            builder.endObject();
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    public static InternalCountHistogramFacet readHistogramFacet(StreamInput in) throws IOException {
        InternalCountHistogramFacet facet = new InternalCountHistogramFacet();
        facet.readFrom(in);
        return facet;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.name = in.readUTF();
        this.comparatorType = HistogramFacet.ComparatorType.fromId(in.readByte());
        int size2 = in.readVInt();
        this.counts = CacheRecycler.popLongLongMap();
        this.cachedCounts = true;
        for (int i2 = 0; i2 < size2; ++i2) {
            long key2 = in.readLong();
            this.counts.put(key2, in.readVLong());
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeByte(this.comparatorType.id());
        out.writeVInt(this.counts.size());
        TLongLongIterator it = this.counts.iterator();
        while (it.hasNext()) {
            it.advance();
            out.writeLong(it.key());
            out.writeVLong(it.value());
        }
        this.releaseCache();
    }

    static final class Fields {
        static final XContentBuilderString _TYPE = new XContentBuilderString("_type");
        static final XContentBuilderString ENTRIES = new XContentBuilderString("entries");
        static final XContentBuilderString KEY = new XContentBuilderString("key");
        static final XContentBuilderString COUNT = new XContentBuilderString("count");

        Fields() {
        }
    }

    public static class CountEntry
    implements HistogramFacet.Entry {
        private final long key;
        private final long count;

        public CountEntry(long key2, long count2) {
            this.key = key2;
            this.count = count2;
        }

        @Override
        public long key() {
            return this.key;
        }

        @Override
        public long getKey() {
            return this.key();
        }

        @Override
        public long count() {
            return this.count;
        }

        @Override
        public long getCount() {
            return this.count();
        }

        @Override
        public double total() {
            return Double.NaN;
        }

        @Override
        public double getTotal() {
            return this.total();
        }

        @Override
        public long totalCount() {
            return 0L;
        }

        @Override
        public long getTotalCount() {
            return 0L;
        }

        @Override
        public double mean() {
            return Double.NaN;
        }

        @Override
        public double getMean() {
            return this.mean();
        }

        @Override
        public double min() {
            return Double.NaN;
        }

        @Override
        public double getMin() {
            return Double.NaN;
        }

        @Override
        public double max() {
            return Double.NaN;
        }

        @Override
        public double getMax() {
            return Double.NaN;
        }
    }
}

