/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.datehistogram;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.elasticsearch.common.CacheRecycler;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.trove.ExtTLongObjectHashMap;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.search.facet.Facet;
import org.elasticsearch.search.facet.InternalFacet;
import org.elasticsearch.search.facet.datehistogram.DateHistogramFacet;
import org.elasticsearch.search.facet.datehistogram.InternalDateHistogramFacet;

public class InternalFullDateHistogramFacet
extends InternalDateHistogramFacet {
    private static final String STREAM_TYPE = "fdHistogram";
    static InternalFacet.Stream STREAM = new InternalFacet.Stream(){

        @Override
        public Facet readFacet(String type2, StreamInput in) throws IOException {
            return InternalFullDateHistogramFacet.readHistogramFacet(in);
        }
    };
    private String name;
    private DateHistogramFacet.ComparatorType comparatorType;
    ExtTLongObjectHashMap<FullEntry> tEntries;
    boolean cachedEntries;
    Collection<FullEntry> entries;

    public static void registerStreams() {
        InternalFacet.Streams.registerStream(STREAM, STREAM_TYPE);
    }

    @Override
    public String streamType() {
        return STREAM_TYPE;
    }

    private InternalFullDateHistogramFacet() {
    }

    public InternalFullDateHistogramFacet(String name2, DateHistogramFacet.ComparatorType comparatorType, ExtTLongObjectHashMap<FullEntry> entries2, boolean cachedEntries) {
        this.name = name2;
        this.comparatorType = comparatorType;
        this.tEntries = entries2;
        this.cachedEntries = cachedEntries;
        this.entries = entries2.valueCollection();
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public String type() {
        return "date_histogram";
    }

    @Override
    public String getType() {
        return this.type();
    }

    public List<FullEntry> entries() {
        if (!(this.entries instanceof List)) {
            this.entries = new ArrayList<FullEntry>(this.entries);
        }
        return (List)this.entries;
    }

    public List<FullEntry> getEntries() {
        return this.entries();
    }

    @Override
    public Iterator<DateHistogramFacet.Entry> iterator() {
        return this.entries().iterator();
    }

    void releaseCache() {
        if (this.cachedEntries) {
            CacheRecycler.pushLongObjectMap(this.tEntries);
            this.cachedEntries = false;
            this.tEntries = null;
        }
    }

    @Override
    public Facet reduce(String name2, List<Facet> facets) {
        FullEntry value2;
        if (facets.size() == 1) {
            InternalFullDateHistogramFacet internalFacet = (InternalFullDateHistogramFacet)facets.get(0);
            List<FullEntry> entries2 = internalFacet.entries();
            Collections.sort(entries2, this.comparatorType.comparator());
            internalFacet.releaseCache();
            return internalFacet;
        }
        ExtTLongObjectHashMap map = CacheRecycler.popLongObjectMap();
        for (Facet facet : facets) {
            InternalFullDateHistogramFacet histoFacet = (InternalFullDateHistogramFacet)facet;
            for (FullEntry fullEntry : histoFacet.entries) {
                FullEntry current2 = (FullEntry)map.get(fullEntry.time);
                if (current2 != null) {
                    current2.count += fullEntry.count;
                    current2.total += fullEntry.total;
                    current2.totalCount += fullEntry.totalCount;
                    if (fullEntry.min < current2.min) {
                        current2.min = fullEntry.min;
                    }
                    if (!(fullEntry.max > current2.max)) continue;
                    current2.max = fullEntry.max;
                    continue;
                }
                map.put(fullEntry.time, fullEntry);
            }
            histoFacet.releaseCache();
        }
        Object[] values2 = map.internalValues();
        Arrays.sort(values2, this.comparatorType.comparator());
        ArrayList<FullEntry> ordered = new ArrayList<FullEntry>(map.size());
        for (int i2 = 0; i2 < map.size() && (value2 = (FullEntry)values2[i2]) != null; ++i2) {
            ordered.add(value2);
        }
        CacheRecycler.pushLongObjectMap(map);
        InternalFullDateHistogramFacet ret = new InternalFullDateHistogramFacet();
        ret.name = name2;
        ret.comparatorType = this.comparatorType;
        ret.entries = ordered;
        return ret;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params2) throws IOException {
        builder.startObject(this.name);
        builder.field(Fields._TYPE, "date_histogram");
        builder.startArray(Fields.ENTRIES);
        for (FullEntry entry : this.entries()) {
            builder.startObject();
            builder.field(Fields.TIME, entry.time());
            builder.field(Fields.COUNT, entry.count());
            builder.field(Fields.MIN, entry.min());
            builder.field(Fields.MAX, entry.max());
            builder.field(Fields.TOTAL, entry.total());
            builder.field(Fields.TOTAL_COUNT, entry.totalCount());
            builder.field(Fields.MEAN, entry.mean());
            builder.endObject();
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    public static InternalFullDateHistogramFacet readHistogramFacet(StreamInput in) throws IOException {
        InternalFullDateHistogramFacet facet = new InternalFullDateHistogramFacet();
        facet.readFrom(in);
        return facet;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.name = in.readUTF();
        this.comparatorType = DateHistogramFacet.ComparatorType.fromId(in.readByte());
        this.cachedEntries = false;
        int size2 = in.readVInt();
        this.entries = new ArrayList<FullEntry>(size2);
        for (int i2 = 0; i2 < size2; ++i2) {
            this.entries.add(new FullEntry(in.readLong(), in.readVLong(), in.readDouble(), in.readDouble(), in.readVLong(), in.readDouble()));
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeByte(this.comparatorType.id());
        out.writeVInt(this.entries.size());
        for (FullEntry entry : this.entries) {
            out.writeLong(entry.time);
            out.writeVLong(entry.count);
            out.writeDouble(entry.min);
            out.writeDouble(entry.max);
            out.writeVLong(entry.totalCount);
            out.writeDouble(entry.total);
        }
        this.releaseCache();
    }

    static final class Fields {
        static final XContentBuilderString _TYPE = new XContentBuilderString("_type");
        static final XContentBuilderString ENTRIES = new XContentBuilderString("entries");
        static final XContentBuilderString TIME = new XContentBuilderString("time");
        static final XContentBuilderString COUNT = new XContentBuilderString("count");
        static final XContentBuilderString TOTAL = new XContentBuilderString("total");
        static final XContentBuilderString TOTAL_COUNT = new XContentBuilderString("total_count");
        static final XContentBuilderString MEAN = new XContentBuilderString("mean");
        static final XContentBuilderString MIN = new XContentBuilderString("min");
        static final XContentBuilderString MAX = new XContentBuilderString("max");

        Fields() {
        }
    }

    public static class FullEntry
    implements DateHistogramFacet.Entry {
        private final long time;
        long count;
        long totalCount;
        double total;
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;

        public FullEntry(long time, long count2, double min2, double max2, long totalCount, double total2) {
            this.time = time;
            this.count = count2;
            this.min = min2;
            this.max = max2;
            this.totalCount = totalCount;
            this.total = total2;
        }

        @Override
        public long time() {
            return this.time;
        }

        @Override
        public long getTime() {
            return this.time();
        }

        @Override
        public long count() {
            return this.count;
        }

        @Override
        public long getCount() {
            return this.count();
        }

        @Override
        public double total() {
            return this.total;
        }

        @Override
        public double getTotal() {
            return this.total();
        }

        @Override
        public long totalCount() {
            return this.totalCount;
        }

        @Override
        public long getTotalCount() {
            return this.totalCount;
        }

        @Override
        public double mean() {
            if (this.totalCount == 0L) {
                return this.totalCount;
            }
            return this.total / (double)this.totalCount;
        }

        @Override
        public double getMean() {
            return this.total / (double)this.totalCount;
        }

        @Override
        public double min() {
            return this.min;
        }

        @Override
        public double getMin() {
            return this.min;
        }

        @Override
        public double max() {
            return this.max;
        }

        @Override
        public double getMax() {
            return this.max;
        }
    }
}

