/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.mvel;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Scorer;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.math.UnboxedMathUtils;
import org.elasticsearch.common.mvel2.MVEL;
import org.elasticsearch.common.mvel2.ParserConfiguration;
import org.elasticsearch.common.mvel2.ParserContext;
import org.elasticsearch.common.mvel2.compiler.ExecutableStatement;
import org.elasticsearch.common.mvel2.integration.impl.MapVariableResolverFactory;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.script.ExecutableScript;
import org.elasticsearch.script.ScriptEngineService;
import org.elasticsearch.script.SearchScript;
import org.elasticsearch.search.lookup.SearchLookup;

public class MvelScriptEngineService
extends AbstractComponent
implements ScriptEngineService {
    private final ParserConfiguration parserConfiguration = new ParserConfiguration();

    @Inject
    public MvelScriptEngineService(Settings settings) {
        super(settings);
        this.parserConfiguration.addPackageImport("java.util");
        this.parserConfiguration.addPackageImport("org.elasticsearch.common.trove");
        this.parserConfiguration.addPackageImport("org.elasticsearch.common.joda");
        this.parserConfiguration.addImport("time", MVEL.getStaticMethod(System.class, "currentTimeMillis", new Class[0]));
        for (Method m : UnboxedMathUtils.class.getMethods()) {
            if ((m.getModifiers() & 8) <= 0) continue;
            this.parserConfiguration.addImport(m.getName(), m);
        }
    }

    @Override
    public void close() {
    }

    @Override
    public String[] types() {
        return new String[]{"mvel"};
    }

    @Override
    public String[] extensions() {
        return new String[]{"mvel"};
    }

    @Override
    public Object compile(String script) {
        return MVEL.compileExpression(script, new ParserContext(this.parserConfiguration));
    }

    public Object execute(Object compiledScript, Map vars) {
        return MVEL.executeExpression(compiledScript, vars);
    }

    public ExecutableScript executable(Object compiledScript, Map vars) {
        return new MvelExecutableScript(compiledScript, vars);
    }

    @Override
    public SearchScript search(Object compiledScript, SearchLookup lookup, @Nullable Map<String, Object> vars) {
        return new MvelSearchScript(compiledScript, lookup, vars);
    }

    @Override
    public Object unwrap(Object value2) {
        return value2;
    }

    public static class MvelSearchScript
    implements SearchScript {
        private final ExecutableStatement script;
        private final SearchLookup lookup;
        private final MapVariableResolverFactory resolver;

        public MvelSearchScript(Object script, SearchLookup lookup, Map<String, Object> vars) {
            this.script = (ExecutableStatement)script;
            this.lookup = lookup;
            this.resolver = vars != null ? new MapVariableResolverFactory(vars) : new MapVariableResolverFactory(new HashMap());
            for (Map.Entry entry : lookup.asMap().entrySet()) {
                this.resolver.createVariable((String)entry.getKey(), entry.getValue());
            }
        }

        @Override
        public void setScorer(Scorer scorer) {
            this.lookup.setScorer(scorer);
        }

        @Override
        public void setNextReader(IndexReader reader) {
            this.lookup.setNextReader(reader);
        }

        @Override
        public void setNextDocId(int doc) {
            this.lookup.setNextDocId(doc);
        }

        @Override
        public void setNextScore(float score) {
            this.resolver.createVariable("_score", Float.valueOf(score));
        }

        @Override
        public void setNextVar(String name2, Object value2) {
            this.resolver.createVariable(name2, value2);
        }

        @Override
        public void setNextSource(Map<String, Object> source2) {
            this.lookup.source().setNextSource(source2);
        }

        @Override
        public Object run() {
            return this.script.getValue(null, this.resolver);
        }

        @Override
        public float runAsFloat() {
            return ((Number)this.run()).floatValue();
        }

        @Override
        public long runAsLong() {
            return ((Number)this.run()).longValue();
        }

        @Override
        public double runAsDouble() {
            return ((Number)this.run()).doubleValue();
        }

        @Override
        public Object unwrap(Object value2) {
            return value2;
        }
    }

    public static class MvelExecutableScript
    implements ExecutableScript {
        private final ExecutableStatement script;
        private final MapVariableResolverFactory resolver;

        public MvelExecutableScript(Object script, Map vars) {
            this.script = (ExecutableStatement)script;
            this.resolver = vars != null ? new MapVariableResolverFactory(vars) : new MapVariableResolverFactory(new HashMap());
        }

        @Override
        public void setNextVar(String name2, Object value2) {
            this.resolver.createVariable(name2, value2);
        }

        @Override
        public Object run() {
            return this.script.getValue(null, this.resolver);
        }

        @Override
        public Object unwrap(Object value2) {
            return value2;
        }
    }
}

